<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class municipios_model extends Ion_auth_model {
	
    public function __construct()
    {
        parent::__construct();
	}
	
	/**
	 * municipios
	 *
	 * @return object
	 * @author Ben Edmunds
	 **/

	public function view_all($tabla, $where = NULL)
	{
		$this->trigger_events('municipios');

		// run each where that was passed
		
		$this->response = $this->db->get_where($this->tables[$tabla], $where)->num_rows();
		
		return $this;
	}


	public function obtener_parcelas($tabla, $where = NULL)
	{
		
		$this->response = $this->db->get_where($this->tables[$tabla], $where);
		
		return $this;
	}


	public function dropdown_data($tabla = NULL, $where = NULL, $order_by = NULL)
	{
		if ($where) {
			foreach ($where as $k => $v) {

				$this->response = $this->db->where($k, $v);
			}
		}
		
		if ($order_by) {
			$this->response = $this->db->order_by($order_by, 'ASC');
		}

		$this->response = $this->db->get($this->tables[$tabla]);

		return $this;
	}
	

	/**
	 * municipio
	 *
	 * @return object
	 * @author Ben Edmunds
	 **/

	public function view($tabla, $where = NULL)
	{
		$this->trigger_events('municipios');

		$this->response = $this->db->get_where($this->tables[$tabla], $where);
		
		return $this;
	}

	/**
	 * create_municipio
	 *
	 * @author aditya menon
	*/
	public function create_municipio($arraycampos = NULL)
	{
		// bail if the group name already exists
		$existing_municipio = $this->db->get_where($this->tables['municipios'], $arraycampos)->num_rows();

		
		if($existing_municipio !== 0)
		{
			$this->ion_auth->set_error('municipio_already_exists');
			return FALSE;
		}
		
		// insert the new group
		$this->db->insert($this->tables['municipios'], $arraycampos);
		$municipio_gid = $this->db->insert_id();

		// report success
		$this->set_message('municipio_creation_successful');
		// return the brand new group id
		return $municipio_gid;
	}

	
	
	/**
	 * update_municipio
	 *
	 * @return bool
	 * @author aditya menon
	 **/

    public function update_municipio($gid, $arraycampos)
	{
		$this->db->update($this->tables['municipios'], $arraycampos, array('gid' => $gid));

        $this->ion_auth->set_message('municipios_update_successful');

        return TRUE;
	}

	/**
	 * eliminar_parcelas
	 * elimina parcelas correspondientes a la municipio de la tabla in_temp
	 * @return bool
	 * @author Diego Ferreira
	 **/

    public function eliminar_parcelas($tabla, $where)
	{
		$this->db->delete($this->tables[$tabla], $where);

        return TRUE;
	}

	public function generar_periciasimple ($objectid)
	{
		$pericia = $this->db->query('SELECT indert.pericias_generarsimple('.$objectid.') r;');
		if ($pericia->num_rows() > 0) {
			//$this->response = $pericia;
			return true;
		}else{
			return false;
		}
	
	}

	public function generar_periciaresumido ($objectid)
	{
		$pericia = $this->db->query('SELECT indert.pericias_generarpericia('.$objectid.') r;');
		if ($pericia->num_rows() > 0) {
			//$this->response = $pericia;
			return true;
		}else{
			return false;
		}
	
	}


    public function eliminar_basura()
	{
		$sql_query = "delete from indert.in_temp ";
		$sql_query = $sql_query . "where (coalesce(dpto,'NN'),coalesce(distrito,'NN'),coalesce(municipio,0)) ";
		$sql_query = $sql_query . "not in (select dpto_cod,dist_cod,col_cod from indert.municipios); ";
		$resultado = $this->db->query($sql_query);

        return TRUE;
	}

    public function eliminar_pericia($objectid)
	{
		$resultado = $this->db->query('delete from indert.in_planopericia3 where objectid = '.$objectid.';');
		$resultado = $this->db->query('delete from indert.in_planopericia2 where objectid = '.$objectid.';');
		$resultado = $this->db->query('delete from indert.in_planopericia1 where objectid = '.$objectid.';');

        return TRUE;
	}

	public function obtener_pericia ($tabla, $where)
	{
		//$pericia = $this->db->pg_query($this->tables['in_planopericia2'], $where);
		$pericia = $this->db->get_where($this->tables[$tabla], $where);
		if ($pericia->num_rows() > 0) {
			$this->response = $pericia;
		}else{
			return false;
		}

		return $this;
	}




	public function md_generar_pericia_completa ($dpto, $distrito, $municipio)
	{

		$pericia = $this->db->query("SELECT indert.generar_pericias_x_municipio("."'".$dpto."','".$distrito."',".$municipio.");");
		if ($pericia->num_rows() > 0) {
			return true;
		}else{
			return false;
		}
	}


	public function crear_poligono_municipio ($dpto, $distrito, $municipio)
	{

		$pericia = $this->db->query("SELECT indert.actualizar_municipios_una("."'".$dpto."','".$distrito."',".$municipio.");");
		if ($pericia->num_rows() > 0) {
			return true;
		}else{
			return false;
		}
	}



	public function md_generar_lineas ($dpto, $distrito, $municipio)
	{

		$pericia = $this->db->query("SELECT indert.pericias_generar_lineas("."'".$dpto."','".$distrito."',".$municipio.");");

		if ($pericia->num_rows() > 0) {
			return true;
		}else{
			return false;
		}
		
	

	}

	public function obtener_parcelas_sinpericias($dpto, $distrito, $municipio)
	{
		
		$sql_query = "select t.*,c.formato_lado from indert.in_temp t, indert.municipios c where ";
  		$sql_query = $sql_query . " t.dpto::text = c.dpto_cod::text and t.distrito::text = c.dist_cod::text ";
  		$sql_query = $sql_query . " and t.municipio::numeric = c.col_cod ";    	
		$sql_query = $sql_query . "and t.objectid in ( ";
		$sql_query = $sql_query . "select p.objectid from indert.v_pericias_lados p ";
		$sql_query = $sql_query . "where p.dpto = '".$dpto."' and  p.distrito = '".$distrito."' and p.municipio  = " .$municipio;
		$sql_query = $sql_query . " and (p.objectid,p.num_p1) ";
		$sql_query = $sql_query . "not in (select x.objectid, x.num_p1 ";
		$sql_query = $sql_query . "from indert.in_planopericia1 x ";
		$sql_query = $sql_query . "where x.dpto = '".$dpto."' and  x.distrito = '".$distrito."' and x.municipio = ".$municipio.")) ;";

		$this->response = $this->db->query($sql_query);
		
		return $this;
	}


	public function f_existe_grafico($exp = NULL, $gest = NULL)
	{
		$resultado = $this->db->query("SELECT SEAM_IDE.F_EXISTE_GRAFICO('".$exp."',".$gest.");")->row()->f_existe_grafico;

		return $resultado;
	}


	/**
	 * actualizar_shapes
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function actualizar_shapes($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL, $id_epsg = NULL)
	{

		$resultado = $this->db->query("SELECT indert.actualizar_shapes(".$gid.",'".$dpto_cod."','".$dist_cod."',".$col_cod.",".$id_epsg.");");

		return $resultado;
	}


	/**
	 * validar_shapes
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function validar_shapes($gid = NULL, $id_epsg = NULL)
	{

		$resultado = $this->db->query("SELECT municipal.validar_shapes(".$gid.",".$id_epsg.");");

		return $resultado;
	}


	/**
	 * eliminar_geometrias
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function eliminar_geometrias($gid = NULL)
	{
		$resultado = $this->db->query("SELECT municipal.f_eliminar_geometrias(".$gid.");")->row()->f_eliminar_geometrias;;


		return $resultado;
	}


	/**
	 * validar_pericias
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function validar_pericias($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL)
	{

		$resultado = $this->db->query("SELECT indert.f_validar_pericias(".$gid.",'".$dpto_cod."','".$dist_cod."',".$col_cod.");");

		return $resultado;

	}


	/**
	 * eliminar_in_parc
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function eliminar_in_parc($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL)
	{

		$resultado = $this->db->query("SELECT indert.f_eliminar_in_parc(".$gid.",'".$dpto_cod."','".$dist_cod."',".$col_cod.");");

		return $resultado;

	}


	/**
	 * confirmar_pericia
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function confirmar_pericias($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL)
	{

		$resultado = $this->db->query("SELECT indert.f_confirmar_pericias(".$gid.",'".$dpto_cod."','".$dist_cod."',".$col_cod.");");

		return $resultado;
	}


	/**
	 * habilitar_pericias
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function habilitar_pericias($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL)
	{

		$resultado = $this->db->query("SELECT indert.f_habilitar_pericias(".$gid.",'".$dpto_cod."','".$dist_cod."',".$col_cod.");");

		return $resultado;
	}



	/**
	 * bloquea_planomunicipio
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function bloquear_planomunicipio($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL)
	{

		$resultado = $this->db->query("SELECT indert.f_bloquear_planomunicipio(".$gid.",'".$dpto_cod."','".$dist_cod."',".$col_cod.");");

		return $resultado;
	}

	/**
	 * eliminar_periciaconfirmada
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function eliminar_periciaconfirmada($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL)
	{

		$resultado = $this->db->query("SELECT indert.f_eliminar_periciaconfirmada(".$gid.",'".$dpto_cod."','".$dist_cod."',".$col_cod.");");

		return $resultado;
	}



	/**
	 * campo_valor_maximo
	 *	Obtiene el valor máximo de una columna y tabla específica
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function obtener_valor_campo ($tabla = NULL, $columna = NULL, $arraywhere = NULL)
	{
		$this->db->select($columna." as campo");

		foreach ($arraywhere as $k => $v) {

			$this->db->where($k, $v);
		}

		$this->db->from($this->tables[$tabla]);

		return $this->db->get()->row()->campo;
	}

	/**
	 * contador_registros
	 *	Obtiene la cantidad de registro de una tabla y condición dada
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function contador_registros_all ($tabla = NULL)
	{

		$this->db->from($this->tables[$tabla]);
		return $this->db->count_all_results();
	}

	/**
	 * contador_registros
	 *	Obtiene la cantidad de registro de una tabla y condición dada
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function contador_registros ($tabla = NULL, $arraywhere = NULL)
	{
		foreach ($arraywhere as $k => $v) {

			$this->db->where($k, $v);
		}
		$this->db->from($this->tables[$tabla]);
		return $this->db->count_all_results();
	}

	/**
	 * eliminar_datos_tabla
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function eliminar_datos_tabla($tabla = NULL)
	{
		
		$resultado = $this->db->query("SELECT bya.f_eliminar_datos_tabla('".$tabla."');");

		return $resultado;
	}
	

	/**
	 * eliminar_datos_tabla
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function eliminar_datos_tabla_municipio($tabla = NULL, $gid = NULL)
	{
		
		$resultado = $this->db->query("SELECT bya.f_eliminar_datos_tabla_municipio('".$tabla."',".$gid.");");

		return $resultado;
	}


	/**
	 * copiar_temporal_a_bya
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function copiar_temporal_a_bya($tabla = NULL)
	{

		$resultado = $this->db->query("SELECT bya.copiar_temporal_a_bya('".$tabla."');");

		return $resultado;
	}

	/**
	 * dinamic_copiar_temporal_a_bya
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function dinamic_copiar_temporal_a_bya($tabla = NULL, $gid = NULL, $id_epsg = NULL)
	{

		//$resultado = 0;
		/* Provoca un error -- sintaxis SQL falsa */
		$i_sql = "SELECT bya.dinamic_copiar_temporal_a_bya('".$tabla."',".$gid.",".$id_epsg.");";
		//Prueba 1 $stmt = $this->db->prepare($i_sql);
		//prueba 1 if (!$stmt) {
	    //prueba 2 $this->db->pg_send_query($i_sql);
  		//prueba 2 $res1 = pg_get_result($this->db);
  		//prueba 2 $err = pg_result_error($res1);
		//prueba 2 if (isset($err)) {		
		   // echo "\nPDO::errorInfo():\n";
		   // print_r($dbh->errorInfo());
		   //$resultado = 1;	
		//} else {
	    //    try {
	    //        // insert the new municipio
		//		$resultado = $this->db->query($i_sql);
		//		$resultado = 0;
	    //    }
	    //    catch(Exception $e) {
	    //    	$resultado = 1;
	    //    }
		//}

		//$db_debug = $this->db->db_debug;
		//$this->db->db_debug = FALSE; 
		$resultado = $this->db->query($i_sql); //run query
		//if (isset($result)) {
		//	$resultado = 1;
		//}
		//$this->db->db_debug = $db_debug;

		return $resultado;
	}


	/**
	 * generar_lotes
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function generar_lotes($i_municipio = NULL)
	{
		//$resultado = 0;
		/* Provoca un error -- sintaxis SQL falsa */
		$i_sql = "SELECT bya.dinamic_generar_lotes_usos(".$i_municipio.",'LOTES');";
		$resultado = $this->db->query($i_sql); //run query
		//$i_sql = "SELECT bya.dinamic_generar_lotes_usos(".$i_municipio.",'USO86');";
		//$resultado = $this->db->query($i_sql); //run query		

		return $resultado;
	}		

	/**
	 * actualizar_categorias
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function actualizar_categorias($i_municipio = NULL)
	{
		//$resultado = 0;
		/* Provoca un error -- sintaxis SQL falsa */
		$i_sql = "SELECT bya.actualizar_categorias('USO_ALTERNATIVO',".$i_municipio.");";
		$resultado = $this->db->query($i_sql); //run query
		//$i_sql = "SELECT bya.actualizar_categorias(".$i_municipio.",'USO_ACTUAL');";
		//$resultado = $this->db->query($i_sql); //run query		

		return $resultado;
	}	



	/**
	 * actualizar_usos
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function actualizar_usos($i_tabla = NULL, $i_municipio = NULL)
	{
		$i_sql = "SELECT bya.actualizar_usos('".$i_tabla."',".$i_municipio.");";
		$resultado = $this->db->query($i_sql); //run query	
		return $resultado;
	}


	/**
	 * actualizar_usos
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	/*
	public function actualizar_usos($i_municipio = NULL)
	{
		// $resultado = 0;
		// Provoca un error -- sintaxis SQL falsa 
		//$i_sql = "SELECT bya.actualizar_usos('BLOQUES_USO_ALTERNATIVO',".$i_municipio.");";
		//$resultado = $this->db->query($i_sql); //run query	
		//$i_sql = "SELECT bya.actualizar_usos('ALDEAS_USO_ALTERNATIVO',".$i_municipio.");";
		//$resultado = $this->db->query($i_sql); //run query
		$i_sql = "SELECT bya.actualizar_usos('PARCELAS_USO_ALTERNATIVO',".$i_municipio.");";
		$resultado = $this->db->query($i_sql); //run query	


		//$i_sql = "SELECT bya.actualizar_categorias(".$i_municipio.",'USO_ACTUAL');";
		//$resultado = $this->db->query($i_sql); //run query		

		return $resultado;
	}	
	*/

	/**
	 * actualizar_usos
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function actualizar_usos2($i_municipio = NULL)
	{
		//$resultado = 0;
		/* Provoca un error -- sintaxis SQL falsa */

		//$i_sql = "SELECT bya.actualizar_usos('BLOQUES_USO_ACTUAL',".$i_municipio.");";
		//$resultado = $this->db->query($i_sql); //run query	
		//$i_sql = "SELECT bya.actualizar_usos('ALDEAS_USO_ACTUAL',".$i_municipio.");";
		//$resultado = $this->db->query($i_sql); //run query
		$i_sql = "SELECT bya.actualizar_usos('PARCELAS_USO_ACTUAL',".$i_municipio.");";
		$resultado = $this->db->query($i_sql); //run query


		//$i_sql = "SELECT bya.actualizar_categorias(".$i_municipio.",'USO_ACTUAL');";
		//$resultado = $this->db->query($i_sql); //run query		

		return $resultado;
	}	

	/**
	 * actualizar_usos
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function actualizar_usos3($i_municipio = NULL)
	{
		//$resultado = 0;
		/* Provoca un error -- sintaxis SQL falsa */	

		//$i_sql = "SELECT bya.actualizar_usos('BLOQUES_USO86',".$i_municipio.");";
		//$resultado = $this->db->query($i_sql); //run query	
		//$i_sql = "SELECT bya.actualizar_usos('ALDEAS_USO86',".$i_municipio.");";
		//$resultado = $this->db->query($i_sql); //run query
		$i_sql = "SELECT bya.actualizar_usos('PARCELAS_USO86',".$i_municipio.");";
		$resultado = $this->db->query($i_sql); //run query


		//$i_sql = "SELECT bya.actualizar_categorias(".$i_municipio.",'USO_ACTUAL');";
		//$resultado = $this->db->query($i_sql); //run query		

		return $resultado;
	}
}