// -- Sammy.js -- /plugins/sammy.storage.js
// http://sammyjs.org
// Version: 0.7.6
// Built: 2014-08-26 10:45:34 +0300
(function(factory){if(typeof define==="function"&&define.amd){define(["jquery","sammy"],factory)}else{(window.Sammy=window.Sammy||{}).Storage=factory(window.jQuery,window.Sammy)}})(function($,Sammy){Sammy.Store=function(options){var store=this;this.options=options||{};this.name=this.options.name||"store";this.element=this.options.element||"body";this.$element=$(this.element);if($.isArray(this.options.type)){$.each(this.options.type,function(i,type){if(Sammy.Store.isAvailable(type)){store.type=type;return false}})}else{this.type=this.options.type||"memory"}this.meta_key=this.options.meta_key||"__keys__";this.storage=new Sammy.Store[Sammy.Store.stores[this.type]](this.name,this.element,this.options)};Sammy.Store.stores={memory:"Memory",data:"Data",local:"LocalStorage",session:"SessionStorage",cookie:"Cookie"};$.extend(Sammy.Store.prototype,{isAvailable:function(){if($.isFunction(this.storage.isAvailable)){return this.storage.isAvailable()}else{return true}},exists:function(key){return this.storage.exists(key)},set:function(key,value){var string_value=typeof value=="string"?value:JSON.stringify(value);key=key.toString();this.storage.set(key,string_value);if(key!=this.meta_key){this._addKey(key);this.$element.trigger("set-"+this.name,{key:key,value:value});this.$element.trigger("set-"+this.name+"-"+key,{key:key,value:value})}return value},get:function(key){var value=this.storage.get(key);if(typeof value=="undefined"||value==null||value==""){return value}try{return JSON.parse(value)}catch(e){return value}},clear:function(key){this._removeKey(key);return this.storage.clear(key)},clearAll:function(){var self=this;this.each(function(key,value){self.clear(key)})},keys:function(){return this.get(this.meta_key)||[]},each:function(callback){var i=0,keys=this.keys(),returned;for(i;i<keys.length;i++){returned=callback(keys[i],this.get(keys[i]));if(returned===false){return false}}},filter:function(callback){var found=[];this.each(function(key,value){if(callback(key,value)){found.push([key,value])}return true});return found},first:function(callback){var found=false;this.each(function(key,value){if(callback(key,value)){found=[key,value];return false}});return found},fetch:function(key,callback){if(!this.exists(key)){return this.set(key,callback.apply(this))}else{return this.get(key)}},load:function(key,path,callback){var s=this;$.get(path,function(response){s.set(key,response);if(callback){callback.apply(this,[response])}})},_addKey:function(key){var keys=this.keys();if($.inArray(key,keys)==-1){keys.push(key)}this.set(this.meta_key,keys)},_removeKey:function(key){var keys=this.keys();var index=$.inArray(key,keys);if(index!=-1){keys.splice(index,1)}this.set(this.meta_key,keys)}});Sammy.Store.isAvailable=function(type){try{return Sammy.Store[Sammy.Store.stores[type]].prototype.isAvailable()}catch(e){return false}};Sammy.Store.Memory=function(name,element){this.name=name;this.element=element;this.namespace=[this.element,this.name].join(".");Sammy.Store.Memory.store=Sammy.Store.Memory.store||{};Sammy.Store.Memory.store[this.namespace]=Sammy.Store.Memory.store[this.namespace]||{};this.store=Sammy.Store.Memory.store[this.namespace]};$.extend(Sammy.Store.Memory.prototype,{isAvailable:function(){return true},exists:function(key){return typeof this.store[key]!="undefined"},set:function(key,value){return this.store[key]=value},get:function(key){return this.store[key]},clear:function(key){delete this.store[key]}});Sammy.Store.Data=function(name,element){this.name=name;this.element=element;this.$element=$(element)};$.extend(Sammy.Store.Data.prototype,{isAvailable:function(){return true},exists:function(key){return!!this.$element.data(this._key(key))},set:function(key,value){return this.$element.data(this._key(key),value)},get:function(key){return this.$element.data(this._key(key))},clear:function(key){this.$element.removeData(this._key(key))},_key:function(key){return["store",this.name,key].join(".")}});Sammy.Store.LocalStorage=function(name,element){this.name=name;this.element=element};$.extend(Sammy.Store.LocalStorage.prototype,{isAvailable:function(){return"localStorage"in window&&window.location.protocol!="file:"},exists:function(key){return this.get(key)!=null},set:function(key,value){return window.localStorage.setItem(this._key(key),value)},get:function(key){return window.localStorage.getItem(this._key(key))},clear:function(key){window.localStorage.removeItem(this._key(key))},_key:function(key){return["store",this.element,this.name,key].join(".")}});Sammy.Store.SessionStorage=function(name,element){this.name=name;this.element=element};$.extend(Sammy.Store.SessionStorage.prototype,{isAvailable:function(){return"sessionStorage"in window&&window.location.protocol!="file:"&&$.isFunction(window.sessionStorage.setItem)},exists:function(key){return this.get(key)!=null},set:function(key,value){return window.sessionStorage.setItem(this._key(key),value)},get:function(key){var value=window.sessionStorage.getItem(this._key(key));if(value&&typeof value.value!="undefined"){value=value.value}return value},clear:function(key){window.sessionStorage.removeItem(this._key(key))},_key:function(key){return["store",this.element,this.name,key].join(".")}});Sammy.Store.Cookie=function(name,element,options){this.name=name;this.element=element;this.options=options||{};this.path=this.options.path||"/";this.expires_in=this.options.expires_in||14*24*60*60};$.extend(Sammy.Store.Cookie.prototype,{isAvailable:function(){return"cookie"in document&&window.location.protocol!="file:"},exists:function(key){return this.get(key)!=null},set:function(key,value){return this._setCookie(key,value)},get:function(key){return this._getCookie(key)},clear:function(key){this._setCookie(key,"",-1)},_key:function(key){return["store",this.element,this.name,key].join(".")},_getCookie:function(key){var escaped=this._key(key).replace(/(\.|\*|\(|\)|\[|\])/g,"\\$1");var match=document.cookie.match("(^|;\\s)"+escaped+"=([^;]*)(;|$)");return match?match[2]:null},_setCookie:function(key,value,expires){if(!expires){expires=this.expires_in*1e3}var date=new Date;date.setTime(date.getTime()+expires);var set_cookie=[this._key(key),"=",value,"; expires=",date.toGMTString(),"; path=",this.path].join("");document.cookie=set_cookie}});Sammy.Storage=function(app){this.use(Sammy.JSON);this.stores=this.stores||{};this.store=function(name,options){if(typeof this.stores[name]=="undefined"){var clear_method_name="clear"+name.substr(0,1).toUpperCase()+name.substr(1);this.stores[name]=new Sammy.Store($.extend({name:name,element:this.element_selector},options||{}));this[name]=function(key,value){if(typeof value=="undefined"){return this.stores[name].get(key)}else if($.isFunction(value)){return this.stores[name].fetch(key,value)}else{return this.stores[name].set(key,value)}};this[clear_method_name]=function(){return this.stores[name].clearAll()};this.helper(name,function(){return this.app[name].apply(this.app,arguments)});this.helper(clear_method_name,function(){return this.app[clear_method_name]()})}return this.stores[name]};this.helpers({store:function(){return this.app.store.apply(this.app,arguments)}})};Sammy.Session=function(app,options){this.use(Sammy.Storage);this.store("session",$.extend({type:["local","cookie","memory"]},options))};Sammy.Cache=function(app,options){this.use(Sammy.Storage);this.cache_partials=true;this.store("cache",$.extend({type:["local","session","memory"]},options))};return Sammy.Storage});