<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pestanhas_model extends Ion_auth_model {
	
	public function __construct()
	{
		parent::__construct();
	}
	
	/**
	 * geocolonias
	 *
	 * @return object
	 * @author Ben Edmunds
	 **/
	public function view_all()
	{
		//$this->trigger_events('geocolonias');

		// run each where that was passed
		
		
		if (isset($this->_ion_where) && !empty($this->_ion_where))
		{
			foreach ($this->_ion_where as $where)
			{
				$this->db->where($where);
			}
			$this->_ion_where = array();
		}

		if (isset($this->_ion_limit) && isset($this->_ion_offset))
		{
			$this->db->limit($this->_ion_limit, $this->_ion_offset);

			$this->_ion_limit  = NULL;
			$this->_ion_offset = NULL;
		}
		else if (isset($this->_ion_limit))
		{
			$this->db->limit($this->_ion_limit);

			$this->_ion_limit  = NULL;
		}

		// set the order
		if (isset($this->_ion_order_by) && isset($this->_ion_order))
		{
			$this->db->order_by($this->_ion_order_by, $this->_ion_order);
		}

		$this->response = $this->db->get($this->tables['geocolonias']);
		
		return $this;
	}
	
	public function buscar_geo($abuscar)
	{
        //usamos after para decir que empiece a buscar por
        //el principio de la cadena
        //ej SELECT poblacion from poblacion
        //WHERE poblacion LIKE '%$abuscar' limit 12
        //$this->db->select('geocolonias');

        //$this->db->like('poblacion',$abuscar,'after');

		$resultados = $this->db->get('geocoloniaS');

        //si existe algún resultado lo devolvemos
		if($resultados->num_rows() > 0)
		{

			return $resultados->result();

        //en otro caso devolvemos false
		}else{

			return FALSE;

		}

	}

	/**
	 * geocolonia
	 *
	 * @return object
	 * @author Ben Edmunds
	 **/
	public function view($dpto = NULL, $dist = NULL, $col = NULL)
	{
		$this->trigger_events('geocolonia');

		if (isset($dpto) AND isset($dist) AND isset($col))
		{
			$this->where($this->tables['geocolonias'].'.dpto_cod', 	$dpto 	);
			$this->where($this->tables['geocolonias'].'.dist_cod', 	$dist 	);
			$this->where($this->tables['geocolonias'].'.col_cod', 	$col 	);
		}

		$this->limit(1);
		$this->order_by('gid');
		
		//$this->db->query("SELECT FROM INDERT.GEOCOLONIAS WHERE gid = $id")

		return $this->view_all();
	}

	/**
	 * create_geocolonia
	 *
	 * @author aditya menon
	*/
	public function create_geocolonia($geocolonia_dpto_cod = '', $geocolonia_dist_cod = '', $geocolonia_col_cod = '', $geocolonia_id_codgeo = '', $geocolonia_col_desc = '', $additional_data = array())
	{
		// bail if the dpto_cod was not passed ** Se utiliza la etiqueta de lenguaje spanish
		if(!$geocolonia_dpto_cod)
		{
			$this->set_error('geocolonia_dpto_cod_required');
			return FALSE;
		}
		// bail if the dist_cod was not passed
		if(!$geocolonia_dist_cod)
		{
			$this->set_error('geocolonia_dist_cod_required');
			return FALSE;
		}
		// bail if the col_cod was not passed
		if(!$geocolonia_col_cod)
		{
			$this->set_error('geocolonia_col_cod_required');
			return FALSE;
		}
		// bail if the id_codgeo was not passed
		if(!$geocolonia_id_codgeo)
		{
			$this->set_error('geocolonia_id_codgeo_required');
			return FALSE;
		}
		// bail if the col_desc was not passed
		if(!$geocolonia_col_desc)
		{
			$this->set_error('geocolonia_col_desc_required');
			return FALSE;
		}		
		// bail if the group name already exists
		$existing_geocolonia = $this->db->get_where($this->tables['geocolonias'], array('col_desc' => $geocolonia_col_desc))->num_rows();

		
		if($existing_geocolonia !== 0)
		{
			$this->set_error('geocolonia_already_exists');
			return FALSE;
		}
		
		$data = array('dpto_cod'=>$geocolonia_dpto_cod, 'dist_cod'=>$geocolonia_dist_cod, 'col_cod'=>$geocolonia_col_cod, 'id_codgeo'=>$geocolonia_id_codgeo, 'col_desc'=>$geocolonia_col_desc, 'col_desc'=>$geocolonia_col_desc);
		
		// filter out any data passed that doesnt have a matching column in the groups table
		// and merge the set group data and the additional data
		if (!empty($additional_data)) $data = array_merge($this->_filter_data($this->tables['geocolonias'], $additional_data), $data);

		$this->trigger_events('extra_geocolonia_set');

		// insert the new group
		$this->db->insert($this->tables['geocolonias'], $data);
		$geocolonia_gid = $this->db->insert_id();

		// report success
		$this->set_message('geocolonia_creation_successful');
		// return the brand new group id
		return $geocolonia_gid;
	}
	
	/**
	 * update_gepcolonia
	 *
	 * @return bool
	 * @author aditya menon
	 **/

	public function update_geocolonia($gid = FALSE, $geocolonia_dpto_cod = FALSE, $geocolonia_dist_cod = FALSE, $geocolonia_col_cod = FALSE, $geocolonia_id_codgeo = FALSE, $geocolonia_col_desc = FALSE, $additional_data = array())
	{
		if (empty($gid) AND empty($geocolonia_dpto_cod) AND empty($geocolonia_dist_cod) AND empty($geocolonia_col_cod) AND empty($geocolonia_id_codgeo) AND empty($geocolonia_col_desc)) return FALSE;

		$data = array();

		if (!empty($gid) AND !empty($geocolonia_dpto_cod) AND !empty($geocolonia_dist_cod) AND !empty($geocolonia_col_cod) AND !empty($geocolonia_id_codgeo) AND !empty($geocolonia_col_desc))
		{
			// we are changing the col_desc, so do some checks

			// bail if the geocolonia col_desc already exists
			$existing_geocolonia = $this->db->get_where($this->tables['geocolonias'], array('dpto_cod' => $geocolonia_dpto_cod, 'dist_cod' => $geocolonia_dist_cod, 'col_cod' => $geocolonia_col_cod, 'id_codgeo' => $geocolonia_id_codgeo))->row();

			if(isset($existing_geocolonia->gid) && $existing_geocolonia->gid != $gid)
			{
				$this->set_error('geocolonia_already_exists');
				return FALSE;
			}
			/*
			if (strlen($geocolonia_dpto_cod) > 2) 
			{
				$this->set_error('geocolonia_already_exists');
				return FALSE;
			}
			*/
			$data['dpto_cod'] = $geocolonia_dpto_cod;
			$data['dist_cod'] = $geocolonia_dist_cod;
			$data['col_cod'] = $geocolonia_col_cod;
			$data['id_codgeo'] = $geocolonia_id_codgeo;
			$data['col_desc'] = $geocolonia_col_desc;
		}

		// restrict change of name of the admin group
		$geocolonia = $this->db->get_where($this->tables['geocolonias'], array('gid' => $gid))->row();

        /*if($this->config->item('admin_group', 'ion_auth') === $geocolonia->dpto_cod && $geocolonia_dpto_cod !== $geocolonia->dpto_cod)
        {
            $this->set_error('group_name_admin_not_alter');
            return FALSE;
        }*/

		// IMPORTANT!! Third parameter was string type $description; this following code is to maintain backward compatibility
		// New projects should work with 3rd param as array
        if (is_string($additional_data)) $additional_data = array('col_cod' => $additional_data);


		// filter out any data passed that doesnt have a matching column in the groups table
		// and merge the set group data and the additional data
        if (!empty($additional_data)) $data = array_merge($this->_filter_data($this->tables['geocolonias'], $additional_data), $data);


        $this->db->update($this->tables['geocolonias'], $data, array('gid' => $gid));

        $this->set_message('geocolonias_update_successful');

        return TRUE;
    }



    public function departamentos()
    {
    	$this->response = $this->db->get($this->tables['departamentos']);

    	return $this;
    }

    public function distritos()
    {
    	$this->response = $this->db->query("SELECT * FROM INDERT.DISTRITOS ORDER BY DISTRITO");
    	return $this;
    }
 

	public function num_post()
	{			
		$number = $this->db->query("SELECT count(*) as number FROM indert.geocolonia")->row()->number; //rápido
		return intval($number);
	}
}