<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Tramos extends Admin_Controller {

	public function __construct()
	{ 
		parent::__construct();

		$this->load->model('tramos/tramos_model');
		$this->lang->load('tramos/tramos_lang');

		/* Titulo de la pagina :: Common */
		$this->page_title->push(lang('menu_tramos'));
		$this->data['pagetitle'] = $this->page_title->show();

		//verificación de módulo para el reset de las variables de sessión utilizadas en la misma
		if ($_SESSION['id_modulo'] != 'TRAMOS') {

			$_SESSION['arraywhere_tramos'] 		 = NULL;
			$_SESSION['arraywhere_tramos_busqueda'] = NULL;
			$_SESSION['id_modulo'] = 'TRAMOS';
		}
		
		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_tramos'), 'tramos/tramos');
	}

	public function index()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{	


/*

	id_tramo
    cod_geografico 
    nombre 
    fecha 
    hora 
    usuario 
*/

			if ($_POST) { 
				if ($_POST['id_tramo']) 
				{
					if (is_numeric($_POST['id_tramo'])) {
						$arraywhere['id_tramo'] 					= $_POST['id_tramo'];
						$arraywherebusq['id_tramo'] 				= $_POST['id_tramo'];
					}
				}
				if ($_POST['cod_geografico']) 
				{
					$arraywhere['cod_geografico'] 					= $_POST['cod_geografico'];
					$arraywherebusq['cod_geografico like '] 		= '%'.$_POST['cod_geografico'].'%';
				}
				if ($_POST['nombre']) 
				{
					$arraywhere['nombre'] 					= $_POST['nombre'];
					$arraywherebusq['nombre like '] 		= '%'.$_POST['nombre'].'%';
				}
				if ($_POST['fecha']) 
				{
					$arraywhere['fecha'] 					= $_POST['fecha'];
					$arraywherebusq['lower(fecha) like '] 	= '%'.strtolower($_POST['fecha']).'%';
				}
				if ($_POST['hora']) 
				{
					$arraywhere['hora'] 					= $_POST['hora'];
					$arraywherebusq['lower(hora) like '] 	= '%'.strtolower($_POST['hora']).'%';
				}
				if ($_POST['usuario']) 
				{
					$arraywhere['usuario'] 						= $_POST['usuario'];
					$arraywherebusq['lower(usuario) like '] 		= '%'.strtolower($_POST['usuario']).'%';
				}
				$_SESSION['arraywhere_tramos'] = $arraywhere;
				$_SESSION['arraywhere_tramos_busqueda'] = $arraywherebusq;

				redirect('tramos/tramos/index/');				
			}
			 // ----- Paginacion Generica 
			$mi_paginacion = $this->ion_auth->paginacion_generica(
				12, 						// resultados por por_pagina, 
				4, 							// segmento uri a leer, 
				5, 							// cantidad_enlaces,
				base_url(). 'tramos/tramos/index/',  // url completa de la pagina paginada
				'tramos',		            // scheme y nombre de la tabla, para la consulta
				$_SESSION['arraywhere_tramos_busqueda']
				);
			$this->data['pagination'] 		= $mi_paginacion['pagination'];
			$this->data['tramos']	  	= $this->ion_auth_model->segmentador_paginas(
			//$tramos	  	= $this->ion_auth_model->segmentador_paginas(
 				$mi_paginacion['per_page'], 	// resultados por pagina
 				4,								// segmento uri a leer
 				'tramos',					    // el nombre de la tabla a consultar $nombre_tabla
 				$_SESSION['arraywhere_tramos_busqueda']
 				)->result();
			// ----- Fin paginacion  
			foreach ($this->data['tramos'] as $key => $value) {
				$i = 0;
				foreach ($value as $k => $val) {
					$i = $i + 1;
					if ($i == 1) {
						//$cant_pol = $this->tramos_model->f_existe_grafico_expe_id($value->expe_id);
						//$exp['existe_poligono'] = $cant_pol;
						$exp['existe_poligono'] = 1;
						//if (grupo_usuario(17) or grupo_usuario(27)) {
							$exp['grupo_usuario'] = 'C';	
						//}else{
						//	$exp['grupo_usuario'] = 'N';
						//}
					}
					$exp[$k] = $val;
				}
				$exps[] = (object)$exp;
			}
			if (isset($exps)) {
				$this->data['tramos'] = $exps;
			}else{
				$this->data['tramos'] = NULL;
			}
			//emite un mensaje si es que se eliminó un expediente
			if (isset($_SESSION['last_exp_delete'])) {
				$this->session->set_flashdata('message', $_SESSION['last_exp_delete']);
				unset($_SESSION['last_exp_delete']);
			}
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
			/* Breadcrumbs */
			$this->data['breadcrumb'] = $this->breadcrumbs->show();
			/* Load Template */
            $this->template->admin_render('tramos/index', $this->data);
		}
	}

	public function reset_busqueda()
	{
		$_SESSION['arraywhere_tramos'] 			= NULL;
		$_SESSION['arraywhere_tramos_busqueda'] 	= NULL;
		
		redirect('tramos/tramos/index/');				
	}

	public function ver_exp($expe_id)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{	
			/* Breadcrumbs */
	        $this->breadcrumbs->unshift(2, 'Información Expediente', 'admin/groups/profile');
	        $this->data['breadcrumb'] = $this->breadcrumbs->show();

			$this->data['expe_info']  = $this->tramos_model->view('exp', array('expe_id' => $expe_id))->result();
	        
			/* Load Template */
            $this->template->admin_render('tramos/ver_expediente', $this->data);
		}
	}

	public function create()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('tramos_create'), 'tramos/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Validate form input */

		$this->form_validation->set_rules('nombre', 		'<b>Nombre</b>' , 		 'required');
		
		//$this->form_validation->set_rules('expe_id_geomatica', 	'<b>ID Geomática</b>' ,  'required');
		
		if ($this->form_validation->run() == TRUE)
		{

/*
  id_tramo
  cod_geografico
  nombre
  fecha
  hora 
  usuario 
*/
/*
  id_tramo integer NOT NULL DEFAULT nextval('tramos_id_tramo_seq'::regclass),
  cod_geografico character varying(50) NOT NULL,
  nombre character varying(200) NOT NULL,
  fecha date DEFAULT ('now'::text)::date,
  hora character varying(5) DEFAULT to_char(now(), 'HH24:MI'::text),
  usuario character varying(50),
  tramo_padre integer, -- Padre del tramo
  id_proyecto
*/
			
				//show_error(2);
	        	if ($_POST['id_tramo']){
					$arraycampos['id_tramo'] 			= $_POST['id_tramo'];
				}

        		if ($_POST['cod_geografico']){
	        		$arraycampos['cod_geografico'] 		= $_POST['cod_geografico'];
	        	}

	        	if ($_POST['nombre']){
	        		$arraycampos['nombre'] 				= $_POST['nombre'];
	        	}

				if ($_POST['fecha']){
					$arraycampos['fecha'] 				= $_POST['fecha'];
				}

				if ($_POST['hora']){
					$arraycampos['hora'] 				= $_POST['hora'];
				}

				if ($_POST['usuario']){
					$arraycampos['usuario'] 			= $_POST['usuario'];
				}

				if ($_POST['tramo_padre']){
					$arraycampos['tramo_padre'] 		= $_POST['tramo_padre'];
				}
				
				if ($_POST['id_proyecto']){
					$arraycampos['id_proyecto'] 		= $_POST['id_proyecto'];
				}
			$accion = 0;	
			if (isset($_POST['accion'])){
				$accion = intval($_POST['accion']);
			}else{
				$accion = 0;	
			}

			$tramos_create = $this->tramos_model->crear_tramo($arraycampos);

        	if ($tramos_create)
        	{
				if($accion===1){ /// ACCION PARA OBSERVAR 						

        			$this->session->set_flashdata('message', '¡Tramo <b>'.$_POST['id_tramo'].'</b>, ID tramo <b>'.$_POST['id_tramo'].'</b> creado exitósamente!');
					redirect('tramos/tramos/create_tramo/'.$tramos_create);

				} else {

        			$this->session->set_flashdata('message', '¡Error al crear el tramo <b>'.$_POST['id_tramo'].'!');
					redirect('tramos/tramos/create_tramo/'.$tramos_create);
				}
			}
			else 
			{
				$this->session->set_flashdata('message', $this->ion_auth->errors());
			}
		}
		else
		{
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));


			$this->data['id_tramo'] = array(
				'type'     => 'text',
				'name'     => 'id_tramo',
				'id'       => 'id_tramo',
				'value'    => $this->form_validation->set_value('id_tramo'),
				'class'    => 'form-control',
				'maxlength'=> '10',
				'readonly' => TRUE
			);				
			$this->data['cod_geografico'] = array(
				'type'     => 'text',
				'name'     => 'cod_geografico',
				'id'       => 'cod_geografico',
				'value'    => $this->form_validation->set_value('cod_geografico'),
				'class'    => 'form-control',
				'maxlength'=> '10'
			);
			$this->data['nombre'] = array(
				'type'     => 'text',
				'name'     => 'nombre',
				'id'       => 'nombre',
				'value'    => $this->form_validation->set_value('nombre'),
				'class'    => 'form-control',
			);
			$this->data['fecha'] = array(
				'type'     => 'text',
				'name'     => 'fecha',
				'id'       => 'fecha',
				'value'    => $this->form_validation->set_value('fecha'),
				'class'    => 'form-control'
			);
			$this->data['hora'] = array(
				'type'     => 'text',
				'name'     => 'hora',
				'id'       => 'hora',
				'value'    => $this->form_validation->set_value('hora'),
				'class'    => 'form-control',
				'maxlength'=> '10'
			);	
			$this->data['usuario'] = array(
				'type'     => 'text',
				'name'     => 'usuario',
				'id'       => 'usuario',
				'value'    => $this->form_validation->set_value('usuario'),
				'class'    => 'form-control',
				'onkeyup'  => 'limit_dig(this.id,10)'
			);
			$proyectos[''] = 'Selecciona el proyecto';
            $proyecto = $this->tramos_model->dropdown_data('proyectos')->result_array();
            foreach ($proyecto as $item) {
                $proyectos[$item['id_proyecto']] = $item['codigo_proyecto'].' - '.$item['descripcion'];
            }
            $this->data['proyecto'] = $proyectos;

            $tramos[''] = 'Selecciona el Tramo Padre';
			$this->data['tramo'] = $tramos;
			
			/*
			$tramos[''] = 'Selecciona el Tramo Padre';
            $tramo = $this->tramos_model->dropdown_data('tramos')->result_array();
            foreach ($tramo as $item) {
                $tramos[$item['id_tramo']] = $item['id_tramo'].' - '.$item['nombre'];
            }
            $this->data['tramo'] = $tramos;
			*/
			
			$this->template->admin_render('tramos/create_tramos', $this->data);
		}
	}













	public function edit_tramo($id_tramo)
	{
//OR ! isset($id_tramo)
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin()  OR empty($id_tramo))
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_tramos_edit'), 'tramos/edit_tramo');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Variables *///Trae de la base de datos la fila seleccionada
        $tramo = $this->tramos_model->view('tramos', array('id_tramo' => $id_tramo))->row();

        $this->data['id_tramo'] = $id_tramo;

        /* Validate form input */
        //$this->form_validation->set_rules('tramo_padre', '<b>Tramo</b>' , 'required');

		//Se produce cuando el usuario da click en el submit
        if (isset($_POST) && ! empty($_POST))
        {
        	if ($this->form_validation->run() == TRUE)
        	{
/*
  id_tramo integer NOT NULL DEFAULT nextval('tramos_id_tramo_seq'::regclass),
  cod_geografico character varying(50) NOT NULL,
  nombre character varying(200) NOT NULL,
  fecha date DEFAULT ('now'::text)::date,
  hora character varying(5) DEFAULT to_char(now(), 'HH24:MI'::text),
  usuario character varying(50),
  tramo_padre integer, -- Padre del tramo
  id_proyecto
*/				if ($_POST['tramo_padre']){
					$arraycampos['tramo_padre'] 			= $_POST['tramo_padre'];
				}

        		if ($_POST['cod_geografico']){
	        		$arraycampos['cod_geografico'] 		= $_POST['cod_geografico'];
	        	}

	        	if ($_POST['nombre']){
	        		$arraycampos['nombre'] 		= $_POST['nombre'];
	        	}

				if ($_POST['fecha']){
					$arraycampos['fecha'] 			= $_POST['fecha'];
				}

				if ($_POST['hora']){
					$arraycampos['hora'] 			= $_POST['hora'];
				}

				if ($_POST['usuario']){
					$arraycampos['usuario'] 	= $_POST['usuario'];
				}
				
				$accion = 0;	
				if (isset($_POST['accion'])){
					$accion = intval($_POST['accion']);
				}else{
					$accion = 0;	
				}

				$unique_exp = $this->tramos_model->view('tramos',array('id_tramo' => $id_tramo))->num_rows();

				$actualizar_tramos = $this->tramos_model->actualizar_tramos($id_tramo,$arraycampos);

        		//if ($resul) 
        		if ($actualizar_tramos) 
        		{
					//una prueba de que trae los valores es reemplazando $this->lang->line('edit_geocolonia_saved') por $_POST('id') por ejemplo
        			$this->session->set_flashdata('message', $this->lang->line('tramos_update_successful'));
					redirect('tramos/tramos/edit_tramo/'.$id_tramo);
				}
				else
				{
					$this->session->set_flashdata('message', $this->ion_auth->errors());
				}

				//aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
				//redirect('man_espacial/geocolonias/geocolonias', 'refresh'); 
			}
		}

		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
			
		//creando campos
		$this->data['id_tramo'] = array(
			'type'     => 'hidden',
			'name'     => 'id_tramo',
			'id'       => 'id_tramo',
			'value'    => $this->form_validation->set_value('id_tramo', $tramo->id_tramo),
			'class'    => 'form-control',
			'maxlength'=> '10',
			'readonly' => TRUE
		);			
		$this->data['cod_geografico'] = array(
			'type'     => 'text',
			'name'     => 'cod_geografico',
			'id'       => 'cod_geografico',
			'value'    => $this->form_validation->set_value('cod_geografico', $tramo->cod_geografico),
			'class'    => 'form-control',
			'maxlength'=> '10'

		);			
		$this->data['nombre'] = array(
			'type'     => 'text',
			'name'     => 'nombre',
			'id'       => 'nombre',
			'value'    => $this->form_validation->set_value('nombre', $tramo->nombre),
			'class'    => 'form-control',
			'maxlength'=> '10'
		
		);
		$this->data['fecha'] = array(
			'type'     => 'text',
			'name'     => 'fecha',
			'id'       => 'fecha',
			'value'    => $this->form_validation->set_value('fecha', formato_fecha($tramo->fecha)),
			'class'    => 'form-control'
		);

		$this->data['hora'] = array(
			'type'     => 'text',
			'name'     => 'hora',
			'id'       => 'hora',
			'value'    => $this->form_validation->set_value('hora', $tramo->hora),
			'class'    => 'form-control',
			'maxlength'=> '30'
		);	
		$this->data['usuario'] = array(
			'type'     => 'text',
			'name'     => 'usuario',
			'id'       => 'usuario',
			'value'    => $this->form_validation->set_value('usuario', $tramo->usuario),
			'class'    => 'form-control',
			'maxlength'=> '30'
		);

		$proyectos[''] = 'Selecciona el proyecto';
		$proyecto = $this->tramos_model->dropdown_data('proyectos')->result_array();
		foreach ($proyecto as $item) {
			$proyectos[$item['id_proyecto']] = $item['codigo_proyecto'].' - '.$item['descripcion'];
		}
		$this->data['proyecto'] = $proyectos;
		$this->data['proyecto_sel'] = $tramo->id_proyecto;

		$tramos[''] = 'Selecciona el tramo padre';
		$tramo_item = $this->tramos_model->dropdown_data('tramos', array('id_proyecto' => $tramo->id_proyecto))->result_array();
		foreach ($tramo_item as $item) {
			$tramos[$item['id_tramo']] = $item['cod_geografico'].' - '.$item['nombre'].' - '.$item['id_proyecto'];
		}
		$this->data['tramo_padre'] = $tramos;
		$this->data['tramo_padre_sel'] = $tramo->tramo_padre;
			
		
		/*
		$tramos[''] = 'Seleccione el tramo';
            $tramo = $this->expedientes_model->dropdown_data('tramos', array('id_proyecto' => $expediente->id_proyecto,'tramo_padre =' => null))->result_array();
            foreach ($tramo as $item) {
                $tramos[$item['id_tramo']] = $item['nombre'];
            }
            $this->data['tramo'] = $tramos;
            $this->data['tramo_sel'] = $expediente->id_tramo;

            $subtramos[''] = 'Seleccione el subtramo';
            $subtramo = $this->expedientes_model->dropdown_data('tramos', array('tramo_padre' => $expediente->id_tramo, 'id_proyecto' => $expediente->id_proyecto))->result_array();
            foreach ($subtramo as $item) {
                $subtramos[$item['id_tramo']] = $item['nombre'];
            }
            $this->data['subtramo'] = $subtramos;
			$this->data['subtramo_sel'] = $expediente->id_subtramo;
			
			$departamentos[''] = 'Seleccione el departamento';
            $departamento = $this->expedientes_model->dropdown_data('departamentos')->result_array();
            foreach ($departamento as $dep) {
                $departamentos[$dep['dpto']] = $dep['dpto'].' - '.$dep['dpto_desc'];
            }
            $this->data['departamento'] = $departamentos;
            $this->data['departamento_sel'] = $expediente->id_departamento;

            $distritos[''] = 'Seleccione el distrito';
            $distrito = $this->expedientes_model->dropdown_data('distritos', array('dpto' => $expediente->id_departamento))->result_array();
            foreach ($distrito as $dist) {
                $distritos[$dist['distrito']] = $dist['distrito'].' - '.$dist['dist_desc'];
            }
            $this->data['distrito'] = $distritos;
            $this->data['distrito_sel'] = $expediente->id_distrito;


		*/
		 


		
		/* Load Template */

		$this->template->admin_render('tramos/edit_tramos', $this->data);
	}
  
	public function tiene_salida()
	{
		$expe_id = $_POST['expe_id'];

		$expe = $this->tramos_model->view('exp', array('expe_id' => $expe_id, 'expe_estado' => 'P'))->row();

		if ($expe) {
			echo 'SI';
		}else{
			echo 'NO';
		}
	}











	public function existe_grafico()
	{
		$id_expediente 	= $_POST['id_expediente'];
		$gestion 		= $_POST['gestion'];

		$expe = $this->tramos_model->existe_grafico($id_expediente, $gestion)->row()->f_existe_grafico;
		
		echo $expe;
	}
  

	public function existe_grafico_expe_id()
	{
		$expe_id 	= $_POST['expe_id'];

		$expe = $this->tramos_model->existe_grafico_expe_id($expe_id)->row()->f_existe_grafico_expe_id;
		
		echo $expe;
	}


	public function existe_exp()
	{
		$exp 		= $_POST['exp'];
		$gestion 	= $_POST['gest'];

		$expe = $this->tramos_model->dropdown_data('exp', array('expe_id_expediente' => $exp, 'expe_gestion' => $gestion))->num_rows();

		if ($expe > 0) {
			echo 'SI';
		}else{
			echo 'NO';
		}
	}

	public function existe_exp_uk()
	{
	
		$codigo 		= $_POST['codigo'];
		$id_proyecto 	= $_POST['id_proyecto'];

		$expe = $this->tramos_model->dropdown_data('tramos', array('codigo' => $codigo, 
			                                                          'id_proyecto' => $id_proyecto
			                                                          ))->num_rows();

		if ($expe > 0) {
			echo 'SI';
		}else{
			echo 'NO';
		}
	}


	public function reingreso_exp()
	{
		$exp 	= $_POST['exp'];
		$gest 	= $_POST['gest'];

		$expe_id = $this->tramos_model->dropdown_data('exp', array('expe_id_expediente' => $exp, 'expe_gestion' => $gest))->row()->expe_id;

		echo $expe_id;

		//$reingreso  = $this->tramos_model->actualizar_expediente($expe_id, array('expe_id_expediente_ref' => $exp, 'expe_id' => ));

		
		//redirect('tramos/tramos/edit_expe/'.$expe_id);
	}

	public function dar_salida_expe($expe_id, $expe_id_expediente, $expe_gestion, $expe_provdg = NULL)
	{

		$i_exp 		= $expe_id_expediente;
		$i_gest 	= $expe_gestion;


					$i_user = $this->session->userdata('username');
					//echo $i_user;
					//show_error(1);



		if (!is_null($i_exp) AND $i_gest > 0) {
			if (grupo_usuario(18)) {


				//if ($expe_provdg == NULL) {
				if (is_null($expe_provdg)) {
					$provdg = 0;
				}else{
					$provdg = $expe_provdg;
				}

				if ($provdg == 0) {
					$i_max = $this->tramos_model->campo_valor_maximo('exp', 'expe_provdg' , array('expe_director' => $i_user ));

					$i_max = $i_max+1;

					$str 	= date_default_timezone_get();
					$fecha  = date("d/m/Y", strtotime($str));

					$salida = $this->tramos_model->actualizar_expediente($expe_id, array('expe_provdg'   => $i_max, 
																					 		  'expe_director' => $this->session->userdata('username'),
																					 		  'expe_salida'   => $fecha,
																					 		  'expe_estado'   => 'P'));
					if ($salida) {
						$this->session->set_flashdata('message', '¡Se DIÓ SALIDA exitósamente!');
						redirect('tramos/tramos/edit_expe/'.$expe_id);
					}else{
						$this->session->set_flashdata('message', '¡No se pudo DAR SALIDA!');
						redirect('tramos/tramos/edit_expe/'.$expe_id);
					}
				}else{
					$this->session->set_flashdata('message', '¡Campo PROV. DG sin dato!');
					redirect('tramos/tramos/edit_expe/'.$expe_id);
				}
			}else{
				$this->session->set_flashdata('message', 'NO TIENE PRIVILEGIOS PARA ESTA ACCIÓN');
				redirect('tramos/tramos/edit_expe/'.$expe_id);
			}
		}else{
			redirect('tramos/tramos/edit_expe/'.$expe_id);
		}
	}

	public function anular_salida_expe($expe_id) 
	{

		//echo($expe_id);
		$expe = $this->tramos_model->dropdown_data('exp', array('expe_id' => $expe_id))->result();


		//echo '<option value="">Seleccione el distrito</option>';

		foreach ($expe as $value) {
			$i_exp 		 = $value->expe_id_expediente;
			$i_gest 	 = $value->expe_gestion;
			$i_provdg = $value->expe_provdg;
		}

		if (!is_null($i_exp) AND $i_gest > 0) {
			if (grupo_usuario(18)) {

				if ($i_provdg == NULL) {
					$provdg = 0;
				}else{
					$provdg = $i_provdg;
				}

				if ($provdg != 0) {
					
					$salida = $this->tramos_model->actualizar_expediente($expe_id, array('expe_provdg'   => NULL, 
																					 		  'expe_director' => '',
																					 		  'expe_salida'   => NULL,
																					 		  'expe_estado'   => 'A'));
					if ($salida) {
						$this->session->set_flashdata('message', '¡Se ANULÓ LA SALIDA exitósamente!');
						redirect('tramos/tramos/edit_expe/'.$expe_id);
					}else{
						$this->session->set_flashdata('message', '¡No se pudo ANULAR SALIDA!');
						//redirect('tramos/tramos/edit_expe/'.$expe_id);
						redirect('tramos/tramos/index/');				
					}
				}
			}else{
				$this->session->set_flashdata('message', 'NO TIENE PRIVILEGIOS PARA ESTA ACCIÓN');
				//redirect('tramos/tramos/index/'.$expe_id);
				redirect('tramos/tramos/index/');				
			}
		}else{
			//redirect('tramos/tramos/index/'.$expe_id);
			redirect('tramos/tramos/index/');				
		}
	}


	public function call_bat()
	{
		$cmd = system('cmd /c C:/espacio_trabajo/importar_shape_ide.bat');
	}


	public function form_expediente()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_tramos'), 'geocolonias/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Validate form input */
		$this->form_validation->set_rules('col_cod', 'lang:geocolonia_col_cod' , 'required');
		$this->form_validation->set_rules('col_desc','lang:geocolonia_col_desc', 'required');

		if ($this->form_validation->run() == TRUE)
		{
			$arraycampos = array('dpto_cod' 	=> $_POST['dpto_cod'],
								 'dist_cod' 	=> $_POST['dist_cod'],
								 'id_codgeo' 	=> $_POST['id_codgeo'],
								 'col_cod' 		=> $_POST['col_cod'],
								 'col_desc' 	=> strtoupper($_POST['col_desc']),
								);

			$new_geocolonia_id = $this->geocolonias_model->create_geocolonia($arraycampos);
			if ($new_geocolonia_id)
			{
				$this->session->set_flashdata('message', $this->ion_auth->messages());

				redirect('man_espacial/geocolonias/geocolonias');
			}
		}
		else
		{
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

			$this->data['dpto_cod'] = array(
				'name'  => 'dpto_cod',
				'id'    => 'dpto_cod',
				'type'  => 'text',
				'class' => 'form-control',
				//'value' => $this->form_validation->set_value('dpto_cod')
				);
			$this->data['dist_cod'] = array(
				'name'  => 'dist_cod',
				'id'    => 'dist_cod',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('dist_cod')
				);
			$this->data['col_cod'] = array(
				'name'  => 'col_cod',
				'id'    => 'col_cod',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('col_cod')
				);
			$this->data['id_codgeo'] = array(
				'name'  => 'id_codgeo',
				'id'    => 'id_codgeo',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('id_codgeo'),
				'readonly' => true,
				);
			$this->data['col_desc'] = array(
				'name'  => 'col_desc',
				'id'    => 'col_desc',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('col_desc')
				);

			$dptos[''] = 'Seleccione el departamento';
			$departamentos = $this->tramos_model->dropdown_data('departamentos','','dpto_id_departamento')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($departamentos as $dpto) {
				$dptos[$dpto['dpto_id_departamento']] = $dpto['dpto_id_departamento'].' - '.$dpto['dpto_descripcion'];
			}
			$this->data['departamentos'] = $dptos;
			
			///* Load Template */
			$this->template->admin_render('tramos/form_expediente', $this->data);
		}
	}

	public function trae_distritos()
	{
		$dpto 	   = $_POST['expe_id_departamento'];

		$distritos = $this->tramos_model->dropdown_data('distritos',array('dist_id_departamento' => $dpto), 'dist_id_ciudad')->result();

		echo '<option value="">Seleccione el distrito</option>';
		foreach ($distritos as $value) {
			echo '<option value="' . $value->dist_id_ciudad . '">' . $value->dist_id_ciudad . ' - ' . $value->dist_descripcion . '</option>';
		}

		//echo json_encode($distritos);
	}

	public function trae_expe_ref()
	{
		$expe 	   = $_POST['expe_id_expediente_ref'];

		$expes = $this->tramos_model->dropdown_data('exp',array('expe_id_expediente_ref' => $expe), 'expe_id')->result();

		echo '<option value="">Seleccione Expediente</option>';
		foreach ($expes as $value) {

			$expes[$ex['expe_id']] = $ex['expe_id_expediente'].'-'.$ex['expe_gestion'].'-'.$ex['expe_id_dependencia'].'-'.$ex['expe_secuencia'];

			echo '<option value="' . $value->expe_id . '">' . $value->expe_id_expediente . '-' . $value->expe_gestion . '-' . $value->expe_id_dependencia . '-' . $value->expe_secuencia .  '</option>';
		}

		//echo json_encode($distritos);
	}

	public function delete()
	{
		$delete  = $this->tramos_model->eliminar_expediente($_POST['expe_id']);
		//$this->session->set_flashdata('message', '¡El expediente <b>'.$_POST['exp'].'</b>, gestión <b>'.$_POST['gest'].'</b> se eliminó correctamente!');

		$_SESSION['last_exp_delete'] = '¡El expediente <b>'.$_POST['exp'].'</b>, gestión <b>'.$_POST['gest'].'</b> se eliminó correctamente!';

		echo 'SI';
		//redirect('tramos/tramos/index');
	}

	

}
