<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Titulares extends Admin_Controller {

	public function __construct()
	{ 
		parent::__construct();

		$this->load->model('titulares/titulares_model');
		$this->lang->load('titulares/titulares_lang');

		/* Titulo de la pagina :: Common */
		$this->page_title->push(lang('menu_titulares'));
		$this->data['pagetitle'] = $this->page_title->show();

		//verificación de módulo para el reset de las variables de sessión utilizadas en la misma
		if ($_SESSION['id_modulo'] != 'TITULARES') {

			$_SESSION['arraywhere_titulares'] 		 = NULL;
			$_SESSION['arraywhere_titulares_busqueda'] = NULL;
			$_SESSION['id_modulo'] = 'TITULARES';
		}
		
		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_titulares'), 'titulares/titulares');
	}

	public function index()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{	


/*
  id_titular 
  nombre_completo
  id_tipo_via
  direccion
  c_postal
  telefono
  fecha 
  hora 
  codigo_pais
  id_tipo_titular
  apellido1 
  apellido2 
  nombrepila 
  id_provincia 
  id_poblacion 
  id_tipo_identificacion 
  identificacion 
  identificacion_vigor
  fecha_nacimiento
  codigo_nacionalidad 
  usuario 
*/


			if ($_POST) { 




				if ($_POST['id_titular']) 
				{
					if (is_numeric($_POST['id_titular'])) {
						$arraywhere['id_titular'] 					= $_POST['id_titular'];
						$arraywherebusq['id_titular'] 				= $_POST['id_titular'];
					}
				}
				

				if ($_POST['nombre_completo']) 
				{
					$arraywhere['nombre_completo'] 					= $_POST['nombre_completo'];
					$arraywherebusq['nombre_completo like '] 		= '%'.$_POST['nombre_completo'].'%';
				}


				if ($_POST['id_tipo_via']) 
				{
					if (is_numeric($_POST['id_tipo_via'])) {
						$arraywhere['id_tipo_via'] 					= $_POST['id_tipo_via'];
						$arraywherebusq['id_tipo_via'] 				= $_POST['id_tipo_via'];
					}
				}


				if ($_POST['direccion']) 
				{
					$arraywhere['direccion'] 					= $_POST['direccion'];
					$arraywherebusq['lower(direccion) like '] 	= '%'.strtolower($_POST['direccion']).'%';
				}

				if ($_POST['c_postal']) 
				{
					$arraywhere['c_postal'] 					= $_POST['c_postal'];
					$arraywherebusq['lower(c_postal) like '] 	= '%'.strtolower($_POST['c_postal']).'%';
				}

				if ($_POST['telefono']) 
				{
					$arraywhere['telefono'] 						= $_POST['telefono'];
					$arraywherebusq['lower(telefono) like '] 		= '%'.strtolower($_POST['telefono']).'%';
				}

				if ($_POST['fecha']) 
				{
					$arraywhere['fecha'] 						= $_POST['fecha'];
					$arraywherebusq['lower(fecha) like ']		= '%'.strtolower($_POST['fecha']).'%';
				}

				if ($_POST['hora']) 
				{
					$arraywhere['hora'] 						= $_POST['hora'];
					$arraywherebusq['lower(hora) like ']		= '%'.strtolower($_POST['hora']).'%';
				}

				if ($_POST['codigo_pais']) 
				{
					$arraywhere['codigo_pais'] 					= $_POST['codigo_pais'];
					$arraywherebusq['lower(codigo_pais) like '] 	= '%'.strtolower($_POST['codigo_pais']).'%';
				}

				if ($_POST['id_tipo_titular']) 
				{
					$arraywhere['id_tipo_titular'] 					= $_POST['id_tipo_titular'];
					$arraywherebusq['lower(id_tipo_titular) like '] 	= '%'.strtolower($_POST['id_tipo_titular']).'%';
				}

				if ($_POST['apellido1']) 
				{
					$arraywhere['apellido1'] 					= $_POST['apellido1'];
					$arraywherebusq['lower(apellido1) like '] 	= '%'.strtolower($_POST['apellido1']).'%';
				}

				if ($_POST['apellido2']) 
				{
					$arraywhere['apellido2'] 					= $_POST['apellido2'];
					$arraywherebusq['lower(apellido2) like '] 	= '%'.strtolower($_POST['apellido2']).'%';
				}

				if ($_POST['nombrepila']) 
				{
					$arraywhere['nombrepila'] 					= $_POST['nombrepila'];
					$arraywherebusq['lower(nombrepila) like '] 	= '%'.strtolower($_POST['nombrepila']).'%';
				}

				if ($_POST['id_provincia']) 
				{
					$arraywhere['id_provincia'] 					= $_POST['id_provincia'];
					$arraywherebusq['lower(id_provincia) like '] 	= '%'.strtolower($_POST['id_provincia']).'%';
				}

				if ($_POST['id_poblacion']) 
				{
					$arraywhere['id_poblacion'] 					= $_POST['id_poblacion'];
					$arraywherebusq['lower(id_poblacion) like '] 	= '%'.strtolower($_POST['id_poblacion']).'%';
				}

				if ($_POST['id_tipo_identificacion']) 
				{
					$arraywhere['id_tipo_identificacion'] 					= $_POST['id_tipo_identificacion'];
					$arraywherebusq['lower(id_tipo_identificacion) like '] 	= '%'.strtolower($_POST['id_tipo_identificacion']).'%';
				}

				if ($_POST['identificacion']) 
				{
					$arraywhere['identificacion'] 					= $_POST['identificacion'];
					$arraywherebusq['lower(identificacion) like '] 	= '%'.strtolower($_POST['identificacion']).'%';
				}

				if ($_POST['identificacion_vigor']) 
				{
					$arraywhere['identificacion_vigor'] 					= $_POST['identificacion_vigor'];
					$arraywherebusq['lower(identificacion_vigor) like '] 	= '%'.strtolower($_POST['identificacion_vigor']).'%';
				}

				if ($_POST['fecha_nacimiento']) 
				{
					$arraywhere['fecha_nacimiento'] 					= $_POST['fecha_nacimiento'];
					$arraywherebusq['lower(fecha_nacimiento) like '] 	= '%'.strtolower($_POST['fecha_nacimiento']).'%';
				}

				if ($_POST['codigo_nacionalidad']) 
				{
					$arraywhere['codigo_nacionalidad'] 					= $_POST['codigo_nacionalidad'];
					$arraywherebusq['lower(codigo_nacionalidad) like '] 	= '%'.strtolower($_POST['codigo_nacionalidad']).'%';
				}

				if ($_POST['usuario']) 
				{
					$arraywhere['usuario'] 					= $_POST['usuario'];
					$arraywherebusq['lower(usuario) like '] 	= '%'.strtolower($_POST['usuario']).'%';
				}

			

				$_SESSION['arraywhere_titulares'] = $arraywhere;
				$_SESSION['arraywhere_titulares_busqueda'] = $arraywherebusq;

				redirect('titulares/titulares/index/');				
			}

			 // ----- Paginacion Generica 
			$mi_paginacion = $this->ion_auth->paginacion_generica(
				12, 						// resultados por por_pagina, 
				4, 							// segmento uri a leer, 
				5, 							// cantidad_enlaces,
				base_url(). 'titulares/titulares/index/',  // url completa de la pagina paginada
				'titulares',		            // scheme y nombre de la tabla, para la consulta
				$_SESSION['arraywhere_titulares_busqueda']
				);

			$this->data['pagination'] 		= $mi_paginacion['pagination'];

			$this->data['titulares']	  	= $this->ion_auth_model->segmentador_paginas(
			//$titulares	  	= $this->ion_auth_model->segmentador_paginas(
 				$mi_paginacion['per_page'], 	// resultados por pagina
 				4,								// segmento uri a leer
 				'titulares',					    // el nombre de la tabla a consultar $nombre_tabla
 				$_SESSION['arraywhere_titulares_busqueda']
 				)->result();
			// ----- Fin paginacion  

			
			foreach ($this->data['titulares'] as $key => $value) {
				$i = 0;
				foreach ($value as $k => $val) {
					$i = $i + 1;
					if ($i == 1) {

						//$cant_pol = $this->titulares_model->f_existe_grafico_id_titular($value->id_titular);
						//$exp['existe_poligono'] = $cant_pol;
						$exp['existe_poligono'] = 1;


						//if (grupo_usuario(17) or grupo_usuario(27)) {
							$exp['grupo_usuario'] = 'C';	
						//}else{
						//	$exp['grupo_usuario'] = 'N';
						//}
					}
					$exp[$k] = $val;
				}
				$exps[] = (object)$exp;
			}

			if (isset($exps)) {
				$this->data['titulares'] = $exps;
			}else{
				$this->data['titulares'] = NULL;
			}
			
			//emite un mensaje si es que se eliminó un titular
			if (isset($_SESSION['last_exp_delete'])) {
				$this->session->set_flashdata('message', $_SESSION['last_exp_delete']);
				unset($_SESSION['last_exp_delete']);
			}

			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

			/* Breadcrumbs */
			$this->data['breadcrumb'] = $this->breadcrumbs->show();

			/* Load Template */
            $this->template->admin_render('titulares/index', $this->data);
		}
	}

	public function reset_busqueda()
	{
		$_SESSION['arraywhere_titulares'] 			= NULL;
		$_SESSION['arraywhere_titulares_busqueda'] 	= NULL;
		
		redirect('titulares/titulares/index/');				
	}

	public function ver_exp($id_titular)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{	
			/* Breadcrumbs */
	        $this->breadcrumbs->unshift(2, 'Información Expediente', 'admin/groups/profile');
	        $this->data['breadcrumb'] = $this->breadcrumbs->show();

			$this->data['expe_info']  = $this->titulares_model->view('exp', array('id_titular' => $id_titular))->result();
	        
			/* Load Template */
            $this->template->admin_render('titulares/ver_titular', $this->data);
		}
	}

	public function expe_mantenimiento($id_titular)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{	
			/* Breadcrumbs */
	        $this->breadcrumbs->unshift(2, 'Mantenimiento', 'titulares/titulares');
	        $this->data['breadcrumb'] = $this->breadcrumbs->show();

	        $exp_datos = $this->titulares_model->view('exp', array('id_titular' => $id_titular))->row();

	        $id_titular_titular = $exp_datos->id_titular_titular;
	        $expe_gestion		= $exp_datos->expe_gestion;



			$expe_info  = $this->titulares_model->view('exp', array('id_titular_titular' => $id_titular_titular,'expe_gestion' => $expe_gestion))->result_array();

			$expe_info[0]["expe_tipo_ref_desc"] = $this->titulares_model->dropdown_data('conceptos', array('tipoconcepto' => 'TIPO_REF', 'concepto' => $expe_info[0]["expe_tipo_ref"]))->row()->nombre;

			$expe_info[0]["expe_estado_desc"] = $this->titulares_model->dropdown_data('conceptos', array('tipoconcepto' => 'EXPE_ESTADO', 'concepto' => $expe_info[0]["expe_estado"]))->row()->nombre;


			/************* CANTIDAD DATOS GRAFICOS ****************/
			$datos_graficos[0]['MOPC_POLIGONO']		= $this->titulares_model->contador_registros('MOPC_POLIGONO', array('exp' => $id_titular_titular, 'gest' => $expe_gestion));
			$datos_graficos[0]['MOPC_UACTUAL']		= $this->titulares_model->contador_registros('MOPC_UACTUAL', array('exp' => $id_titular_titular, 'gest' => $expe_gestion));
			$datos_graficos[0]['MOPC_UALTER']		= $this->titulares_model->contador_registros('MOPC_UALTER', array('exp' => $id_titular_titular, 'gest' => $expe_gestion));
			$datos_graficos[0]['MOPC_U86']			= $this->titulares_model->contador_registros('MOPC_U86', array('exp' => $id_titular_titular, 'gest' => $expe_gestion));
			$datos_graficos[0]['MOPC_U04']			= $this->titulares_model->contador_registros('MOPC_U04', array('exp' => $id_titular_titular, 'gest' => $expe_gestion));
			$datos_graficos[0]['MOPC_TSUELO']		= $this->titulares_model->contador_registros('MOPC_TSUELO', array('exp' => $id_titular_titular, 'gest' => $expe_gestion));
			$datos_graficos[0]['MOPC_FINCAS']		= $this->titulares_model->contador_registros('MOPC_FINCAS', array('exp' => $id_titular_titular, 'gest' => $expe_gestion));
			$datos_graficos[0]['MOPC_CAP_SUELO']	= $this->titulares_model->contador_registros('MOPC_CAP_SUELO', array('exp' => $id_titular_titular, 'gest' => $expe_gestion));
			$datos_graficos[0]['MOPC_CLA_ECO']		= $this->titulares_model->contador_registros('MOPC_CLA_ECO', array('exp' => $id_titular_titular, 'gest' => $expe_gestion));
			$datos_graficos[0]['MOPC_COMP_DEF']		= $this->titulares_model->contador_registros('MOPC_COMP_DEF', array('exp' => $id_titular_titular, 'gest' => $expe_gestion));
			$datos_graficos[0]['MOPC_DEF_BOS']		= $this->titulares_model->contador_registros('MOPC_DEF_BOS', array('exp' => $id_titular_titular, 'gest' => $expe_gestion));
			$datos_graficos[0]['MOPC_PROP_CERT']	= $this->titulares_model->contador_registros('MOPC_PROP_CERT', array('exp' => $id_titular_titular, 'gest' => $expe_gestion));
			/************* FIN CANTIDAD DATOS GRAFICOS ****************/

			$this->data['expe_info'] 		= $expe_info;
 
			$this->data['datos_graficos'] 	= $datos_graficos;

			$this->data['id_titular_titular'] = array(
				'type'     => 'hidden',
				'name'     => 'id_titular_titular',
				'id'       => 'id_titular_titular',
				'value'    => $id_titular_titular
			);

			$this->data['expe_gestion'] = array(
				'type'     => 'hidden',
				'name'     => 'expe_gestion',
				'id'       => 'expe_gestion',
				'value'    => $expe_gestion
			);

			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
	        
			/* Load Template */
            $this->template->admin_render('titulares/Mantenimiento', $this->data);
		}
	}

	public function create()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('titulares_create'), 'titulares/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Validate form input */
	
		$this->form_validation->set_rules('anyo_contrato', 		'<b>Año contrato</b>' , 		 'required');
		$this->form_validation->set_rules('expediente', 		'<b>Expediente</b>' , 		 'required');
		
		//$this->form_validation->set_rules('id_titular_geomatica', 	'<b>ID Geomática</b>' ,  'required');
		
		if ($this->form_validation->run() == TRUE)
		{





/*
  id_titular 
  nombre_completo
  id_tipo_via
  direccion
  c_postal
  telefono
  fecha 
  hora 
  codigo_pais
  id_tipo_titular
  apellido1 
  apellido2 
  nombrepila 
  id_provincia 
  id_poblacion 
  id_tipo_identificacion 
  identificacion 
  identificacion_vigor
  fecha_nacimiento
  codigo_nacionalidad 
  usuario 
*/

			
				//show_error(2);
	        	if ($_POST['id_titular']){
					$arraycampos['id_titular'] 			= $_POST['id_titular'];
				}

        		if ($_POST['numero_contrato']){
	        		$arraycampos['numero_contrato'] 		= $_POST['numero_contrato'];
	        	}

	        	if ($_POST['anyo_contrato']){
	        		$arraycampos['anyo_contrato'] 		= $_POST['anyo_contrato'];
	        	}

				if ($_POST['expediente']){
					$arraycampos['expediente'] 			= $_POST['expediente'];
				}

				if ($_POST['consultora']){
					$arraycampos['consultora'] 			= $_POST['consultora'];
				}

				if ($_POST['descripcion']){
					$arraycampos['descripcion'] 	= $_POST['descripcion'];
				}
				

				if ($_POST['contratista']){
					$arraycampos['contratista'] 	= $_POST['contratista'];
				}

				if ($_POST['presupuesto']){
					$arraycampos['presupuesto'] 	= $_POST['presupuesto'];
		
				}

				if ($_POST['tipo_moneda']){
					$arraycampos['tipo_moneda'] 		= strtoupper($_POST['tipo_moneda']);
				
				}
				
				if ($_POST['fecha_orden_proceder']){
					$arraycampos['fecha_orden_proceder'] 		= $_POST['fecha_orden_proceder'];
				}
				
				if ($_POST['plazo_ejecucion']){
					$arraycampos['plazo_ejecucion'] 		= $_POST['plazo_ejecucion'];
				}
				
				if ($_POST['plazo_ejecucion_catastral']){
					$arraycampos['plazo_ejecucion_catastral'] 			= strtoupper($_POST['plazo_ejecucion_catastral']);
				
				}

				if ($_POST['fecha_hora_insercion']){
					$arraycampos['fecha_hora_insercion'] 		= $_POST['fecha_hora_insercion'];
				}
				
				if ($_POST['observaciones']){
					$arraycampos['observaciones'] 		= $_POST['observaciones'];
				}
				
				if ($_POST['usuario']){
					$arraycampos['usuario'] 			= strtoupper($_POST['usuario']);
				
				}

			$accion = 0;	
			if (isset($_POST['accion'])){
				$accion = intval($_POST['accion']);
			}else{
				$accion = 0;	
			}

			$titular_create = $this->titulares_model->crear_titular($arraycampos);

        	if ($titular_create)
        	{

				if($accion===1){ /// ACCION PARA OBSERVAR 						

        			$this->session->set_flashdata('message', '¡Expediente <b>'.$_POST['id_titular'].'</b>, Proyecto <b>'.$_POST['id_titular'].'</b> creado exitósamente!');
					redirect('titulares/titulares/edit_titular/'.$titular_create);

				} else {

        			$this->session->set_flashdata('message', '¡Expediente <b>'.$_POST['id'].'</b>, Gestión <b>'.$_POST['id_titular'].'</b> creado exitósamente!');
					redirect('titulares/titulares/edit_titular/'.$titular_create);
				}
			}
			else 
			{
				$this->session->set_flashdata('message', $this->ion_auth->errors());
			}
		}
		else
		{
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));


/*
  id_titular 
  nombre_completo
  id_tipo_via
  direccion
  c_postal
  telefono
  fecha 
  hora 
  codigo_pais
  id_tipo_titular
  apellido1 
  apellido2 
  nombrepila 
  id_provincia 
  id_poblacion 
  id_tipo_identificacion 
  identificacion 
  identificacion_vigor
  fecha_nacimiento
  codigo_nacionalidad 
  usuario 
*/

			$this->data['id_titular'] = array(
				'type'     => 'text',
				'name'     => 'id_titular',
				'id'       => 'id_titular',
				'value'    => $this->form_validation->set_value('id_titular'),
				'class'    => 'form-control',
				'maxlength'=> '10',
				'readonly' => TRUE
			);				
			$this->data['nombre_completo'] = array(
				'type'     => 'text',
				'name'     => 'nombre_completo',
				'id'       => 'nombre_completo',
				'value'    => $this->form_validation->set_value('nombre_completo'),
				'class'    => 'form-control',
				'maxlength'=> '10'
			);
			$this->data['id_tipo_via'] = array(
				'type'     => 'number',
				'name'     => 'id_tipo_via',
				'id'       => 'id_tipo_via',
				'value'    => $this->form_validation->set_value('id_tipo_via'),
				'class'    => 'form-control',
				'onkeyup'  => 'limit_dig(this.id,4)'
			);
			$this->data['direccion'] = array(
				'type'     => 'text',
				'name'     => 'direccion',
				'id'       => 'direccion',
				'value'    => $this->form_validation->set_value('direccion'),
				'class'    => 'form-control'
			);
			$this->data['c_postal'] = array(
				'type'     => 'text',
				'name'     => 'c_postal',
				'id'       => 'c_postal',
				'value'    => $this->form_validation->set_value('c_postal'),
				'class'    => 'form-control',
				'maxlength'=> '10'
			);	
			$this->data['telefono'] = array(
				'type'     => 'number',
				'name'     => 'telefono',
				'id'       => 'telefono',
				'value'    => $this->form_validation->set_value('telefono'),
				'class'    => 'form-control',
				'onkeyup'  => 'limit_dig(this.id,10)'
			);
			$this->data['fecha'] = array(
				'type'     => 'text',
				'name'     => 'fecha',
				'id'       => 'fecha',
				'value'    => $this->form_validation->set_value('fecha'),
				'class'    => 'form-control',
				'maxlength'=> '20'
			);
			$this->data['hora'] = array(
				'type'     => 'text',
				'name'     => 'hora',
				'id'       => 'hora',
				'value'    => $this->form_validation->set_value('hora'),
				'class'    => 'form-control',
				'maxlength'=> '100'
			);
			$this->data['codigo_pais'] = array(
				'type'     => 'number',
				'name'     => 'codigo_pais',
				'id'       => 'codigo_pais',
				'value'    => $this->form_validation->set_value('codigo_pais'),
				'class'    => 'form-control',
				'onkeyup'  => 'limit_dig(this.id,20)'
			);
			$this->data['id_tipo_titular'] = array(
				'type'     => 'text',
				'name'     => 'id_tipo_titular',
				'id'       => 'id_tipo_titular',
				'rows'     => '1',
				'value'    => $this->form_validation->set_value('id_tipo_titular'),
				'class'    => 'form-control',
				'maxlength'=> '255'
			);
			$this->data['apellido1'] = array(
				'type'     => 'text',
				'name'     => 'apellido1',
				'id'       => 'apellido1',
				'value'    => $this->form_validation->set_value('apellido1'),
				'class'    => 'form-control',
				'list'	   => 'id_titular_consultor_list',
				'maxlength'=> '10'
			);
			$this->data['apellido2'] = array(
				'type'     => 'text',
				'name'     => 'apellido2',
				'id'       => 'apellido2',
				'value'    => $this->form_validation->set_value('apellido2'),
				'class'    => 'form-control',
				'maxlength'=> '100'
			);
			$this->data['nombrepila'] = array(
				'type'     => 'text',
				'name'     => 'nombrepila',
				'id'       => 'nombrepila',
				'rows'     => '1',
				'value'    => $this->form_validation->set_value('nombrepila'),
				'class'    => 'form-control',
				'maxlength'=> '255'
			);
			$this->data['id_provincia'] = array(
				'type'     => 'text',
				'name'     => 'id_provincia',
				'id'       => 'id_provincia',
				'value'    => $this->form_validation->set_value('id_provincia'),
				'class'    => 'form-control',
				'list'	   => 'id_titular_consultor_list',
				'maxlength'=> '10'
			);
			$this->data['id_poblacion'] = array(
				'type'     => 'text',
				'name'     => 'id_poblacion',
				'id'       => 'id_poblacion',
				'value'    => $this->form_validation->set_value('id_poblacion'),
				'class'    => 'form-control',
				'maxlength'=> '100'
			);
			$this->data['id_tipo_identificacion'] = array(
				'type'     => 'text',
				'name'     => 'id_tipo_identificacion',
				'id'       => 'id_tipo_identificacion',
				'value'    => $this->form_validation->set_value('id_tipo_identificacion'),
				'class'    => 'form-control',
				'maxlength'=> '100'
			);
			$this->data['identificacion'] = array(
				'type'     => 'text',
				'name'     => 'identificacion',
				'id'       => 'identificacion',
				'rows'     => '1',
				'value'    => $this->form_validation->set_value('identificacion'),
				'class'    => 'form-control',
				'maxlength'=> '255'
			);
			$this->data['identificacion_vigor'] = array(
				'type'     => 'text',
				'name'     => 'identificacion_vigor',
				'id'       => 'identificacion_vigor',
				'value'    => $this->form_validation->set_value('identificacion_vigor'),
				'class'    => 'form-control',
				'list'	   => 'id_titular_consultor_list',
				'maxlength'=> '10'
			);
			$this->data['fecha_nacimiento'] = array(
				'type'     => 'text',
				'name'     => 'fecha_nacimiento',
				'id'       => 'fecha_nacimiento',
				'value'    => $this->form_validation->set_value('fecha_nacimiento'),
				'class'    => 'form-control',
				'maxlength'=> '100'
			);
			$this->data['codigo_nacionalidad'] = array(
				'type'     => 'text',
				'name'     => 'codigo_nacionalidad',
				'id'       => 'codigo_nacionalidad',
				'value'    => $this->form_validation->set_value('codigo_nacionalidad'),
				'class'    => 'form-control',
				'list'	   => 'id_titular_consultor_list',
				'maxlength'=> '10'
			);
			$this->data['usuario'] = array(
				'type'     => 'text',
				'name'     => 'usuario',
				'id'       => 'usuario',
				'value'    => $this->form_validation->set_value('usuario'),
				'class'    => 'form-control',
				'maxlength'=> '100'
			);

			

			/* Load Template */
			$this->template->admin_render('titulares/create_titular', $this->data);
		}
	}

	public function edit_titular($id_titular)
	{

		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin() OR ! $id_titular OR empty($id_titular))
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_titulares_edit'), 'titulares/edit');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Variables *///Trae de la base de datos la fila seleccionada
        $titular = $this->titulares_model->view('titulares', array('id_titular' => $id_titular))->row();

        $this->data['id_titular'] = $id_titular;

        /* Validate form input */
     
		$this->form_validation->set_rules('id_titular', 		'<b>Id titular</b>' , 		 'required');
		
	


	// Campos TITULARES IDOM
/*
  id_titular 
  nombre_completo
  id_tipo_via
  direccion
  c_postal
  telefono
  fecha 
  hora 
  codigo_pais
  id_tipo_titular
  apellido1 
  apellido2 
  nombrepila 
  id_provincia 
  id_poblacion 
  id_tipo_identificacion 
  identificacion 
  identificacion_vigor
  fecha_nacimiento
  codigo_nacionalidad 
  usuario 
*/
		//Se produce cuando el usuario da click en el submit
        if (isset($_POST) && ! empty($_POST))
        {
        	if ($this->form_validation->run() == TRUE)
        	{
				if ($_POST['id_titular']){
					$arraycampos['id_titular'] 			= $_POST['id_titular'];
				}

        		if ($_POST['nombre_completo']){
	        		$arraycampos['nombre_completo'] 		= $_POST['nombre_completo'];
	        	}

	        	if ($_POST['id_tipo_via']){
	        		$arraycampos['id_tipo_via'] 		= $_POST['id_tipo_via'];
	        	}

				if ($_POST['direccion']){
					$arraycampos['direccion'] 			= $_POST['direccion'];
				}

				if ($_POST['c_postal']){
					$arraycampos['c_postal'] 			= $_POST['c_postal'];
				}

				if ($_POST['telefono']){
					$arraycampos['telefono'] 	= $_POST['telefono'];
				}
				

				if ($_POST['fecha']){
					$arraycampos['fecha'] 	= $_POST['fecha'];
				}

				if ($_POST['hora']){
					$arraycampos['hora'] 	= $_POST['hora'];
		
				}

				if ($_POST['codigo_pais']){
					$arraycampos['codigo_pais'] 		= strtoupper($_POST['codigo_pais']);
				
				}
				
				if ($_POST['id_tipo_titular']){
					$arraycampos['id_tipo_titular'] 		= $_POST['id_tipo_titular'];
				}
				
				if ($_POST['apellido1']){
					$arraycampos['apellido1'] 		= $_POST['apellido1'];
				}
				
				if ($_POST['apellido2']){
					$arraycampos['apellido2'] 			= strtoupper($_POST['apellido2']);
				
				}

				if ($_POST['nombrepila']){
					$arraycampos['nombrepila'] 		= $_POST['nombrepila'];
				}
				
				if ($_POST['id_provincia']){
					$arraycampos['id_provincia'] 		= $_POST['id_provincia'];
				}
				
				if ($_POST['id_poblacion']){
					$arraycampos['id_poblacion'] 			= strtoupper($_POST['id_poblacion']);
				}

				if ($_POST['id_tipo_identificacion']){
					$arraycampos['id_tipo_identificacion'] 		= $_POST['id_tipo_identificacion'];
				}
				
				if ($_POST['identificacion']){
					$arraycampos['identificacion'] 		= $_POST['identificacion'];
				}
				
				if ($_POST['identificacion_vigor']){
					$arraycampos['identificacion_vigor'] 			= strtoupper($_POST['identificacion_vigor']);
				
				}

				if ($_POST['fecha_nacimiento']){
					$arraycampos['fecha_nacimiento'] 		= $_POST['fecha_nacimiento'];
				}
				
				if ($_POST['codigo_nacionalidad']){
					$arraycampos['codigo_nacionalidad'] 		= $_POST['codigo_nacionalidad'];
				}
				
				if ($_POST['usuario']){
					$arraycampos['usuario'] 			= strtoupper($_POST['usuario']);
				
				}
				
			

				$accion = 0;	
				if (isset($_POST['accion'])){
					$accion = intval($_POST['accion']);
				}else{
					$accion = 0;	
				}
				


				$unique_exp = $this->titulares_model->view('titulares',array('id_titular' => $_POST['id_titular'],
																		'id_titular' 	 => $_POST['id_titular'],
																
																		)
															)->num_rows();

/*
				if ($unique_exp > 0) {
					$this->session->set_flashdata('message', 'Ya existe un titular con = codigo + id_titular');
					redirect('titulares/titulares/edit_titular/'.$id_titular);
				}
*/
						//echo $accion;
						//show_error(1);	


				$actualizar_titular = $this->titulares_model->actualizar_titular($id_titular,$arraycampos);

				///////////////////////////////////////////////////////////
				///////////////////// ACCIONES POST ///////////////////////
				///////////////////////////////////////////////////////////
				

	
        		//if ($resul) 
        		if ($actualizar_titular) 
        		{
					//una prueba de que trae los valores es reemplazando $this->lang->line('edit_geocolonia_saved') por $_POST('id') por ejemplo
        			$this->session->set_flashdata('message', $this->lang->line('titulares_update_successful'));
					redirect('titulares/titulares/edit_titular/'.$id_titular);
				}
				else
				{
					$this->session->set_flashdata('message', $this->ion_auth->errors());
				}

				//aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
				//redirect('man_espacial/geocolonias/geocolonias', 'refresh'); 
			}
		}

		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
		//$this->data['geocolonia']   = $geocolonia;

		//$readonly = $this->config->item('admin_group', 'ion_auth') === $geocolonia->col_desc ? 'readonly' : '';
		




		// Campos TITULARES IDOM
/*
  id_titular 
  nombre_completo
  id_tipo_via
  direccion
  c_postal
  telefono
  fecha 
  hora 
  codigo_pais
  id_tipo_titular
  apellido1 
  apellido2 
  nombrepila 
  id_provincia 
  id_poblacion 
  id_tipo_identificacion 
  identificacion 
  identificacion_vigor
  fecha_nacimiento
  codigo_nacionalidad 
  usuario 
*/


		//creando campos
		$this->data['id_titular'] = array(
			'type'     => 'number',
			'name'     => 'id_titular',
			'id'       => 'id_titular',
			'value'    => $this->form_validation->set_value('id_titular', $titular->id_titular),
			'class'    => 'form-control',
			'maxlength'=> '10',
			'readonly' => TRUE
		);			
		$this->data['nombre_completo'] = array(
			'type'     => 'text',
			'name'     => 'nombre_completo',
			'id'       => 'nombre_completo',
			'value'    => $this->form_validation->set_value('nombre_completo', $titular->nombre_completo),
			'class'    => 'form-control',
			'maxlength'=> '10'
		);
		$this->data['id_tipo_via'] = array(
			'type'     => 'number',
			'name'     => 'id_tipo_via',
			'id'       => 'id_tipo_via',
			'value'    => $this->form_validation->set_value('id_tipo_via', $titular->id_tipo_via),
			'class'    => 'form-control',
			'onkeyup'  => 'limit_dig(this.id,4)'
		);
		$this->data['direccion'] = array(
			'type'     => 'text',
			'name'     => 'direccion',
			'id'       => 'direccion',
			'value'    => $this->form_validation->set_value('direccion', $titular->direccion),
			'class'    => 'form-control'
		);

		$this->data['c_postal'] = array(
			'type'     => 'text',
			'name'     => 'c_postal',
			'id'       => 'c_postal',
			'value'    => $this->form_validation->set_value('c_postal', $titular->c_postal),
			'class'    => 'form-control',
			'maxlength'=> '30'
		);	
		$this->data['telefono'] = array(
			'type'     => 'number',
			'name'     => 'telefono',
			'id'       => 'telefono',
			'value'    => $this->form_validation->set_value('telefono', $titular->telefono),
			'class'    => 'form-control',
			'maxlength'=> '30'
		);

		$this->data['fecha'] = array(
			'type'     => 'text',
			'name'     => 'fecha',
			'id'       => 'fecha',
			'value'    => $this->form_validation->set_value('fecha', $titular->fecha),
			'class'    => 'form-control',
			'maxlength'=> '50'
		);
		$this->data['hora'] = array(
			'type'     => 'text',
			'name'     => 'hora',
			'id'       => 'hora',
			'value'    => $this->form_validation->set_value('hora', $titular->hora),
			'class'    => 'form-control',
			'maxlength'=> '50'
		);
	
		/*
		$this->data['tipo_moneda'] = array(
			'type'     => 'text',
			'name'     => 'tipo_moneda',
			'id'       => 'tipo_moneda',
			'value'    => $this->form_validation->set_value('tipo_moneda', $titular->tipo_moneda),
			'class'    => 'form-control',
			'onkeyup'  => 'limit_dig(this.id,20)',
			'maxlength'=> '10'

		); */

		$a_monedas[''] = 'Seleccione tipo de moneda';
		$r_monedas = $this->titulares_model->dropdown_data('tipos_moneda')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($r_monedas as $d_moneda) {
			$a_monedas[$d_moneda['id_tipo_moneda']] = $d_moneda['id_tipo_moneda'] . ' - ' . $d_moneda['nombre'];
		}
		$this->data['tipos_moneda'] = $a_monedas;
		$this->data['tipo_moneda_sel'] = $titular->tipo_moneda;


		$this->data['codigo_pais'] = array(
			'type'     => 'text',
			'name'     => 'codigo_pais',
			'id'       => 'codigo_pais',
			'rows'     => '1',
			'value'    => $this->form_validation->set_value('codigo_pais', $titular->codigo_pais),
			'class'    => 'form-control',
			'maxlength'=> '20'
		);
		$this->data['id_tipo_titular'] = array(
			'type'     => 'text',
			'name'     => 'id_tipo_titular',
			'id'       => 'id_tipo_titular',
			'value'    => $this->form_validation->set_value('id_tipo_titular', $titular->id_tipo_titular),
			'class'    => 'form-control',
			'maxlength'=> '10'
		);
		$this->data['apellido1'] = array(
			'type'     => 'text',
			'name'     => 'apellido1',
			'id'       => 'apellido1',
			'value'    => $this->form_validation->set_value('apellido1', $titular->apellido1),
			'class'    => 'form-control',
			'maxlength'=> '20'
		);
		$this->data['apellido2'] = array(
			'type'     => 'text',
			'name'     => 'apellido2',
			'id'       => 'apellido2',
			'rows'     => '1',
			'value'    => $this->form_validation->set_value('apellido2', $titular->apellido2),
			'class'    => 'form-control',
			'maxlength'=> '20'
		);
		$this->data['nombrepila'] = array(
			'type'     => 'text',
			'name'     => 'nombrepila',
			'id'       => 'nombrepila',
			'value'    => $this->form_validation->set_value('nombrepila', $titular->nombrepila),
			'class'    => 'form-control',
			'maxlength'=> '10'
		);
		$this->data['id_provincia'] = array(
			'type'     => 'text',
			'name'     => 'id_provincia',
			'id'       => 'id_provincia',
			'value'    => $this->form_validation->set_value('id_provincia', $titular->id_provincia),
			'class'    => 'form-control',
			'maxlength'=> '20'
		);
		$this->data['id_poblacion'] = array(
			'type'     => 'text',
			'name'     => 'id_poblacion',
			'id'       => 'id_poblacion',
			'rows'     => '1',
			'value'    => $this->form_validation->set_value('id_poblacion', $titular->id_poblacion),
			'class'    => 'form-control',
			'maxlength'=> '20'
		);
		$this->data['id_tipo_identificacion'] = array(
			'type'     => 'text',
			'name'     => 'id_tipo_identificacion',
			'id'       => 'id_tipo_identificacion',
			'value'    => $this->form_validation->set_value('id_tipo_identificacion', $titular->id_tipo_identificacion),
			'class'    => 'form-control',
			'maxlength'=> '10'
		);
		$this->data['identificacion'] = array(
			'type'     => 'text',
			'name'     => 'identificacion',
			'id'       => 'identificacion',
			'value'    => $this->form_validation->set_value('identificacion', $titular->identificacion),
			'class'    => 'form-control',
			'maxlength'=> '20'
		);
		$this->data['identificacion_vigor'] = array(
			'type'     => 'text',
			'name'     => 'identificacion_vigor',
			'id'       => 'identificacion_vigor',
			'rows'     => '1',
			'value'    => $this->form_validation->set_value('identificacion_vigor', $titular->identificacion_vigor),
			'class'    => 'form-control',
			'maxlength'=> '20'
		);
		$this->data['fecha_nacimiento'] = array(
			'type'     => 'text',
			'name'     => 'fecha_nacimiento',
			'id'       => 'fecha_nacimiento',
			'value'    => $this->form_validation->set_value('fecha_nacimiento', $titular->fecha_nacimiento),
			'class'    => 'form-control',
			'maxlength'=> '10'
		);
		$this->data['codigo_nacionalidad'] = array(
			'type'     => 'text',
			'name'     => 'codigo_nacionalidad',
			'id'       => 'codigo_nacionalidad',
			'value'    => $this->form_validation->set_value('codigo_nacionalidad', $titular->codigo_nacionalidad),
			'class'    => 'form-control',
			'maxlength'=> '20'
		);
		$this->data['usuario'] = array(
			'type'     => 'text',
			'name'     => 'usuario',
			'id'       => 'usuario',
			'value'    => $this->form_validation->set_value('usuario', $titular->usuario),
			'class'    => 'form-control',
			'maxlength'=> '20'
		);

		
		

		
		/* Load Template */

		$this->template->admin_render('titulares/edit_titular', $this->data);
	}
  
	public function tiene_salida()
	{
		$id_titular = $_POST['id_titular'];

		$expe = $this->titulares_model->view('exp', array('id_titular' => $id_titular, 'expe_estado' => 'P'))->row();

		if ($expe) {
			echo 'SI';
		}else{
			echo 'NO';
		}
	}

	public function existe_grafico()
	{
		$id_titular 	= $_POST['id_titular'];
		$gestion 		= $_POST['gestion'];

		$expe = $this->titulares_model->existe_grafico($id_titular, $gestion)->row()->f_existe_grafico;
		
		echo $expe;
	}
  

	public function existe_grafico_id_titular()
	{
		$id_titular 	= $_POST['id_titular'];

		$expe = $this->titulares_model->existe_grafico_id_titular($id_titular)->row()->f_existe_grafico_id_titular;
		
		echo $expe;
	}


	public function existe_exp()
	{
		$exp 		= $_POST['exp'];
		$gestion 	= $_POST['gest'];

		$expe = $this->titulares_model->dropdown_data('exp', array('id_titular_titular' => $exp, 'expe_gestion' => $gestion))->num_rows();

		if ($expe > 0) {
			echo 'SI';
		}else{
			echo 'NO';
		}
	}

	public function existe_exp_uk()
	{
		
        


		$codigo 		= $_POST['codigo'];
		$id_titular 	= $_POST['id_titular'];

		$expe = $this->titulares_model->dropdown_data('titulares', array('codigo' => $codigo, 
			                                                          'id_titular' => $id_titular
			                                                          ))->num_rows();

		if ($expe > 0) {
			echo 'SI';
		}else{
			echo 'NO';
		}
	}


	public function reingreso_exp()
	{
		$exp 	= $_POST['exp'];
		$gest 	= $_POST['gest'];

		$id_titular = $this->titulares_model->dropdown_data('exp', array('id_titular_titular' => $exp, 'expe_gestion' => $gest))->row()->id_titular;

		echo $id_titular;

		//$reingreso  = $this->titulares_model->actualizar_titular($id_titular, array('id_titular_titular_ref' => $exp, 'id_titular' => ));

		
		//redirect('titulares/titulares/edit_titular/'.$id_titular);
	}

	public function dar_salida_expe($id_titular, $id_titular_titular, $expe_gestion, $expe_provdg = NULL)
	{

		$i_exp 		= $id_titular_titular;
		$i_gest 	= $expe_gestion;


					$i_user = $this->session->userdata('username');
					//echo $i_user;
					//show_error(1);



		if (!is_null($i_exp) AND $i_gest > 0) {
			if (grupo_usuario(18)) {


				//if ($expe_provdg == NULL) {
				if (is_null($expe_provdg)) {
					$provdg = 0;
				}else{
					$provdg = $expe_provdg;
				}

				if ($provdg == 0) {
					$i_max = $this->titulares_model->campo_valor_maximo('exp', 'expe_provdg' , array('expe_director' => $i_user ));

					$i_max = $i_max+1;

					$str 	= date_default_timezone_get();
					$fecha  = date("d/m/Y", strtotime($str));

					$salida = $this->titulares_model->actualizar_titular($id_titular, array('expe_provdg'   => $i_max, 
																					 		  'expe_director' => $this->session->userdata('username'),
																					 		  'expe_salida'   => $fecha,
																					 		  'expe_estado'   => 'P'));
					if ($salida) {
						$this->session->set_flashdata('message', '¡Se DIÓ SALIDA exitósamente!');
						redirect('titulares/titulares/edit_titular/'.$id_titular);
					}else{
						$this->session->set_flashdata('message', '¡No se pudo DAR SALIDA!');
						redirect('titulares/titulares/edit_titular/'.$id_titular);
					}
				}else{
					$this->session->set_flashdata('message', '¡Campo PROV. DG sin dato!');
					redirect('titulares/titulares/edit_titular/'.$id_titular);
				}
			}else{
				$this->session->set_flashdata('message', 'NO TIENE PRIVILEGIOS PARA ESTA ACCIÓN');
				redirect('titulares/titulares/edit_titular/'.$id_titular);
			}
		}else{
			redirect('titulares/titulares/edit_titular/'.$id_titular);
		}
	}

	public function anular_salida_expe($id_titular) 
	{

		//echo($id_titular);
		$expe = $this->titulares_model->dropdown_data('exp', array('id_titular' => $id_titular))->result();


		//echo '<option value="">Seleccione el distrito</option>';

		foreach ($expe as $value) {
			$i_exp 		 = $value->id_titular_titular;
			$i_gest 	 = $value->expe_gestion;
			$i_provdg = $value->expe_provdg;
		}

		if (!is_null($i_exp) AND $i_gest > 0) {
			if (grupo_usuario(18)) {

				if ($i_provdg == NULL) {
					$provdg = 0;
				}else{
					$provdg = $i_provdg;
				}

				if ($provdg != 0) {
					
					$salida = $this->titulares_model->actualizar_titular($id_titular, array('expe_provdg'   => NULL, 
																					 		  'expe_director' => '',
																					 		  'expe_salida'   => NULL,
																					 		  'expe_estado'   => 'A'));
					if ($salida) {
						$this->session->set_flashdata('message', '¡Se ANULÓ LA SALIDA exitósamente!');
						redirect('titulares/titulares/edit_titular/'.$id_titular);
					}else{
						$this->session->set_flashdata('message', '¡No se pudo ANULAR SALIDA!');
						//redirect('titulares/titulares/edit_titular/'.$id_titular);
						redirect('titulares/titulares/index/');				
					}
				}
			}else{
				$this->session->set_flashdata('message', 'NO TIENE PRIVILEGIOS PARA ESTA ACCIÓN');
				//redirect('titulares/titulares/index/'.$id_titular);
				redirect('titulares/titulares/index/');				
			}
		}else{
			//redirect('titulares/titulares/index/'.$id_titular);
			redirect('titulares/titulares/index/');				
		}
	}


	public function call_bat()
	{
		$cmd = system('cmd /c C:/espacio_trabajo/importar_shape_ide.bat');
	}


	public function form_titular()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_titulares'), 'geocolonias/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Validate form input */
		$this->form_validation->set_rules('col_cod', 'lang:geocolonia_col_cod' , 'required');
		$this->form_validation->set_rules('col_desc','lang:geocolonia_col_desc', 'required');

		if ($this->form_validation->run() == TRUE)
		{
			$arraycampos = array('dpto_cod' 	=> $_POST['dpto_cod'],
								 'dist_cod' 	=> $_POST['dist_cod'],
								 'id_codgeo' 	=> $_POST['id_codgeo'],
								 'col_cod' 		=> $_POST['col_cod'],
								 'col_desc' 	=> strtoupper($_POST['col_desc']),
								);

			$new_geocolonia_id = $this->geocolonias_model->create_geocolonia($arraycampos);
			if ($new_geocolonia_id)
			{
				$this->session->set_flashdata('message', $this->ion_auth->messages());

				redirect('man_espacial/geocolonias/geocolonias');
			}
		}
		else
		{
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

			$this->data['dpto_cod'] = array(
				'name'  => 'dpto_cod',
				'id'    => 'dpto_cod',
				'type'  => 'text',
				'class' => 'form-control',
				//'value' => $this->form_validation->set_value('dpto_cod')
				);
			$this->data['dist_cod'] = array(
				'name'  => 'dist_cod',
				'id'    => 'dist_cod',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('dist_cod')
				);
			$this->data['col_cod'] = array(
				'name'  => 'col_cod',
				'id'    => 'col_cod',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('col_cod')
				);
			$this->data['id_codgeo'] = array(
				'name'  => 'id_codgeo',
				'id'    => 'id_codgeo',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('id_codgeo'),
				'readonly' => true,
				);
			$this->data['col_desc'] = array(
				'name'  => 'col_desc',
				'id'    => 'col_desc',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('col_desc')
				);

			$dptos[''] = 'Seleccione el departamento';
			$departamentos = $this->titulares_model->dropdown_data('departamentos','','dpto_id_departamento')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($departamentos as $dpto) {
				$dptos[$dpto['dpto_id_departamento']] = $dpto['dpto_id_departamento'].' - '.$dpto['dpto_descripcion'];
			}
			$this->data['departamentos'] = $dptos;
			
			///* Load Template */
			$this->template->admin_render('titulares/form_titular', $this->data);
		}
	}

	public function trae_distritos()
	{
		$dpto 	   = $_POST['id_titular_departamento'];

		$distritos = $this->titulares_model->dropdown_data('distritos',array('dist_id_departamento' => $dpto), 'dist_id_ciudad')->result();

		echo '<option value="">Seleccione el distrito</option>';
		foreach ($distritos as $value) {
			echo '<option value="' . $value->dist_id_ciudad . '">' . $value->dist_id_ciudad . ' - ' . $value->dist_descripcion . '</option>';
		}

		//echo json_encode($distritos);
	}

	public function trae_expe_ref()
	{
		$expe 	   = $_POST['id_titular_titular_ref'];

		$expes = $this->titulares_model->dropdown_data('exp',array('id_titular_titular_ref' => $expe), 'id_titular')->result();

		echo '<option value="">Seleccione Expediente</option>';
		foreach ($expes as $value) {

			$expes[$ex['id_titular']] = $ex['id_titular_titular'].'-'.$ex['expe_gestion'].'-'.$ex['id_titular_dependencia'].'-'.$ex['expe_secuencia'];

			echo '<option value="' . $value->id_titular . '">' . $value->id_titular_titular . '-' . $value->expe_gestion . '-' . $value->id_titular_dependencia . '-' . $value->expe_secuencia .  '</option>';
		}

		//echo json_encode($distritos);
	}

	public function delete()
	{
		$delete  = $this->titulares_model->eliminar_titular($_POST['id_titular']);
		//$this->session->set_flashdata('message', '¡El titular <b>'.$_POST['exp'].'</b>, gestión <b>'.$_POST['gest'].'</b> se eliminó correctamente!');

		$_SESSION['last_exp_delete'] = '¡El titular <b>'.$_POST['exp'].'</b>, gestión <b>'.$_POST['gest'].'</b> se eliminó correctamente!';

		echo 'SI';
		//redirect('titulares/titulares/index');
	}

	public function verparcela ($id_titular , $expe_gest) {

        	$i_jameuge = "http://181.120.125.178:8065/jmap/index.html?exp=" . $id_titular;
        	$i_jameuge = $i_jameuge . "&gest=" . $expe_gest;

			redirect($i_jameuge);
	}

	public function verparcela_id_titular ($id_titular ) {

        	$i_jameuge = "http://181.120.125.178:8065/jmap/index.html?id_titular=" . $id_titular;

			redirect($i_jameuge);
	}

}