<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Departamentos extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('man_espacial/departamentos/departamentos_model');
		$this->lang->load('departamentos/departamentos_lang');


		/* Title Page :: Common */
		$this->page_title->push(lang('menu_departamentos'));
		$this->data['pagetitle'] = $this->page_title->show();
		$_SESSION['id_modulo'] = 'DEPARTAMENTOS';

		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_departamentos'), 'admin/menu_departamentos');
	}
	
	public function index()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{
			/* Breadcrumbs */
			$this->data['breadcrumb'] = $this->breadcrumbs->show();

			$this->data['departamentos'] = $this->departamentos_model->departamentos_all()->result();

			/* Load Template */
			$this->template->admin_render('man_espacial/departamentos/index', $this->data);
		}
	}
}