<head>
    <style>
        body {
            background-color: #f8f9fa;
        }
        .form-section {
            margin-bottom: 15px;
        }
        .btn-primary {
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <div class="content-wrapper">
        <section class="content-header">
            <!-- Puedes agregar breadcrumbs o títulos aquí -->
        </section>

        <section class="content">
            <div class="container mt-5">
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h4>Editar Resolución</h4>
                    </div>
                    <div class="card-body">
                        <form action="<?= base_url('resoluciones/edit/' . $resolucion['id_resoluciones']) ?>" method="post">

                            <div class="form-row">
                            <div class="form-group col-md-6">
                                    <label for="nombre_proyecto">Nombre del Proyecto</label>
                                    <input type="text" id="nombre_proyecto" name="nombre_proyecto" value="<?php echo isset($nombre_proyecto) ? $nombre_proyecto : 'No especificado'; ?>" class="form-control" readonly>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="id_declaracion">ID Declaración</label>
                                    <input type="number" class="form-control" name="id_declaracion" id="id_declaracion" value="<?= set_value('id_declaracion', $resolucion['id_declaracion']) ?>" readonly>
                                    <?= form_error('id_declaracion', '<small class="text-danger">', '</small>') ?>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="nro_resolucion">Número de Resolución</label>
                                    <input type="number" class="form-control" name="nro_resolucion" id="nro_resolucion" value="<?= set_value('nro_resolucion', $resolucion['nro_resolucion']) ?>" readonly>
                                    <?= form_error('nro_resolucion', '<small class="text-danger">', '</small>') ?>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="gestion_resolucion">Gestión de Resolución</label>
                                    <input type="number" class="form-control" name="gestion_resolucion" id="gestion_resolucion" value="<?= set_value('gestion_resolucion', $resolucion['gestion_resolucion']) ?>" readonly>
                                    <?= form_error('gestion_resolucion', '<small class="text-danger">', '</small>') ?>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="fecha_resolucion">Fecha de Resolución</label>
                                    <input type="date" class="form-control" name="fecha_resolucion" id="fecha_resolucion" value="<?= set_value('fecha_resolucion', $resolucion['fecha_resolucion']) ?>" readonly>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="fecha_prox_vto_aa">Fecha Próximo Vencimiento Presentación</label>
                                    <input type="date" class="form-control" name="fecha_prox_vto_aa" id="fecha_prox_vto_aa" value="<?= set_value('fecha_prox_vto_aa', $resolucion['fecha_prox_vto_aa']) ?>" readonly>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="estado">Estado</label>
                                    <input type="text" class="form-control" name="estado" id="estado" value="<?= set_value('estado', $resolucion['estado']) ?>" readonly>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="tipo_resoluciones">Tipo de Resolución</label>
                                    <select class="form-control" name="tipo_resoluciones" id="tipo_resoluciones" readonly>
                                        <option value="">Seleccione...</option>
                                        <?php foreach ($dropdown_tipo_resoluciones as $value => $label): ?>
                                            <option value="<?= $value ?>" <?= set_value('tipo_resoluciones', $resolucion['tipo_resoluciones']) == $value ? 'selected' : '' ?>>
                                                <?= $label ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                    <?= form_error('tipo_resoluciones', '<small class="text-danger">', '</small>') ?>
                                </div>
                            </div>


                            <div class="form-group">
                                <label for="observacion">Observación</label>
                                <textarea class="form-control" name="observacion" id="observacion" rows="3" readonly><?= set_value('observacion', $resolucion['observacion']) ?></textarea>
                            </div>

                            <div class="form-group col-12 d-flex justify-content-between gap-2">
                               
                                <a href="<?= base_url('resoluciones/index/'.$resolucion['id_proyecto']) ?>" class="btn btn-warning">Cancelar</a>
                            </div>
                            
                            <div style="border: 1px solid #ccc; border-radius: 5px; background-color: #f1f1f1;">
                                <h4>Documentos Existentes</h4>
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Nombre del Archivo</th>
                                            <th>Fecha de Subida</th>
                                            <th>Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if (!empty($documentos)): ?>
                                            <?php foreach ($documentos as $documento): ?>
                                                <tr>
                                                    <td><?php echo htmlspecialchars(basename($documento->url)); ?></td>
                                                    <td><?php echo date('d/m/Y', strtotime($documento->fecha_reg)); ?></td>
                                                    <td>
                                                        <a href="<?php echo site_url('documentos/descargarArchivo/' . $documento->id_archivo); ?>" class="btn btn-info btn-sm">
                                                            Descargar
                                                        </a>
                                                        &nbsp;
                                                        <a href="#" class="btn btn-danger btn-sm delete-document"
                                                            data-id="<?= isset($documento->id_archivo) ? $documento->id_archivo : ''; ?>"
                                                            data-id-proyecto="<?= isset($resolucion['id_proyecto']) ? $resolucion['id_proyecto'] : ''; ?>"
                                                            data-id-resolucion="<?= isset($resolucion['id_resoluciones']) ? $resolucion['id_resoluciones'] : ''; ?>">
                                                            Eliminar
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <tr>
                                                <td colspan="3" class="text-center">No hay documentos asociados.</td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.delete-document').on('click', function(e) {
                e.preventDefault();
                
                var idDocumento = $(this).data('id'); 
                var idProyecto = $(this).data('id-proyecto');
                var idResolucion = $(this).data('id-resolucion');

                if (!idDocumento || !idProyecto || !idResolucion) {
                    alert("Error: Falta información para eliminar el documento.");
                    return;
                }

                var deleteUrl = '<?= site_url("resoluciones/delete_document") ?>/' + idResolucion + '/' + idProyecto + '/' + idDocumento;
                console.log("Eliminando documento en:", deleteUrl);

                if (confirm('¿Estás seguro de que deseas eliminar este documento?')) {
                    window.location.href = deleteUrl;
                }
            });
        });
    </script>
</body>