<head>
    <style>
        body {
            background-color: #f8f9fa;
        }

        .table th {
            background-color: #007bff;
            color: white;
        }

        .btn-primary, .btn-success {
            margin-top: 10px;
        }

        .table-container {
            max-width: 1200px;
            margin: auto;
            padding: 20px;
            border-radius: 5px;
            background-color: #ffffff;
        }

        .table {
            font-size: 15px;
        }

        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }

        .pagination a, .pagination strong {
            padding: 10px 15px;
            margin: 0 5px;
            text-decoration: none;
            background-color: #007bff;
            color: #ffffff;
            border-radius: 3px;
        }

        .pagination a:hover {
            background-color: #0056b3;
        }

        .pagination strong {
            background-color: #6c757d;
        }

        @media (max-width: 768px) {
            .table th, .table td {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <div class="content-wrapper">
        <section class="content-header">
            <?php //echo $pagetitle; ?>
            <?php //echo $breadcrumb; ?>
        </section>

        <section class="content">    
            <div class="container mt-5">

            <?php
            echo anchor('man_espacial/proyectos/proyectos/index', '<button type="button" class="btn btn-primary btn-lg w-100">Volver</button>');
            ?>
                <h1 class="mb-4">Gestión de PGA, Proyecto: <?php echo isset($nombre_proyecto) ? $nombre_proyecto : 'No especificado'; ?></h1>


                <!-- Formulario de filtros -->
                <form method="get" class="row g-3 mb-4">
     
                    <div class="col-md-3">
                        <label for="des_tipo_riesgo" class="form-label">Tipo Riesgo</label>
                        <input type="text" name="des_tipo_riesgo" id="des_tipo_riesgo" class="form-control" value="<?= $this->input->get('des_tipo_riesgo') ?>">
                    </div>
                    <div class="col-md-3">
                        <label for="des_tipo_plan" class="form-label">Tipo Plan</label>
                        <input type="text" name="des_tipo_plan" id="des_tipo_plan" class="form-control" value="<?= $this->input->get('des_tipo_plan') ?>">
                    </div>
                    <div class="col-md-3">
                        <label for="des_pga_estado" class="form-label">Estado</label>
                        <select name="des_pga_estado" id="des_pga_estado" class="form-control">
                            <?php foreach ($dropdown_estados as $key => $value): ?>
                                <option value="<?= $key ?>" <?= ($this->input->get('des_pga_estado') == $key) ? 'selected' : '' ?>>
                                    <?= $value ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>          
                    <div class="col-md-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary w-100">Filtrar</button>
                    </div>
                </form>

                <?php 
                $user_id = $this->session->userdata('user_id');
                $tipo_usuario = $_SESSION['tipo_usuario'][0];
                $id_cliente = $_SESSION['id_cliente'][0];
                if ($tipo_usuario == 'C') { 
                ?> 
                
                <?php
                    } else {  
                ?>   
                    <a href="<?= site_url('pga/create/'.$id_proyecto )?>" class="btn btn-success mb-3">Crear Nuevo</a>
                    <br>
                <?php
                    } 
                ?>
                
                <br>
                <!-- Contenedor con fondo blanco -->
                <div class="table-container">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>Acciones</th>
                                    <th>ID</th>
                                    <th>Estado</th>
                                    <th>Tipo Riesgo</th>
                                    <th>Tipo Plan</th>
                                    <th>Descripción</th>
                                    <th>Fecha Reg</th>
                                   
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($pgas as $pga): ?>
                                    <tr>
                                        <td>
                                        <?php 
                                        $user_id = $this->session->userdata('user_id');
                                        $tipo_usuario = $_SESSION['tipo_usuario'][0];
                                        $id_cliente = $_SESSION['id_cliente'][0];
                                        if ($tipo_usuario == 'C') { 
                                        ?> 
                                            <a href="<?= site_url('pga/views/' . $pga->id . '/' . $id_proyecto) ?>" class="btn btn-info btn-sm">Ver</a>
                                        <?php
                                            } else {  
                                        ?>   
                                            <a href="<?= site_url('pga/edit/' . $pga->id . '/' . $id_proyecto) ?>" class="btn btn-warning btn-sm">Editar</a>
                                            &nbsp
                                            <a href="<?= site_url('pga/delete/' . $pga->id . '/' . $id_proyecto) ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Está seguro?')">Eliminar</a>
                                            &nbsp
                                            <a href="<?= site_url('pga/views/' . $pga->id . '/' . $id_proyecto) ?>" class="btn btn-info btn-sm">Ver</a>
                                        <?php
                                            } 
                                        ?>
                                        
                                        </td>
                                        <td><?= $pga->id ?></td>
                                        <td class="fw-bold text-dark <?php 
                                            switch ($pga->des_pga_estado) {
                                                case 'Cumplido': echo 'bg-success bg-opacity-50'; break;
                                                case 'Pendiente': echo 'bg-danger bg-opacity-50'; break;
                                                case 'Anulado': echo 'bg-secondary bg-opacity-50'; break;
                                                case 'En proceso': echo 'bg-warning bg-opacity-50'; break;
                                            }
                                        ?>">
                                            <?= $pga->des_pga_estado ?>
                                        </td>
                                        <td><?= $pga->des_tipo_riesgo ?></td>
                                        <td><?= $pga->des_tipo_plan ?></td>
                                        <td><?= substr($pga->descript_plan, 0, 50) ?>...</td>
                                        <td><?= $pga->fecha_reg ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Paginación -->
                <div class="pagination">
                    <?= $pagination ?>
                </div>
            </div>
        </section>
    </div>
    <script>
<?php if ($this->session->flashdata('message')): ?>
    console.log("<?= addslashes($this->session->flashdata('message')); ?>");
<?php endif; ?>

<?php if ($this->session->flashdata('error')): ?>
    console.error("<?= addslashes($this->session->flashdata('error')); ?>");
<?php endif; ?>
</script>

</body>
