<head> 
    <style>
        body {
            background-color: #f8f9fa;
        }

        .form-inline {
            gap: 10px;
        }

        .table th {
            background-color: #007bff;
            color: white;
        }

        .btn-primary, .btn-success {
            margin-top: 10px;
        }

        .table-container {
            max-width: 1200px;
            margin: auto;
            padding: 20px; /* Espaciado interno */
            border-radius: 5px; /* Bordes redondeados */
            background-color: #ffffff; /* Fondo blanco */
        }

        .table {
            font-size: 15px;
        }

        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }

        .pagination a, .pagination strong {
            padding: 10px 15px;
            margin: 0 5px;
            text-decoration: none;
            background-color: #007bff;
            color: #ffffff;
            border-radius: 3px;
        }

        .pagination a:hover {
            background-color: #0056b3;
        }

        .pagination strong {
            background-color: #6c757d;
        }

        @media (max-width: 768px) {
            .table th, .table td {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <div class="content-wrapper">
        <section class="content-header">
            <?php //echo $pagetitle; ?>
            <?php //echo $breadcrumb; ?>
        </section>

        <section class="content">
            <div class="container mt-5">
                <h1 class="mb-4 text-center">Listado de Consultores</h1>

                <!-- Formulario de filtros -->
                <form method="get" class="row g-3 mb-4">
                    <div class="col-md-3">
                        <label for="cedularuc" class="form-label">Cédula/RUC</label>
                        <input type="text" name="cedularuc" id="cedularuc" class="form-control" value="<?= $this->input->get('cedularuc') ?>">
                    </div>
                    <div class="col-md-3">
                        <label for="nombre" class="form-label">Nombre</label>
                        <input type="text" name="nombre" id="nombre" class="form-control" value="<?= $this->input->get('nombre') ?>">
                    </div>
                    <div class="col-md-3">
                        <label for="apellido" class="form-label">Apellido</label>
                        <input type="text" name="apellido" id="apellido" class="form-control" value="<?= $this->input->get('apellido') ?>">
                    </div>
                    <div class="col-md-3">
                        <label for="email" class="form-label">Email</label>
                        <input type="text" name="email" id="email" class="form-control" value="<?= $this->input->get('email') ?>">
                    </div>
                    <div class="col-md-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary w-100">Filtrar</button>
                    </div>
                </form>
                <?php 
                    $user_id = $this->session->userdata('user_id');
                    $tipo_usuario = $_SESSION['tipo_usuario'][0];
                    $id_cliente = $_SESSION['id_cliente'][0];
                    if ($tipo_usuario == 'C') { 
                ?> 
                
                <?php
                    } else {  
                ?>   
                <a href="<?= site_url('man_espacial/consultores/create') ?>" class="btn btn-success mb-3">Nuevo Consultor</a>
                <br>
                <?php
                    } 
                ?>
                
                <br>
                <!-- Contenedor con fondo blanco -->
                <div class="table-container">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>Acciones</th>
                                    <th>ID</th>
                                    <th>Cédula/RUC</th>
                                    <th>Nombre</th>
                                    <th>Apellido</th>
                                    <th>Email</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (!empty($consultores)): ?>
                                    <?php foreach ($consultores as $consultor): ?>
                                        <tr>
                                            <td> 
                                                <?php 
                                                    $user_id = $this->session->userdata('user_id');
                                                    $tipo_usuario = $_SESSION['tipo_usuario'][0];
                                                    $id_cliente = $_SESSION['id_cliente'][0];
                                                    if ($tipo_usuario == 'C') { 
                                                ?> 
                                                <a href="<?= site_url('man_espacial/consultores/view/' . $consultor['id_consultor']) ?>" class="btn btn-info btn-sm">Ver</a>
                                                <?php
                                                    } else {  
                                                ?>   
                                                <a href="<?= site_url('man_espacial/consultores/edit/' . $consultor['id_consultor']) ?>" class="btn btn-warning btn-sm">Editar</a>
                                                &nbsp
                                                <a href="<?= site_url('man_espacial/consultores/delete/' . $consultor['id_consultor']) ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Está seguro?')">Eliminar</a>
                                                &nbsp
                                                <a href="<?= site_url('man_espacial/consultores/view/' . $consultor['id_consultor']) ?>" class="btn btn-info btn-sm">Ver</a>
                                                <?php
                                                    } 
                                                ?>
                                                
                                            </td>
                                            <td><?= $consultor['id_consultor'] ?></td>
                                            <td><?= $consultor['cedularuc'] ?></td>
                                            <td><?= substr($consultor['nombre'], 0, 20) ?></td>
                                            <td><?= substr($consultor['apellido'], 0, 20) ?></td>
                                            <td><?= $consultor['email'] ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="6" class="text-center">No se encontraron Consultores.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Paginación -->
                <div class="pagination">
                    <?= $pagination ?>
                </div>
            </div>
        </section>
    </div>
</body>
