<head>
<style>
        body {
            background-color: #f8f9fa;
        }

        .form-inline {
            gap: 10px;
        }

        .table th {
            background-color: #007bff;
            color: white;
        }

        .btn-primary, .btn-success {
            margin-top: 10px;
        }

        .table-container {
            max-width: 1200px;
            margin: auto;
            padding: 20px;
            border-radius: 5px;
            background-color: #ffffff;
        }

        .table {
            font-size: 15px;
        }

        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }

        .pagination a, .pagination strong {
            padding: 10px 15px;
            margin: 0 5px;
            text-decoration: none;
            background-color: #007bff;
            color: #ffffff;
            border-radius: 3px;
        }

        .pagination a:hover {
            background-color: #0056b3;
        }

        .pagination strong {
            background-color: #6c757d;
        }

        @media (max-width: 768px) {
            .table th, .table td {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <div class="content-wrapper">
        <section class="content-header">
            <h1 class="mb-4">Listado de Departamentos</h1>
        </section>

        <section class="content">
            <div class="container mt-5">
                <?= anchor('dpto/create', '<i class="fa fa-plus"></i> Crear Departamento', ['class' => 'btn btn-primary']); ?>
                <div class="table-container mt-3">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>Acciones</th>
                                    <th>ID</th>
                                    <th>Código</th>
                                    <th>Descripción</th>
                                    <th>Región</th>
                                    <th>Área</th>
                                    <th>Longitud</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($departamentos as $row): ?>
                                    <tr>
                                        <td>
                                            <a href="<?= site_url('dpto/edit/'.$row->id) ?>" class="btn btn-warning btn-sm">Editar</a>
                                            <a href="<?= site_url('dpto/delete/'.$row->id) ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Está seguro?')">Eliminar</a>
                                        </td>
                                        <td><?= htmlspecialchars($row->id, ENT_QUOTES, 'UTF-8') ?></td>
                                        <td><?= htmlspecialchars($row->dpto, ENT_QUOTES, 'UTF-8') ?></td>
                                        <td><?= htmlspecialchars($row->dpto_desc, ENT_QUOTES, 'UTF-8') ?></td>
                                        <td><?= htmlspecialchars($row->region, ENT_QUOTES, 'UTF-8') ?></td>
                                        <td><?= htmlspecialchars($row->shape_area, ENT_QUOTES, 'UTF-8') ?></td>
                                        <td><?= htmlspecialchars($row->shape_leng, ENT_QUOTES, 'UTF-8') ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="pagination">
                    <?= $pagination; ?>
                </div>
            </div>
        </section>
    </div>
</body>
