<head> 
<style>
        body {
            background-color: #f8f9fa;
        }

        .form-inline {
            gap: 10px;
        }

        .table th {
            background-color: #007bff;
            color: white;
        }

        .btn-primary, .btn-success {
            margin-top: 10px;
        }

        .table-container {
            max-width: 1200px;
            margin: auto;
            padding: 20px;
            border-radius: 5px;
            background-color: #ffffff;
        }

        .table {
            font-size: 15px;
        }

        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }

        .pagination a, .pagination strong {
            padding: 10px 15px;
            margin: 0 5px;
            text-decoration: none;
            background-color: #007bff;
            color: #ffffff;
            border-radius: 3px;
        }

        .pagination a:hover {
            background-color: #0056b3;
        }

        .pagination strong {
            background-color: #6c757d;
        }

        @media (max-width: 768px) {
            .table th, .table td {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <div class="content-wrapper">
        <section class="content-header">
        </section>

        <section class="content">
            <div class="container mt-5">
                <h1 class="mb-4"><?php echo $pagetitle; ?></h1>

                <?php echo anchor('alertnotific/create', '<i class="fa fa-plus"></i> Crear Alerta', array('class' => 'btn btn-block btn-primary btn-flat')); ?>

                <div class="table-container mt-3">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>Acciones</th>
                                    <th>ID</th>
                                    <th>Tipo Alerta</th>
                                    <th>Mensaje</th>
                                    <th>Estado</th>
                                    <th>Fecha Registro</th>
                                    <th>Módulo</th>
                                    <th>Clase</th>
                                    <th>Descripción</th>
                                    <th>Día</th>
                                    <th>ID Proyecto</th>
                                    <th>ID Proponente</th>
                                    <th>Color</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($alertas as $row): ?>
                                    <tr>
                                    <td>
                                        <a href="<?= site_url('alertnotific/ver_conversacion/'.$row->id_alerta) ?>" class="btn btn-secondary btn-sm">Responder</a>
                                    </td>
                                    <td><?= htmlspecialchars($row->id_alerta) ?></td>
                                    <td><?= htmlspecialchars($row->tipo_alerta) ?></td>
                                    <td><?= htmlspecialchars(substr($row->mensaje, 0, 15)) ?></td>
                                    <td><?= htmlspecialchars($row->estado) ?></td>
                                    <td><?= htmlspecialchars($row->fecha_reg) ?></td>
                                    <td><?= htmlspecialchars($row->modulo) ?></td>
                                    <td><?= htmlspecialchars($row->clase) ?></td>
                                    <td><?= htmlspecialchars($row->descripcion) ?></td>
                                    <td><?= htmlspecialchars($row->dia) ?></td>
                                    <td><?= htmlspecialchars($row->id_proyecto) ?></td>
                                    <td><?= htmlspecialchars($row->id_proponente) ?></td>
                                    <td><?= htmlspecialchars($row->color) ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="pagination">
                    <?php echo $pagination; ?>
                </div>
            </div>
        </section>
    </div>
</body>
</html>
