<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Grupos_model extends CI_Model {


    public function get_grupos($filters = [], $limit = 10, $offset = 0) {
        $this->db->select('g.*, c.nombre AS nombre_cliente');
        $this->db->from('ema.grupos g');
        $this->db->join('ema.cliente c', 'g.id_cliente = c.id_cliente', 'left'); // JOIN con clientes
    
        // Aplicar filtros
        if (!empty($filters['id'])) {
            $this->db->where('g.id', $filters['id']);
        }
        if (!empty($filters['id_cliente'])) {
            $this->db->where('g.id_cliente', $filters['id_cliente']);
        }
        if (!empty($filters['nombre_cliente'])) {
            $this->db->like('LOWER(c.nombre)', strtolower($filters['nombre_cliente'])); // ✅ Filtro por nombre cliente
        }
        if (!empty($filters['nombre_grupo'])) {
            $this->db->like('LOWER(g.nombre_grupo)', strtolower($filters['nombre_grupo']));
        }
    
        $this->db->limit($limit, $offset);
        return $this->db->get()->result_array();
    }
    
    public function count_grupos($filters = []) {
        $this->db->from('ema.grupos g');
        $this->db->join('ema.cliente c', 'g.id_cliente = c.id_cliente', 'left');
    
        // Aplicar filtros
        if (!empty($filters['id'])) {
            $this->db->where('g.id', $filters['id']);
        }
        if (!empty($filters['id_cliente'])) {
            $this->db->where('g.id_cliente', $filters['id_cliente']);
        }
        if (!empty($filters['nombre_cliente'])) {
            $this->db->like('LOWER(c.nombre)', strtolower($filters['nombre_cliente'])); // ✅ Filtro por nombre cliente
        }
        if (!empty($filters['nombre_grupo'])) {
            $this->db->like('LOWER(g.nombre_grupo)', strtolower($filters['nombre_grupo']));
        }
    
        return $this->db->count_all_results();
    }
    
    


    public function get_grupo($id) {
        return $this->db->get_where('ema.grupos', ['id' => $id])->row_array();
    }

    public function insert_grupo($data) {
        return $this->db->insert('ema.grupos', $data);
    }

    public function update_grupo($id, $data) {
        $this->db->where('id', $id);
        return $this->db->update('ema.grupos', $data);
    }

    public function delete_grupo($id) {
        $this->db->where('id', $id);
        return $this->db->delete('ema.grupos');
    }

    public function dropdown_data($tabla = NULL, $where = NULL, $order_by = NULL)
{
    if (!$tabla) {
        return []; // Devuelve un array vacío si no se especifica una tabla
    }

    $this->db->from($tabla); // Especifica la tabla correctamente

    if ($where) {
        foreach ($where as $k => $v) {
            $this->db->where($k, $v);
        }
    }

    if ($order_by) {
        $this->db->order_by($order_by, 'ASC');
    }

    return $this->db->get()->result_array(); // Devuelve los resultados correctamente
}
}