<?php
class Proyectos_evaluaciones_model extends CI_Model {

    //creado por Kevin Adorno
    public function get_evaluaciones_por_proyecto($proyecto_id) {
        $this->db->where('proyecto_id', $proyecto_id);
        $this->db->order_by('fecha', 'ASC');
        return $this->db->get('ema.proyectos_evaluaciones')->result();
    }


    public function get_proyectos_evaluaciones($filters = [], $limit = 10, $offset = 0) {
        if (!empty($filters)) {
            if (!empty($filters['proyecto_id'])) {
                $this->db->where('proyecto_id', $filters['proyecto_id']);
            }
            if (!empty($filters['categoria'])) {
                $this->db->like('categoria', $filters['categoria']);
            }
            if (!empty($filters['estado'])) {
                $this->db->where('estado', $filters['estado']);
            }
        }
    
        $this->db->order_by('id', 'ASC'); // Ordenar por ID de menor a mayor
        $this->db->limit($limit, $offset);
        
        return $this->db->get('ema.proyectos_evaluaciones')->result();
    }
    
    public function count_proyectos_evaluaciones($filters = []) {
        if (!empty($filters['proyecto_id'])) {  // ✅ Corregido aquí
            $this->db->where('proyecto_id', $filters['proyecto_id']);
        }
        if (!empty($filters['categoria'])) {
            $this->db->like('categoria', $filters['categoria']);
        }
        if (!empty($filters['estado'])) {
            $this->db->where('estado', $filters['estado']);
        }

        return $this->db->count_all_results('ema.proyectos_evaluaciones');
    }

    public function get_proyecto_evaluacion_by_id($id) {
        return $this->db->where('id', $id)->get('ema.proyectos_evaluaciones')->row_array();
    }

    public function create_proyecto_evaluacion($data) {
        return $this->db->insert('ema.proyectos_evaluaciones', $data);
    }

    public function update_proyecto_evaluacion($id, $data) {
        return $this->db->where('id', $id)->update('ema.proyectos_evaluaciones', $data);
    }

    public function delete_proyecto_evaluacion($id) {
        return $this->db->where('id', $id)->delete('ema.proyectos_evaluaciones');
    }
    
    public function concepto($i_tipoconcepto, $blanco = FALSE, $orderby = FALSE, $i_concepto = FALSE)
    {
        $query = "SELECT CONCEPTO, NOMBRE, DESCRIPCION, TIPOCONCEPTO FROM public.CONCEPTOS WHERE TIPOCONCEPTO = '".$i_tipoconcepto."'";

        if ($i_concepto == TRUE) {
            $query .= " AND CONCEPTO = '" . $i_concepto . "'";
        }

        if ($blanco == TRUE) {
            $query .= " UNION SELECT '  ', 'DEJAR EN BLANCO', '', ''";
        }
        if ($orderby) {
            $query .= " ORDER BY ".$orderby;
        }

        // Ejecutar la consulta
        $result = $this->db->query($query);

        // Registrar la última consulta
        $_SESSION['last_query'] = $this->db->last_query();

        // Devolver el resultado como un arreglo
        return $result->result_array();
    }
    
}
?>
