<?php
class Alertnotific_model extends CI_Model {

    /* public function get_alertas($filters = [], $limit = 10, $offset = 0) 
    {
        if (!empty($filters)) {
            if (!empty($filters['id_alerta'])) {
                $this->db->where('id_alerta', (int) $filters['id_alerta']);
            }
            if (!empty($filters['tipo_alerta'])) {
                $this->db->like('tipo_alerta', $filters['tipo_alerta']);
            }
            if (!empty($filters['estado'])) {
                $this->db->where('estado', $filters['estado']);
            }
        }

        $this->db->limit($limit, $offset);
        return $this->db->get('ema.alertnotific')->result();
    }
 */

    public function get_alertas($filters, $limit, $offset)
    {
        $this->db->from('alertnotific a');
        $this->db->join('resoluciones r', 'a.id_origen = r.id_resoluciones', 'left');

        if (!empty($filters['tipo_alerta'])) {
            $this->db->where('a.tipo_alerta', $filters['tipo_alerta']);
        }

        if (!empty($filters['dias_min']) || !empty($filters['dias_max'])) {
            $this->db->select("a.*, r.fecha_prox_vto_aa, DATE_PART('day', r.fecha_prox_vto_aa - NOW()) AS dias_restantes");

            if (!empty($filters['dias_min'])) {
                $this->db->having('dias_restantes >=', (int)$filters['dias_min']);
            }

            if (!empty($filters['dias_max'])) {
                $this->db->having('dias_restantes <=', (int)$filters['dias_max']);
            }
        } else {
            $this->db->select("a.*");
        }

        $this->db->limit($limit, $offset);
        $query = $this->db->get();
        return $query->result();
    }


    /* public function count_alertas($filters = []) {
        if (!empty($filters['tipo_alerta'])) {
            $this->db->like('tipo_alerta', $filters['tipo_alerta']);
        }
        if (!empty($filters['estado'])) {
            $this->db->where('estado', $filters['estado']);
        }
        return $this->db->count_all_results('ema.alertnotific');
    } */

    public function count_alertas($filters)
    {
        $this->db->from('alertnotific a');
        $this->db->join('resoluciones r', 'a.id_origen = r.id_resoluciones', 'left');

        if (!empty($filters['tipo_alerta'])) {
            $this->db->where('a.tipo_alerta', $filters['tipo_alerta']);
        }

        if (!empty($filters['dias_min']) || !empty($filters['dias_max'])) {
            $this->db->select("COUNT(*) as total, DATE_PART('day', r.fecha_prox_vto_aa - NOW()) AS dias_restantes");

            if (!empty($filters['dias_min'])) {
                $this->db->having('dias_restantes >=', (int)$filters['dias_min']);
            }

            if (!empty($filters['dias_max'])) {
                $this->db->having('dias_restantes <=', (int)$filters['dias_max']);
            }
        } else {
            $this->db->select("COUNT(*) as total");
        }

        $query = $this->db->get();
        return $query->row()->total ?? 0;
    }


    public function get_alerta_by_id($id_alerta) {
        $this->db->where('id_alerta', $id_alerta);
        return $this->db->get('ema.alertnotific')->row_array();
    }

    public function create_alerta($data) {
        return $this->db->insert('ema.alertnotific', $data);
    }

    public function update_alerta($id_alerta, $data) {
        return $this->db->where('id_alerta', $id_alerta)->update('ema.alertnotific', $data);
    }

    public function delete_alerta($id_alerta) {
        return $this->db->where('id_alerta', $id_alerta)->delete('ema.alertnotific');
    }
}