<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class tipo_alertnotific extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Tipo_alertnotific_model');
        $this->load->helper('url');
		$this->load->library('pagination');
        $this->load->library('form_validation');
    }

    public function index() {
        // Obtener filtros desde GET (si se desea filtrar)
        $filters = $this->input->get();
    
        // Eliminar 'per_page' de los filtros manualmente en PHP 5
        if (isset($filters['per_page'])) {
            unset($filters['per_page']);
        }
    
        // Configuración de la paginación
        $this->load->library('pagination');
    
        $config['base_url'] = site_url('tipo_alertnotific/index') . '?' . http_build_query($filters); // Eliminamos 'per_page' manualmente
        $config['total_rows'] = $this->Tipo_alertnotific_model->count_tipo_alertas($filters);
        $config['per_page'] = 10;
        $config['page_query_string'] = TRUE;
        $config['query_string_segment'] = 'per_page'; // Define el parámetro correcto
    
        // Inicializar la paginación
        $this->pagination->initialize($config);
    
        // Obtener el offset desde la URL (GET), asegurando que sea un número válido
        $offset = (int) $this->input->get('per_page', TRUE);
        if ($offset < 0) {
            $offset = 0;
        }
    
        // Obtener los resultados paginados
        $data['tipo_alertas'] = $this->Tipo_alertnotific_model->get_tipo_alertas($filters, $config['per_page'], $offset);
        $data['pagination'] = $this->pagination->create_links();
        $data['filters'] = $filters;
        $data['pagetitle'] = 'Listado de Tipo Alertas';
        $data['breadcrumb'] = '<ol class="breadcrumb">
                                    <li><a href="' . site_url() . '"><i class="fa fa-dashboard"></i> Home</a></li>
                                    <li class="active">Tipo Alertas</li>
                                  </ol>';
    
        // Renderizar la vista con los datos
        $this->template->admin_render('tipo_alertnotific/index', array_merge($data, $this->data));
    }
    
    

    public function create() {
        if ($this->input->post()) {
            // Definir reglas de validación
            $this->form_validation->set_rules('codigo', 'Código', 'required');
            // Puedes agregar más reglas según tus necesidades
    
            if ($this->form_validation->run() === FALSE) {
                // En caso de error, cargar la vista del formulario con errores
                $data['pagetitle']  = 'Crear Tipo Alerta';
                $data['breadcrumb'] = '<ol class="breadcrumb">
                                            <li><a href="' . site_url() . '"><i class="fa fa-dashboard"></i> Home</a></li>
                                            <li><a href="' . site_url('tipo_alertnotific') . '">Tipo Alertas</a></li>
                                            <li class="active">Crear</li>
                                         </ol>';
                $this->template->admin_render('tipo_alertnotific/create', array_merge($data, $this->data));
            } else {
                // Verificar si el código ya existe en la base de datos
                $codigo = $this->input->post('codigo');
                $this->db->where('codigo', $codigo);
                $query = $this->db->get('ema.tipo_alertnotific');
    
                if ($query->num_rows() > 0) {
                    // Si el código ya existe, mostrar mensaje de error y redirigir
                    $this->session->set_flashdata('error', 'Error: El código ingresado ya existe en la base de datos.');
                    redirect('tipo_alertnotific/create');
                    exit;
                } else {
                    // Preparar datos a insertar
                    $data_insert = array(
                        'codigo'       => $codigo,
                        'mensaje'      => $this->input->post('mensaje'),
                        'modulo'       => $this->input->post('modulo'),
                        'clase'        => $this->input->post('clase'),
                        'tipo'         => $this->input->post('tipo'),
                        'tabla'        => $this->input->post('tabla'),
                        'campo'        => $this->input->post('campo'),
                        'dias_alerta1' => !empty($this->input->post('dias_alerta1')) ? $this->input->post('dias_alerta1') : 0,
                        'dias_alerta2' => !empty($this->input->post('dias_alerta2')) ? $this->input->post('dias_alerta2') : 0,
                        'dias_alerta3' => !empty($this->input->post('dias_alerta3')) ? $this->input->post('dias_alerta3') : 0,
                        'dias_alerta4' => !empty($this->input->post('dias_alerta4')) ? $this->input->post('dias_alerta4') : 0,
                        'dias_alerta5' => !empty($this->input->post('dias_alerta5')) ? $this->input->post('dias_alerta5') : 0,
                        'rgb1'         => $this->input->post('rgb1'),
                        'rgb2'         => $this->input->post('rgb2'),
                        'rgb3'         => $this->input->post('rgb3'),
                        'rgb4'         => $this->input->post('rgb4'),
                        'rgb5'         => $this->input->post('rgb5'),
                        'estado'       => $this->input->post('estado'),
                    );
    
                    if ($this->Tipo_alertnotific_model->create_tipo_alerta($data_insert)) {
                        $this->session->set_flashdata('message', 'Tipo Alerta creada exitosamente.');
                    } else {
                        $this->session->set_flashdata('error', 'Error al crear el Tipo Alerta.');
                    }
                    redirect('tipo_alertnotific');
                }
            }
        } else {
            // Mostrar formulario en blanco
            $data['pagetitle']  = 'Crear Tipo Alerta';
            $data['breadcrumb'] = '<ol class="breadcrumb">
                                        <li><a href="' . site_url() . '"><i class="fa fa-dashboard"></i> Home</a></li>
                                        <li><a href="' . site_url('tipo_alertnotific') . '">Tipo Alertas</a></li>
                                        <li class="active">Crear</li>
                                   </ol>';
            $this->template->admin_render('tipo_alertnotific/create', array_merge($data, $this->data));
        }
    }
    

    public function edit($codigo) {
        $tipo_alerta = $this->Tipo_alertnotific_model->get_tipo_alerta_by_id($codigo);
        if (!$tipo_alerta) {
            show_404();
        }

        if ($this->input->post()) {
            // Reglas de validación
            $this->form_validation->set_rules('codigo', 'Código', 'required');
            // Agrega más reglas según los campos a actualizar

            if ($this->form_validation->run() === FALSE) {
                $data['tipo_alerta'] = $tipo_alerta;
                $data['pagetitle']   = 'Editar Tipo Alerta';
                $data['breadcrumb']  = '<ol class="breadcrumb">
                                            <li><a href="' . site_url() . '"><i class="fa fa-dashboard"></i> Home</a></li>
                                            <li><a href="' . site_url('tipo_alertnotific') . '">Tipo Alertas</a></li>
                                            <li class="active">Editar</li>
                                         </ol>';
                $this->template->admin_render('tipo_alertnotific/edit', array_merge($data, $this->data));
            } else {
                // Preparar datos actualizados
                $data_update = array(
                    'codigo'       => $this->input->post('codigo'),
                    'mensaje'      => $this->input->post('mensaje'),
                    'modulo'       => $this->input->post('modulo'),
                    'clase'        => $this->input->post('clase'),
                    'tipo'         => $this->input->post('tipo'),
                    'tabla'        => $this->input->post('tabla'),
                    'campo'        => $this->input->post('campo'),
                    'dias_alerta1' => !empty($this->input->post('dias_alerta1')) ? $this->input->post('dias_alerta1') : 0,
                    'dias_alerta2' => !empty($this->input->post('dias_alerta2')) ? $this->input->post('dias_alerta2') : 0,
                    'dias_alerta3' => !empty($this->input->post('dias_alerta3')) ? $this->input->post('dias_alerta3') : 0,
                    'dias_alerta4' => !empty($this->input->post('dias_alerta4')) ? $this->input->post('dias_alerta4') : 0,
                    'dias_alerta5' => !empty($this->input->post('dias_alerta5')) ? $this->input->post('dias_alerta5') : 0,
                    'rgb1'         => $this->input->post('rgb1'),
                    'rgb2'         => $this->input->post('rgb2'),
                    'rgb3'         => $this->input->post('rgb3'),
                    'rgb4'         => $this->input->post('rgb4'),
                    'rgb5'         => $this->input->post('rgb5'),
                    'estado'       => $this->input->post('estado'),
                );

                if ($this->Tipo_alertnotific_model->update_tipo_alerta($codigo, $data_update)) {
                    $this->session->set_flashdata('message', 'Tipo Alerta actualizada exitosamente.');
                    redirect('tipo_alertnotific');
                } else {
                    $this->session->set_flashdata('error', 'Error al actualizar el Tipo Alerta.');
                    redirect('tipo_alertnotific/edit/' . $codigo);
                }
            }
        } else {
            $data['tipo_alerta'] = $tipo_alerta;
            $data['pagetitle']   = 'Editar Tipo Alerta';
            $data['breadcrumb']  = '<ol class="breadcrumb">
                                        <li><a href="' . site_url() . '"><i class="fa fa-dashboard"></i> Home</a></li>
                                        <li><a href="' . site_url('tipo_alertnotific') . '">Tipo Alertas</a></li>
                                        <li class="active">Editar</li>
                                    </ol>';
            $this->template->admin_render('tipo_alertnotific/edit', array_merge($data, $this->data));
        }
    }

    public function delete($codigo) {
        if ($this->Tipo_alertnotific_model->delete_tipo_alerta($codigo)) {
            $this->session->set_flashdata('message', 'Tipo Alerta eliminada exitosamente.');
        } else {
            $this->session->set_flashdata('error', 'Error al eliminar el Tipo Alerta.');
        }
        redirect('tipo_alertnotific');
    }
}
