<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Distritos extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Distritos_model');
        $this->load->library('pagination');
        $this->load->library('form_validation');
    }

    public function index() {
        $filters = $this->input->get();
        if (isset($filters['per_page'])) {
            unset($filters['per_page']);
        }

        $config['base_url'] = site_url('distritos/index') . '?' . http_build_query($filters);
        $config['total_rows'] = $this->Distritos_model->count_distritos($filters);
        $config['per_page'] = 10;
        $config['page_query_string'] = TRUE;
        $config['query_string_segment'] = 'per_page';

        $this->pagination->initialize($config);
        $offset = (int) $this->input->get('per_page', TRUE);
        if ($offset < 0) {
            $offset = 0;
        }

        $data['distritos'] = $this->Distritos_model->get_distritos($filters, $config['per_page'], $offset);
        $data['pagination'] = $this->pagination->create_links();
        $data['filters'] = $filters;
        $data['pagetitle'] = 'Listado de Distritos';

        $this->template->admin_render('distritos/index', array_merge($data, $this->data));
    }

    public function create() {
        if ($this->input->post()) {
            $this->form_validation->set_rules('cod_snc', 'Código SNC', 'required');
            $this->form_validation->set_rules('nombre_dis_snc', 'Nombre', 'required');

            if ($this->form_validation->run() === FALSE) {
                $data['pagetitle'] = 'Crear Distrito';
                $this->template->admin_render('distritos/create', array_merge($data, $this->data));
            } else {
                $data_insert = [
                    'cod_snc' => $this->input->post('cod_snc'),
                    'nombre_dis_snc' => $this->input->post('nombre_dis_snc'),
                    'dpto' => $this->input->post('dpto'),
                    'distrito' => $this->input->post('distrito'),
                    'area_km2' => $this->input->post('area_km2'),
                    'shape_leng' => $this->input->post('shape_leng'),
                    'shape_area' => $this->input->post('shape_area'),
                    'obs' => $this->input->post('obs'),
                ];

                if ($this->Distritos_model->create_distrito($data_insert)) {
                    $this->session->set_flashdata('message', 'Distrito creado exitosamente.');
                } else {
                    $this->session->set_flashdata('error', 'Error al crear el distrito.');
                }
                redirect('distritos');
            }
        } else {
            $data['pagetitle'] = 'Crear Distrito';
            $this->template->admin_render('distritos/create', array_merge($data, $this->data));
        }
    }

    public function edit($id) {
        $distrito = $this->Distritos_model->get_distrito_by_id($id);
        if (!$distrito) {
            show_404();
        }

        if ($this->input->post()) {
            $this->form_validation->set_rules('cod_snc', 'Código SNC', 'required');
            $this->form_validation->set_rules('nombre_dis_snc', 'Nombre', 'required');

            if ($this->form_validation->run() === FALSE) {
                $data['distrito'] = $distrito;
                $data['pagetitle'] = 'Editar Distrito';
                $this->template->admin_render('distritos/edit', array_merge($data, $this->data));
            } else {
                $data_update = [
                    'cod_snc' => $this->input->post('cod_snc'),
                    'nombre_dis_snc' => $this->input->post('nombre_dis_snc'),
                    'dpto' => $this->input->post('dpto'),
                    'distrito' => $this->input->post('distrito'),
                    'area_km2' => $this->input->post('area_km2'),
                    'shape_leng' => $this->input->post('shape_leng'),
                    'shape_area' => $this->input->post('shape_area'),
                    'obs' => $this->input->post('obs'),
                ];

                if ($this->Distritos_model->update_distrito($id, $data_update)) {
                    $this->session->set_flashdata('message', 'Distrito actualizado correctamente.');
                    redirect('distritos');
                } else {
                    $this->session->set_flashdata('error', 'Error al actualizar el distrito.');
                    redirect('distritos/edit/' . $id);
                }
            }
        } else {
            $data['distrito'] = $distrito;
            $data['pagetitle'] = 'Editar Distrito';
            $this->template->admin_render('distritos/edit', array_merge($data, $this->data));
        }
    }

    public function delete($id) {
        if ($this->Distritos_model->delete_distrito($id)) {
            $this->session->set_flashdata('message', 'Distrito eliminado correctamente.');
        } else {
            $this->session->set_flashdata('error', 'Error al eliminar el distrito.');
        }
        redirect('distritos');
    }
}
?>
