<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Alertnotific extends Admin_Controller {

public function __construct() {
    parent::__construct();
    $this->load->model('Alertnotific_model');
    $this->load->helper('url');
    $this->load->library('pagination');
    $this->load->library('form_validation');
}

public function index() {
    $filters = $this->input->get();
    if (isset($filters['per_page'])) {
        unset($filters['per_page']);
    }

    $config['base_url'] = site_url('alertnotific/index') . '?' . http_build_query($filters);
    $config['total_rows'] = $this->Alertnotific_model->count_alertas($filters);
    $config['per_page'] = 10;
    $config['page_query_string'] = TRUE;
    $config['query_string_segment'] = 'per_page';

    $this->pagination->initialize($config);

    $offset = (int) $this->input->get('per_page', TRUE);
    if ($offset < 0) {
        $offset = 0;
    }

    $data['alertas'] = $this->Alertnotific_model->get_alertas($filters, $config['per_page'], $offset);
    $data['pagination'] = $this->pagination->create_links();
    $data['filters'] = $filters;
    $data['pagetitle'] = 'Listado de Alertas';

    $this->template->admin_render('alertnotific/index', array_merge($data, $this->data));
}

public function create() {
    if ($this->input->post()) {
        $this->form_validation->set_rules('tipo_alerta', 'Tipo de Alerta', 'required');
        $this->form_validation->set_rules('mensaje', 'Mensaje', 'required');
        
        if ($this->form_validation->run() === FALSE) {
            $this->template->admin_render('alertnotific/create', $this->data);
        } else {
            $data_insert = array(
                'id_origen'        => $this->input->post('id_origen'),
                'tipo_alerta'      => $this->input->post('tipo_alerta'),
                'mensaje'          => $this->input->post('mensaje'),
                'estado'           => $this->input->post('estado'),
                'id_alerta_padre'  => $this->input->post('id_alerta_padre'),
                'modulo'           => $this->input->post('modulo'),
                'clase'            => $this->input->post('clase'),
                'descripcion'      => $this->input->post('descripcion'),
                'dia'              => $this->input->post('dia'),
                'id_proyecto'      => $this->input->post('id_proyecto'),
                'id_proponente'    => $this->input->post('id_proponente'),
                'color'            => $this->input->post('color'),
            );
            if ($this->Alertnotific_model->create_alerta($data_insert)) {
                $this->session->set_flashdata('message', 'Alerta creada exitosamente.');
                redirect('alertnotific');
            } else {
                $this->session->set_flashdata('error', 'Error al crear la alerta.');
                redirect('alertnotific/create');
            }
        }
    } else {
        $this->template->admin_render('alertnotific/create', $this->data);
    }
}

public function edit($id_alerta) {
    $alerta = $this->Alertnotific_model->get_alerta_by_id($id_alerta);
    if (!$alerta) {
        show_404();
    }

    if ($this->input->post()) {
        $data_update = array(
            'id_origen'        => $this->input->post('id_origen'),
            'tipo_alerta'      => $this->input->post('tipo_alerta'),
            'mensaje'          => $this->input->post('mensaje'),
            'estado'           => $this->input->post('estado'),
            'id_alerta_padre'  => $this->input->post('id_alerta_padre'),
            'modulo'           => $this->input->post('modulo'),
            'clase'            => $this->input->post('clase'),
            'descripcion'      => $this->input->post('descripcion'),
            'dia'              => $this->input->post('dia'),
            'id_proyecto'      => $this->input->post('id_proyecto'),
            'id_proponente'    => $this->input->post('id_proponente'),
            'color'            => $this->input->post('color'),
        );

        if ($this->Alertnotific_model->update_alerta($id_alerta, $data_update)) {
            $this->session->set_flashdata('message', 'Alerta actualizada exitosamente.');
            redirect('alertnotific');
        } else {
            $this->session->set_flashdata('error', 'Error al actualizar la alerta.');
            redirect('alertnotific/edit/' . $id_alerta);
        }
    } else {
        $data['alerta'] = $alerta;
        $this->template->admin_render('alertnotific/edit', array_merge($data, $this->data));
    }
}

public function delete($id_alerta) {
    if ($this->Alertnotific_model->delete_alerta($id_alerta)) {
        $this->session->set_flashdata('message', 'Alerta eliminada exitosamente.');
    } else {
        $this->session->set_flashdata('error', 'Error al eliminar la alerta.');
    }
    redirect('alertnotific');
}

/* public function ver_conversacion($id_alerta) {
    // Obtiene el mensaje inicial
    $mensaje_padre = $this->Alertnotific_model->get_alerta_by_id($id_alerta);

    if (!$mensaje_padre) {
        show_404();
    }

    // Obtiene las respuestas directas a este mensaje
    $respuestas = $this->Alertnotific_model->get_respuestas($id_alerta);

    $data['mensaje_padre'] = $mensaje_padre;
    $data['respuestas'] = $respuestas;
    $data['pagetitle'] = 'Conversación: Alerta ID ' . $id_alerta;

    $this->template->admin_render('alertnotific/ver_conversacion', array_merge($data, $this->data));
}
*/

public function ver_conversacion($id_alerta) {
    $mensaje_padre = $this->Alertnotific_model->get_alerta_by_id($id_alerta);

    if (!$mensaje_padre) {
        show_404();
    }

    // Obtener respuestas directas
    $respuestas = $this->Alertnotific_model->get_respuestas($id_alerta);

    // Verificar si ya tiene respuesta directa
    $ya_respondido = !empty($respuestas);

    $data['mensaje_padre'] = $mensaje_padre;
    $data['respuestas'] = $respuestas;
    $data['ya_respondido'] = $ya_respondido;
    $data['pagetitle'] = 'Conversación: Alerta ID ' . $id_alerta;

    $this->template->admin_render('alertnotific/ver_conversacion', array_merge($data, $this->data));
}

/* public function responder($id_alerta_padre) {
    $alerta_padre = $this->Alertnotific_model->get_alerta_by_id($id_alerta_padre);

    if (!$alerta_padre) {
        show_404();
    }

    if ($this->input->post()) {
        $mensaje = $this->input->post('mensaje');

        $data_insert = array(
            'id_origen'        => $alerta_padre['id_origen'],
            'tipo_alerta'      => $alerta_padre['tipo_alerta'],
            'mensaje'          => $mensaje,
            'estado'           => $alerta_padre['estado'],
            'id_alerta_padre'  => $id_alerta_padre,
            'modulo'           => $alerta_padre['modulo'],
            'clase'            => $alerta_padre['clase'],
            'descripcion'      => $alerta_padre['descripcion'],
            'dia'              => 0, // el nuevo mensaje tendrá dia=0
            'id_proyecto'      => $alerta_padre['id_proyecto'],
            'id_proponente'    => $alerta_padre['id_proponente'],
            'color'            => $alerta_padre['color'],
        );

        if ($this->Alertnotific_model->create_alerta($data_insert)) {
            $this->session->set_flashdata('message', 'Respuesta enviada exitosamente.');
            redirect('alertnotific/ver_conversacion/'.$id_alerta_padre);
        } else {
            $this->session->set_flashdata('error', 'Error al enviar la respuesta.');
            redirect('alertnotific/ver_conversacion/'.$id_alerta_padre);
        }
    } else {
        $data['alerta_padre'] = $alerta_padre;
        $this->template->admin_render('alertnotific/ver_conversacion', array_merge($data, $this->data));
    }
}  */

public function responder($id_alerta_padre) {
    $alerta_padre = $this->Alertnotific_model->get_alerta_by_id($id_alerta_padre);

    if (!$alerta_padre) {
        show_404();
    }

    // Verificar si ya tiene respuesta directa
    $this->db->where('id_alerta_padre', $id_alerta_padre);
    $respuesta_existente = $this->db->get('ema.alertnotific')->row();

    if ($respuesta_existente) {
        $this->session->set_flashdata('error', 'Este mensaje ya tiene una respuesta. No se puede responder nuevamente.');
        redirect('alertnotific/ver_conversacion/'.$id_alerta_padre);
        return;
    }

    if ($this->input->post()) {
        $mensaje = $this->input->post('mensaje');

        $data_insert = array(
            'id_origen'        => $alerta_padre['id_origen'],
            'tipo_alerta'      => $alerta_padre['tipo_alerta'],
            'mensaje'          => $mensaje,
            'estado'           => $alerta_padre['estado'],
            'id_alerta_padre'  => $id_alerta_padre,
            'modulo'           => $alerta_padre['modulo'],
            'clase'            => $alerta_padre['clase'],
            'descripcion'      => $alerta_padre['descripcion'],
            'dia'              => 0,
            'id_proyecto'      => $alerta_padre['id_proyecto'],
            'id_proponente'    => $alerta_padre['id_proponente'],
            'color'            => $alerta_padre['color'],
        );

        if ($this->Alertnotific_model->create_alerta($data_insert)) {
            $this->session->set_flashdata('message', 'Respuesta enviada exitosamente.');
            redirect('alertnotific/ver_conversacion/'.$id_alerta_padre);
        } else {
            $this->session->set_flashdata('error', 'Error al enviar la respuesta.');
            redirect('alertnotific/ver_conversacion/'.$id_alerta_padre);
        }
    } else {
        $data['alerta_padre'] = $alerta_padre;
        $this->template->admin_render('alertnotific/ver_conversacion', array_merge($data, $this->data));
    }
}
 


}
