<?php
	require_once('../fpdf.php');
	
	
	class PDF extends FPDF
	{
		function Header()
		{	
			/*$this->Image('../img/mopc.jpg', 8, 5, 45 );
			$this->Image('../img/gobierno-nacional.jpg', 80, 5, 40 );
			$this->Image('../img/paraguay-de-la-gente.jpg', 245, 5, 30 );*/
			$this->Image('../img/mopc_23.jpg', 10, 5, 80 );
			//$this->Image('../img/gobierno-nacional.jpg', 120, 5, 40 );
			$this->Image('../img/gobierno_del_paraguay.jpg', 200, 5, 80 );
			$this->Ln(7);
			$this->SetFont('Arial','I',5);
			$this->Cell(20,10, '__________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________');
			$this->Ln(8);

		}

		function Footer()
		{
			$this->SetY(-18);
			$this->SetFont('Arial','I',5);
			$this->Cell(0,10, '__________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________');
			// Posicion: a 1,5 cm del final
			$this->SetY(-15);
			// Arial italic 8
			$this->SetFont('Arial','I',8);
			// Numero de pagina
			$this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');

			/* OPCION CHETA
			$this->SetY(-22);
			$this->SetFont('Arial','I',5);
			$this->Cell(0,10, '_____________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________________');
			$this->SetFont('Arial','B', 8);
			$this->SetY(-18);
			$this->Cell(0,10, 'Pagina '.$this->PageNo().'/{nb}',0,0,'C' );
			$this->SetFont('Arial','I', 7);
			$this->Ln(2.9);
			$this->Cell(0,10,utf8_decode('Ministerio de Obras Públicas y Comunicaciones'),0,0,'C');
			$this->Ln(2.5);
			$this->Cell(0,10,utf8_decode('Oliva 411 y Alberdi - Asunción - Paraguay - Tel.: (59521)4149000'),0,0,'C');
			$this->Ln(2.5);
			$this->Cell(0,10, 'www.mopc.gov.py',0,0,'C');
			$this->Ln(3);*/

		}
		function WordWrap(&$text, $maxwidth)
		{
			$text = trim($text);
			if ($text==='')
				return 0;
			$space = $this->GetStringWidth(' ');
			$lines = explode("\n", $text);
			$text = '';
			$count = 0;

			foreach ($lines as $line)
			{
				$words = preg_split('/ +/', $line);
				$width = 0;

				foreach ($words as $word)
				{
					$wordwidth = $this->GetStringWidth($word);
					if ($wordwidth > $maxwidth)
					{
						// Word is too long, we cut it
						for($i=0; $i<strlen($word); $i++)
						{
							$wordwidth = $this->GetStringWidth(substr($word, $i, 1));
							if($width + $wordwidth <= $maxwidth)
							{
								$width += $wordwidth;
								$text .= substr($word, $i, 1);
							}
							else
							{
								$width = $wordwidth;
								$text = rtrim($text)."\n".substr($word, $i, 1);
								$count++;
							}
						}
					}
					elseif($width + $wordwidth <= $maxwidth)
					{
						$width += $wordwidth + $space;
						$text .= $word.' ';
					}
					else
					{
						$width = $wordwidth + $space;
						$text = rtrim($text)."\n".$word.' ';
						$count++;
					}
				}
				$text = rtrim($text)."\n";
				$count++;
			}
			$text = rtrim($text);
			return $count;
		}		
	}
?>