<?php
defined('BASEPATH') or exit('No direct script access allowed');
?>


<div class="content-wrapper">
  <section class="content-header">
    <?php echo $pagetitle; ?>
    <?php echo $breadcrumb; ?>
  </section>

  <section class="content">
    <div class="row">
      <div class="col-md-12">
        <?php
        if ($message) {
            echo '<pre>';
            echo '<h4><b>Mensaje:</b></h4>';
            echo '<h5>' . $message . '</h5>';
            echo '</pre>';
        }
        ?>
      </div>
    </div>

    <?php echo form_open(current_url(), array('class' => 'form-horizontal', 'id' => 'form-create_expe'));?>

    <div class="panel panel-default">
      <div class="panel-body">
        <div class="text-center">
          <h4>CARGA DE DATOS GENERALES POR TITULO</h4>
        </div>
        <br>
        
        <div class="col-sm-6">
          <table class="tablaCentrada" border="1px solid rgb(0, 0, 0)" style="width: 100%;">
            <thead>
              <tr class="colorMOPC">
                <td colspan="2">CARACTERISTICAS GENERALES</td>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td><label class="control-label" for="fecha_ingreso">Fecha de ingreso:</label></td>
                <td>
                  <div class="input-group date" data-provide="datepicker" data-date-format="dd/mm/yyyy">
                    <?php echo form_input($fecha_ingreso);?>
                    <div class="input-group-addon">
                      <i class="fa fa-calendar"></i>
                    </div>
                  </div>
                </td>
              </tr>
              <tr>
                <td><label class="control-label" for="codigo"><?php echo lang('expedientes_codigo'); ?></label></td>
                <td><?php echo form_input($codigo); ?></td>
              </tr>
              <tr>
                <td><label class="control-label" for="nombre_completo">Nombre del propietario:</label></td>
                <td><?php echo form_input($nombre_completo); ?></td>
              </tr>
              <tr>
                  <td><label class="control-label" for="id_proyecto">Sedes:</label></td>
                  <td>
                    <?php 
                      $attribute = 'class="form-control selectpicker" id="id_proyecto" required="required"';
                      echo form_dropdown('id_proyecto', $proyecto, '', $attribute); 
                    ?>
                  </td>
                </tr>
                <tr>
                  <td><label class="control-label" for="id_condicion_dominio">Condición de dominio:</label></td>
                  <td>
                    <?php 
                      $attribute = 'class="form-control selectpicker" data-live-search="true" id="id_condicion_dominio" required="required"';
                      echo form_dropdown('id_condicion_dominio', $condicion_dominio, '', $attribute); 
                    ?>
                  </td>
                </tr>
            </tbody>
          </table>
          <br>

          <div class="table-responsive">
            <table class="tablaCentrada" border="1px solid rgb(0, 0, 0)" style="width: 100%;">
            <thead>
              <tr class="colorMOPC">
                <td colspan="2">CARACTERISTICAS DEL TITULO</td>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td><label class="control-label" for="numero_escritura">Número de Escritura:</label></td>
                <td><?php echo form_input($numero_escritura); ?></td>
              </tr>
              <tr>
                <td><label class="control-label" for="escritura_publica">Escritura Pública:</label></td>
                <td><?php echo form_input($escritura_publica); ?></td>
              </tr>
              <tr>
                <td><label class="control-label" for="numero_titulo">Número de Título:</label></td>
                <td><?php echo form_input($numero_titulo); ?></td>
              </tr>
              <tr>
                <td><label class="control-label" for="superficie_legal">Superficie Legal (m²):</label></td>
                <td><?php echo form_input($superficie_legal); ?></td>
              </tr>
              <tr>
                <td><label class="control-label" for="folio">Folio:</label></td>
                <td><?php echo form_input($folio); ?></td>
              </tr>
              <tr>
                <td><label class="control-label" for="fecha_inscripcion">Fecha de Inscripción:</label></td>
                <td>
                  <div class="input-group date" data-provide="datepicker" data-date-format="dd/mm/yyyy">
                    <?php echo form_input($fecha_inscripcion); ?>
                    <div class="input-group-addon">
                      <i class="fa fa-calendar"></i>
                    </div>
                  </div>
                </td>
              </tr>
              <tr>
                <td><label class="control-label" for="juez">Juez:</label></td>
                <td><?php echo form_input($juez); ?></td>
              </tr>
              <tr>
                <td><label class="control-label" for="escribano">Escribano:</label></td>
                <td><?php echo form_input($escribano); ?></td>
              </tr>
            </tbody>
          </table>
          </div>

        </div>

        <div class="col-sm-6">
          <table class="tablaCentrada" border="1px solid rgb(0, 0, 0)" style="width: 100%;">
            <thead>
              <tr class="colorMOPC">
                <td colspan="2">CARACTERISTICAS DEL INMUEBLE</td>
              </tr>
            </thead>
            <tbody>
              
              <tr>
                <td><label class="control-label" for="id_departamento">Departamento:</label></td>
                <td>
                  <?php 
                    $attribute = 'class="form-control selectpicker" data-live-search="true" id="id_departamento" required="required"';
                    echo form_dropdown('id_departamento', $departamento, '', $attribute); 
                  ?>
                </td>
              </tr>
              <tr>
                <td><label class="control-label" for="id_distrito">Distrito:</label></td>
                <td>
                <?php 
                $attribute = 'class="form-control selectpicker" data-live-search="true" id="id_distrito" required="required"';
                echo form_dropdown('id_distrito', ['' => 'Seleccione un distrito'], '', $attribute); 
                ?>
                </td>
              </tr>
              <tr>
                <td><label class="control-label" for="lugar">Lugar:</label></td>
                <td><?php echo form_input($lugar); ?></td>
              </tr>
              <tr>
                <td><label class="control-label" for="cta_cte_catastral">Cta. Cte. Ctral:</label></td>
                <td><?php echo form_input($cta_cte_catastral); ?></td>
              </tr>
              <tr>
                <td><label class="control-label" for="padron">Padrón:</label></td>
                <td><?php echo form_input($padron); ?></td>
              </tr>
              <tr>
                <td><label class="control-label" for="finca">Finca:</label></td>
                <td><?php echo form_input($finca); ?></td>
              </tr>
              <tr>
                <td><label class="control-label" for="matricula">Matrícula:</label></td>
                <td><?php echo form_input($matricula); ?></td>
              </tr>
              <tr>
                <td><label class="control-label" for="tiene_cotejo">Tiene Cotejo:</label></td>
                <td>
                  <label>Si&nbsp&nbsp
                  <?php echo form_radio(
                    $tiene_cotejo['name'],
                    $tiene_cotejo['value_s'],
                    $tiene_cotejo['checked_s']
                    );?>
                  </label>
                  <?php echo '&nbsp;';?><?php echo '&nbsp;';?><?php echo '&nbsp;';?>
                  <label>No&nbsp&nbsp
                  <?php echo form_radio(
                    $tiene_cotejo['name'],
                    $tiene_cotejo['value_n'],
                    $tiene_cotejo['checked_n']
                    );?>
                  </label>
                </td>
              </tr>
              <tr>
                <td><label class="control-label" for="tiene_mensura_judicial">Tiene Mensura Judicial:</label></td>
                <td>
                  <label>Si&nbsp&nbsp
                  <?php echo form_radio(
                    $tiene_mensura_judicial['name'],
                    $tiene_mensura_judicial['value_s'],
                    $tiene_mensura_judicial['checked_s']
                    );?>
                  </label>
                  <?php echo '&nbsp;';?><?php echo '&nbsp;';?><?php echo '&nbsp;';?>
                  <label>No&nbsp&nbsp
                  <?php echo form_radio(
                    $tiene_mensura_judicial['name'],
                    $tiene_mensura_judicial['value_n'],
                    $tiene_mensura_judicial['checked_n']
                    );?>
                  </label>
                </td>
              </tr>

              <tr>
                <td><label class="control-label" for="impuesto_al_dia">Impuesto al día:</label></td>
                <td>
                  <label>Si&nbsp&nbsp
                  <?php echo form_radio(
                    $impuesto_al_dia['name'],
                    $impuesto_al_dia['value_s'],
                    $impuesto_al_dia['checked_s']
                    );?>
                  </label>
                  <?php echo '&nbsp;';?><?php echo '&nbsp;';?><?php echo '&nbsp;';?>
                  <label>No&nbsp&nbsp
                  <?php echo form_radio(
                    $impuesto_al_dia['name'],
                    $impuesto_al_dia['value_n'],
                    $impuesto_al_dia['checked_n']
                    );?>
                  </label>
                </td>
                
              </tr>
            </tbody>
          </table>
        </div>

      </div>
    </div>

    <!-- <div class="panel panel-default">
      <div class="panel-body">
        <div class="text-center">
          <h4>VALIDACIÓN DE CARÁTULAS</h4>
        </div>
        <div class="col-sm-4">
          <div class="colorMOPC">Validación cáratulas documentación</div>
          <br>
          <div class="colorMOPC">Validación Cédulas de Notificación</div>
          <br>
          <div class="colorMOPC">Validación Autorización</div>
        </div>
        <div class="col-sm-8">
          <?php echo form_textarea($observacion_caratula); ?>
          <br>
          <?php echo form_textarea($observacion_cedula); ?>
          <br>
          <?php echo form_textarea($observacion_autorizacion); ?>
        </div>
      </div>
    </div> -->

    <div class="form-group" style="text-align: center;">
      <?php echo form_button(array('type' => 'submit','class' => 'btn btn-primary btn-size', 'content' => 'GRABAR')); ?>
      &nbsp;
      <?php echo anchor('expedientes/expedientes/', 'REGRESAR', array('class' => 'btn btn-primary btn-size')); ?>
    </div>

    <?php echo form_close();?>
  </section>
</div>
<script>
$.ajax({
    url: "<?php echo site_url('expedientes/expedientes/get_distritos_por_departamento');?>",
    type: "POST",
    data: {id_departamento: id_departamento},
    dataType: "json",
    success: function(data){
        console.log("Datos recibidos:", data);
        $('#id_distrito').empty();
        $.each(data, function(key, value) {
            $('#id_distrito').append('<option value="'+key+'">'+value+'</option>');
        });
        $('#id_distrito').selectpicker('refresh');
    },
    error: function(xhr, status, error){
        console.error("Error AJAX:", status, error);
    }
});

</script>

