<?php


	/**
	 * Prouectos MOPC
	 *
	 * @return bool
	 * @author Lissy Jameuge Rojas Gonzales
	 **/


defined('BASEPATH') OR exit('No direct script access allowed');

class Proyectos extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('proyectos/proyectos_model');
		$this->lang->load('proyectos/proyectos_lang');
		$this->load->library('pagination');

		/* Titulo de la pagina :: Common */
		$this->page_title->push(lang('menu_proyectos'));
		$this->data['pagetitle'] = $this->page_title->show();

		//verificación de módulo para el reset de las variables de sessión utilizadas en la misma
		if ($_SESSION['id_modulo'] != 'PROYECTOS') {

			$_SESSION['arraywhere_proyectos'] 		 = NULL;
			$_SESSION['arraywhere_proyectos_busqueda'] = NULL;
			$_SESSION['id_modulo'] = 'PROYECTOS';
		}

		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_proyectos'), 'proyectos/proyectos');
	}

	public function index()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{

			if ($_POST) {
				if ($_POST['id_proyecto'])
				{
					if (is_numeric($_POST['id_proyecto'])) {
						$arraywhere['id_proyecto'] 					= $_POST['id_proyecto'];
						$arraywherebusq['id_proyecto'] 				= $_POST['id_proyecto'];
					}
				}

				if ($_POST['numero_contrato'])
				{
					$arraywhere['numero_contrato'] 					= $_POST['numero_contrato'];
					$arraywherebusq['numero_contrato like '] 		= '%'.$_POST['numero_contrato'].'%';
				}

				if ($_POST['anyo_contrato'])
				{
					if (is_numeric($_POST['anyo_contrato'])) {
						$arraywhere['anyo_contrato'] 					= $_POST['anyo_contrato'];
						$arraywherebusq['anyo_contrato'] 				= $_POST['anyo_contrato'];
					}
				}

				if ($_POST['expediente'])
				{
					$arraywhere['expediente'] 					= $_POST['expediente'];
					$arraywherebusq['lower(expediente) like '] 	= '%'.strtolower($_POST['expediente']).'%';
				}

				if ($_POST['consultora'])
				{
					$arraywhere['consultora'] 					= $_POST['consultora'];
					$arraywherebusq['lower(consultora) like '] 	= '%'.strtolower($_POST['consultora']).'%';
				}

				if ($_POST['descripcion'])
				{
					$arraywhere['descripcion'] 						= $_POST['descripcion'];
					$arraywherebusq['lower(descripcion) like '] 		= '%'.strtolower($_POST['descripcion']).'%';
				}

				if ($_POST['contratista'])
				{
					$arraywhere['contratista'] 						= $_POST['contratista'];
					$arraywherebusq['lower(contratista) like ']		= '%'.strtolower($_POST['contratista']).'%';
				}

				/*
				if ($_POST['presupuesto'])
				{
					$arraywhere['presupuesto'] 						= $_POST['presupuesto'];
					$arraywherebusq['lower(presupuesto) like ']		= '%'.strtolower($_POST['presupuesto']).'%';
				}

				if ($_POST['tipo_moneda'])
				{
					$arraywhere['tipo_moneda'] 					= $_POST['tipo_moneda'];
					$arraywherebusq['lower(tipo_moneda) like '] 	= '%'.strtolower($_POST['tipo_moneda']).'%';
				}
				*/

				if ($_POST['fecha_orden_proceder'])
				{
					$arraywhere['fecha_orden_proceder'] 					= $_POST['fecha_orden_proceder'];
					$arraywherebusq['lower(fecha_orden_proceder) like '] 	= '%'.strtolower($_POST['fecha_orden_proceder']).'%';
				}

				if ($_POST['plazo_ejecucion'])
				{
					$arraywhere['plazo_ejecucion'] 					= $_POST['plazo_ejecucion'];
					$arraywherebusq['lower(plazo_ejecucion) like '] 	= '%'.strtolower($_POST['plazo_ejecucion']).'%';
				}

				if ($_POST['plazo_ejecucion_catastral'])
				{
					$arraywhere['plazo_ejecucion_catastral'] 					= $_POST['plazo_ejecucion_catastral'];
					$arraywherebusq['lower(plazo_ejecucion_catastral) like '] 	= '%'.strtolower($_POST['plazo_ejecucion_catastral']).'%';
				}

				if ($_POST['fecha_hora_insercion'])
				{
					$arraywhere['fecha_hora_insercion'] 					= $_POST['fecha_hora_insercion'];
					$arraywherebusq['lower(fecha_hora_insercion) like '] 	= '%'.strtolower($_POST['fecha_hora_insercion']).'%';
				}

				if ($_POST['observaciones'])
				{
					$arraywhere['observaciones'] 					= $_POST['observaciones'];
					$arraywherebusq['lower(observaciones) like '] 	= '%'.strtolower($_POST['observaciones']).'%';
				}

				if ($_POST['usuario'])
				{
					$arraywhere['usuario'] 					= $_POST['usuario'];
					$arraywherebusq['lower(usuario) like '] 	= '%'.strtolower($_POST['usuario']).'%';
				}
				if ($_POST['codigo_proyecto'])
				{
					$arraywhere['codigo_proyecto'] 					= $_POST['codigo_proyecto'];
					$arraywherebusq['lower(codigo_proyecto) like '] 	= '%'.strtolower($_POST['codigo_proyecto']).'%';
				}

				$_SESSION['arraywhere_proyectos'] = $arraywhere;
				$_SESSION['arraywhere_proyectos_busqueda'] = $arraywherebusq;

				redirect('proyectos/proyectos/index/');
			}

			 // ----- Paginacion Generica
			$mi_paginacion = $this->ion_auth->paginacion_generica(
				12, 						// resultados por por_pagina,
				4, 							// segmento uri a leer,
				5, 							// cantidad_enlaces,
				base_url(). 'proyectos/proyectos/index/',  // url completa de la pagina paginada
				'proyectos',		            // scheme y nombre de la tabla, para la consulta
				$_SESSION['arraywhere_proyectos_busqueda']
				);

			$this->data['pagination'] 		= $mi_paginacion['pagination'];

			$this->data['proyectos']	  	= $this->ion_auth_model->segmentador_paginas(
			//$proyectos	  	= $this->ion_auth_model->segmentador_paginas(
 				$mi_paginacion['per_page'], 	// resultados por pagina
 				4,								// segmento uri a leer
 				'proyectos',					    // el nombre de la tabla a consultar $nombre_tabla
 				$_SESSION['arraywhere_proyectos_busqueda'],
				'proyectos',
				'ASC'
 				)->result();
			// ----- Fin paginacion


			foreach ($this->data['proyectos'] as $key => $value) {
				$i = 0;
				foreach ($value as $k => $val) {
					$i = $i + 1;
					if ($i == 1) {

						//$cant_pol = $this->proyectos_model->f_existe_grafico_id_proyecto($value->id_proyecto);
						//$exp['existe_poligono'] = $cant_pol;
						$exp['existe_poligono'] = 1;


						//if (grupo_usuario(17) or grupo_usuario(27)) {
							$exp['grupo_usuario'] = 'C';
						//}else{
						//	$exp['grupo_usuario'] = 'N';
						//}
					}
					$exp[$k] = $val;
				}
				$exps[] = (object)$exp;
			}

			if (isset($exps)) {
				$this->data['proyectos'] = $exps;
			}else{
				$this->data['proyectos'] = NULL;
			}

			//emite un mensaje si es que se eliminó un proyecto
			if (isset($_SESSION['last_exp_delete'])) {
				$this->session->set_flashdata('message', $_SESSION['last_exp_delete']);
				unset($_SESSION['last_exp_delete']);
			}

			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

			/* Breadcrumbs */
			$this->data['breadcrumb'] = $this->breadcrumbs->show();

			$this->data['habilitado_sis'] = grupo_usuario(3);
			$this->data['habilitado_director'] = grupo_usuario(3);

			/* Load Template */
            $this->template->admin_render('proyectos/index', $this->data);
		}
	}

	public function reset_busqueda()
	{
		$_SESSION['arraywhere_proyectos'] 			= NULL;
		$_SESSION['arraywhere_proyectos_busqueda'] 	= NULL;

		redirect('proyectos/proyectos/index/');
	}

	public function ver_exp($id_proyecto)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{
			/* Breadcrumbs */
	        $this->breadcrumbs->unshift(2, 'Información Expediente', 'admin/groups/profile');
	        $this->data['breadcrumb'] = $this->breadcrumbs->show();

			$this->data['expe_info']  = $this->proyectos_model->view('exp', array('id_proyecto' => $id_proyecto))->result();

			/* Load Template */
            $this->template->admin_render('proyectos/ver_proyecto', $this->data);
		}
	}



	public function create()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('proyectos_create'), 'proyectos/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Validate form input */

		$this->form_validation->set_rules('codigo_proyecto', 		'<b>Codigo del Proyecto</b>' , 	'required');
		/* $this->form_validation->set_rules('expediente', 		'<b>Expediente</b>' , 		'required'); */

		//$this->form_validation->set_rules('id_proyecto_geomatica', 	'<b>ID Geomática</b>' ,  'required');

		if ($this->form_validation->run() == TRUE)
		{
				
				//show_error(2);
	        	if ($_POST['id_proyecto']){
					$arraycampos['id_proyecto'] 		= $_POST['id_proyecto'];
				}

				if ($_POST['nombre_sede']){
					$arraycampos['nombre_sede'] = $_POST['nombre_sede'];
				}
				if ($_POST['dpto']){
					$arraycampos['dpto'] = $_POST['dpto'];
				}
				if ($_POST['distrito']){
					$arraycampos['distrito'] = $_POST['distrito'];
				}
				if ($_POST['localidad']){
					$arraycampos['localidad'] = $_POST['localidad']; // Aquí va el lugar (barloc)
				}
				if ($_POST['gerente_sede']){
					$arraycampos['gerente_sede'] = $_POST['gerente_sede'];
				}

        		/* if ($_POST['numero_contrato']){
	        		$arraycampos['numero_contrato'] 	= $_POST['numero_contrato'];
	        	} */

	        	/* if ($_POST['anyo_contrato']){
	        		$arraycampos['anyo_contrato'] 		= $_POST['anyo_contrato'];
	        	} */

				/* if ($_POST['expediente']){
					$arraycampos['expediente'] 			= $_POST['expediente'];
				} */

				/* if ($_POST['consultora']){
					$arraycampos['consultora'] 			= $_POST['consultora'];
				}
 				*/
				/* if ($_POST['descripcion']){
					$arraycampos['descripcion'] 		= $_POST['descripcion'];
				}
 				*/

				/* if ($_POST['contratista']){
					$arraycampos['contratista'] 		= $_POST['contratista'];
				} */

				/* if ($_POST['presupuesto']){
					$arraycampos['presupuesto'] 		= $_POST['presupuesto'];

				} */

				/* if ($_POST['tipo_moneda']){
					$arraycampos['tipo_moneda'] 		= strtoupper($_POST['tipo_moneda']);

				} */

				/* if ($_POST['fecha_orden_proceder']){
					$arraycampos['fecha_orden_proceder'] 	= $_POST['fecha_orden_proceder'];
				} */

				/* if ($_POST['plazo_ejecucion']){
					$arraycampos['plazo_ejecucion'] 		= $_POST['plazo_ejecucion'];
				} */

				/* if ($_POST['plazo_ejecucion_catastral']){
					$arraycampos['plazo_ejecucion_catastral'] 	= strtoupper($_POST['plazo_ejecucion_catastral']);

				} */

				/* if ($_POST['fecha_hora_insercion']){
					$arraycampos['fecha_hora_insercion'] 		= $_POST['fecha_hora_insercion'];
				} */

				if ($_POST['observaciones']){
					$arraycampos['observaciones'] 		= $_POST['observaciones'];
				}

				/* if ($_POST['usuario']){
					$arraycampos['usuario'] 			= strtoupper($_POST['usuario']);

				} */
				if ($_POST['codigo_proyecto']){
					$arraycampos['codigo_proyecto'] 	= strtoupper($_POST['codigo_proyecto']);

				}

			$accion = 0;
			if (isset($_POST['accion'])){
				$accion = intval($_POST['accion']);
			}else{
				$accion = 0;
			}

			$id_proyecto = $this->proyectos_model->obtener_nextval('public.proyectos_id_proyecto_seq');
			$arraycampos['id_proyecto'] = $id_proyecto;

			$proyecto_create = $this->proyectos_model->crear_proyecto($arraycampos);


        	if ($proyecto_create)
        	{

				if($accion===1){ /// ACCION PARA OBSERVAR

        			$this->session->set_flashdata('message', '¡Expediente <b>'.$_POST['id_proyecto'].'</b>, Proyecto <b>'.$_POST['id_proyecto'].'</b> creado exitósamente!');
					redirect('proyectos/proyectos/edit_proyecto/'.$id_proyecto);

				} else {

        			$this->session->set_flashdata('message', '¡Expediente <b>'.$_POST['id'].'</b>, Gestión <b>'.$_POST['id_proyecto'].'</b> creado exitósamente!');
					redirect('proyectos/proyectos/edit_proyecto/'.$id_proyecto);
				}
			}
			else
			{
				$this->session->set_flashdata('message', $this->ion_auth->errors());
			}
		}
		else
		{
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
			// Departamento
			$departamentos[''] = 'Seleccione el departamento';
            $departamento = $this->proyectos_model->dropdown_data('departamentos')->result_array();
            foreach ($departamento as $dep) {
                $departamentos[$dep['dpto']] = $dep['dpto'].' - '.$dep['dpto_desc'];
            }
            $this->data['departamento'] = $departamentos;

            $distritos[''] = 'Seleccione el distrito';
            $this->data['distrito'] = $distritos;

			// Lugar (barrio/localidad)
			$lugares = $this->proyectos_model->dropdown_data('barloc')->result_array();
			$a_lugares = ['' => 'Seleccione lugar'];
			$this->data['departamento_sel'] = '';
			$this->data['distrito_sel']     = '';
			$this->data['lugar_sel']        = '';
			$this->data['lugar']            = $a_lugares; // o lo que ya tenías como lugares
			foreach ($lugares as $l) {
				if (isset($l['id']) && isset($l['barlo_desc'])) {
					$a_lugares[$l['id']] = $l['barlo_desc'];
				}
			}
			$this->data['lugares'] = $a_lugares;
			


			$this->data['nombre_sede'] = array(
				'type'  => 'text',
				'name'  => 'nombre_sede',
				'id'    => 'nombre_sede',
				'value' => $this->form_validation->set_value('nombre_sede'),
				'class' => 'form-control',
				'maxlength' => '255'
			);
			$this->data['gerente_sede'] = array(
				'type'  => 'text',
				'name'  => 'gerente_sede',
				'id'    => 'gerente_sede',
				'value' => $this->form_validation->set_value('gerente_sede'),
				'class' => 'form-control',
				'maxlength' => '255'
			);
			

			$this->data['id_proyecto'] = array(
				'type'     => 'text',
				'name'     => 'id_proyecto',
				'id'       => 'id_proyecto',
				'value'    => $this->form_validation->set_value('id_proyecto'),
				'class'    => 'form-control',
				'maxlength'=> '10',
				'readonly' => TRUE
			);
			$this->data['numero_contrato'] = array(
				'type'     => 'text',
				'name'     => 'numero_contrato',
				'id'       => 'numero_contrato',
				'value'    => $this->form_validation->set_value('numero_contrato'),
				'class'    => 'form-control',
				'maxlength'=> '4'
			);
			$this->data['anyo_contrato'] = array(
				'type'     => 'number',
				'name'     => 'anyo_contrato',
				'id'       => 'anyo_contrato',
				'value'    => $this->form_validation->set_value('anyo_contrato'),
				'class'    => 'form-control',
				'onkeyup'  => 'limit_dig(this.id,4)',
				'maxlength'=> '4'

			);
			$this->data['expediente'] = array(
				'type'     => 'text',
				'name'     => 'expediente',
				'id'       => 'expediente',
				'value'    => $this->form_validation->set_value('expediente'),
				'class'    => 'form-control',
				'maxlength'=> '50'
			);
			$this->data['consultora'] = array(
				'type'     => 'text',
				'name'     => 'consultora',
				'id'       => 'consultora',
				'value'    => $this->form_validation->set_value('consultora'),
				'class'    => 'form-control',
				'maxlength'=> '50'
			);
			$this->data['descripcion'] = array(
				'type'     => 'text',
				'name'     => 'descripcion',
				'id'       => 'descripcion',
				'value'    => $this->form_validation->set_value('descripcion'),
				'class'    => 'form-control',
				'maxlength'=> '500'
			);
			$this->data['contratista'] = array(
				'type'     => 'text',
				'name'     => 'contratista',
				'id'       => 'contratista',
				'value'    => $this->form_validation->set_value('contratista'),
				'class'    => 'form-control',
				'maxlength'=> '50'
			);
			$this->data['presupuesto'] = array(
				'type'     => 'text',
				'name'     => 'presupuesto',
				'id'       => 'presupuesto',
				'value'    => $this->form_validation->set_value('presupuesto'),
				'class'    => 'form-control',
				'maxlength'=> '100'
			);
			
			$a_tipos_moneda[''] = 'Seleccione tipo de moneda';
			$r_tipos_moneda = $this->proyectos_model->dropdown_data('tipos_moneda')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
				foreach ($r_tipos_moneda as $d_tipo_moneda) {
			$a_tipos_moneda[$d_tipo_moneda['id_tipo_moneda']] = $d_tipo_moneda['id_tipo_moneda'] . ' - ' . $d_tipo_moneda['nombre'];
				}
			$this->data['tipos_moneda'] = $a_tipos_moneda;
				//$this->data['id_lineaproducto_sel'] = $this->form_validation->set_value('id_lineaproducto'),

			$this->data['fecha_orden_proceder'] = array(
				'type'     => 'text',
				'name'     => 'fecha_orden_proceder',
				'id'       => 'fecha_orden_proceder',
				'rows'     => '1',
				'value'    => $this->form_validation->set_value('fecha_orden_proceder'),
				'class'    => 'form-control',
				'maxlength'=> '255'
			);
			$this->data['plazo_ejecucion'] = array(
				'type'     => 'text',
				'name'     => 'plazo_ejecucion',
				'id'       => 'plazo_ejecucion',
				'value'    => $this->form_validation->set_value('plazo_ejecucion'),
				'class'    => 'form-control',
				'list'	   => 'id_proyecto_consultor_list',
				'maxlength'=> '10'
			);
			$this->data['plazo_ejecucion_catastral'] = array(
				'type'     => 'text',
				'name'     => 'plazo_ejecucion_catastral',
				'id'       => 'plazo_ejecucion_catastral',
				'value'    => $this->form_validation->set_value('plazo_ejecucion_catastral'),
				'class'    => 'form-control',
				'maxlength'=> '100'
			);
			$this->data['fecha_hora_insercion'] = array(
				'type'     => 'text',
				'name'     => 'fecha_hora_insercion',
				'id'       => 'fecha_hora_insercion',
				'rows'     => '1',
				'value'    => $this->form_validation->set_value('fecha_hora_insercion'),
				'class'    => 'form-control',
				'maxlength'=> '255'
			);
			$this->data['observaciones'] = array(
				'type'     => 'text',
				'name'     => 'observaciones',
				'id'       => 'observaciones',
				'value'    => $this->form_validation->set_value('observaciones'),
				'class'    => 'form-control textarea',
                'placeholder' => 'OBSERVACIONES:',
				'list'	   => 'id_proyecto_consultor_list',
				'maxlength'=> '500'
			);
			$this->data['usuario'] = array(
				'type'     => 'text',
				'name'     => 'usuario',
				'id'       => 'usuario',
				'value'    => $this->form_validation->set_value('usuario'),
				'class'    => 'form-control',
				'maxlength'=> '50'
			);
			$this->data['codigo_proyecto'] = array(
				'type'     => 'text',
				'name'     => 'codigo_proyecto',
				'id'       => 'codigo_proyecto',
				'value'    => $this->form_validation->set_value('codigo_proyecto'),
				'class'    => 'form-control',
				'maxlength'=> '50'
			);


			/* Load Template */
			$this->template->admin_render('proyectos/create_proyecto', $this->data);
		}
	}


	public function edit_proyecto($id_proyecto)
	{

		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin() OR ! $id_proyecto OR empty($id_proyecto))
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_proyectos_edit'), 'proyectos/edit');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Variables *///Trae de la base de datos la fila seleccionada
        $proyecto = $this->proyectos_model->view('proyectos', array('id_proyecto' => $id_proyecto))->row();

        $this->data['id_proyecto'] = $id_proyecto;

        /* Validate form input */

		$this->form_validation->set_rules('id_proyecto', 		'<b>Id proyecto</b>' , 		 'required');


		//Se produce cuando el usuario da click en el submit
        if (isset($_POST) && ! empty($_POST))
        {
        	if ($this->form_validation->run() == TRUE)
        	{
				if ($_POST['id_proyecto']){
					$arraycampos['id_proyecto'] 			= $_POST['id_proyecto'];
				}

				if ($_POST['nombre_sede']){
					$arraycampos['nombre_sede'] = $_POST['nombre_sede'];
				}
				if ($_POST['dpto']){
					$arraycampos['dpto'] = $_POST['dpto'];
				}
				if ($_POST['distrito']){
					$arraycampos['distrito'] = $_POST['distrito'];
				}
				if ($_POST['localidad']){
					$arraycampos['localidad'] = $_POST['localidad']; // Aquí va el lugar (barloc)
				}
				if ($_POST['gerente_sede']){
					$arraycampos['gerente_sede'] = $_POST['gerente_sede'];
				}

        		/* if ($_POST['numero_contrato']){
	        		$arraycampos['numero_contrato'] 		= $_POST['numero_contrato'];
	        	}

	        	if ($_POST['anyo_contrato']){
	        		$arraycampos['anyo_contrato'] 		= $_POST['anyo_contrato'];
	        	}

				if ($_POST['expediente']){
					$arraycampos['expediente'] 			= $_POST['expediente'];
				}

				if ($_POST['consultora']){
					$arraycampos['consultora'] 			= $_POST['consultora'];
				}

				if ($_POST['descripcion']){
					$arraycampos['descripcion'] 	= $_POST['descripcion'];
				}


				if ($_POST['contratista']){
					$arraycampos['contratista'] 	= $_POST['contratista'];
				}

				if ($_POST['presupuesto']){
					$arraycampos['presupuesto'] 	= $_POST['presupuesto'];

				}

				if ($_POST['tipo_moneda']){
					$arraycampos['tipo_moneda'] 		= strtoupper($_POST['tipo_moneda']);

				}

				if ($_POST['fecha_orden_proceder']){
					$arraycampos['fecha_orden_proceder'] 		= $_POST['fecha_orden_proceder'];
				}

				if ($_POST['plazo_ejecucion']){
					$arraycampos['plazo_ejecucion'] 		= $_POST['plazo_ejecucion'];
				}

				if ($_POST['plazo_ejecucion_catastral']){
					$arraycampos['plazo_ejecucion_catastral'] 			= strtoupper($_POST['plazo_ejecucion_catastral']);

				}

				if ($_POST['fecha_hora_insercion']){
					$arraycampos['fecha_hora_insercion'] 		= $_POST['fecha_hora_insercion'];
				} */

				if ($_POST['observaciones']){
					$arraycampos['observaciones'] 		= $_POST['observaciones'];
				}

				/* if ($_POST['usuario']){
					$arraycampos['usuario'] 			= strtoupper($_POST['usuario']);

				} */
				if ($_POST['codigo_proyecto']){
					$arraycampos['codigo_proyecto'] 			= strtoupper($_POST['codigo_proyecto']);

				}



				$accion = 0;
				if (isset($_POST['accion'])){
					$accion = intval($_POST['accion']);
				}else{
					$accion = 0;
				}



				$unique_exp = $this->proyectos_model->view('proyectos',array('id_proyecto' => $id_proyecto))->num_rows();
				
                /*
				if ($unique_exp > 0) {
					$this->session->set_flashdata('message', 'Ya existe un proyecto con = codigo + id_proyecto');
					redirect('proyectos/proyectos/edit_proyecto/'.$id_proyecto);
				}
				*/
						//echo $accion;
						//show_error(1);


				$actualizar_proyecto = $this->proyectos_model->actualizar_proyecto($id_proyecto,$arraycampos);

				///////////////////////////////////////////////////////////
				///////////////////// ACCIONES POST ///////////////////////
				///////////////////////////////////////////////////////////



        		//if ($resul)
        		if ($actualizar_proyecto)
        		{
					//una prueba de que trae los valores es reemplazando $this->lang->line('edit_geocolonia_saved') por $_POST('id') por ejemplo
        			$this->session->set_flashdata('message', $this->lang->line('proyectos_update_successful'));
					redirect('proyectos/proyectos/edit_proyecto/'.$id_proyecto);
				}
				else
				{
					$this->session->set_flashdata('message', $this->ion_auth->errors());
				}

				//aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
				//redirect('man_espacial/geocolonias/geocolonias', 'refresh');
			}
		}

		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
		//$this->data['geocolonia']   = $geocolonia;

		//$readonly = $this->config->item('admin_group', 'ion_auth') === $geocolonia->col_desc ? 'readonly' : '';

		//creando campos
		$this->data['nombre_sede'] = array(
			'type'  => 'text',
			'name'  => 'nombre_sede',
			'id'    => 'nombre_sede',
			'value' => $this->form_validation->set_value('nombre_sede', $proyecto->nombre_sede),
			'class' => 'form-control',
			'maxlength' => '255'
		);
		$this->data['gerente_sede'] = array(
			'type'  => 'text',
			'name'  => 'gerente_sede',
			'id'    => 'gerente_sede',
			'value' => $this->form_validation->set_value('gerente_sede', $proyecto->gerente_sede),
			'class' => 'form-control',
			'maxlength' => '255'
		);
		$this->data['id_proyecto'] = array(
			'type'     => 'number',
			'name'     => 'id_proyecto',
			'id'       => 'id_proyecto',
			'value'    => $this->form_validation->set_value('id_proyecto', $proyecto->id_proyecto),
			'class'    => 'form-control',
			'maxlength'=> '10',
			'readonly' => TRUE
		);

		$this->data['numero_contrato'] = array(
			'type'     => 'text',
			'name'     => 'numero_contrato',
			'id'       => 'numero_contrato',
			'value'    => $this->form_validation->set_value('numero_contrato', $proyecto->numero_contrato),
			'class'    => 'form-control',
			'maxlength'=> '4'
		);

		$this->data['anyo_contrato'] = array(
			'type'     => 'number',
			'name'     => 'anyo_contrato',
			'id'       => 'anyo_contrato',
			'value'    => $this->form_validation->set_value('anyo_contrato', $proyecto->anyo_contrato),
			'class'    => 'form-control',
			'onkeyup'  => 'limit_dig(this.id,4)',
			'maxlength'=> '4'
		);

		$this->data['expediente'] = array(
			'type'     => 'text',
			'name'     => 'expediente',
			'id'       => 'expediente',
			'value'    => $this->form_validation->set_value('expediente', $proyecto->expediente),
			'class'    => 'form-control',
			'maxlength'=> '20'
		);

		$this->data['consultora'] = array(
			'type'     => 'text',
			'name'     => 'consultora',
			'id'       => 'consultora',
			'value'    => $this->form_validation->set_value('consultora', $proyecto->consultora),
			'class'    => 'form-control',
			'maxlength'=> '50'
		);
		$this->data['descripcion'] = array(
			'type'     => 'text',
			'name'     => 'descripcion',
			'id'       => 'descripcion',
			'value'    => $this->form_validation->set_value('descripcion', $proyecto->descripcion),
			'class'    => 'form-control',
			'maxlength'=> '500'
		);

		$this->data['contratista'] = array(
			'type'     => 'text',
			'name'     => 'contratista',
			'id'       => 'contratista',
			'value'    => $this->form_validation->set_value('contratista', $proyecto->contratista),
			'class'    => 'form-control',
			'maxlength'=> '50'
		);

		$this->data['presupuesto'] = array(
			'type'     => 'text',
			'name'     => 'presupuesto',
			'id'       => 'presupuesto',
			'value'    => $this->form_validation->set_value('presupuesto', $proyecto->presupuesto),
			'class'    => 'form-control',
			'maxlength'=> '50'
		);

		/*
		$this->data['tipo_moneda'] = array(
			'type'     => 'text',
			'name'     => 'tipo_moneda',
			'id'       => 'tipo_moneda',
			'value'    => $this->form_validation->set_value('tipo_moneda', $proyecto->tipo_moneda),
			'class'    => 'form-control',
			'onkeyup'  => 'limit_dig(this.id,20)',
			'maxlength'=> '10'

		); */

		$a_monedas[''] = 'Seleccione tipo de moneda';
		$r_monedas = $this->proyectos_model->dropdown_data('tipos_moneda')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($r_monedas as $d_moneda) {
			$a_monedas[$d_moneda['id_tipo_moneda']] = $d_moneda['id_tipo_moneda'] . ' - ' . $d_moneda['nombre'];
		}
		$this->data['tipos_moneda'] = $a_monedas;
		$this->data['tipo_moneda_sel'] = $proyecto->tipo_moneda;

		$this->data['fecha_orden_proceder'] = array(
            'type'     => 'text',
            'name'     => 'fecha_orden_proceder',
            'id'       => 'fecha_orden_proceder',
            'value'    => $this->form_validation->set_value('fecha_orden_proceder', formato_fecha($proyecto->fecha_orden_proceder)),
            'class'    => 'form-control',
            'required' => 'true'
        );
		$this->data['plazo_ejecucion'] = array(
			'type'     => 'text',
			'name'     => 'plazo_ejecucion',
			'id'       => 'plazo_ejecucion',
			'value'    => $this->form_validation->set_value('plazo_ejecucion', $proyecto->plazo_ejecucion),
			'class'    => 'form-control',
			'maxlength'=> '10'
		);
		$this->data['plazo_ejecucion_catastral'] = array(
			'type'     => 'number',
			'name'     => 'plazo_ejecucion_catastral',
			'id'       => 'plazo_ejecucion_catastral',
			'value'    => $this->form_validation->set_value('plazo_ejecucion_catastral', $proyecto->plazo_ejecucion_catastral),
			'class'    => 'form-control',
			'maxlength'=> '20'
		);
		$this->data['fecha_hora_insercion'] = array(
            'type'     => 'text',
            'name'     => 'fecha_hora_insercion',
            'id'       => 'fecha_hora_insercion',
            'value'    => $this->form_validation->set_value('fecha_hora_insercion', formato_fecha($proyecto->fecha_hora_insercion)),
            'class'    => 'form-control',
            'required' => 'true'
            );
		$this->data['observaciones'] = array(
			'type'     => 'text',
			'name'     => 'observaciones',
			'id'       => 'observaciones',
            'placeholder' => 'OBSERVACIONES:',
			'value'    => $this->form_validation->set_value('observaciones', $proyecto->observaciones),
			'class'    => 'form-control textarea',
			'maxlength'=> '500'
		);
		$this->data['usuario'] = array(
			'type'     => 'text',
			'name'     => 'usuario',
			'id'       => 'usuario',
			'value'    => $this->form_validation->set_value('usuario', $proyecto->usuario),
			'class'    => 'form-control',
			'maxlength'=> '50'
		);
		$this->data['codigo_proyecto'] = array(
			'type'     => 'text',
			'name'     => 'codigo_proyecto',
			'id'       => 'codigo_proyecto',
			'value'    => $this->form_validation->set_value('codigo_proyecto', $proyecto->codigo_proyecto),
			'class'    => 'form-control',
			'maxlength'=> '50'
		);
		// --- DEPARTAMENTO ---
		$departamentos[''] = 'Seleccione el departamento';
		$departamento = $this->proyectos_model->dropdown_data('departamentos')->result_array();
		foreach ($departamento as $dep) {
			$departamentos[$dep['dpto']] = $dep['dpto'] . ' - ' . $dep['dpto_desc'];
		}
		$this->data['departamento'] = $departamentos;

		// --- DISTRITO ---
		$distritos = ['' => 'Seleccione el distrito'];

		// Solo si hay un departamento seleccionado
		if (!empty($proyecto->dpto)) {
			$distritos_result = $this->proyectos_model->dropdown_data('distritos', ['dpto' => $proyecto->dpto])->result_array();
			foreach ($distritos_result as $d) {
				$distritos[$d['distrito']] = $d['distrito'] . ' - ' . $d['dist_desc'];
			}
		}
		$this->data['distrito'] = $distritos;
		// --- LUGAR ---
		$lugares = $this->proyectos_model->dropdown_data('barloc')->result_array();
		$a_lugares = ['' => 'Seleccione lugar'];
		foreach ($lugares as $l) {
			if (isset($l['id']) && isset($l['barlo_desc'])) {
				$a_lugares[$l['id']] = $l['barlo_desc'];
			}
		}
		$this->data['lugar'] = $a_lugares;

		// --- VALORES SELECCIONADOS (rellenalos desde tu base de datos del proyecto actual) ---
		$this->data['departamento_sel'] = isset($proyecto->dpto) ? $proyecto->dpto : '';
		$this->data['distrito_sel']     = isset($proyecto->distrito) ? $proyecto->distrito : '';
		$this->data['lugar_sel']        = isset($proyecto->localidad) ? $proyecto->localidad : '';



		/* Load Template */

		$this->template->admin_render('proyectos/edit_proyecto', $this->data);
	}

	public function tiene_salida()
	{
		$id_proyecto = $_POST['id_proyecto'];

		$expe = $this->proyectos_model->view('exp', array('id_proyecto' => $id_proyecto, 'expe_estado' => 'P'))->row();

		if ($expe) {
			echo 'SI';
		}else{
			echo 'NO';
		}
	}

	public function existe_grafico()
	{
		$id_proyecto 	= $_POST['id_proyecto'];
		$gestion 		= $_POST['gestion'];

		$expe = $this->proyectos_model->existe_grafico($id_proyecto, $gestion)->row()->f_existe_grafico;

		echo $expe;
	}


	public function existe_grafico_id_proyecto()
	{
		$id_proyecto 	= $_POST['id_proyecto'];

		$expe = $this->proyectos_model->existe_grafico_id_proyecto($id_proyecto)->row()->f_existe_grafico_id_proyecto;

		echo $expe;
	}


	public function existe_exp()
	{
		$exp 		= $_POST['exp'];
		$gestion 	= $_POST['gest'];

		$expe = $this->proyectos_model->dropdown_data('exp', array('id_proyecto_proyecto' => $exp, 'expe_gestion' => $gestion))->num_rows();

		if ($expe > 0) {
			echo 'SI';
		}else{
			echo 'NO';
		}
	}

	public function existe_exp_uk()
	{




		$codigo 		= $_POST['codigo'];
		$id_proyecto 	= $_POST['id_proyecto'];

		$expe = $this->proyectos_model->dropdown_data('proyectos', array('codigo' => $codigo,
			                                                          'id_proyecto' => $id_proyecto
			                                                          ))->num_rows();

		if ($expe > 0) {
			echo 'SI';
		}else{
			echo 'NO';
		}
	}


	public function reingreso_exp()
	{
		$exp 	= $_POST['exp'];
		$gest 	= $_POST['gest'];

		$id_proyecto = $this->proyectos_model->dropdown_data('exp', array('id_proyecto_proyecto' => $exp, 'expe_gestion' => $gest))->row()->id_proyecto;

		echo $id_proyecto;

		//$reingreso  = $this->proyectos_model->actualizar_proyecto($id_proyecto, array('id_proyecto_proyecto_ref' => $exp, 'id_proyecto' => ));


		//redirect('proyectos/proyectos/edit_proyecto/'.$id_proyecto);
	}

	public function dar_salida_expe($id_proyecto, $id_proyecto_proyecto, $expe_gestion, $expe_provdg = NULL)
	{

		$i_exp 		= $id_proyecto_proyecto;
		$i_gest 	= $expe_gestion;


					$i_user = $this->session->userdata('username');
					//echo $i_user;
					//show_error(1);



		if (!is_null($i_exp) AND $i_gest > 0) {
			if (grupo_usuario(18)) {


				//if ($expe_provdg == NULL) {
				if (is_null($expe_provdg)) {
					$provdg = 0;
				}else{
					$provdg = $expe_provdg;
				}

				if ($provdg == 0) {
					$i_max = $this->proyectos_model->campo_valor_maximo('exp', 'expe_provdg' , array('expe_director' => $i_user ));

					$i_max = $i_max+1;

					$str 	= date_default_timezone_get();
					$fecha  = date("d/m/Y", strtotime($str));

					$salida = $this->proyectos_model->actualizar_proyecto($id_proyecto, array('expe_provdg'   => $i_max,
																					 		  'expe_director' => $this->session->userdata('username'),
																					 		  'expe_salida'   => $fecha,
																					 		  'expe_estado'   => 'P'));
					if ($salida) {
						$this->session->set_flashdata('message', '¡Se DIÓ SALIDA exitósamente!');
						redirect('proyectos/proyectos/edit_proyecto/'.$id_proyecto);
					}else{
						$this->session->set_flashdata('message', '¡No se pudo DAR SALIDA!');
						redirect('proyectos/proyectos/edit_proyecto/'.$id_proyecto);
					}
				}else{
					$this->session->set_flashdata('message', '¡Campo PROV. DG sin dato!');
					redirect('proyectos/proyectos/edit_proyecto/'.$id_proyecto);
				}
			}else{
				$this->session->set_flashdata('message', 'NO TIENE PRIVILEGIOS PARA ESTA ACCIÓN');
				redirect('proyectos/proyectos/edit_proyecto/'.$id_proyecto);
			}
		}else{
			redirect('proyectos/proyectos/edit_proyecto/'.$id_proyecto);
		}
	}

	public function anular_salida_expe($id_proyecto)
	{

		//echo($id_proyecto);
		$expe = $this->proyectos_model->dropdown_data('exp', array('id_proyecto' => $id_proyecto))->result();


		//echo '<option value="">Seleccione el distrito</option>';

		foreach ($expe as $value) {
			$i_exp 		 = $value->id_proyecto_proyecto;
			$i_gest 	 = $value->expe_gestion;
			$i_provdg = $value->expe_provdg;
		}

		if (!is_null($i_exp) AND $i_gest > 0) {
			if (grupo_usuario(18)) {

				if ($i_provdg == NULL) {
					$provdg = 0;
				}else{
					$provdg = $i_provdg;
				}

				if ($provdg != 0) {

					$salida = $this->proyectos_model->actualizar_proyecto($id_proyecto, array('expe_provdg'   => NULL,
																					 		  'expe_director' => '',
																					 		  'expe_salida'   => NULL,
																					 		  'expe_estado'   => 'A'));
					if ($salida) {
						$this->session->set_flashdata('message', '¡Se ANULÓ LA SALIDA exitósamente!');
						redirect('proyectos/proyectos/edit_proyecto/'.$id_proyecto);
					}else{
						$this->session->set_flashdata('message', '¡No se pudo ANULAR SALIDA!');
						//redirect('proyectos/proyectos/edit_proyecto/'.$id_proyecto);
						redirect('proyectos/proyectos/index/');
					}
				}
			}else{
				$this->session->set_flashdata('message', 'NO TIENE PRIVILEGIOS PARA ESTA ACCIÓN');
				//redirect('proyectos/proyectos/index/'.$id_proyecto);
				redirect('proyectos/proyectos/index/');
			}
		}else{
			//redirect('proyectos/proyectos/index/'.$id_proyecto);
			redirect('proyectos/proyectos/index/');
		}
	}


	public function call_bat()
	{
		$cmd = system('cmd /c C:/espacio_trabajo/importar_shape_ide.bat');
	}


	public function trae_distritos()
	{
		$departamento = $this->input->post('departamento');

		$distritos = $this->expedientes_model->dropdown_data('distritos', ['id_departamento' => $departamento], 'id_distrito')->result();

		echo '<option value="">Seleccione el distrito</option>';
		foreach ($distritos as $d) {
			echo '<option value="' . $d->id_distrito . '">' . $d->nombre . '</option>';
		}
	}

	public function trae_lugares()
	{
		$distrito = $this->input->post('distrito');

		if (!$distrito) {
			echo '<option value="">Seleccione el lugar</option>';
			return;
		}

		// Trae todos los lugares (barrios/localidades) del distrito
		$lugares = $this->proyectos_model->dropdown_data('barloc', ['distrito' => $distrito])->result();

		echo '<option value="">Seleccione el lugar</option>';
		foreach ($lugares as $lugar) {
			echo '<option value="' . $lugar->id . '">' . $lugar->barlo_desc . '</option>';
		}
	}


	public function trae_expe_ref()
	{
		$expe 	   = $_POST['id_proyecto_proyecto_ref'];

		$expes = $this->proyectos_model->dropdown_data('exp',array('id_proyecto_proyecto_ref' => $expe), 'id_proyecto')->result();

		echo '<option value="">Seleccione Expediente</option>';
		foreach ($expes as $value) {

			$expes[$ex['id_proyecto']] = $ex['id_proyecto_proyecto'].'-'.$ex['expe_gestion'].'-'.$ex['id_proyecto_dependencia'].'-'.$ex['expe_secuencia'];

			echo '<option value="' . $value->id_proyecto . '">' . $value->id_proyecto_proyecto . '-' . $value->expe_gestion . '-' . $value->id_proyecto_dependencia . '-' . $value->expe_secuencia .  '</option>';
		}

		//echo json_encode($distritos);
	}

	public function eliminar_proyecto()
	{
		$id_proyecto= $_POST['id_proyecto'];

		$resultado  = $this->proyectos_model->eliminar_proyecto($id_proyecto);

		/*
		if ($resultado > 0) {
			$this->session->set_flashdata('message', '¡El proyecto con ID= <b>'.$id_proyecto.'</b> tiene expedientes NO SE PUEDE ELIMINAR!!!');
			redirect('proyectos/proyectos/index');
		} else {
			$this->session->set_flashdata('message', '¡El proyecto con ID= <b>'.$id_proyecto.'</b> se eliminó correctamente!');
			redirect('proyectos/proyectos/index');
		}
		*/
		echo $resultado;
	}

//		public function verproyecto_id_proyecto ($id_proyecto ) {
//
//        	$i_jameuge = "http://10.68.8.52:8065/jmap/index.html?id_proyecto=" . $id_proyecto;
//
//			redirect($i_jameuge);
//	}

}
