<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Chart extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->database(); // <--- esto asegura que $this->db esté disponible
        $this->load->model('Chart_model');
        header('Content-Type: application/json'); // Respuesta como JSON
    }

    public function expedientes_por_estado()
    {
        $data = $this->Chart_model->contar_por_estado_agrupado();
        // Reemplazar null por 'Sin clasificar'
        foreach ($data as &$item) {
            if (is_null($item->estado_agrupado)) {
                $item->estado_agrupado = 'Sin clasificar';
            }
        }
        echo json_encode($data);
    }
}
