<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class educacion extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('censo/censo_model');
		$this->lang->load('censo/censo_lang');

		/* Title Page :: Common */
		$this->page_title->push(lang('menu_dgsa_censo'));
		$this->data['pagetitle'] = $this->page_title->show();

		$_SESSION['id_modulo_ant'] = $_SESSION['id_modulo'];

		$_SESSION['url_anterior'] = 'http://jaimito.site/sge/index.php/censo/censo/index';

		
		if ($_SESSION['id_modulo'] != 'educacion') {
			//show_error($_SESSION['id_modulo']);
			if ($_SESSION['id_modulo'] != 'educacion') {
				
				$_SESSION['arraywhere_educacion'] = NULL;
				$_SESSION['arraywhere_educacion_busq'] = NULL;	
			}
			
			$_SESSION['id_modulo'] = 'educacion';

			$_SESSION['errores_censo'] = NULL;
			is_array($_SESSION['errores_censo']);
		}

		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_censos'), 'censo/censo/index');
	}

	public function educacion_index()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}
		$_SESSION['url_sub_anterior'] = 'http://jaimito.site/sge/index.php/censo/educacion/educacion_index';
		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('educacion_titulo'), 'censo/ubi_geo/index');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		$this->data['educacion'] = $this->censo_model->viewlist_abm('educacion', $_SESSION['identificador'])->result();

		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('//message')));

		/* Load Template */
		$this->template->admin_render('censo/educacion_index', $this->data);
	}

	public function educacion_create()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(3, lang('educacion_tiutlo'), 'educacion/create_educacion');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		$max   = $this->censo_model->valor_maximo('educacion', 'occ', array('level_1_id' => $_SESSION['identificador']))->row()->max;
		$max   = $max + 1;
		$educacion = $this->censo_model->view('educacion', array('level_1_id' => $_SESSION['identificador']))->row();

		/* Validate form input */
		$this->form_validation->set_rules('educacion', 'lang:educacion_occ' , 'required');
		//$this->form_validation->set_rules('p01_b','lang:geocolonia_col_desc', 'required');

		//if ($this->form_validation->run() == TRUE)
		if ($_POST)
		{

			$arraycamposinsert['level_1_id']  = (string)$_SESSION['identificador'];
			$arraycamposinsert['educacion_id']  = (string)$_SESSION['identificador'];

			$arraycamposinsert['occ']         		= $max;
		
			if ($_POST['n_de_miembro2']) {
				$arraycamposinsert['n_de_miembro2']         	= $_POST['n_de_miembro2'];
			}

			if ($_POST['dgsa_educacion_nivel_academico']) 
			{
				$arraycamposinsert['nivel_academico']        				= $_POST['dgsa_educacion_nivel_academico'];
				if (trim($_POST['dgsa_educacion_nivel_academico']) == '') {
					$arraycamposinsert['nivel_academico']   = NULL;
				} else {
					$arraycamposinsert['nivel_academico']   = (int)$_POST['dgsa_educacion_nivel_academico'];
				}				
			}

			if ($_POST['ultimo_grado_aprobado']) {
				$arraycamposinsert['ultimo_grado_aprobado']         	= $_POST['ultimo_grado_aprobado'];
			}

			if ($_POST['nombre_de_inst_educ']) {
				$arraycamposinsert['nombre_de_inst_educ']         	= $_POST['nombre_de_inst_educ'];
			}

			if ($_POST['dgsa_educacion_priv_pu']) 
			{
				$arraycamposinsert['priv_pu']        				= $_POST['dgsa_educacion_priv_pu'];
				if (trim($_POST['dgsa_educacion_priv_pu']) == '') {
					$arraycamposinsert['priv_pu']   = NULL;
				} else {
					$arraycamposinsert['priv_pu']   = (int)$_POST['dgsa_educacion_priv_pu'];
				}				
			}

			if ($_POST['ciudad1']) {
				$arraycamposinsert['ciudad1']     		= $_POST['ciudad1'];
			}

			if ($_POST['horario1']) {
				$arraycamposinsert['horario1']         	= $_POST['horario1'];
			}

			if ($_POST['dgsa_educacion_distancia_recorrida3']) 
			{
				$arraycamposinsert['distancia_recorrida3']        				= $_POST['dgsa_educacion_distancia_recorrida3'];
				if (trim($_POST['dgsa_educacion_distancia_recorrida3']) == '') {
					$arraycamposinsert['distancia_recorrida3']   = NULL;
				} else {
					$arraycamposinsert['distancia_recorrida3']   = (int)$_POST['dgsa_educacion_distancia_recorrida3'];
				}				
			}

			if ($_POST['dificultades_escolares']) {
				$arraycamposinsert['dificultades_escolares']     		= $_POST['dificultades_escolares'];
			}


			$create_educacion = $this->censo_model->crear_registro('educacion', $arraycamposinsert);

			/*
			$str = date_default_timezone_get();
			$fecha_procesado_4 = date("d/m/Y", strtotime($str));
			$arraycampos3 = array('proceso' 		   => 'A03'
				//,'mapear' 			   => $reg02->mapear
				,'procesado_4'		   => 1
				,'fecha_procesado_4'	   => $fecha_procesado_4
					
			);
			*/					
			/*****************************************************************/
			
			redirect('censo/educacion/educacion_index');
		}
		else
		{
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
/* 
educacion_id
level_1_id
occ
n_de_miembro2
nivel_academico
ultimo_grado_aprobado
nombre_de_inst_educ
priv_pu
ciudad1
horario1
distancia_recorrida3
dificultades_escolares
*/	
			$this->data['educacion_id'] = array(
				'name'  => 'educacion_id',
				'id'    => 'educacion_id',
				'type'  => 'text',
				'class' => 'form-control',
				//'value' => $this->form_validation->set_value('educacion_id'),
				'value'   => $this->form_validation->set_value('educacion_id', trim($_SESSION['identificador'])),
				'maxlength' => 15,
				'readonly' => 'true'
				);
			$this->data['level_1_id'] = array(
				'name'  => 'level_1_id',
				'id'    => 'level_1_id',
				'type'  => 'text',
				'class' => 'form-control',
				//'value' => $this->form_validation->set_value('level_1_id'),
				'value'   => $this->form_validation->set_value('level_1_id', trim($_SESSION['identificador'])),
				'maxlength' => 15,
				'readonly' => 'true'
				);
			$this->data['occ'] = array(
				'name'  => 'occ',
				'id'    => 'occ',
				'type'  => 'text',
				'class' => 'form-control',
				//'value' => $this->form_validation->set_value('occ'),
				'value'   => $this->form_validation->set_value('occ', trim($max)), 			
				'maxlength' => 20,
				'readonly' => 'true'
				);
			$this->data['n_de_miembro2'] = array(
				'name'  => 'n_de_miembro2',
				'id'    => 'n_de_miembro2',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('n_de_miembro2'),
				'maxlength' => 20
				);
/*
			$this->data['nivel_academico'] = array(
				'name'  => 'nivel_academico',
				'id'    => 'nivel_academico',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('nivel_academico'),
				'maxlength' => 7
				);
*/
			$this->data['ultimo_grado_aprobado'] = array(
				'name'  => 'ultimo_grado_aprobado',
				'id'    => 'ultimo_grado_aprobado',
				'type'  => 'number',
				'max'   => 110,
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('ultimo_grado_aprobado'),
				'maxlength' => 3
				);
			$this->data['nombre_de_inst_educ'] = array(
				'name'  => 'nombre_de_inst_educ',
				'id'    => 'nombre_de_inst_educ',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('nombre_de_inst_educ'),
				'maxlength' => 20
				);
			$this->data['priv_pu'] = array(
				'name'  => 'priv_pu',
				'id'    => 'priv_pu',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('priv_pu'),
				'maxlength' => 20
				);
			$this->data['ciudad1'] = array(
				'name'  => 'ciudad1',
				'id'    => 'ciudad1',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('ciudad1'),
				'maxlength' => 20
				);
			$this->data['nombre_de_inst_educ'] = array(
				'name'  => 'nombre_de_inst_educ',
				'id'    => 'nombre_de_inst_educ',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('nombre_de_inst_educ'),
				'maxlength' => 20
				);
/*
			$this->data['priv_pu'] = array(
				'name'  => 'priv_pu',
				'id'    => 'priv_pu',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('priv_pu'),
				'maxlength' => 20
				);
*/
			$this->data['ciudad1'] = array(
				'name'  => 'ciudad1',
				'id'    => 'ciudad1',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('ciudad1'),
				'maxlength' => 20
				);
            $this->data['horario1'] = array(
                'name'  => 'horario1',
                'id'    => 'horario1',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('horario1'),
                'maxlength' => 20
                );
/*
            $this->data['distancia_recorrida3'] = array(
                'name'  => 'distancia_recorrida3',
                'id'    => 'distancia_recorrida3',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('distancia_recorrida3'),
                'maxlength' => 20
                );
*/
            $this->data['dificultades_escolares'] = array(
                'name'  => 'dificultades_escolares',
                'id'    => 'dificultades_escolares',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('dificultades_escolares'),
                'maxlength' => 20
                );

				$nivel_academico = $this->censo_model->concepto('NIVEL_ACADEMICO',true,'concepto')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
				foreach ($nivel_academico as $af) 
				{
					$nivel_academicos[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
				}
				$this->data['nivel_academico'] = $nivel_academicos;
		
				if (ctype_space($educacion->nivel_academico)) {
					$this->data['nivel_academico_sel'] = '  ';
				}else{
					$this->data['nivel_academico_sel'] = (int)$educacion->nivel_academico;
				}

				$priv_pu = $this->censo_model->concepto('PRIV_PU',true,'concepto')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
				foreach ($priv_pu as $af) 
				{
					$priv_pus[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
				}
				$this->data['priv_pu'] = $priv_pus;
		
				if (ctype_space($educacion->priv_pu)) {
					$this->data['priv_pu_sel'] = '  ';
				}else{
					$this->data['priv_pu_sel'] = (int)$educacion->priv_pu;
				}

				$distancia_recorrida3 = $this->censo_model->concepto('DISTANCIA_RECORRIDA3',true,'concepto')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
				foreach ($distancia_recorrida3 as $af) 
				{
					$distancia_recorrida3s[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
				}
				$this->data['distancia_recorrida3'] = $distancia_recorrida3s;
		
				if (ctype_space($educacion->distancia_recorrida3)) {
					$this->data['distancia_recorrida3_sel'] = '  ';
				}else{
					$this->data['distancia_recorrida3_sel'] = (int)$educacion->distancia_recorrida3;
				}

                /*
			/*
			$p02_filtro = $this->reg01_model->concepto('P02_FILTRO',false,'CONCEPTO')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($p02_filtro as $p02f) {
				$p02_fs[$p02f['concepto']] = $p02f['concepto'].' - '.$p02f['nombre'];
			}
			$this->data['p02_filtro'] = $p02_fs;
			*/

			/* Load Template */
			$this->template->admin_render('censo/educacion_create', $this->data);
		}
	}

	public function educacion_edit($level_1_id, $modo_censo)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}
		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('educacion_level_1_id'), 'censo/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		$_SESSION['identificador'] = $level_1_id;
		$educacion = $this->censo_model->view('educacion', array('level_1_id' => $_SESSION['identificador']))->row();

			//declara el indice del array si es que no existe
		if (is_array($_SESSION['errores_censo']) && !array_key_exists('educacion_level_1_id' , $_SESSION['errores_censo'])) {
			$_SESSION['errores_censo']['educacion_level_1_id'] = NULL;     
		}

		/**** BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/
		//función para validar pestaña
		//$this->censo_model->validar_pestanha($_SESSION['identificador'], '3');
		//$this->censo_model->validar_pestanha($_SESSION['identificador'], '6');

		//obtiene los errores de la tabla
		$errores = $this->censo_model->obtener_errores($_SESSION['identificador'], '3')->result_array();

		foreach ($errores as $value) {

			$concepto = $this->censo_model->concepto('CENSO_ERRORES', false, 'CONCEPTO', $value['error'])->result_array();

			if (isset($concepto[0])) {
				$error[$value['error']] = $concepto[0]['descripcion'];
			}
		}

		if (isset($error)) {
			$_SESSION['errores_censo']['educacion_level_1_id'] = $error;
		}else{
			$_SESSION['errores_censo']['educacion_level_1_id'] = NULL;
		}
		/**** FIN BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/

    /* 
educacion_id
level_1_id
occ
n_de_miembro2
nivel_academico
ultimo_grado_aprobado
nombre_de_inst_educ
priv_pu
ciudad1
horario1
distancia_recorrida3
dificultades_escolares
    */

		if ($_POST) {

			/*
			if ($_POST['educacion_id']) 
			{
				$arraycampos['educacion_id']                       = $_POST['educacion_id'];
			}

			if ($_POST['level_1_id'])
			{
				$arraycampos['level_1_id']   					= $_POST['level_1_id'];
			}

			if ($_POST['occ']) 
			{
				$arraycampos['occ']             				            = $_POST['occ'];
			}
			*/

			if ($_POST['n_de_miembro2']) 
			{
				$arraycampos['n_de_miembro2']        			            = $_POST['n_de_miembro2'];
			}

			if ($_POST['dgsa_educacion_nivel_academico']) 
			{
				$arraycampos['nivel_academico']        				= $_POST['dgsa_educacion_nivel_academico'];
				if (trim($_POST['dgsa_educacion_nivel_academico']) == '') {
					$arraycampos['nivel_academico']   = NULL;
				} else {
					$arraycampos['nivel_academico']   = (int)$_POST['dgsa_educacion_nivel_academico'];
				}				
			}

			if ($_POST['ultimo_grado_aprobado']) 
			{
				$arraycampos['ultimo_grado_aprobado']        				= $_POST['ultimo_grado_aprobado'];
			}

			if ($_POST['nombre_de_inst_educ']) 
			{
				$arraycampos['nombre_de_inst_educ']        				    = $_POST['nombre_de_inst_educ'];
			}

			if ($_POST['dgsa_educacion_priv_pu']) 
			{
				$arraycampos['priv_pu']        				= $_POST['dgsa_educacion_priv_pu'];
				if (trim($_POST['dgsa_educacion_priv_pu']) == '') {
					$arraycampos['priv_pu']   = NULL;
				} else {
					$arraycampos['priv_pu']   = (int)$_POST['dgsa_educacion_priv_pu'];
				}				
			}

			if ($_POST['ciudad1']) 
			{
				$arraycampos['ciudad1']    					                = $_POST['ciudad1'];
			}

			if ($_POST['horario1']) 
			{
				$arraycampos['horario1']        				            = $_POST['horario1'];
			}

			if ($_POST['dgsa_educacion_distancia_recorrida3']) 
			{
				$arraycampos['distancia_recorrida3']        				= $_POST['dgsa_educacion_distancia_recorrida3'];
				if (trim($_POST['dgsa_educacion_distancia_recorrida3']) == '') {
					$arraycampos['distancia_recorrida3']   = NULL;
				} else {
					$arraycampos['distancia_recorrida3']   = (int)$_POST['dgsa_educacion_distancia_recorrida3'];
				}				
			}

			if ($_POST['dificultades_escolares']) 
			{
				$arraycampos['dificultades_escolares']    					= $_POST['dificultades_escolares'];
			}


			$update_reg = $this->censo_model->actualizar_censo(array('level_1_id' => $_SESSION['identificador'],'occ' => $educacion->occ), 'educacion', $arraycampos);

			
			//obtiene los errores de la tabla
			$errores = $this->censo_model->obtener_errores($_SESSION['identificador'], '3')->result_array();

			foreach ($errores as $value) {

				$concepto = $this->censo_model->concepto('CENSO_ERRORES', false, 'CONCEPTO', $value['error'])->result_array();

				if (isset($concepto[0])) {
					$error[$value['error']] = $concepto[0]['descripcion'];
				}
			}

			$_SESSION['errores_censo']['educacion'] = $error;
			/**** FIN BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/

			/*****************************************************************/
			if ($update_reg)
			{
				$this->session->set_flashdata('message', $this->lang->line('edit_in_temp_saved'));
			}else{
				$this->session->set_flashdata('message', $this->ion_auth->errors());
			}

			redirect('censo/educacion/educacion_edit/'.$level_1_id.'/E');
		}


		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
/* 
educacion_id
level_1_id
occ
n_de_miembro2
nivel_academico
ultimo_grado_aprobado
nombre_de_inst_educ
priv_pu
ciudad1
horario1
distancia_recorrida3
dificultades_escolares
*/

		$this->data['educacion_id'] = array(
			'type'    => 'text',
			'name'    => 'educacion_id',
			'id'      => 'educacion_id',
			'value'   => $this->form_validation->set_value('educacion_educacion_id', trim($educacion->educacion_id)),
			'class'   => 'form-control',	
			'readonly' => 'true'		
			);
		$this->data['level_1_id'] = array(
			'type'  => 'text',
			'name'  => 'level_1_id',
			'id'    => 'level_1_id',
			'value' => $this->form_validation->set_value('educacion_level_1_id', trim($educacion->level_1_id)),
			'class' => 'form-control',
			'readonly' => 'true'
			);
		$this->data['occ'] = array(
			'type'  => 'text',
			'name'  => 'occ',
			'id'    => 'occ',
			'value' => $this->form_validation->set_value('educacion_occ', trim($educacion->occ)),
			'class' => 'form-control',
			'readonly' => 'true'
			);
		$this->data['n_de_miembro2'] = array(
			'type'  => 'text',
			'name'  => 'n_de_miembro2',
			'id'    => 'n_de_miembro2',
			'value' => $this->form_validation->set_value('educacion_n_de_miembro2', trim($educacion->n_de_miembro2)),
			'class' => 'form-control',
            'maxlength'=> '2'
		);
/*
		$this->data['nivel_academico'] = array(
			'type'  => 'text',
			'name'  => 'nivel_academico',
			'id'    => 'nivel_academico',
			'value' => $this->form_validation->set_value('educacion_nivel_academico', trim($educacion->nivel_academico)),
			'class' => 'form-control'
		);
*/
		$this->data['nombre_de_inst_educ'] = array(
			'type'  => 'text',
			'name'  => 'nombre_de_inst_educ',
			'id'    => 'nombre_de_inst_educ',
			'value' => $this->form_validation->set_value('educacion_nombre_de_inst_educ', trim($educacion->nombre_de_inst_educ)),
			'class' => 'form-control',
            'maxlength'=> '30'
		);
/*
		$this->data['priv_pu'] = array(
			'type'  => 'text',
			'name'  => 'priv_pu',
			'id'    => 'priv_pu',
			'value' => $this->form_validation->set_value('educacion_priv_pu', trim($educacion->priv_pu)),
			'class' => 'form-control'
		);
*/
		$this->data['ciudad1'] = array(
			'type'  => 'text',
			'name'  => 'ciudad1',
			'id'    => 'ciudad1',
			'value' => $this->form_validation->set_value('educacion_ciudad1', trim($educacion->ciudad1)),
			'class' => 'form-control',
            'maxlength'=> '15'
		);
		$this->data['horario1'] = array(
			'type'  => 'text',
			'name'  => 'horario1',
			'id'    => 'horario1',
			'value' => $this->form_validation->set_value('educacion_horario1', trim($educacion->horario1)),
			'class' => 'form-control',
            'maxlength'=> '10'
		);
/*
		$this->data['distancia_recorrida3'] = array(
			'type'  => 'text',
			'name'  => 'distancia_recorrida3',
			'id'    => 'distancia_recorrida3',
			'value' => $this->form_validation->set_value('educacion_distancia_recorrida3', trim($educacion->distancia_recorrida3)),
			'class' => 'form-control'
		);
*/
		$this->data['dificultades_escolares'] = array(
			'type'  => 'text',
			'name'  => 'dificultades_escolares',
			'id'    => 'dificultades_escolares',
			'value' => $this->form_validation->set_value('educacion_dificultades_escolares', trim($educacion->dificultades_escolares)),
			'class' => 'form-control',
            'maxlength'=> '1'
		);

		$nivel_academico = $this->censo_model->concepto('NIVEL_ACADEMICO',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($nivel_academico as $af) 
		{
			$nivel_academicos[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
		}
		$this->data['nivel_academico'] = $nivel_academicos;

		if (ctype_space($educacion->nivel_academico)) {
			$this->data['nivel_academico_sel'] = '  ';
		}else{
			$this->data['nivel_academico_sel'] = (int)$educacion->nivel_academico;
		}

		$priv_pu = $this->censo_model->concepto('PRIV_PU',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($priv_pu as $af) 
		{
			$priv_pus[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
		}
		$this->data['priv_pu'] = $priv_pus;

		if (ctype_space($educacion->priv_pu)) {
			$this->data['priv_pu_sel'] = '  ';
		}else{
			$this->data['priv_pu_sel'] = (int)$educacion->priv_pu;
		}

		$distancia_recorrida3 = $this->censo_model->concepto('NIVEL_ACADEMICO',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($distancia_recorrida3 as $af) 
		{
			$distancia_recorrida3s[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
		}
		$this->data['distancia_recorrida3'] = $distancia_recorrida3s;

		if (ctype_space($educacion->distancia_recorrida3)) {
			$this->data['distancia_recorrida3_sel'] = '  ';
		}else{
			$this->data['distancia_recorrida3_sel'] = (int)$educacion->distancia_recorrida3;
		}

		/* Load Template */
		$this->template->admin_render('censo/educacion', $this->data);
	}

}
//Llave de finalizacion de la clase