<?php
  defined('BASEPATH') or exit('No direct script access allowed');
  
  ?>
<div class="content-wrapper">
  <section class="content-header">
    <?php echo $pagetitle; ?>
    <?php echo $breadcrumb; ?>
  </section>
  <section class="content">
    <div class="row">
      <?php
        if ($message) {
            echo '<pre>';
            echo '<h4><b>Mensaje:</b></h4>';
            echo '<h5>' . $message . '</h5>';
            echo '</pre>';
        }
        ?>
    </div>
    <div class="row">
      <div class="col-md-12">
        <div class="box">
          <!-- Primer bloque -->
          <div class="box-body">
            <?php echo form_open(current_url(), array('class' => 'form-horizontal', 'id' => 'form-edit_expe'));?>
            <div class="panel panel-default">
              <div class="panel-body">
                <div class="text-center">
                  <h4>CARGA DE DATOS GENERALES POR EXPEDIENTE</h4>
                </div>
                <br>
                <div class="col-sm-6">
                  <table class="tablaCentrada tablaD" border="1px solid rgb(0, 0, 0)" style="width: 100%;">
                    <thead>
                      <tr class="colorMOPC">
                        <td colspan="2">CARACTERISTICAS DEL EXPEDIENTE</td>
                      </tr>
                    </thead>
                    <tbody>
                      <tr>
                        <td><label class="control-label" for="fecha_ingreso">Fecha de ingreso:</label></td>
                        <td>
                          <div class="input-group date" data-provide="datepicker" data-date-format="dd/mm/yyyy">
                            <?php echo form_input($fecha_ingreso);?>
                            <div class="input-group-addon">
                              <i class="fa fa-calendar"></i>
                            </div>
                          </div>
                        </td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="codigo"><?php echo lang('expedientes_codigo'); ?></label></td>
                        <td><?php echo form_input($codigo); ?></td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="notificacion">N° Notificación:</label></td>
                        <td><?php echo form_input($notificacion); ?></td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="codigo_meu">Código MEU:</label></td>
                        <td><?php echo form_input($codigo_meu); ?></td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="daj_fecha_meu">Fecha MEU:</label></td>
                        <td>
                          <div class="input-group date" data-provide="datepicker" data-date-format="dd/mm/yyyy">
                            <?php echo form_input($daj_fecha_meu);?>
                            <div class="input-group-addon">
                              <i class="fa fa-calendar"></i>
                            </div>
                          </div>
                        </td>
                      </tr>
                    </tbody>
                  </table>
                  <br>
                  <table class="tablaCentrada tablaD" border="1px solid rgb(0, 0, 0)" style="width: 100%;">
                    <thead>
                      <tr class="colorMOPC">
                        <td colspan="2">CARACTERISTICAS DE LA AFECTACIÓN</td>
                      </tr>
                    </thead>
                    <tbody>
                      <tr>
                        <td><label class="control-label" for="id_tipo_afectacion">Tipo de afectación:</label></td>
                        <td>
                          <?php $attribute = 'class="form-control selectpicker" data-live-search="true" title="Departamento" id="id_tipo_afectacion" required="required"';
                            echo form_dropdown('id_tipo_afectacion', $tipo_afectacion, '', $attribute); ?>
                        </td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="id_proyecto">Proyecto:</label></td>
                        <td><?php $attribute = 'class="form-control selectpicker" title="Proyecto" id="id_proyecto" required="required"';
                          echo form_dropdown('id_proyecto', $proyecto, '', $attribute); ?></td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="id_tramo">Tramo:</label></td>
                        <td><?php $attribute = 'class="form-control selectpicker" data-live-search="true" title="Tramo" id="id_tramo" required="required"';
                          echo form_dropdown('id_tramo', $tramo, '', $attribute); ?></td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="id_subtramo">Subtramo:</label></td>
                        <td><?php $attribute = 'class="form-control selectpicker" data-live-search="true" title="Subtramo" id="id_subtramo"';
                          echo form_dropdown('id_subtramo', $subtramo, '', $attribute); ?></td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="progresiva_inicial">Progresiva inicial:</label></td>
                        <td>
                          <?php echo form_input($progresiva_inicial); ?>
                        </td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="progresiva_final">Progresiva final:</label></td>
                        <td>
                          <?php echo form_input($progresiva_final); ?>
                        </td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="franja_dominio">Franja:</label></td>
                        <td>
                          <label>Construcción
                          <?php echo form_radio(
                            $franja_dominio['name'],
                            $franja_dominio['value_fc'],
                            $franja_dominio['checked_fc']
                            );?>
                          </label>
                          <?php echo '&nbsp;';?><?php echo '&nbsp;';?><?php echo '&nbsp;';?>
                          <label>Dominio
                          <?php echo form_radio(
                            $franja_dominio['name'],
                            $franja_dominio['value_fd'],
                            $franja_dominio['checked_fd']
                            );?>
                          </label>
                        </td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="desafectado">Desafectado:</label></td>
                        <td>
                          <label>Si&nbsp&nbsp
                          <?php echo form_radio(
                            $desafectado['name'],
                            $desafectado['value_s'],
                            $desafectado['checked_s']
                            );?>
                          </label>
                          <?php echo '&nbsp;';?><?php echo '&nbsp;';?><?php echo '&nbsp;';?>
                          <label>No&nbsp&nbsp
                          <?php echo form_radio(
                            $desafectado['name'],
                            $desafectado['value_n'],
                            $desafectado['checked_n']
                            );?>
                          </label>
                        </td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="id_condicion_dominio">Condición de dominio:</label></td>
                        <td>
                          <?php $attribute = 'class="form-control selectpicker" data-live-search="true" title="Departamento" id="id_condicion_dominio" required="required"';
                            echo form_dropdown('id_condicion_dominio', $condicion_dominio, '', $attribute); ?>
                        </td>
                      </tr>
                    </tbody>
                  </table>
                </div>
                <div class="col-sm-6">
                  <table class="tablaCentrada tablaD" border="1px solid rgb(0, 0, 0)" style="width: 100%;">
                    <thead>
                      <tr class="colorMOPC">
                        <td colspan="2">CARACTERISTICAS DEL AFECTADO</td>
                      </tr>
                    </thead>
                    <tbody>
                      <tr>
                        <td><label class="control-label" for="nombre_completo">Nombre del afectado:</label></td>
                        <td><?php echo form_input($nombre_completo); ?></td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="cedula_identidad">Cedula del afectado:</label></td>
                        <td><?php echo form_input($cedula_identidad); ?></td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="fecha_nacimiento">Fecha de nacimiento del afectado:</label></td>
                        <td>
                          <div class="input-group date" data-provide="datepicker" data-date-format="dd/mm/yyyy">
                            <?php echo form_input($fecha_nacimiento);?>
                            <div class="input-group-addon">
                              <i class="fa fa-calendar"></i>
                            </div>
                          </div>
                        </td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="telefono">Teléfono del afectado:</label></td>
                        <td><?php echo form_input($telefono); ?></td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="id_departamento">Departamento:</label></td>
                        <td>
                          <?php $attribute = 'class="form-control selectpicker" data-live-search="true" title="Departamento" id="id_departamento" required="required"';
                            echo form_dropdown('id_departamento', $departamento, '', $attribute); ?>
                        </td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="id_distrito">Distrito:</label></td>
                        <td>
                          <?php $attribute = 'class="form-control selectpicker" data-live-search="true" title="Departamento" id="id_distrito" required="required"';
                            echo form_dropdown('id_distrito', $distrito, '', $attribute); ?>
                        </td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="lugar">Lugar:</label></td>
                        <td>
                          <?php echo form_input($lugar); ?>
                        </td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="cta_cte_catastral">Cta. Cte. Ctral:</label></td>
                        <td><?php echo form_input($cta_cte_catastral); ?></td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="padron">Padrón:</label></td>
                        <td><?php echo form_input($padron); ?></td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="finca">Finca:</label></td>
                        <td><?php echo form_input($finca); ?></td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="matricula">Matrícula:</label></td>
                        <td><?php echo form_input($matricula); ?></td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="entrada_maquina">Entrada de máquina:</label></td>
                        <td>
                          <label>Si&nbsp&nbsp
                          <?php echo form_radio(
                            $entrada_maquina['name'],
                            $entrada_maquina['value_s'],
                            $entrada_maquina['checked_s']
                            );?>
                          </label>
                          <?php echo '&nbsp;';?><?php echo '&nbsp;';?><?php echo '&nbsp;';?>
                          <label>No&nbsp&nbsp
                          <?php echo form_radio(
                            $entrada_maquina['name'],
                            $entrada_maquina['value_n'],
                            $entrada_maquina['checked_n']
                            );?>
                          </label>
                        </td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="urgente">Urgente?:</label></td>
                        <td>
                          <label>Si&nbsp&nbsp
                          <?php echo form_radio(
                            $urgente['name'],
                            $urgente['value_s'],
                            $urgente['checked_s']
                            );?>
                          </label>
                          <?php echo '&nbsp;';?><?php echo '&nbsp;';?><?php echo '&nbsp;';?>
                          <label>No&nbsp&nbsp
                          <?php echo form_radio(
                            $urgente['name'],
                            $urgente['value_n'],
                            $urgente['checked_n']
                            );?>
                          </label>
                        </td>
                      </tr>
                      <tr>
                        <td><label class="control-label" for="lado">Lado:</label></td>
                        <td>
                          <label>Izquierdo&nbsp&nbsp
                          <?php echo form_radio(
                          $lado['name'],
                          $lado['value_i'],
                          $lado['checked_i']
                          );?>
                          </label>
                          <?php echo '&nbsp;';?><?php echo '&nbsp;';?><?php echo '&nbsp;';?>
                          <label>Derecho&nbsp&nbsp
                          <?php echo form_radio(
                          $lado['name'],
                          $lado['value_d'],
                          $lado['checked_d']
                          );?>
                          </label>
                          <?php echo '&nbsp;';?><?php echo '&nbsp;';?><?php echo '&nbsp;';?>
                          <label>Pendiente&nbsp&nbsp
                          <?php echo form_radio(
                          $lado['name'],
                          $lado['value_p'],
                          $lado['checked_p']
                          );?>
                          </label>
                        </td>
                      </tr>
                      
                    </tbody>
                  </table>
                  <br>
                  <div class="box box-option collapsed-box">
                    <div class="box-header with-border">
                      <h3 class="box-title">Historial Código MEU</h3>
                      <div class="box-tools pull-right" >
                        <!-- Collapse Button -->
                        <button type="button" class="btn btn-box-tool" data-widget="collapse">
                        <i class="fa fa-plus"></i>
                        </button>
                      </div>
                      <!-- /.box-tools -->
                    </div>
                    <!-- /.box-header -->
                    <div style="display: none;" class="box-body">
                      <?php
                        $i = 0;
                        if (isset($historial_meu)) : ?>
                      <table class="table">
                        <thead>
                          <tr>
                            <th>#</th>
                            <th>Código MEU</th>
                            <th>Fecha MEU</th>
                            <th>Fecha guardado</th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php foreach ($historial_meu as $values) :
                            $i = $i + 1; ?>
                          <tr>
                            <th scope="row"><?php echo $i; ?></th>
                            <td><?php echo htmlspecialchars($values['codigo_meu'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?php echo htmlspecialchars(formato_fecha($values['daj_fecha_meu']), ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?php echo htmlspecialchars(formato_fecha_hora($values['fecha_insercion']), ENT_QUOTES, 'UTF-8'); ?></td>
                          </tr>
                          <?php endforeach;?>
                        </tbody>
                      </table>
                      <?php else : ?>
                      <p>No se encuentran registros.</p>
                      <?php endif; ?>
                    </div>
                    <!-- /.box-body -->
                  </div>
                  <div class="box box-option collapsed-box">
                    <div class="box-header with-border">
                      <h3 class="box-title">Historial número notificación</h3>
                      <div class="box-tools pull-right" >
                        <!-- Collapse Button -->
                        <button type="button" class="btn btn-box-tool" data-widget="collapse">
                        <i class="fa fa-plus"></i>
                        </button>
                      </div>
                      <!-- /.box-tools -->
                    </div>
                    <!-- /.box-header -->
                    <div style="display: none;" class="box-body">
                      <?php
                        $i = 0;
                        if (isset($historial_notificacion)) : ?>
                      <table class="table">
                        <thead>
                          <tr>
                            <th>#</th>
                            <th>Número notificación</th>
                            <th>Fecha guardado</th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php foreach ($historial_notificacion as $values) :
                            $i = $i + 1; ?>
                          <tr>
                            <th scope="row"><?php echo $i; ?></th>
                            <td><?php echo htmlspecialchars($values['notificacion'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?php echo htmlspecialchars(formato_fecha_hora($values['fecha_insercion']), ENT_QUOTES, 'UTF-8'); ?></td>
                          </tr>
                          <?php endforeach;?>
                        </tbody>
                      </table>
                      <?php else : ?>
                      <p>No se encuentran registros.</p>
                      <?php endif; ?>
                    </div>
                    <!-- /.box-body -->
                  </div>
                </div>
              </div>
            </div>
            <div class="panel panel-default">
              <div class="panel-body">
                
                <div class="text-center">
                  <h4>VALIDACIÓN DE CARÁTULAS</h4>
                </div>
                <div class="col-sm-4">
                  <div class="colorMOPC">Validación cáratulas documentación</div>
                  <br>
                  <div class="colorMOPC">Validación Cédulas de Notificación</div>
                  <br>
                  <div class="colorMOPC">Validación Autorización</div>
                </div>
                <div class="col-sm-8">
                  <?php echo form_textarea($observacion_caratula); ?>
                  <br>
                  <?php echo form_textarea($observacion_cedula); ?>
                  <br>
                  <?php echo form_textarea($observacion_autorizacion); ?>
                </div>
              </div>
            </div>
            <div class="panel panel-default">
              <div class="panel-body">
                <!-- Sección botones -->
                <div class="form-group" style="text-align: center;">
                  <?php echo form_button(array('name' => 'accion','type' => 'submit','value' => '1','class' => 'btn btn-primary btn-size', 'content' =>   'GRABAR')); ?>
                  <?php echo '&nbsp;';?>
                  <?php echo anchor('expedientes/expedientes/', 'REGRESAR', array('class' => 'btn btn-primary btn-size', 'content' => 'REGRESAR')); ?> 
                  
                </div>
                <!-- Fin sección botones --> 
              </div>
            </div>
            <?php echo form_close();?>

          </div>
        </div>
        <!-- Fin primer bloque --> 
      </div>
    </div>
  </section>
</div>