<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dictamen_model extends Ion_auth_model {
	
	public function __construct()
	{
		parent::__construct();
	}
	
	public function dropdown_data($tabla = NULL, $where = NULL, $order_by = NULL)
	{
		$this->response = $this->db->select('*');
		$this->response = $this->db->from($this->tables[$tabla]);
		
		if ($where != NULL) {
			foreach ($where as $k => $v) {

				$this->response = $this->db->where($k, $v);
			}
		}

		$this->response = $this->db->order_by($order_by);
		$this->response = $this->db->get();
		//$this->response = $this->db->get_where($this->tables[$tabla],$where);

		return $this;
	}


	public function select_data($tabla = NULL, $where = NULL)
	{
		$this->response = $this->db->get_where($this->tables[$tabla],$where);

		//return $this;
	}


	/**
	 * View
	 *
	 * @return object
	 * @author Diego Ferreira
	 **/
	public function view($tabla = NULL, $where = NULL)
	{
		$this->trigger_events('expediente');

		$this->response = $this->db->get_where($this->tables[$tabla], $where);

		return $this;
	}


	/**
	 * crear_expediente
	 *
	 * @return integer
	 * @author Diego Ferreira
	*/
	public function crear_expediente($arraycampos = NULL)
	{
		// bail if the group name already exists
		$existe_expediente = $this->db->get_where($this->tables['exp'], $arraycampos)->num_rows();

		
		if($existe_expediente !== 0)
		{
			$this->ion_auth->set_error('expedientes_already_exists');
			return FALSE;
		}
		
		// insert the new expediente
		$this->db->insert($this->tables['exp'], $arraycampos);
		$expe_id = $this->db->insert_id();

		// report success
		$this->ion_auth->set_message('expedientes_creation_successful');
		// return the brand new group id
		return $expe_id;
	}
	
	/**
	 * actualizar_expediente
	 *
	 * @return bool
	 * @author Diego Ferreira
	 **/

	public function actualizar_dic1($expe_id = FALSE, $campo = NULL, $valor = NULL)
	{

		$actualizar = $this->db->update($this->tables['dic1_datos'], array('valor' => $valor), array('dic1_expe_id' => $expe_id, 'concepto' => $campo));

		if ($actualizar) {
			
        	return $this->db->last_query();
		}else{
        	return $this->db->last_query();
			//return FALSE;
		}
    }

 	public function eliminar_expediente($expe_id)
    {
    	$this->db->delete($this->tables['exp'],array('expe_id' => $expe_id));
		return TRUE;
    }
}