<?php

	/**
	 * Prouectos Model MOPC
	 *
	 * @return bool
	 * @author Lissy Jameuge Rojas Gonzales
	 **/


defined('BASEPATH') OR exit('No direct script access allowed');

class proyectos_model extends Ion_auth_model {

	public function __construct()
	{
		parent::__construct();
	}

	/**
	 * geocolonias
	 *
	 * @return object
	 * @author Ben Edmunds
	 **/
	public function view_all()
	{
		//$this->trigger_events('geocolonias');

		// run each where that was passed


		if (isset($this->_ion_where) && !empty($this->_ion_where))
		{
			foreach ($this->_ion_where as $where)
			{
				$this->db->where($where);
			}
			$this->_ion_where = array();
		}

		if (isset($this->_ion_limit) && isset($this->_ion_offset))
		{
			$this->db->limit($this->_ion_limit, $this->_ion_offset);

			$this->_ion_limit  = NULL;
			$this->_ion_offset = NULL;
		}
		else if (isset($this->_ion_limit))
		{
			$this->db->limit($this->_ion_limit);

			$this->_ion_limit  = NULL;
		}

		// set the order
		if (isset($this->_ion_order_by) && isset($this->_ion_order))
		{
			$this->db->order_by($this->_ion_order_by, $this->_ion_order);
		}

		$this->response = $this->db->get($this->tables['geocolonias']);

		return $this;
	}

	public function dropdown_data($tabla = NULL, $where = NULL, $order_by = NULL)
	{
		$this->response = $this->db->select('*');
		$this->response = $this->db->from($this->tables[$tabla]);

		if ($where != NULL) {
			foreach ($where as $k => $v) {

				$this->response = $this->db->where($k, $v);
			}
		}

		$this->response = $this->db->order_by($order_by);
		$this->response = $this->db->get();
		//$this->response = $this->db->get_where($this->tables[$tabla],$where);

		return $this;
	}


	public function select_data($tabla = NULL, $where = NULL)
	{
		$this->response = $this->db->get_where($this->tables[$tabla],$where);

		//return $this;
	}


	/**
	 * Expedientes
	 *
	 * @return object
	 * @author Ben Edmunds
	 **/
	public function view($tabla = NULL, $where = NULL)
	{
		$this->trigger_events('proyectos');

		$this->response = $this->db->get_where($this->tables[$tabla], $where);

		return $this;
	}

	/**
	 * existe_grafico
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function existe_grafico($exp = NULL, $gest = NULL)
	{
		$resultado = $this->db->query("SELECT MOPC_IDE.F_EXISTE_GRAFICO('".$exp."',".$gest.");");

		return $resultado;
	}


	/**
	 * existe_grafico_proyecto_id
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function existe_grafico_id_proyecto($id_proyecto = NULL)
	{
		$resultado = $this->db->query("SELECT IDE.F_EXISTE_GRAFICO_ID_PROYECTO(".$id_proyecto.");");

		return $resultado;
	}


	/**
	 * f_existe_grafico_proyecto_id
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function f_existe_grafico_proyecto_id($id_proyecto = NULL)
	{
		$resultado = $this->db->query("SELECT IDE.F_EXISTE_GRAFICO_ID_PROYECTO(".$id_proyecto.");")->row()->f_existe_grafico_id_proyecto;

		return $resultado;
	}


	/**
	 * f_existe_grafico
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function f_existe_grafico($exp = NULL, $gest = NULL)
	{
		$resultado = $this->db->query("SELECT MOPC_IDE.F_EXISTE_GRAFICO('".$exp."',".$gest.");")->row()->f_existe_grafico;

		return $resultado;
	}


	/**
	 * actualizar_shapes_proyecto_dgsa
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function actualizar_shapes_proyecto_dgsa($id_proyecto = NULL, $epsg = NULL)
	{

		$resultado = $this->db->query("SELECT dgsa.actualizar_shapes_proyecto_dgsa(".$id_proyecto.",".$epsg.");");

		return $resultado;
	}

	/**
	 * actualizar_shapes_proyecto_dgsa
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function actualizar_shapes_proyecto($id_proyecto = NULL, $epsg = NULL)
	{

		$resultado = $this->db->query("SELECT ide.actualizar_shapes_proyecto(".$id_proyecto.",".$epsg.");");

		return $resultado;
	}

	/**
	 * actualizar_shapes
	 *
	 * @return int
	 * @author Gustavo López
	 **/
	public function actualizar_shapes_progre($id_proyecto = NULL, $epsg = NULL)
	{

		$resultado = $this->db->query("SELECT ide.actualizar_shapes_progre(".$id_proyecto.",".$epsg.");");

		return $resultado;
	}


	/**
	 * eliminar_geometrias
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function eliminar_geometrias_proyecto($id_proyecto = NULL)
	{
		$resultado = $this->db->query("SELECT IDE.F_ELIMINAR_GEOMETRIAS_PROYECTO(".$id_proyecto.");");

		return $resultado;
	}
	
	/**
	 * eliminar_fd_proyecto
	 *
	 * @return int
	 * @author Gustavo López
	 **/
	public function eliminar_fd_proyecto($id_proyecto = NULL)
	{
		$resultado = $this->db->query("SELECT ide.f_eliminar_fd_proyecto(".$id_proyecto.");");

		return $resultado;
	}

	/**
	 * eliminar_fd_proyecto
	 *
	 * @return int
	 * @author Jaime Rojas Landivar
	 **/
	public function eliminar_fc_proyecto($id_proyecto = NULL)
	{
		$resultado = $this->db->query("SELECT ide.f_eliminar_fc_proyecto(".$id_proyecto.");");

		return $resultado;
	}

	/**	
	 * eliminar_progre_proyecto
	 *
	 * @return int
	 * @author Gustavo López
	 **/
	public function eliminar_progre_proyecto($id_proyecto = NULL)
	{
		$resultado = $this->db->query("SELECT ide.f_eliminar_progre_proyecto(".$id_proyecto.");");

		return $resultado;
	}

	/**
	 * contador_registros
	 * Obtiene la cantidad de registro de una tabla y condici�n dada
	 * @return int
	 * @author Diego Ferreira
	 **/
	public function contador_registros ($tabla = NULL, $arraywhere = NULL)
	{
		foreach ($arraywhere as $k => $v) {

			$this->db->where($k, $v);
		}
		$this->db->from($this->tables[$tabla]);
		return $this->db->count_all_results();
	}

	/**
	 * obtener_nextval
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function obtener_nextval($sequence)
	{
		$seq = $this->db->query("SELECT NEXTVAL('" . $sequence . "');")->row()->nextval;

		return $seq;
	}

	public function buscar_geo($abuscar)
	{
        //usamos after para decir que empiece a buscar por
        //el principio de la cadena
        //ej SELECT poblacion from poblacion
        //WHERE poblacion LIKE '%$abuscar' limit 12
        //$this->db->select('geocolonias');

        //$this->db->like('poblacion',$abuscar,'after');

		$resultados = $this->db->get('geocolonias');

        //si existe alg�n resultado lo devolvemos
		if($resultados->num_rows() > 0)
		{

			return $resultados->result();

        //en otro caso devolvemos false
		}else{

			return FALSE;

		}
	}



	/**
	 * actualizar_resolucion
	 *
	 * @return bool
	 * @author Jaime Rojas
	 **/
	public function actualizar_resolucion($proyecto_id = FALSE, $arraycampos = NULL)
	{

		$this->db->update($this->tables['resoluciones'], $arraycampos, array('reso_proyecto_id' => $proyecto_id));

        $this->set_message('proyectos_update_successful');

        return 'TRUE';
    }



	/**
	 * actualizar_proyecto
	 *
	 * @return bool
	 * @author Lissy Rojas
	 **/
/**


	public function actualizar_proyecto($proyecto_id = FALSE, $arraycampos = NULL)
	{

		$this->db->update($this->tables['proyectos'], $arraycampos, array('id_proyecto' => $proyecto_id));

        $this->set_message('proyectos_update_successful');

        return 'TRUE';
    }

	/**
	 * valor_maximo
	 *	Obtiene el valor máximo de una columna y tabla específica
	 * @return int
	 * @author Lissy Jameuge Rojas Gonzales
	 **/
	public function valor_maximo_2 ($tabla = NULL, $columna = NULL, $arraywhere = NULL)
	{
		$this->db->select("MAX(".$columna.") max");

		foreach ($arraywhere as $k => $v) {

			$this->db->where($k, $v);
		}

		$this->db->from($this->tables[$tabla]);

		return $this->db->get();
	}

    /**
	 * valor_maximo
	 *	Obtiene el valor m�ximo de una columna y tabla espec�fica
	 * @return int
	 * @author Diego Ferreira
	 **/
	public function valor_maximo ($tabla = NULL, $columna = NULL, $arraywhere = NULL)
	{
		$this->db->select("MAX(".$columna.") max");

		if ($arraywhere != NULL) {
			foreach ($arraywhere as $k => $v) {

				$this->db->where($k, $v);
			}
		}

		$this->db->from($this->tables[$tabla]);

		return $this->db->get()->row()->max;
	}


	/**
	 * campo_valor_maximo
	 *	Obtiene el valor m�ximo de una columna y tabla espec�fica
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function obtener_valor_campo ($tabla = NULL, $columna = NULL, $arraywhere = NULL)
	{
		$this->db->select($columna." campo");

		foreach ($arraywhere as $k => $v) {

			$this->db->where($k, $v);
		}

		$this->db->from($this->tables[$tabla]);

		return $this->db->get()->row()->campo;
	}





	/**
	 * campo_valor_maximo
	 *	Obtiene el valor m�ximo de una columna y tabla espec�fica
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function campo_valor_maximo ($tabla = NULL, $columna = NULL, $arraywhere = NULL)
	{
		$this->db->select("MAX(".$columna.") max");

		foreach ($arraywhere as $k => $v) {

			$this->db->where($k, $v);
		}

		$this->db->from($this->tables[$tabla]);

		return $this->db->get()->row()->max;
	}

	/**
	 * eliminar_proyecto
	 *	Obtiene el valor m�ximo de una columna y tabla espec�fica
	 * @return int
	 * @author Jaime Rojas
	 **/
    public function eliminar_proyecto($proyecto_id)
    {

        $resultado = $this->db->query("SELECT count (*) cnt from ide.expedientes where id_proyecto =".$proyecto_id.";")->row()->cnt;

        if ($resultado == 0) {
           $this->db->delete($this->tables['proyectos'],array('id_proyecto' => $proyecto_id));
        }
    	
		return $resultado;
    }

	/**
	 * eliminar_dgsa_terrenos
	 *	Obtiene el valor m�ximo de una columna y tabla espec�fica
	 * @return int
	 * @author Jaime Rojas
	 **/
    public function eliminar_dgsa_terrenos($id_proyec)
    {
    	$this->db->delete($this->tables['dgsa_terrenos'],array('id_proyec' => $id_proyec));
		return TRUE;
    }

	/**
	 * eliminar_dgsa_puntos
	 *	Obtiene el valor m�ximo de una columna y tabla espec�fica
	 * @return int
	 * @author Jaime Rojas
	 **/
    public function eliminar_dgsa_puntos($id_proyec)
    {
    	$this->db->delete($this->tables['dgsa_puntos'],array('id_proyec' => $id_proyec));
		return TRUE;
    }


    public function departamentos()
    {
    	$this->response = $this->db->get($this->tables['departamentos']);

    	return $this;
    }

    public function distritos()
    {
    	$this->response = $this->db->query("SELECT * FROM INDERT.DISTRITOS ORDER BY DISTRITO");
    	return $this;
    }

	//PAGINATION
    public function get_pagination($number_per_page)
    {
    	if ($this->uri->segment(5) == null | $this->uri->segment(5) == '') {

    		$this->response = $this->db->get($this->tables['geocolonias'],$number_per_page, 0);
    	}else
    	{
    		$this->response = $this->db->get($this->tables['geocolonias'],$number_per_page, $this->uri->segment(5));
    	}

    	return $this;
	}

	public function num_post()
	{
		$number = $this->db->query("SELECT count(*) as number FROM indert.geocolonia")->row()->number; //r�pido
		return intval($number);
	}

	public function v_tipo_moneda()
	{
		$this->response = $this->db->get($this->tables['tipo_moneda']);

		return $this;
	}


	public function mapabb($proyecto_id)
	{


			$i_sql = "select ";
			$i_sql = $i_sql. "round(cast((x.campo1+x.campo1*(0.0002)) as decimal),13) as ext1, ";
			$i_sql = $i_sql. "round(cast((x.campo2+x.campo2*(0.0002)) as decimal),13) as ext2, ";
			$i_sql = $i_sql. "round(cast((x.campo3-x.campo3*(0.0002)) as decimal),13) as ext3, ";
			$i_sql = $i_sql. "round(cast((x.campo4-x.campo4*(0.0002)) as decimal),13) as ext4 ";
			$i_sql = $i_sql. "from ";
			$i_sql = $i_sql. "(";

			$i_sql = $i_sql. "select ";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[1] as decimal) as campo1,";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[2] as decimal) as campo2,";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[3] as decimal) as campo3,";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[4] as decimal) as campo4";
			$i_sql = $i_sql. " from ( ";

			$i_sql = $i_sql . "select ";
            $i_sql = $i_sql . "replace(";
            $i_sql = $i_sql . "replace(substr(cast(a.bb as varchar),5),' ',',')";
            $i_sql = $i_sql . ",')','') as bb ";
            $i_sql = $i_sql . "FROM (select ST_Extent(the_geom) as bb ";
            $i_sql = $i_sql . "from i3geo.MOPC_poligono ";
            $i_sql = $i_sql . "where proyecto_id=" . $proyecto_id . " ";
            $i_sql = $i_sql . "group by proyecto_id) as a) as t1 ";
            //$i_sql = $i_sql . ";";
			$i_sql = $i_sql . ") as x;";

            $response = $this->db->query($i_sql)->result_array();

            return $response;

	}

	public function mensaje_error($id_proyecto = NULL)
	{
		$this->response = $this->db->query("SELECT descrip_error FROM ide.errores where id_proyec=".$id_proyecto.";");
		return $this;
	}


	/**
	 * crear_proyecto
	 *
	 * @return integer
	 * @author Lissy Rojas
	*/
	public function crear_proyecto($arraycampos = NULL)
	{
		// bail if the group name already exists
		$existe_proyecto = $this->db->get_where($this->tables['proyectos'], $arraycampos)->num_rows();

		
		if($existe_proyecto !== 0)
		{
			$this->ion_auth->set_error('proyectos_already_exists');
			return FALSE;
		}
		


		// insert the new producto
		$this->db->insert($this->tables['proyectos'], $arraycampos);
		$proyecto_id = $this->db->query("SELECT MAX(id_proyecto) FROM public.proyectos;")->row()->max;


		//$producto_id = $this->db->insert_id();

		// report success
		$this->ion_auth->set_message('proyectos_creation_successful');
		// return the brand new group id
		return $proyecto_id;
	}


	/**
	 * obtener_errores
	 *	Función encargada de obtener los errores de la tabla public.reg_errores
	 * @return array
	 * @author Lissy Jameuge Rojas Gonzales
	 **/
	public function obtener_errores($level_1_id, $id_pestanha)
	{
		return $this->db->get_where("dgsa.reg_errores",array('level_1_id' => $level_1_id,
														'pestanha'		   => $id_pestanha
														));
	}



	public function viewlist_abm($tabla = NULL, $proyec_id = NULL, $orderby = NULL) 
	{
		$this->trigger_events('viewlist_abm');

		$this->response = $this->db->select('*');
		$this->response = $this->db->from($this->tables[$tabla]);

		$this->response = $this->db->where('proyec_id', $proyec_id);

		if ($orderby != NULL) {
			$this->response = $this->db->order_by($orderby);
		}

		$this->response = $this->db->get();

		return $this;
		
		if (isset($proyec_id))
		{
			$this->response = $this->db->get_where($this->tables[$tabla],array('proyec_id' => $proyec_id));	
		}

		return $this;
	}


	/**
	 * crear_registro
	 *	Función encargada de crear un nuevo registro en la tabla y con la condición propuesta
	 * @return bool
	 * @author Lissy Jameuge Rojas Gonzales
	 **/
	public function crear_registro($tabla = NULL, $arraycampos = NULL)
	{
		if (empty($arraycampos)) return FALSE;

		$this->db->insert($this->tables[$tabla], $arraycampos);

		$this->set_message('proyectos_update_successful');

		return TRUE;
	}

	/**
	 * actualizar_tabla
	 *	Función encargada de actualizar el cuestionario en la tabla y con la condición propuesta
	 * @return bool
	 * @author Lissy Jameuge Rojas Gonzales
	 **/
    public function actualizar_registro($where = NULL, $tabla = NULL, $arraycampos = NULL)
	{
		if (empty($arraycampos)) {
			return FALSE;
		} else {	
			$this->db->update($this->tables[$tabla], $arraycampos, $where);

			$this->set_message('update_successful');

			return TRUE;
		}
    }

	/**
	 * eliminar_registro
	 *	Función encargada de eliminar un registro dada la tabla y la condición de la misma
	 * @return bool
	 * @author Lissy Jameuge Rojas Gonzales
	 **/
	public function eliminar_registro($tabla = NULL, $arraywhere){

		$eliminar = $this->db->delete($tabla, $arraywhere);

		if ($eliminar) {
			return TRUE;
		}else{
			return FALSE;
		}
	}

	public function eliminar_users_censo($proyec_id,$occ)
    {

		$array_where['proyec_id'] = $proyec_id;
		$array_where['occ'] = $occ;
		$this->db->delete($this->tables['users_censo'], $array_where);
        return true;
    }

	public function concepto ($where1, $blanco = FALSE, $orderby = FALSE, $where2 = FALSE)
	{
		$query = "SELECT CONCEPTO, NOMBRE, DESCRIPCION, TIPOCONCEPTO FROM dgsa_admin.CONCEPTOS WHERE TIPOCONCEPTO = '".$where1."'";

		if ($where2 == TRUE) {
			$query = $query . " AND CONCEPTO = '" . $where2 . "'";
		}

		if ($blanco == TRUE) {
			$query = $query . " UNION SELECT '  ', 'DEJAR EN BLANCO', '', ''";
		}
		if ($orderby) {
			$query = $query . " ORDER BY ".$orderby;
		}
		$this->response = $this->db->query($query);

		$_SESSION['last_query'] = $this->db->last_query();

		return $this;
	}

}
