<?php

	/**
	 * Prouectos Model MOPC
	 *
	 * @return bool
	 * @author Lissy Jameuge Rojas Gonzales
	 **/


defined('BASEPATH') OR exit('No direct script access allowed');

class memos_model extends Ion_auth_model {

	public function __construct()
	{
		parent::__construct();
	}

	/**
	 * geocolonias
	 *
	 * @return object
	 * @author Ben Edmunds
	 **/
	public function view_all()
	{
		//$this->trigger_events('geocolonias');

		// run each where that was passed


		if (isset($this->_ion_where) && !empty($this->_ion_where))
		{
			foreach ($this->_ion_where as $where)
			{
				$this->db->where($where);
			}
			$this->_ion_where = array();
		}

		if (isset($this->_ion_limit) && isset($this->_ion_offset))
		{
			$this->db->limit($this->_ion_limit, $this->_ion_offset);

			$this->_ion_limit  = NULL;
			$this->_ion_offset = NULL;
		}
		else if (isset($this->_ion_limit))
		{
			$this->db->limit($this->_ion_limit);

			$this->_ion_limit  = NULL;
		}

		// set the order
		if (isset($this->_ion_order_by) && isset($this->_ion_order))
		{
			$this->db->order_by($this->_ion_order_by, $this->_ion_order);
		}

		$this->response = $this->db->get($this->tables['memos']);

		return $this;
	}

	public function dropdown_data($tabla = NULL, $where = NULL, $order_by = NULL)
	{
		$this->response = $this->db->select('*');
		$this->response = $this->db->from($this->tables[$tabla]);

		if ($where != NULL) {
			foreach ($where as $k => $v) {

				$this->response = $this->db->where($k, $v);
			}
		}

		$this->response = $this->db->order_by($order_by);
		$this->response = $this->db->get();
		//$this->response = $this->db->get_where($this->tables[$tabla],$where);

		return $this;
	}


	public function select_data($tabla = NULL, $where = NULL)
	{
		$this->response = $this->db->get_where($this->tables[$tabla],$where);

		//return $this;
	}


	/**
	 * Expedientes
	 *
	 * @return object
	 * @author Ben Edmunds
	 **/
	public function view($tabla = NULL, $where = NULL)
	{
		$this->trigger_events('memos');

		$this->response = $this->db->get_where($this->tables[$tabla], $where);

		return $this;
	}

	/**
	 * existe_grafico
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function existe_grafico($exp = NULL, $gest = NULL)
	{
		$resultado = $this->db->query("SELECT MOPC_IDE.F_EXISTE_GRAFICO('".$exp."',".$gest.");");

		return $resultado;
	}


	/**
	 * existe_grafico_proyecto_id
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function existe_grafico_id_proyecto($id_proyecto = NULL)
	{
		$resultado = $this->db->query("SELECT IDE.F_EXISTE_GRAFICO_ID_PROYECTO(".$id_proyecto.");");

		return $resultado;
	}


	/**
	 * f_existe_grafico_proyecto_id
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function f_existe_grafico_proyecto_id($id_proyecto = NULL)
	{
		$resultado = $this->db->query("SELECT IDE.F_EXISTE_GRAFICO_ID_PROYECTO(".$id_proyecto.");")->row()->f_existe_grafico_id_proyecto;

		return $resultado;
	}


	/**
	 * f_existe_grafico
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function f_existe_grafico($exp = NULL, $gest = NULL)
	{
		$resultado = $this->db->query("SELECT MOPC_IDE.F_EXISTE_GRAFICO('".$exp."',".$gest.");")->row()->f_existe_grafico;

		return $resultado;
	}


	/**
	 * actualizar_shapes
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function actualizar_shapes_proyecto($id_proyecto = NULL, $epsg = NULL)
	{

		$resultado = $this->db->query("SELECT ide.actualizar_shapes_proyecto(".$id_proyecto.",".$epsg.");");

		return $resultado;
	}


	/**
	 * eliminar_geometrias
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function eliminar_geometrias_proyecto($id_proyecto = NULL)
	{
		$resultado = $this->db->query("SELECT IDE.F_ELIMINAR_GEOMETRIAS_PROYECTO(".$id_proyecto.");");

		return $resultado;
	}

	/**
	 * contador_registros
	 *	Obtiene la cantidad de registro de una tabla y condici�n dada
	 * @return int
	 * @author Diego Ferreira
	 **/
	public function contador_registros ($tabla = NULL, $arraywhere = NULL)
	{
		foreach ($arraywhere as $k => $v) {

			$this->db->where($k, $v);
		}
		$this->db->from($this->tables[$tabla]);
		return $this->db->count_all_results();
	}

	/**
	 * obtener_nextval
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function obtener_nextval($sequence)
	{
		$seq = $this->db->query("SELECT NEXTVAL('" . $sequence . "');")->row()->nextval;

		return $seq;
	}

	
//($id_detalle,$coord_id_memo,$id_exp,$notificacion,$item);
	public function f_existe_detalle($coord_id_memo=NULL,$id_detalle=NULL,$id_exp=NULL,$notificacion=NULL,$item=NULL,$codigo_unico_ref=NULL)
    {
        /*$resultado = $this->db->query("SELECT count (*) cnt from public.memos_detalle where id_memo =".$coord_id_memo." AND id_detalle=".$id_detalle." AND id_exp =".$id_exp." AND notificacion='".$notificacion."' AND item=".$item.";")->row()->cnt;
        */

        $resultado = $this->db->query("SELECT count (*) cnt from public.memos_detalle where id_memo =".$coord_id_memo." AND id_detalle=".$id_detalle." AND id_exp =".$id_exp." AND notificacion='".$notificacion."' AND item=".$item." AND codigo_unico_ref='".$codigo_unico_ref."';")->row()->cnt;

        return $resultado;
    }

    public function insertar_detalle($arraycampos = NULL)
    {
       // bail if the group name already exists
        $existe_detalle = $this->db->get_where($this->tables['memos_detalle'], $arraycampos)->num_rows();


        if($existe_detalle !== 0)
        {
            $this->ion_auth->set_error('detalle_already_exists');
            return FALSE;
        }
        else
        {
            try {
                // insert the new expediente
                $this->db->insert($this->tables['memos_detalle'], $arraycampos);
                //$expe_id = $this->db->insert_id();
                //$this->ion_auth->set_message('coordafecta_creation_successful');
                return  TRUE;
            } catch(Exception $e) {
                //echo 'Message: ' .$e->getMessage();
                //$this->ion_auth->set_message('coordafecta_creation_successful');
                return  FALSE;
            }

            // report success

            // return the brand new group id

        }
    }


    public function obtener_detalle($tabla, $where = NULL)
	{

	$this->response = $this->db->get_where($this->tables[$tabla], $where);

	return $this;
	}


	public function buscar_geo($abuscar)
	{
        //usamos after para decir que empiece a buscar por
        //el principio de la cadena
        //ej SELECT poblacion from poblacion
        //WHERE poblacion LIKE '%$abuscar' limit 12
        //$this->db->select('geocolonias');

        //$this->db->like('poblacion',$abuscar,'after');

		$resultados = $this->db->get('memos');

        //si existe alg�n resultado lo devolvemos
		if($resultados->num_rows() > 0)
		{

			return $resultados->result();

        //en otro caso devolvemos false
		}else{

			return FALSE;

		}
	}


	/**
	 * actualizar_resolucion
	 *
	 * @return bool
	 * @author Jaime Rojas
	 **/
	public function actualizar_resolucion($proyecto_id = FALSE, $arraycampos = NULL)
	{

		$this->db->update($this->tables['resoluciones'], $arraycampos, array('reso_proyecto_id' => $proyecto_id));

        $this->set_message('proyectos_update_successful');

        return 'TRUE';
    }



	/**
	 * actualizar_memo
	 *
	 * @return bool
	 * @author Lissy Rojas
	 **/
	public function actualizar_memo($memo_id = FALSE, $arraycampos = NULL)
	{

		$this->db->update($this->tables['memos'], $arraycampos, array('id_memo' => $memo_id));

        $this->set_message('memos_update_successful');

        return 'TRUE';
    }

    /*
    public function actualizar_m_detalle($memo_detalle = FALSE, $arraycampos = NULL)
	{

		$this->db->update($this->tables['memos_detalle'], $arraycampos, array('id_detalle' => $memo_detalle));

        $this->set_message('memos_update_successful');

        return 'TRUE';
    }
     $actu = $this->memos_model->actualizar_m_detalle($id_detalle,$coord_id_memo,$id_exp,$notificacion,$item,$codigo_unico_ref,$datos_update);
    */

        public function actualizar_detalle($id_detalle = FALSE,$arraycampos=NULL)
    {

        $this->db->update($this->tables['memos_detalle'], $arraycampos, array('id_detalle' => $id_detalle));

        $this->set_message('memos_update_successful');

        return 'TRUE';

    }

    /**
	 * valor_maximo
	 *	Obtiene el valor m�ximo de una columna y tabla espec�fica
	 * @return int
	 * @author Diego Ferreira
	 **/
	public function valor_maximo ($tabla = NULL, $columna = NULL, $arraywhere = NULL)
	{
		$this->db->select("MAX(".$columna.") max");

		if ($arraywhere != NULL) {
			foreach ($arraywhere as $k => $v) {

				$this->db->where($k, $v);
			}
		}

		$this->db->from($this->tables[$tabla]);

		return $this->db->get()->row()->max;
	}


	/**
	 * campo_valor_maximo
	 *	Obtiene el valor m�ximo de una columna y tabla espec�fica
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function obtener_valor_campo ($tabla = NULL, $columna = NULL, $arraywhere = NULL)
	{
		$this->db->select($columna." campo");

		foreach ($arraywhere as $k => $v) {

			$this->db->where($k, $v);
		}

		$this->db->from($this->tables[$tabla]);

		return $this->db->get()->row()->campo;
	}

	/**
	 * campo_valor_maximo
	 *	Obtiene el valor m�ximo de una columna y tabla espec�fica
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function campo_valor_maximo ($tabla = NULL, $columna = NULL, $arraywhere = NULL)
	{
		$this->db->select("MAX(".$columna.") max");

		foreach ($arraywhere as $k => $v) {

			$this->db->where($k, $v);
		}

		$this->db->from($this->tables[$tabla]);

		return $this->db->get()->row()->max;
	}

	/**
	 * eliminar_proyecto
	 *	Obtiene el valor m�ximo de una columna y tabla espec�fica
	 * @return int
	 * @author Jaime Rojas
	 **/
    public function eliminar_proyecto($proyecto_id)
    {

        $resultado = $this->db->query("SELECT count (*) cnt from ide.expedientes where id_proyecto =".$proyecto_id.";")->row()->cnt;

        if ($resultado == 0) {
           $this->db->delete($this->tables['proyectos'],array('id_proyecto' => $proyecto_id));
        }
    	
		return $resultado;
    }

	/**
	 * eliminar_licencia
	 *	Obtiene el valor m�ximo de una columna y tabla espec�fica
	 * @return int
	 * @author Jaime Rojas
	 **/
    public function eliminar_licencia($proyecto_id)
    {
    	$this->db->delete($this->tables['declaraciones'],array('decl_proyecto_id' => $proyecto_id));
		return TRUE;
    }

	/**
	 * eliminar_licencia
	 *	Obtiene el valor m�ximo de una columna y tabla espec�fica
	 * @return int
	 * @author Jaime Rojas
	 **/
    public function eliminar_resolucion($proyecto_id)
    {
    	$this->db->delete($this->tables['resoluciones'],array('reso_proyecto_id' => $proyecto_id));
		return TRUE;
    }

    public function departamentos()
    {
    	$this->response = $this->db->get($this->tables['departamentos']);

    	return $this;
    }

    public function distritos()
    {
    	$this->response = $this->db->query("SELECT * FROM INDERT.DISTRITOS ORDER BY DISTRITO");
    	return $this;
    }

	//PAGINATION
    public function get_pagination($number_per_page)
    {
    	if ($this->uri->segment(5) == null | $this->uri->segment(5) == '') {

    		$this->response = $this->db->get($this->tables['geocolonias'],$number_per_page, 0);
    	}else
    	{
    		$this->response = $this->db->get($this->tables['geocolonias'],$number_per_page, $this->uri->segment(5));
    	}

    	return $this;
	}

	public function num_post()
	{
		$number = $this->db->query("SELECT count(*) as number FROM indert.geocolonia")->row()->number; //r�pido
		return intval($number);
	}

	public function v_tipo_moneda()
	{
		$this->response = $this->db->get($this->tables['tipo_moneda']);

		return $this;
	}


	public function mapabb($proyecto_id)
	{


			$i_sql = "select ";
			$i_sql = $i_sql. "round(cast((x.campo1+x.campo1*(0.0002)) as decimal),13) as ext1, ";
			$i_sql = $i_sql. "round(cast((x.campo2+x.campo2*(0.0002)) as decimal),13) as ext2, ";
			$i_sql = $i_sql. "round(cast((x.campo3-x.campo3*(0.0002)) as decimal),13) as ext3, ";
			$i_sql = $i_sql. "round(cast((x.campo4-x.campo4*(0.0002)) as decimal),13) as ext4 ";
			$i_sql = $i_sql. "from ";
			$i_sql = $i_sql. "(";

			$i_sql = $i_sql. "select ";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[1] as decimal) as campo1,";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[2] as decimal) as campo2,";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[3] as decimal) as campo3,";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[4] as decimal) as campo4";
			$i_sql = $i_sql. " from ( ";

			$i_sql = $i_sql . "select ";
            $i_sql = $i_sql . "replace(";
            $i_sql = $i_sql . "replace(substr(cast(a.bb as varchar),5),' ',',')";
            $i_sql = $i_sql . ",')','') as bb ";
            $i_sql = $i_sql . "FROM (select ST_Extent(the_geom) as bb ";
            $i_sql = $i_sql . "from i3geo.MOPC_poligono ";
            $i_sql = $i_sql . "where proyecto_id=" . $proyecto_id . " ";
            $i_sql = $i_sql . "group by proyecto_id) as a) as t1 ";
            //$i_sql = $i_sql . ";";
			$i_sql = $i_sql . ") as x;";

            $response = $this->db->query($i_sql)->result_array();

            return $response;

	}

	public function mensaje_error($id_proyecto = NULL)
	{
		$this->response = $this->db->query("SELECT descrip_error FROM ide.errores where id_proyec=".$id_proyecto.";");
		return $this;
	}


	/**
	 * crear_proyecto
	 *
	 * @return integer
	 * @author Lissy Rojas
	*/
	public function crear_memo($arraycampos = NULL)
	{
		// bail if the group name already exists
		$existe_memo = $this->db->get_where($this->tables['memos'], $arraycampos)->num_rows();

		
		if($existe_memo !== 0)
		{
			$this->ion_auth->set_error('memos_already_exists');
			return FALSE;
		}
		


		// insert the new producto
		$this->db->insert($this->tables['memos'], $arraycampos);
		$memo_id = $this->db->query("SELECT MAX(id_memo) FROM public.memos;")->row()->max;


		//$producto_id = $this->db->insert_id();

		// report success
		$this->ion_auth->set_message('memos_creation_successful');
		// return the brand new group id
		return $memo_id;
	}

	 public function view_detalle($tabla = null, $where = null, $order_by = null)
    {
        $this->trigger_events('memos_detalles');

        $this->response = $this->db->get_where($this->tables[$tabla], $where, null, null, $order_by);

        return $this;
    }

    public function contar_puntos($id_memo=NULL)
    {
        $resultado = $this->db->query("SELECT count (*) cnt from public.memos_detalle where id_memo =".$id_memo.";")->row()->cnt;

        return $resultado;
    }

    public function validar_afectacion_coord($id_memo=NULL,$validacion=NULL)
    {
        //$resultado = $this->db->query("SELECT count (*) cnt from public.memos_detalle where id_memo =".$id_memo." AND validacion=".$validacion.";")->row()->cnt;
        $resultado = $this->db->query("SELECT count (*) cnt from public.memos_detalle where id_memo =".$id_memo.";")->row()->cnt;

        return $resultado;
    }


    public function eliminar_detalle($id_detalle = NULL)
    {

        $resultado_off = $this->db->query("delete from memos_detalle where id_detalle = ".$id_detalle);
        $resultado = $this->db->query("SELECT count (*) cnt from memos_detalle where id_detalle =".$id_detalle.";")->row()->cnt;

        return $resultado;
    }

}
