<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Distritos_model extends Ion_auth_model {
	
	public function __construct()
	{
		parent::__construct();
	}
	
	/**
	 * geocolonias
	 *
	 * @return object
	 * @author Ben Edmunds
	 **/
	public function distritos_all()
	{
		$this->trigger_events('distritos');

		// run each where that was passed
		
		if (isset($this->_ion_where) && !empty($this->_ion_where))
		{
			foreach ($this->_ion_where as $where)
			{
				$this->db->where($where);
			}
			$this->_ion_where = array();
		}

		if (isset($this->_ion_limit) && isset($this->_ion_offset))
		{
			$this->db->limit($this->_ion_limit, $this->_ion_offset);

			$this->_ion_limit  = NULL;
			$this->_ion_offset = NULL;
		}
		else if (isset($this->_ion_limit))
		{
			$this->db->limit($this->_ion_limit);

			$this->_ion_limit  = NULL;
		}

		// set the order
		if (isset($this->_ion_order_by) && isset($this->_ion_order))
		{
			$this->db->order_by($this->_ion_order_by, $this->_ion_order);
		}



		$this->response = $this->db->get($this->tables['distritos']);
		
		return $this;
	}

	/**
	 * geocolonia
	 *
	 * @return object
	 * @author Ben Edmunds
	 **/
	public function distritos_unique($id = NULL)
	{
		$this->trigger_events('distritos');

		if (isset($id))
		{
			$this->where($this->tables['distritos'].'.gid', $id);
		}

		$this->limit(1);
		//$this->order_by('gid', 'col_desc');

		return $this->distritos_all();
	}

	/**
	 * create_geocolonia
	 *
	 * @author aditya menon
	*/
	public function get_vistas ($dpto = ''){
		$dpto_desc = $this->db->get_where($this->tables['departamentos'], array('dpto' => $dpto));
		return $dpto_desc;
	}

	public function create_distritos($dpto = '', $dpto_desc = '', $distrito = '', $dist_desc = '', $additional_data = array())
	{
		// bail if the dpto_cod was not passed ** Se utiliza la etiqueta de lenguaje spanish
		if(!$dpto)
		{
			$this->set_error('distritos_dpto_required');
			return FALSE;
		}
		// bail if the dist_cod was not passed
		/*if(!$dpto_desc)
		{
			$this->set_error('distritos_dpto_desc_required');
			return FALSE;
		}*/
		if(!$distrito)
		{
			$this->set_error('distritos_distrito_required');
			return FALSE;
		}
		// bail if the dist_cod was not passed
		if(!$dist_desc)
		{
			$this->set_error('distritos_distrito_desc_required');
			
			return FALSE;
		}
		// bail if the group name already exists
		$existing_distritos = $this->db->get_where($this->tables['distritos'], array('distrito' => $distrito))->num_rows();
		
		if($existing_distritos !== 0)
		{
			$this->set_error('distritos_no_exists');
			
			return FALSE;
		}

		//$dpto_desc = $this->db->query("SELECT dpto_desc FROM INDERT.DPTO WHERE DPTO = '".$dpto."'");
		//$dpto_desc = $descrip->dpto_desc;
		$data = array('dpto'=>$dpto, 'dpto_desc'=>$dpto_desc, 'distrito'=>$distrito, 'dist_desc'=>$dist_desc);
		
		// filter out any data passed that doesnt have a matching column in the groups table
		// and merge the set group data and the additional data
		if (!empty($additional_data)) $data = array_merge($this->_filter_data($this->tables['distritos'], $additional_data), $data);

		$this->trigger_events('extra_distrito_set');

		// insert the new group
		$this->db->insert($this->tables['distritos'], $data);
		$gid = $this->db->insert_id();

		// report success
		$this->set_message('distritos_creation_successful');
		// return the brand new group id
		return $gid;

	}
	
	/**
	 * update_gepcolonia
	 *
	 * @return bool
	 * @author aditya menon
	 **/

	public function update_distritos($gid = FALSE, $dpto = FALSE, $distrito = FALSE, $dist_desc = FALSE, $additional_data = array())
	{
		//if (empty($id)) return FALSE;

		if (empty($gid) AND empty($dpto) AND empty($distrito) AND empty($dist_desc)) return FALSE;

		$data = array();

		//if (!empty($distrito))

		if (!empty($gid) AND !empty($dpto) AND !empty($distrito) AND !empty($dist_desc))
		{
			// we are changing the col_desc, so do some checks

			// bail if the geocolonia col_desc already exists
			$existing_distritos = $this->db->get_where($this->tables['distritos'], array('dpto' => $dpto, 'distrito' => $distrito, 'dist_desc' => $dist_desc))->row();
			if(isset($existing_distritos->gid) && $existing_distritos->gid != $gid)
			{
				$this->set_error('distritos_no_exists');
				return FALSE;
			}
			/*
			if (strlen($geocolonia_dpto_cod) > 2) 
			{
				$this->set_error('geocolonia_already_exists');
				return FALSE;
			}
			*/
			
			$data['dpto']		 	= $dpto;
			$data['distrito']		= $distrito;
			$data['dist_desc'] 		= $dist_desc;
		}

		// restrict change of name of the admin group
		$distrito = $this->db->get_where($this->tables['distritos'], array('gid' => $gid))->row();
		
		// IMPORTANT!! Third parameter was string type $description; this following code is to maintain backward compatibility
		// New projects should work with 3rd param as array
		if (is_string($additional_data)) $additional_data = array('distrito' => $additional_data);


		// filter out any data passed that doesnt have a matching column in the groups table
		// and merge the set group data and the additional data
		if (!empty($additional_data)) $data = array_merge($this->_filter_data($this->tables['distritos'], $additional_data), $data);


		$this->db->update($this->tables['distritos'], $data, array('gid' => $gid));

		$this->set_message('distritos_update_successful');

		return TRUE; 
	}
	
	public function num_filas () { 
	
		$number = $this->db->query("SELECT count(*) as number FROM distritos")->row()->number; //rápido
		return intval($number);
	
	}

	public function get_pagination ($number_per_page) {
	
		return $this->db->get("distritos",$number_per_page, $this->uri->segment(3));
	
	}

	public function departamentos()
	{
		$this->response = $this->db->get($this->tables['departamentos']);

		return $this;
	}
	public function delete_distrito($gid){

		$this->db->delete($this->tables['distritos'], array('gid' => $gid));

		return TRUE;

	}
}