<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Mantenimiento extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('users/users_model');
		$this->lang->load('users/users_lang');

		/* Titulo de la pagina :: Common */
		$this->page_title->push(lang('menu_users'));
		$this->data['pagetitle'] = $this->page_title->show();
		$this->load->helper('download');

		//verificación de módulo para el reset de las variables de sessión utilizadas en la misma
		if ($_SESSION['id_modulo'] != 'USERS') {

			$_SESSION['arraywhere_users'] 		 = NULL;
			$_SESSION['arraywhere_users_busqueda'] = NULL;
			$_SESSION['id_modulo'] = 'USERS';
		}   
		
		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_users'), 'users/users');
	}

	public function expe_mantenimiento($user_id)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{	
			/* Breadcrumbs */
	        $this->breadcrumbs->unshift(2, 'Mantenimiento', 'users/users');
	        $this->data['breadcrumb'] = $this->breadcrumbs->show();

	        $exp_datos = $this->users_model->view('users', array('id' => $user_id))->row();

	        $user_id_user 	= $exp_datos->user_id_user;
	        $user_gestion			= $exp_datos->user_gestion;
	        $user_estado			= $exp_datos->user_estado;
	        $user_tipo_ref			= $exp_datos->user_tipo_ref;
	        $user_tipo_dictamen		= $exp_datos->user_tipo_dictamen;
	        $user_id_imagen1		= $exp_datos->user_id_imagen1;
	        $user_id_imagen2		= $exp_datos->user_id_imagen2;
	        $user_id_imagen3		= $exp_datos->user_id_imagen3;
	        $user_id_imagen4		= $exp_datos->user_id_imagen4;
	        $user_dictamen			= $exp_datos->user_dictamen;

	        //$_SESSION['archivo_shp'] = "/intercambio/uso_actual.*";
	        
			$user_info  = $this->users_model->view('v_exp01', array('user_id' => $user_id))->result_array();
			
			$user_info[0]["user_tipo_ref_desc"] = $this->users_model->obtener_valor_campo('conceptos', 'nombre' , array('tipoconcepto' => 'TIPO_REF', 'concepto' => $expe_info[0]["user_tipo_ref"]));

			$user_info[0]["user_estado_desc"] = $this->users_model->obtener_valor_campo('conceptos', 'nombre', array('tipoconcepto' => 'EXPE_ESTADO', 'concepto' => $user_info[0]["user_estado"]));

//echo $expe_info[0]["expe_tipo_ref_desc"];
//show_error('TEMPORALMENTE INACTIVO');

			/************* CANTIDAD DATOS GRAFICOS ****************/
			$datos_graficos[0]['MOPC_POLIGONO']		= $this->users_model->contador_registros('MOPC_POLIGONO', array('user_id' => $user_id));
			$datos_graficos[0]['MOPC_UACTUAL']		= $this->users_model->contador_registros('MOPC_UACTUAL', array('user_id' => $user_id));
			$datos_graficos[0]['MOPC_UALTER']		= $this->users_model->contador_registros('MOPC_UALTER', array('user_id' => $user_id));
			$datos_graficos[0]['MOPC_U86']			= $this->users_model->contador_registros('MOPC_U86',  array('user_id' => $user_id));
			$datos_graficos[0]['MOPC_U04']			= $this->users_model->contador_registros('MOPC_U04',  array('user_id' => $user_id));
			$datos_graficos[0]['MOPC_TSUELO']		= $this->users_model->contador_registros('MOPC_TSUELO', array('user_id' => $user_id));
			$datos_graficos[0]['MOPC_FINCAS']		= $this->users_model->contador_registros('MOPC_FINCAS', array('user_id' => $user_id));
			$datos_graficos[0]['MOPC_CAP_SUELO']	= $this->users_model->contador_registros('MOPC_CAP_SUELO', array('user_id' => $user_id));
			$datos_graficos[0]['MOPC_CLA_ECO']		= $this->users_model->contador_registros('MOPC_CLA_ECO', array('user_id' => $user_id));
			$datos_graficos[0]['MOPC_COMP_DEF']		= $this->users_model->contador_registros('MOPC_COMP_DEF', array('user_id' => $user_id));
			$datos_graficos[0]['MOPC_DEF_BOS']		= $this->users_model->contador_registros('MOPC_DEF_BOS', array('user_id' => $user_id));
			$datos_graficos[0]['MOPC_PROP_CERT']	= $this->users_model->contador_registros('MOPC_PROP_CERT', array('user_id' => $user_id));
			/************* FIN CANTIDAD DATOS GRAFICOS ****************/

			$this->data['user_info'] 		= $user_info;

			$this->data['datos_graficos'] 	= $datos_graficos;

			$this->data['user_id_user'] = array(
				'type'     => 'hidden',
				'name'     => 'user_id_user',
				'id'       => 'user_id_user',
				'value'    => $user_id_user
			);
			$this->data['expe_gestion'] = array(
				'type'     => 'hidden',
				'name'     => 'user_gestion',
				'id'       => 'user_gestion',
				'value'    => $expe_gestion
			);
			$this->data['user_id'] = array(
				'type'     => 'hidden',
				'name'     => 'user_id',
				'id'       => 'user_id',
				'value'    => $user_id
			);
			$this->data['expe_estado'] = array(
				'type'     => 'hidden',
				'name'     => 'user_estado',
				'id'       => 'user_estado',
				'value'    => $user_estado
			);
			$this->data['expe_tipo_ref'] = array(
				'type'     => 'hidden',
				'name'     => 'user_tipo_ref',
				'id'       => 'user_tipo_ref',
				'value'    => $user_tipo_ref
			);	


			$tipo_dictamens[''] = 'Seleccione la Tipo Dictamen';
			$tipo_dictamen = $this->users_model->dropdown_data('conceptos',array('tipoconcepto' => 'TIPO_DICTAMEN'))->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($tipo_dictamen as $dic) {
				$tipo_dictamens[$dic['concepto']] = $dic['concepto'].' - '.$dic['nombre'];
			}
			$this->data['user_tipo_dictamen'] = $tipo_dictamens;
			$this->data['user_tipo_dictamen_sel'] = $user_tipo_dictamen;


			$imagen1s[''] = 'Seleccione mapfile';
			$imagen1 = $this->users_model->dropdown_data('imagenes','','imgn_id_imagen')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($imagen1 as $img) {
				$imagen1s[$img['imgn_id_imagen']] = $img['imgn_id_imagen'].' - '.$img['imgn_codigo'];
			}
			$this->data['user_id_imagen1'] 	= $imagen1s;
			$this->data['user_id_imagen1_sel'] = $user_id_imagen1;


			$imagen2s[''] = 'Seleccione mapfile';
			$imagen2 = $this->users_model->dropdown_data('imagenes','','imgn_id_imagen')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($imagen2 as $img) {
				$imagen2s[$img['imgn_id_imagen']] = $img['imgn_id_imagen'].' - '.$img['imgn_codigo'];
			}
			$this->data['user_id_imagen2'] 	= $imagen2s;
			$this->data['user_id_imagen2_sel'] = $user_id_imagen2;


			$imagen3s[''] = 'Seleccione mapfile';
			$imagen3 = $this->users_model->dropdown_data('imagenes','','imgn_id_imagen')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($imagen3 as $img) {
				$imagen3s[$img['imgn_id_imagen']] = $img['imgn_id_imagen'].' - '.$img['imgn_codigo'];
			}
			$this->data['user_id_imagen3'] 	= $imagen3s;
			$this->data['user_id_imagen3_sel'] = $user_id_imagen3;


			$imagen4s[''] = 'Seleccione mapfile';
			$imagen4 = $this->users_model->dropdown_data('imagenes','','imgn_id_imagen')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($imagen4 as $img) {
				$imagen4s[$img['imgn_id_imagen']] = $img['imgn_id_imagen'].' - '.$img['imgn_codigo'];
			}
			$this->data['user_id_imagen4'] 	= $imagen4s;
			$this->data['user_id_imagen4_sel'] = $user_id_imagen4;


			$this->data['user_dictamen'] = array(
				'type'     => 'text',
				'name'     => 'user_dictamen',
				'id'       => 'user_dictamen', 
				'style'	   => 'height: 200px',
				'value'    => $this->form_validation->set_value('expe_dictamen', $user_dictamen),
				'class'    => 'form-control'
			);


			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ?
				$this->ion_auth->errors() : $this->session->flashdata('message')));
	        
			/* Load Template */
            $this->template->admin_render('users/Mantenimiento', $this->data);
		}
	}


	public function eliminar_geometrias($exp = NULL, $gest = NULL, $user_id = NULL)
	{
		//show_error('AÚN NO PUEDE ELIMINAR GEOMETRÍAS');

        
		$resultado = $this->users_model->eliminar_geometrias($exp,$gest,$user_id);

		//if (condition) {
		//	# code...
		//}
		$this->session->set_flashdata('message', 'LOS DATOS ESPACIALES SE ELIMINARON!');
		redirect('users/Mantenimiento/expe_mantenimiento/'.$user_id);
		
	}

	public function download_expe($exp = NULL, $gest = NULL, $user_id = NULL)
	{

        exec('cmd /c "C:\espacio_trabajo\exp_tabla_a_shp.bat sge 2l2f1nt22022i '.trim($user_id).'"');	

        $download_file = "user".$user_id.".zip";

		if ( ! empty($download_file)) {
        	//If you want to download an existing file from your server you'll need to read the file into a string
        	$data = file_get_contents(base_url("/download/".$download_file)); // Read the file's contents
        	$name = $download_file;
        	force_download($name, $data);
    	}

		redirect('users/Mantenimiento/user_mantenimiento/'.$user_id);
		
	}

	public function importar_shapes()
	{

		if (empty($_FILES['shapes']['name'][0])) {
			$this->session->set_flashdata('message', '¡PRIMERO SELECCIONE LA CARPETA!');
			redirect('users/mantenimiento/expe_mantenimiento/'.$_POST['user_id']);
		}

		$id_user 	= $_POST['user_id_user'];
		$gestion 		= $_POST['user_gestion'];
		$user_id 		= $_POST['user_id'];
		$expe_estado 	= $_POST['user_estado'];



		$accion = 0;	
		if (isset($_POST['accion'])){
			$accion = intval($_POST['accion']);
		}else{
			$accion = 0;
		}		


		// pregunta sin existen datos graficos del user.
		$expe = $this->users_model->existe_grafico_user_id($user_id)->row()->f_existe_grafico;

		if ($expe>0) {
			$this->session->set_flashdata('message', 'EL EXPEDIENTE YA TIENE DATOS ESPACIALES!');
			redirect('users/mantenimiento/expe_mantenimiento/'.$_POST['user_id']);
		}
		else { 		


			exec('cmd /c "'.trim('md C:\espacio_trabajo\ ').trim($user_id).'"');		

			//echo 'user_id: '.$user_id;
			//show_error('TEMPORALMENTE INACTIVO');

			$ruta_dest = trim('C:\espacio_trabajo\ ').trim($user_id).trim('\ ');

			$i = 0;
			while (isset($_FILES['shapes']['name'][$i])) {

				switch (substr($_FILES['shapes']['name'][$i],-3)) {
					case 'dbf':

						$nomdbf = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest.$nomdbf);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;		
						break;

					case 'shp':

						$nomshp = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest.$nomshp);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;
						break;

					case 'shx':

						$nom_i = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest . $_FILES['shapes']['name'][$i]);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;
						break;
					
					default:
						$i = $i + 1;
						break;			

				}
			}				
			
			$id_epsg = 32721;
			if ($accion==1) {
				$id_epsg = 32721;
			} elseif ($accion == 2) { 	
				$id_epsg = 32720;
			} elseif ($accion == 3) { 	
				$id_epsg = 4326;
			} else  { 	
				$id_epsg = 32721;
			}

			exec('cmd /c "C:\espacio_trabajo\imp_shp_a_tabla.bat '.trim($user_id).' '.$id_epsg.'"');				

			//echo 'user_id: '.$user_id;
			//show_error('TEMPORALMENTE INACTIVO');

			$actu = $this->users_model->actualizar_shapes($id_user, $gestion, $user_id, $id_epsg)->row()->actualizar_shapes;

			if ($actu>0) {
				$this->session->set_flashdata('message', 'NO importo!!');
				redirect('users/mantenimiento/user_mantenimiento/'.$_POST['user_id']);
			}
			else { 	
				$this->session->set_flashdata('message', '<h3>¡IMPORTADOS! </h3> <h3>¡IMPORTADOS! </h3> <h3>¡IMPORTADOS! </h3> ');		

				redirect('users/mantenimiento/user_mantenimiento/'.$_POST['user_id']);

			}
		}
	}

	public function verparcela ($user_id , $user_gest) {
	
        	$i_jameuge = "http://181.120.125.178:8065/jmap/index.html?exp=" . $user_id;
        	$i_jameuge = $i_jameuge . "&gest=" . $user_gest;

			redirect($i_jameuge);
	}



	public function actualizar_dictamen()
	{


		$id_user 	= $_POST['user_id_user'];
		$gestion 		= $_POST['user_gestion'];
		$user_id 		= $_POST['user_id'];
		$user_estado 	= $_POST['user_estado'];



		$user_tipo_dictamen 	= $_POST['user_tipo_dictamen'];
		$user_id_imagen1 		= $_POST['user_id_imagen1'];
		$user_id_imagen2 		= $_POST['user_id_imagen2'];
		$user_id_imagen3 		= $_POST['user_id_imagen3'];
		$user_dictamen 			= $_POST['user_dictamen'];


        $datos_update['user_tipo_dictamen'] = $_POST['user_tipo_dictamen'];
        $datos_update['user_id_imagen1'] 	= $_POST['user_id_imagen1'];
        $datos_update['user_id_imagen2'] 	= $_POST['user_id_imagen2'];
        $datos_update['user_id_imagen3'] 	= $_POST['user_id_imagen3'];
        $datos_update['user_dictamen'] 		= $_POST['user_dictamen'];

		$accion = 0;	
		if (isset($_POST['accion'])){
			$accion = intval($_POST['accion']);
		}else{
			$accion = 0;
		}		


		// pregunta sin existen datos graficos del user.
		$cnt_grafico = $this->users_model->f_existe_grafico_user_id($user_id);


		//echo($cnt_licencia);
		//show_error(1);

		if ($cnt_grafico=0) {
			$this->session->set_flashdata('message', 'Expediente sin Datos espaciales!!');
			redirect('users/mantenimiento/expe_mantenimiento/'.$_POST['user_id']);
		}
		else { 		

			$actu = $this->users_model->actualizar_dictamen($user_id, $datos_update);	
			
			$this->session->set_flashdata('message', 'Actualizacion Realizada!');

			if ($actu) {
				$this->session->set_flashdata('message', '¡Actualización Realizada!');
				redirect('users/mantenimiento/expe_mantenimiento/'.$_POST['user_id']);
			}
			else { 	
				$this->session->set_flashdata('message', '¡No actualizo!');		
				redirect('users/mantenimiento/user_mantenimiento/'.$_POST['user_id']);
			}
		}
	}

	public function imprimirdictamen ($user_id = NULL , $user_tipo_dictamen = NULL) {
	
		$bbox = $this->users_model->mapabb($user_id);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
			if ($user_tipo_dictamen)
			{
				if ($user_tipo_dictamen)
				{
					if ($user_tipo_dictamen == 'D2')
					{
			        	$i_jameuge = "http://181.120.125.178:8062/i3geo/ferramentas/imprimir/Mapa_A3_MOPC_dictamen2.php?";
			        	$i_jameuge = $i_jameuge . "&user_id=" . $user_id;
			        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
			        	
						redirect($i_jameuge);
					}
					else
					{
			        	$i_jameuge = "http://181.120.125.178:8062/i3geo/ferramentas/imprimir/Mapa_A3_MOPC_dictamen3.php?";
			        	$i_jameuge = $i_jameuge . "&user_id=" . $user_id;
			        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
			        	
						redirect($i_jameuge);
					}
				}
			}
		}
		else
		{
			//$this->session->set_flashdata('message', $this->ion_auth->errors());
			$this->session->set_flashdata('message', 'No tiene datos graficos!');
			redirect('users/mantenimiento/user_mantenimiento/'.$user_id);
		}
	}
}