<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Carga_masiv_fotos extends Admin_Controller {

    public function __construct()
    {
        parent::__construct();

        $this->load->model('herramientas/tool/tool_model');
        $this->lang->load('colonias/colonias_lang');

        /* Title Page :: Common */
        $this->page_title->push('Carga Masiva de Fotos');
        $this->data['pagetitle'] = $this->page_title->show();
        if ($_SESSION['id_modulo'] != 'CARGA_FOTOS') {
            $_SESSION['id_modulo'] = 'CARGA_FOTOS';
            $_SESSION['carga_masiv_error'] = NULL;
        }


        /* Breadcrumbs :: Common */
        $this->breadcrumbs->unshift(1, 'Carga Masiva de Fotos', 'admin/reg01');
    }

    public function index()
    {
        $_SESSION['errores_cuestionario'] = NULL;

        if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
        {
            redirect('auth', 'refresh');
        }
        
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        $this->session->set_flashdata('message','');

        if (!empty($_FILES)) {

            //show_error(1);
            
            //obtiene los codigos de dpto, distrito y colonia elegida por el usuario
            $dpto_cod   = $_POST['dpto'];
            $dist_cod   = $_POST['dist'];
            $col_cod    = $_POST['col_cod'];

            if (!$dpto_cod || !$dist_cod || !$col_cod) {
                $_SESSION['carga_masiv_error'] = '<b>¡Primero debe elegir el Departamento, el Distrito y la Colonia!</b>';
                redirect('herramientas/carga_masiv_fotos/carga_masiv_fotos/index');
            }

            $i          = 0;
            $cntok      = 0;
            $cnterror   = 0;
            $estado     = 0;
            
            while (isset($_FILES['fotos_cuest']['name'][$i])) {

                $archivo_temporal = $_FILES['fotos_cuest']['tmp_name'][$i];
                $nombre_archivo   = $_FILES['fotos_cuest']['name'][$i];
                
                $dpto_file       = ltrim(substr($nombre_archivo, 4,2), '0');
                if (!is_numeric($dpto_file)) {
                    $dpto_file = 0;
                }

                $distrito_file   = ltrim(substr($nombre_archivo, 6,2), '0');
                if (!is_numeric($distrito_file)) {
                    $distrito_file = 0;
                }

                $barrio_file     = ltrim(substr($nombre_archivo, 8,3), '0');
                if (!is_numeric($barrio_file)) {
                    $barrio_file = 0;
                }

                $colonia_file    = ltrim(substr($nombre_archivo, 11,3), '0');
                if (!is_numeric($colonia_file)) {
                    $colonia_file = 0;
                }
                $area_file       = ltrim(substr($nombre_archivo, 14,1), '0');
                if (!is_numeric($area_file)) {
                    $area_file = 0;
                }

                $ae_file         = ltrim(substr($nombre_archivo, 15,3), '0');
                if (!is_numeric($ae_file)) {
                    $ae_file = 0;
                }

                $manzana_file    = ltrim(substr($nombre_archivo, 18,7), '0');
                $lote_a_file     = ltrim(substr($nombre_archivo, 25,6), '0');
                $lote_b_file     = ltrim(substr($nombre_archivo, 31,6), '0');

                $cuest_file      = ltrim(substr($nombre_archivo, 37,3), '0');
                if (!is_numeric($cuest_file)) {
                    $cuest_file = 0;
                }

                if ($dpto_cod != $dpto_file || $dist_cod != $distrito_file || $col_cod != $colonia_file) {
                    $estado     = 3;
                    $cnterror   = $cnterror + 1;
                }else{
                    $cuest = $this->tool_model->view('reg01', array('dpto'      => $dpto_file,
                                                                    'distrito'  => $distrito_file,
                                                                    'colonia'   => $colonia_file,
                                                                    'manzana'   => $manzana_file,
                                                                    'lote_a'    => $lote_a_file,
                                                                    'lote_b'    => $lote_b_file,
                                                                    'cuest'     => $cuest_file)
                                                                    
                                                    )->row();

                    if ($cuest) {
                        $estado         = 1;
                        $dpto_reg       = str_pad($cuest->dpto,     2, '0', STR_PAD_LEFT);
                        $distrito_reg   = str_pad($cuest->distrito, 2, '0', STR_PAD_LEFT);
                        $barrio_reg     = str_pad($cuest->barrio,   3, '0', STR_PAD_LEFT);
                        $colonia_reg    = str_pad($cuest->colonia,  3, '0', STR_PAD_LEFT);
                        $area_reg       = str_pad($cuest->area,     1, '0', STR_PAD_LEFT);
                        $ae_reg         = str_pad($cuest->ae,       3, '0', STR_PAD_LEFT);
                        $manzana_reg    = str_pad($cuest->manzana,  7, '0', STR_PAD_LEFT);
                        $lote_a_reg     = str_pad($cuest->lote_a,   6, '0', STR_PAD_LEFT);
                        $lote_b_reg     = str_pad($cuest->lote_b,   6, '0', STR_PAD_LEFT);
                        $finca_reg      = str_pad($cuest->finca,    5, '0', STR_PAD_LEFT);
                        $padron_reg     = str_pad($cuest->padron,   5, '0', STR_PAD_LEFT);
                        $cuest_reg      = str_pad($cuest->cuest,    3, '0', STR_PAD_LEFT);
                    }else{
                        $estado         = 2;
                        $cnterror       = $cnterror + 1;
                        $dpto_reg       = str_pad($dpto_file,     2, '0', STR_PAD_LEFT);
                        $distrito_reg   = str_pad($distrito_file, 2, '0', STR_PAD_LEFT);
                        $barrio_reg     = str_pad($barrio_file,   3, '0', STR_PAD_LEFT);
                        $colonia_reg    = str_pad($colonia_file,  3, '0', STR_PAD_LEFT);
                        $area_reg       = str_pad($area_file,     1, '0', STR_PAD_LEFT);
                        $ae_reg         = str_pad($ae_file,       3, '0', STR_PAD_LEFT);
                        $manzana_reg    = str_pad($manzana_file,  7, '0', STR_PAD_LEFT);
                        $lote_a_reg     = str_pad($lote_a_file,   6, '0', STR_PAD_LEFT);
                        $lote_b_reg     = str_pad($lote_b_file,   6, '0', STR_PAD_LEFT);
                        $finca_reg      = '00000';
                        $padron_reg     = '00000';
                        $cuest_reg      = str_pad($cuest_file,    3, '0', STR_PAD_LEFT);    
                    }
                }

                $arraycampos = array('id_registro_lote' => $dpto_reg.$distrito_reg.$barrio_reg.$colonia_reg.$area_reg.$ae_reg.$manzana_reg.$lote_a_reg.$lote_b_reg.$finca_reg.$padron_reg.$cuest_reg,
                   'dpto'             => $dpto_reg,
                   'distrito'         => $distrito_reg,
                   'barrio'           => $barrio_reg,
                   'colonia'          => $colonia_reg,
                   'area'             => $area_reg,
                   'ae'               => $ae_reg,
                   'manzana'          => $manzana_reg,
                   'lote_a'           => $lote_a_reg,
                   'lote_b'           => $lote_b_reg,
                   'finca'            => $finca_reg,
                   'padron'           => $padron_reg,
                   'cuest'            => $cuest_reg,
                   'c_tipo_objeto'    => '2',
                   'descrip_objeto'   => ' ',
                   'codigo_objeto'    => "'".$nombre_archivo."'",
                   'image'            => $archivo_temporal,
                   'r_dpto'           => $dpto_cod,
                   'r_distrito'       => $dist_cod,
                   'r_colonia'        => $col_cod,
                   'estado'           => $estado);

                
    
                $importar = $this->tool_model->importar_foto($arraycampos);

                if ($importar) {
                    $cntok = $cntok + 1;
                }
    
                $this->session->set_flashdata('message', '¡Fichero subido con éxito!');
                
                $i = $i + 1;
            }

            $_SESSION['carga_masiv_error'] = "<b>Cantidad de fotos subidas: </b>" . $cntok . "<b> de </b>" . $i . ".<br><br><b>Con erróres: </b>" . $cnterror;

            redirect('herramientas/carga_masiv_fotos/carga_masiv_fotos/index');
        }

        $dptos[''] = 'Seleccione el departamento';
        $departamentos = $this->tool_model->dropdown_data('departamentos')->result_array();
        //inserta en un array asociativo para poder utilizarlo en el form_dropdown
        foreach ($departamentos as $dpto) {
            $dptos[$dpto['dpto']] = $dpto['dpto'].' - '.$dpto['dpto_desc'];
        }
        $this->data['departamentos'] = $dptos;


        $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

        $this->template->admin_render('herramientas/carga_masiv_fotos', $this->data);
    }

    public function trae_distritos()
    {
        $dpto      = $_POST['dpto_cod'];

        $distritos = $this->tool_model->dropdown_data('distritos',array('dpto' => $dpto), 'distrito')->result();

        echo '<option value="">Seleccione el distrito</option>';
        foreach ($distritos as $value) {
            echo '<option value="' . $value->distrito . '">' . $value->distrito . ' - ' . $value->dist_desc . '</option>';
        }
    }

    public function trae_colonia()
    {
        $dpto      = $_POST['dpto_cod'];
        $distrito  = $_POST['dist_cod'];

        $colonias = $this->tool_model->dropdown_data('colonias',array('dpto_cod' => $dpto, 'dist_cod' => $distrito), 'col_cod')->result();

        echo '<option value="">Seleccione la colonia</option>';
        foreach ($colonias as $value) {
            echo '<option value="' . $value->col_cod . '">' . $value->col_cod . ' - ' . $value->col_desc . '</option>';
        }
    }
}