<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Geocolonias extends Admin_Controller {

    public function __construct()
    {
        parent::__construct();

        $this->lang->load('admin/geocolonias');

        /* Title Page :: Common */
        $this->page_title->push(lang('menu_geocolonias'));
        $this->data['pagetitle'] = $this->page_title->show();

        /* Breadcrumbs :: Common */
        $this->breadcrumbs->unshift(1, lang('menu_geocolonias'), 'admin/geocolonias');
    }


	public function index()
	{
        if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
        {
            redirect('auth/login', 'refresh');
        }
        else
        {
            /* Breadcrumbs */
            $this->data['breadcrumb'] = $this->breadcrumbs->show();

            $this->data['geocolonias'] = $this->ion_auth->geocolonias()->result();

            /* Load Template */
            $this->template->admin_render('admin/geocolonias/index', $this->data);
        }
    }


	public function create()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_geocolonias'), 'admin/geocolonias/create');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Validate form input */
		$this->form_validation->set_rules('col_desc', 'lang:create_geocolonia_validation_name_label', 'required|alpha_dash');

		if ($this->form_validation->run() == TRUE)
		{
			$new_geocolonia_id = $this->ion_auth->create_geocolonia($this->input->post('dpto_cod'), $this->input->post('dist_cod'), $this->input->post('col_cod'), $this->input->post('id_codgeo'), $this->input->post('col_desc'));
			if ($new_geocolonia_id)
			{
				$this->session->set_flashdata('message', $this->ion_auth->messages());
				redirect('admin/geocolonias', 'refresh');
			}
		}
		else
		{
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
	
			$this->data['dpto_cod'] = array(
				'name'  => 'dpto_cod',
				'id'    => 'dpto_cod',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->form_validation->set_value('dpto_cod')
			);
			$this->data['dist_cod'] = array(
				'name'  => 'dist_cod',
				'id'    => 'dist_cod',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->form_validation->set_value('dist_cod')
			);
			$this->data['col_cod'] = array(
				'name'  => 'col_cod',
				'id'    => 'col_cod',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->form_validation->set_value('col_cod')
			);
			$this->data['id_codgeo'] = array(
				'name'  => 'id_codgeo',
				'id'    => 'id_codgeo',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->form_validation->set_value('id_codgeo')
			);
			$this->data['col_desc'] = array(
				'name'  => 'col_desc',
				'id'    => 'col_desc',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->form_validation->set_value('col_desc')
			);
            /* Load Template */
            $this->template->admin_render('admin/geocolonias/create', $this->data);
		}
	}


	public function delete()
	{
        if ( ! $this->ion_auth->logged_in())
        {
            redirect('auth/login', 'refresh');
        }
        elseif ( ! $this->ion_auth->is_admin())
		{
            return show_error('You must be an administrator to view this page.');
        }
        else
        {
            $this->load->view('admin/geocolonias/delete');
        }
	}


	public function edit($id)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin() OR ! $id OR empty($id))
		{
			redirect('auth', 'refresh');
		}

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_geocolonias_edit'), 'admin/geocolonias/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Variables */
		$geocolonia = $this->ion_auth->geocolonia($id)->row();

		/* Validate form input */
        //$this->form_validation->set_rules('geocolonia_col_desc', $this->lang->line('edit_geocolonia_validation_name_label'), 'required|alpha_dash');
		//$this->form_validation->set_rules('password', $this->lang->line('edit_user_validation_password_label'), 'required|min_length[' . $this->config->item('min_password_length', 'ion_auth') . ']|max_length[' . $this->config->item('max_password_length', 'ion_auth') . ']|matches[password_confirm]');
		$this->form_validation->set_rules('geocolonia_dpto_cod', $this->lang->line('edit_geocolonia_validation_name_label'), 'required|is_numeric|min_length[2]|max_length[2]');
		$this->form_validation->set_rules('geocolonia_dist_cod', $this->lang->line('edit_geocolonia_validation_name_label'), 'required|is_numeric|min_length[2]|max_length[2]');
		$this->form_validation->set_rules('geocolonia_col_cod', $this->lang->line('edit_geocolonia_validation_name_label'), 'required|is_numeric|max_length[3]');
        $this->form_validation->set_rules('geocolonia_col_desc', $this->lang->line('edit_geocolonia_validation_name_label'), 'required');
		//$this->form_validation->set_rules('geocolonia_id_codgeo', $this->lang->line('edit_geocolonia_validation_name_label'), 'required');
		$this->form_validation->set_rules('geocolonia_id_codgeo', $this->lang->line('edit_geocolonia_validation_name_label'), 'required|is_numeric|min_length[7]|max_length[7]');

		
		if (isset($_POST) && ! empty($_POST))
		{
			if ($this->form_validation->run() == TRUE)
			{
				$geocolonia_update = $this->ion_auth->update_geocolonia($id, $_POST['geocolonia_dpto_cod'], $_POST['geocolonia_dist_cod'], $_POST['geocolonia_col_cod'], $_POST['geocolonia_id_codgeo'], $_POST['geocolonia_col_desc']);

				if ($geocolonia_update)
				{
					$this->session->set_flashdata('message', $this->lang->line('edit_geocolonia_saved'));

                    /* IN TEST */
                    //$this->db->update('geocolonias', array('bgcolor' => $_POST['geocolonia_bgcolor']), 'id = '.$id);
				}
				else
				{
					$this->session->set_flashdata('message', $this->ion_auth->errors());
				}

				redirect('admin/geocolonias', 'refresh');
			}
		}

        $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
        $this->data['geocolonia']   = $geocolonia;

		$readonly = $this->config->item('admin_group', 'ion_auth') === $geocolonia->col_desc ? 'readonly' : '';

		
/*
'dpto_cod';
'dist_cod';
'col_cod';
'id_codgeo';
'col_desc';
*/		
		
		$this->data['geocolonia_dpto_cod'] = array(
			'type'    => 'text',
			'name'    => 'geocolonia_dpto_cod',
			'id'      => 'geocolonia_dpto_cod',
			'value'   => $this->form_validation->set_value('geocolonia_dpto_cod', $geocolonia->dpto_cod),
            'class'   => 'form-control',
			$readonly => $readonly
		);
		$this->data['geocolonia_dist_cod'] = array(
			'type'  => 'text',
			'name'  => 'geocolonia_dist_cod',
			'id'    => 'geocolonia_dist_cod',
			'value' => $this->form_validation->set_value('geocolonia_dist_cod', $geocolonia->dist_cod),
            'class' => 'form-control'
		);
		$this->data['geocolonia_col_cod'] = array(
			'type'     => 'text',
			'name'     => 'geocolonia_col_cod',
			'id'       => 'geocolonia_col_cod',
			'value'    => $this->form_validation->set_value('geocolonia_col_cod', $geocolonia->col_cod),
			'data-src' => $geocolonia->col_cod,
            'class'    => 'form-control'
		);
		$this->data['geocolonia_id_codgeo'] = array(
			'type'     => 'text',
			'name'     => 'geocolonia_id_codgeo',
			'id'       => 'geocolonia_id_codgeo',
			'value'    => $this->form_validation->set_value('geocolonia_id_codgeo', $geocolonia->id_codgeo),
			'data-src' => $geocolonia->id_codgeo,
            'class'    => 'form-control'
		);
		$this->data['geocolonia_col_desc'] = array(
			'type'     => 'text',
			'name'     => 'geocolonia_col_desc',
			'id'       => 'geocolonia_col_desc',
			'value'    => $this->form_validation->set_value('geocolonia_col_desc', $geocolonia->col_desc),
			'data-src' => $geocolonia->col_desc,
            'class'    => 'form-control'
		);
        /* Load Template */
        $this->template->admin_render('admin/geocolonias/edit', $this->data);
	}
}
