<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Observaciones extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('censo/censo_model');
		$this->lang->load('censo/censo_lang');

		/* Title Page :: Common */
		$this->page_title->push(lang('menu_dgsa_censo'));
		$this->data['pagetitle'] = $this->page_title->show();

		$_SESSION['id_modulo_ant'] = $_SESSION['id_modulo'];

		$_SESSION['url_anterior'] = 'http://jaimito.site/sge/index.php/censo/censo/index';

		//echo '<pre>';
		//print_r($_SESSION['id_modulo_ant']);
		//echo '</pre>';
		//show_error(1);

		//if ($_SESSION['id_modulo'] != 'censos' AND $_SESSION['id_modulo'] != 'CONSULTAS_REG') {

		if ($_SESSION['id_modulo'] != 'OBSERVACIONES') {
			//show_error($_SESSION['id_modulo']);
			if ($_SESSION['id_modulo'] != 'OBSERVACIONES') {
				
				$_SESSION['arraywhere_observaciones'] = NULL;
				$_SESSION['arraywhere_observaciones_busq'] = NULL;	
			}
			
			$_SESSION['id_modulo'] = 'OBSERVACIONES';

			$_SESSION['errores_censo'] = NULL;
			is_array($_SESSION['errores_censo']);
		}

		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_censos'), 'censo/censo/index');
	}


	public function observaciones_edit($level_1_id, $modo_censo)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}
		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('observaciones_level_1_id'), 'censo/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		$_SESSION['identificador'] = $level_1_id;
		$observaciones = $this->censo_model->view('observaciones', array('level_1_id' => $_SESSION['identificador']))->row();

			//declara el indice del array si es que no existe
		if (is_array($_SESSION['errores_censo']) && !array_key_exists('observaciones_level_1_id' , $_SESSION['errores_censo'])) {
			$_SESSION['errores_censo']['observaciones_level_1_id'] = NULL;     
		}

		/**** BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/
		//función para validar pestaña
		//$this->censo_model->validar_pestanha($_SESSION['identificador'], '3');
		//$this->censo_model->validar_pestanha($_SESSION['identificador'], '6');

		//obtiene los errores de la tabla
		$errores = $this->censo_model->obtener_errores($_SESSION['identificador'], '3')->result_array();

		foreach ($errores as $value) {

			$concepto = $this->censo_model->concepto('CENSO_ERRORES', false, 'CONCEPTO', $value['error'])->result_array();

			if (isset($concepto[0])) {
				$error[$value['error']] = $concepto[0]['descripcion'];
			}
		}

		if (isset($error)) {
			$_SESSION['errores_censo']['observaciones_level_1_id'] = $error;
		}else{
			$_SESSION['errores_censo']['observaciones_level_1_id'] = NULL;
		}
		/**** FIN BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/

/*
observaciones_id
level_1_id
observaciones2
firma__entrevistado
firma__entrevistador
*/
		if ($_POST) {

			/*
			if ($_POST['observaciones_id']) 
			{
				$arraycampos['observaciones_id']                       = $_POST['observaciones_id'];
			}

			if ($_POST['level_1_id'])
			{
				$arraycampos['level_1_id']   					= $_POST['level_1_id'];
			}
			*/
			if ($_POST['fecha']) 
			{
				$arraycampos['fecha']             				= $_POST['fecha'];
			}

			if ($_POST['observaciones2']) 
			{
				$arraycampos['observaciones2']        			= $_POST['observaciones2'];
			}

			if ($_POST['firma__entrevistado']) 
			{
				$arraycampos['firma__entrevistado']      					= $_POST['firma__entrevistado'];
			}

			if ($_POST['firma__entrevistador']) 
			{
				$arraycampos['firma__entrevistador']        				= $_POST['firma__entrevistador'];
			}

			/*
			if (grupo_usuario(6)) {			
				$this->censo_model->actualizar_censo(array('level_1_id' => $_SESSION['identificador']),
													 'monitoreo',
													 array('reg_modificado' => 1)
													);
			}
			*/

			$update_reg = $this->censo_model->actualizar_censo(array('level_1_id' => $_SESSION['identificador']), 'observaciones', $arraycampos);

			/**** BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/
			//función para validar pestaña
			//$this->censo_model->validar_pestanha($_SESSION['identificador'], '3');
			//$this->censo_model->validar_pestanha($_SESSION['identificador'], '6');

			//obtiene los errores de la tabla
			$errores = $this->censo_model->obtener_errores($_SESSION['identificador'], '3')->result_array();

			foreach ($errores as $value) {

				$concepto = $this->censo_model->concepto('CENSO_ERRORES', false, 'CONCEPTO', $value['error'])->result_array();

				if (isset($concepto[0])) {
					$error[$value['error']] = $concepto[0]['descripcion'];
				}
			}

			$_SESSION['errores_censo']['observaciones'] = $error;
			/**** FIN BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/

			/****** Actualizar tabla MONITOREO Y ASIGNACIONLOTES *********************/
			/**
			 **Se actualiza el campo PROCESO pasa a ser A03
			**/

			//$monitoreoasignacion = $this->censo_model->view('monitoreo_verificador', array('id_registro_lote' => $_SESSION['identificador']))->row();
			//$observaciones = $this->censo_model->view('observaciones', array('id_registro_lote' => $_SESSION['identificador']))->row();
			/*if ($monitoreoasignacion->proceso == 'A04' || $monitoreoasignacion->proceso == 'A07') 
			{   
				$arraycampos1 = array('registro_analizado' => 0
					,'proceso'            => 'A03'
					//,'mapear'             => $observaciones->mapear
					);
						//show_error($observaciones->mapear. ' RECH ');
				$update_monitoreo = $this->censo_model->actualizar_censo(array('id_registro_lote' => $_SESSION['identificador']),
					'monitoreo',
					$arraycampos1
					);

				$cantidad_reg_analizado = $monitoreoasignacion->cantidad_reg_analizado - 1;

				$arraycampos2 = array('cantidad_reg_analizado' => $cantidad_reg_analizado);
				$update_asignacion = $this->censo_model->actualizar_censo(array('lote' => $monitoreoasignacion->lote),
																		  'asignacionlotes',
																		  $arraycampos2
																		  );
			}elseif ($monitoreoasignacion->proceso == 'A02' || $monitoreoasignacion->proceso == 'A03') 
			{

				if ((string)$monitoreoasignacion->fecha_procesado_4 == '0001-01-01' || 
					(string)$monitoreoasignacion->fecha_procesado_4 == '1970-01-01' || 
					$monitoreoasignacion->fecha_procesado_4 == null || 
					$monitoreoasignacion->fecha_procesado_4 == "" )  {
					$str = date_default_timezone_get();
					$fecha_procesado_4 =date("d/m/Y", strtotime($str));
					
				$arraycampos3 = array('proceso' 		   => 'A03'
					//,'mapear' 			   => $observaciones->mapear
					,'procesado_4'		   => 1
					,'fecha_procesado_4'	   => $fecha_procesado_4
					
					);
				}
				else {

				$str = date_default_timezone_get();
				$fecha_procesado_4 = date("d/m/Y", strtotime($str));
				$arraycampos3 = array('proceso' 		   => 'A03'
					//,'mapear' 			   => $observaciones->mapear
					,'procesado_4'		   => 1
					
					);
				}


				//$arraycampos3 = array('proceso'            => 'A03',
				//					  'mapear'             => $observaciones->mapear
				//					  );
				

				$update_monitoreo = $this->censo_model->actualizar_censo(array('id_registro_lote' => $_SESSION['identificador']),
					'monitoreo',
					$arraycampos3
					);
				
				$str = date_default_timezone_get();
				$fecha = date("d/m/Y", strtotime($str));
				$arraycampos4 = array('fecha_inicio' => $fecha);

				$update_monitoreo = $this->censo_model->actualizar_censo(array('lote' => $monitoreoasignacion->lote),
					'asignacionlotes',
					$arraycampos4
					);
			}
			*/
			/*****************************************************************/
			if ($update_reg)
			{
				$this->session->set_flashdata('message', $this->lang->line('edit_in_temp_saved'));
			}else{
				$this->session->set_flashdata('message', $this->ion_auth->errors());
			}

			redirect('censo/observaciones/observaciones_edit/'.$level_1_id.'/E');
		}


		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

/*
observaciones_id
level_1_id
observaciones2
firma__entrevistado
firma__entrevistador
*/


		$this->data['observaciones_id'] = array(
			'type'    => 'text',
			'name'    => 'observaciones_id',
			'id'      => 'observaciones_id',
			'value'   => $this->form_validation->set_value('observaciones_observaciones_id', trim($observaciones->observaciones_id)),
			'class'   => 'form-control',
			'readonly' => 'true'
			);
		$this->data['level_1_id'] = array(
			'type'  => 'text',
			'name'  => 'level_1_id',
			'id'    => 'level_1_id',
			'value' => $this->form_validation->set_value('observaciones_level_1_id', trim($observaciones->level_1_id)),
			'class' => 'form-control',
			'readonly' => 'true'
			);
		$this->data['observaciones2'] = array(
			'type'  => 'text',
			'name'  => 'observaciones2',
			'id'    => 'observaciones2',
			'value' => $this->form_validation->set_value('observaciones_observaciones2', trim($observaciones->observaciones2)),
			'class' => 'form-control',
            'maxlength'=> '80'
			);
		$this->data['firma__entrevistado'] = array(
			'type'  => 'text',
			'name'  => 'firma__entrevistado',
			'id'    => 'firma__entrevistado',
			'value' => $this->form_validation->set_value('observaciones_firma__entrevistado', trim($observaciones->firma__entrevistado)),
			'class' => 'form-control',
            'maxlength'=> '20'
		);
		$this->data['firma__entrevistador'] = array(
			'type'  => 'text',
			'name'  => 'firma__entrevistador',
			'id'    => 'firma__entrevistador',
			'value' => $this->form_validation->set_value('observaciones_firma__entrevistador', trim($observaciones->firma__entrevistador)),
			'class' => 'form-control',
            'maxlength'=> '20'
		);
			

		/* Load Template */
		$this->template->admin_render('censo/observaciones', $this->data);
		
	}

    public function trae_distritos_snc()
    {
        //$dpto      = $_GET['departamento'];
		$dpto      = $_POST['departamento'];


        $distritos = $this->censo_model->dropdown_data('distritos', array('dpto_snc' => $dpto))->result();

        echo '<option value="">Seleccione el distrito</option>';
        foreach ($distritos as $dist) {
            echo '<option value="' . $dist->dist_snc . '">' . $dist->dist_snc . ' - ' . $dist->dist_desc . '</option>';
        }

        //echo json_encode($distritos);
    }


}
//Llave de finalizacion de la clase