<?php
public function create()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('memos_create'), 'memos/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Validate form input */

		$this->form_validation->set_rules('id_emisor', 		'<b>Emisor</b>' , 	'required');
		//$this->form_validation->set_rules('expediente', 		'<b>Expediente</b>' , 		'required');

		//$this->form_validation->set_rules('id_proyecto_geomatica', 	'<b>ID Geomática</b>' ,  'required');

		if ($this->form_validation->run() == TRUE)
		{

				//show_error(2);
	        	if ($_POST['id_memo']){
					$arraycampos['id_memo'] 		= $_POST['id_memo'];
				}

        		if ($_POST['id_emisor']){
	        		$arraycampos['id_emisor'] 		= $_POST['id_emisor'];
	        	}

	        	if ($_POST['id_receptor']){
	        		$arraycampos['id_receptor'] 	= $_POST['id_receptor'];
	        	}

	        	if ($_POST['referencia']){
					$arraycampos['referencia'] 		= $_POST['referencia'];
				}

				if ($_POST['descripcion']){
					$arraycampos['descripcion'] 	= $_POST['descripcion'];
				}

				
				if ($_POST['fecha']){
					$arraycampos['fecha'] 			= $_POST['fecha'];
				}

				if ($_POST['id_usuario']){
					$arraycampos['id_usuario'] 		= $_POST['id_usuario'];
				}


				if ($_POST['nro_memo']){
					$arraycampos['nro_memo'] 		= $_POST['nro_memo'];
				}


				if ($_POST['anho_memo']){
					$arraycampos['anho_memo'] 		= $_POST['anho_memo'];
				}

				

			$accion = 0;
			if (isset($_POST['accion'])){
				$accion = intval($_POST['accion']);
			}else{
				$accion = 0;
			}

			$id_memo = $this->memos_model->obtener_nextval('public.memos_id_memo_seq');
			$arraycampos['id_memo'] = $id_memo;

			$memo_create = $this->memos_model->crear_memo($arraycampos);


        	if ($memo_create)
        	{

				if($accion===1){ /// ACCION PARA OBSERVAR

        			$this->session->set_flashdata('message', '¡Expediente <b>'.$_POST['id_memo'].'</b>, Memo <b>'.$_POST['id_memo'].'</b> creado exitósamente!');
					//redirect('memos/memos/edit_memos/'.$id_memo);
					redirect('memos/memos/index');

				} else {

        			$this->session->set_flashdata('message', '¡Expediente <b>'.$_POST['id_memo'].'</b>, Gestión <b>'.$_POST['id_memo'].'</b> creado exitósamente!');
					//redirect('memos/memos/edit_memos/'.$id_memo);
					redirect('memos/memos/index');
				}
			}
			else
			{
				$this->session->set_flashdata('message', $this->ion_auth->errors());
			}
		}
		else
		{
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));


			$this->data['id_memo'] = array(
				'type'     => 'text',
				'name'     => 'id_memo',
				'id'       => 'id_memo',
				'value'    => $this->form_validation->set_value('id_memo'),
				'class'    => 'form-control',
				'maxlength'=> '10',
				'readonly' => TRUE
			);
			$this->data['id_emisor'] = array(
				'type'     => 'text',
				'name'     => 'id_emisor',
				'id'       => 'id_emisor',
				'value'    => $this->form_validation->set_value('id_emisor'),
				'class'    => 'form-control',
				'maxlength'=> '4'
			);
			$this->data['id_receptor'] = array(
				'type'     => 'text',
				'name'     => 'id_receptor',
				'id'       => 'id_receptor',
				'value'    => $this->form_validation->set_value('id_receptor'),
				'class'    => 'form-control',
				'maxlength'=> '4'
			);
			$this->data['referencia'] = array(
				'type'     => 'text',
				'name'     => 'referencia',
				'id'       => 'referencia',
				'value'    => $this->form_validation->set_value('referencia'),
				'class'    => 'form-control',
				'maxlength'=> '500'
			);
			$this->data['descripcion'] = array(
				'type'     => 'text',
				'name'     => 'descripcion',
				'id'       => 'descripcion',
				'value'    => $this->form_validation->set_value('descripcion'),
				'class'    => 'form-control',
				'maxlength'=> '500'
			);
			$this->data['fecha'] = array(
				'type'     => 'text',
				'name'     => 'fecha',
				'id'       => 'fecha',
				'rows'     => '1',
				'value'    => $this->form_validation->set_value('fecha'),
				'class'    => 'form-control',
				'maxlength'=> '255'
			);
			$this->data['id_usuario'] = array(
				'type'     => 'text',
				'name'     => 'id_usuario',
				'id'       => 'id_usuario',
				'value'    => $this->form_validation->set_value('id_usuario'),
				'class'    => 'form-control',
				'maxlength'=> '4'
			);
			$this->data['nro_memo'] = array(
				'type'     => 'text',
				'name'     => 'nro_memo',
				'id'       => 'nro_memo',
				'value'    => $this->form_validation->set_value('nro_memo'),
				'class'    => 'form-control',
				'maxlength'=> '10'
			);
			$this->data['anho_memo'] = array(
				'type'     => 'number',
				'name'     => 'anho_memo',
				'id'       => 'anho_memo',
				'value'    => $this->form_validation->set_value('anho_memo'),
				'class'    => 'form-control',
				'onkeyup'  => 'limit_dig(this.id,4)',
				'maxlength'=> '4'
			);
			

			/* Load Template */
			$this->template->admin_render('memos/create_memos', $this->data);
		}
	}

?>