<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Distritos extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('man_espacial/distritos/distritos_model');
		$this->lang->load('distritos/distritos_lang');


		/* Title Page :: Common */
		$this->page_title->push(lang('menu_distritos'));
		$this->data['pagetitle'] = $this->page_title->show();
		$_SESSION['id_modulo'] = 'DISTRITOS';

		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_distritos'), 'admin/distritos');
	}
	
	
	public function index()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{
			/* Breadcrumbs */
			$this->data['breadcrumb'] = $this->breadcrumbs->show();

			//$this->data['geocolonias'] = $this->geocolonias_model->geocolonias()->result();
			//$this->prueba['dpto'] = $this->dpto_model->dpto()->result();

			$this->data['distritos'] = $this->distritos_model->distritos_all()->result();

			/* Load Template */
			$this->template->admin_render('man_espacial/distritos/index', $this->data);
		}
	}


	public function create()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		//if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin() OR ! $dpto OR empty($dpto) OR ! $dist OR empty($dist))
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_distritos'), 'distritos/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Validate form input */
		//$this->form_validation->set_rules('dpto', 'lang:create_dpto_validation_name_label', 'required|is_numeric|min_length[2]|max_length[2]');
		//$this->form_validation->set_rules('dpto_desc', 'lang:create_dpto_desc_validation_name_label', 'required');
		$this->form_validation->set_rules('distrito', 'lang:create_distrito_validation_name_label', 'required|is_numeric|min_length[2]|max_length[2]');
		$this->form_validation->set_rules('dist_desc', 'lang:create_dist_desc_validation_name_label', 'required');
		
		
		if ($this->form_validation->run() == TRUE)
		{
			$dpto = $this->input->post('dpto');
			$dpto_desc = $this->distritos_model->get_desc($dpto);
			$new_distrito_id = $this->distritos_model->create_distritos($this->input->post('dpto'),$dpto_desc->dpto_desc, $this->input->post('distrito'), $this->input->post('dist_desc'));
			if ($new_distrito_id)
			{
				$this->session->set_flashdata('message', '');
				redirect('man_espacial/distritos/distritos/create');
			}
			else {
				redirect('man_espacial/distritos/distritos', 'refresh');
				
			}
		}
		else 
		{
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
	
			$this->data['dpto'] = array(
				'name'  => 'dpto',
				'id'    => 'dpto',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('dpto')
			);
			$this->data['distrito'] = array(
				'name'  => 'distrito',
				'id'    => 'distrito',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('distrito')
			);
			$this->data['dist_desc'] = array(
				'name'  => 'dist_desc',
				'id'    => 'dist_desc',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('dist_desc')
			);

			$this->data['ddl_dpto'] = $this->distritos_model->departamentos()->result();

			/* Load Template */
			$this->template->admin_render('man_espacial/distritos/create', $this->data);
		}
	}

	public function edit($gid)
	{

		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin() OR ! $gid OR empty($gid))
		//if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin() OR ! $dpto OR empty($dpto) OR ! $dist OR empty($dist))
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_distritos_edit'), 'distritos/edit');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Variables */
		$registro = $this->distritos_model->distritos_unique($gid)->row();
		//$registro = $this->distritos_model->distritos_unique($dpto,$dist)->row();

	
		//$this->form_validation->set_rules('departamento', $this->lang->line('edit_dpto_validation_label'), 'required|is_numeric|min_length[2]|max_length[2]');

		//$this->form_validation->set_rules('dpto_desc', $this->lang->line('edit_dpto_desc_validation_label'), 'required');

		$this->form_validation->set_rules('distrito', $this->lang->line('edit_distrito_validation_label'), 'required|is_numeric|min_length[2]|max_length[2]');

		$this->form_validation->set_rules('dist_desc', $this->lang->line('edit_dist_desc_validation_label'), 'required');

		if (isset($_POST) && ! empty($_POST))
		{
			if ($this->form_validation->run() == TRUE)
			{
				$update = $this->distritos_model->update_distritos($gid, $_POST['departamento'], $_POST['distrito'], $_POST['dist_desc']);

				if ($update)
				{
					$this->session->set_flashdata('message', $this->lang->line('edit_distritos_saved'));

					/* IN TEST */
					//$this->db->update('geocolonias', array('bgcolor' => $_POST['geocolonia_bgcolor']), 'id = '.$id);

					redirect('man_espacial/distritos/distritos/edit/'.$gid.'/'.$_POST['departamento'].'/'.$_POST['distrito'].'/'.$_POST['dist_desc'].'/'); //VER OTRA MANERA DE ACTUALIZAR LA PAGINA, YA QUE AL REFRESCAR SOLO VUELVE A TOMAR LOS VALORES DE DPTO, DISTRITO Y COLONIA
				}
				else
				{
					$this->session->set_flashdata('message', $this->ion_auth->errors());
				}

				//redirect('man_espacial/distritos/distritos', 'refresh');
			}
		}

		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
		$this->data['distritos']   = $registro;

		//$readonly = $this->config->item('admin_group', 'ion_auth') === $registro->col_desc ? 'readonly' : '';
		
		$this->data['dpto'] = array(
			'type'    => 'text',
			'name'    => 'dpto',
			'id'      => 'dpto',
			'value'   => $this->form_validation->set_value('dpto', $registro->dpto),
			'class'   => 'form-control',
			//$readonly => $readonly
		);
		/*$this->data['dpto_desc'] = array(
			'type'  => 'text',
			'name'  => 'dpto_desc',
			'id'    => 'dpto_desc',
			'value' => $this->form_validation->set_value('dpto_desc', $registro->dpto_desc),
			'class' => 'form-control'
		);*/
		$this->data['distrito'] = array(
			'type'    => 'text',
			'name'    => 'distrito',
			'id'      => 'distrito',
			'value'   => $this->form_validation->set_value('distrito', $registro->distrito),
			'class'   => 'form-control',
			//$readonly => $readonly
		);
		$this->data['dist_desc'] = array(
			'type'  => 'text',
			'name'  => 'dist_desc',
			'id'    => 'dist_desc',
			'value' => $this->form_validation->set_value('dist_desc', $registro->dist_desc),
			'class' => 'form-control'
		);

		$this->data['ddl_dpto'] = $this->distritos_model->departamentos()->result();

		
		/* Load Template */
		$this->template->admin_render('man_espacial/distritos/edit', $this->data);
	}

	  public function delete($gid){

		$distrito_delete = $this->distritos_model->delete_distrito($gid);

		if ($distrito_delete)
		{
			$this->session->set_flashdata('message', $this->lang->line('edit_group_saved'));
			redirect('man_espacial/distritos/distritos');
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}
}