<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class lotes extends Admin_Controller {

    public function __construct()
    {
        parent::__construct();

		$this->load->model('ficha_catastral/lotes_model');
        $this->lang->load('ficha_catastral/lotes');

   		/* Titulo de la pagina :: Common */
        $this->page_title->push(lang('menu_lotes'));
        $this->data['pagetitle'] = $this->page_title->show();

        if ($_SESSION['id_modulo'] != 'lotes') {

			$_SESSION['arraywhere_lotes'] 		= NULL;
			$_SESSION['arraywhere_lotes_busqueda'] 	= NULL;

			$_SESSION['id_modulo'] = 'lotes';
		}

    	/* Breadcrumbs :: Common */
        $this->breadcrumbs->unshift(1, lang('menu_lotes'), 'admin/lotes');
    }
 	
	public function index()
	{
        if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
        {
            redirect('auth/login', 'refresh');
        }
        else
        {
        if ($_POST) { 
			$arraywhere = NULL;
		
			if ($_POST['gid']) 
			{
				if (is_numeric($_POST['gid'])) {
					$arraywhere['gid']			= $_POST['gid'];
					$arraywherebusq['gid'] 			= (integer)$_POST['gid'];
				}
			}        				
		
			if ($_POST['lote']) 
			{
				$arraywhere['lote'] 				= $_POST['lote'];
				$arraywherebusq['lower(lote) like '] 		= '%'.strtolower($_POST['lote']).'%';
			}
			

			if ($_POST['nombres_propietarios']) 
			{
				$arraywhere['nombres_propietarios'] 			        	= $_POST['nombres_propietarios'];
				$arraywherebusq['lower(nombres_propietarios) like '] 		= '%'.strtolower($_POST['nombres_propietarios']).'%';
			}

			if ($_POST['manzana']) 
			{
				$arraywhere['cod_manz'] 				= $_POST['manzana'];
				$arraywherebusq['lower(cod_manz) like ']	  	= '%'.strtolower($_POST['manzana']).'%';
			}
		
		
			if ($_POST['distrito']) 
			{
				$arraywhere['cod_dist'] 			= $_POST['distrito'];
				$arraywherebusq['lower(cod_dist) like '] 	= '%'.strtolower($_POST['distrito']).'%';
			}
		
			if ($_POST['radiourb']) 
			{
				$arraywhere['cod_ru'] 			= $_POST['radiourb'];
				$arraywherebusq['lower(cod_ru) like '] 	= '%'.strtolower($_POST['radiourb']).'%';
			}
		
			if ($_POST['municipio']) 
			{
				$arraywhere['cod_muni'] 				= $_POST['municipio'];
				$arraywherebusq['lower(cod_muni) like ']		= '%'.strtolower($_POST['municipio']).'%';
			}
		
			if ($_POST['cod_cat']) 
			{
				$arraywhere['cod_cat'] 				= $_POST['cod_cat'];
				$arraywherebusq['lower(cod_cat) like '] 		= '%'.strtolower($_POST['cod_cat']).'%';
			}
		
			if ($_POST['zonaho']) 
			{
				
				$arraywhere['cod_zonaho']			= $_POST['zonaho'];
				$arraywherebusq['lower(cod_zonaho) like '] 	= '%'.strtolower($_POST['zonaho']).'%';
									
			}
		
			if ($_POST['sup_m2']) 
			{
				if (is_numeric($_POST['sup_m2'])) {
					$arraywhere['sup_lev'] 				= $_POST['sup_m2'];
					$arraywherebusq['sup_lev']		= (double)$_POST['sup_m2'];
				}
			}
		

		
			$_SESSION['arraywhere_lotes'] = $arraywhere;
			$_SESSION['arraywhere_lotes_busqueda'] = $arraywherebusq;
		
			redirect('ficha_catastral/lotes/lotes');				
		}
		
			// ----- Paginacion Generica 
		$mi_paginacion = $this->ion_auth->paginacion_generica(
			12, 						// resultados por por_pagina, 
			5, 						// segmento uri a leer, 
			5, 						// cantidad_enlaces,
			base_url(). 'ficha_catastral/lotes/lotes/index',  // url completo del paginado
			'v_lotes_index',		// nombre de la tabla o nombre de la vista
			$_SESSION['arraywhere_lotes_busqueda']
			);
		
		$this->data['pagination'] 		= $mi_paginacion['pagination'];
		
		$this->data['lotes']	  		= $this->ion_auth_model->segmentador_paginas(
			$mi_paginacion['per_page'], // resultados por pagina
			5,							// segmento uri a leer
			'v_lotes_index',					// el nombre de la tabla a consultar $nombre_tabla
			$_SESSION['arraywhere_lotes_busqueda']
			)->result();
		// ----- Fin paginacion
		
		/* Breadcrumbs */
		$this->data['breadcrumb'] = $this->breadcrumbs->show();
		
            /* Load Template */
         	$this->template->admin_render('ficha_catastral/lotes/index', $this->data);
	        
        }
    }


	public function create()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

	/* Breadcrumbs */
	$this->breadcrumbs->unshift(2, lang('menu_lotes'), 'lotes/create');
	$this->data['breadcrumb'] = $this->breadcrumbs->show();

	/* Validate form input */
 	$this->form_validation->set_rules('cod_dist', $this->lang->line('edit_lotes_validation_distrito_label'), 'required');
        
        $this->form_validation->set_rules('cod_manz', $this->lang->line('edit_lotes_validation_manzano_label'), 'required'); 
        
        $this->form_validation->set_rules('lote', $this->lang->line('edit_lotes_validation_lote_label'), 'required'); 
                      	
	$this->form_validation->set_rules('cod_cat', $this->lang->line('edit_lotes_validation_cod_catast_label'), 'required');
	
	$this->form_validation->set_rules('zonas', $this->lang->line('edit_lotes_validation_zonas_label'), 'required');

		if ($this->form_validation->run() == TRUE)
		{
		

				if ($_POST['gid']) {
					$arraycampos['gid']		= $_POST['gid'];
				}

				if ($_POST['lote']) {
					$arraycampos['lote']		= $_POST['lote'];
				}
				
				if ($_POST['cod_manz']) {
					$arraycampos['cod_manz']	= $_POST['cod_manz'];
				}

				if ($_POST['cod_dist']) {
					$arraycampos['cod_dist'] 	= $_POST['cod_dist'];
				}

				if ($_POST['cod_ru']) {
					$arraycampos['cod_ru']	= $_POST['cod_ru'];
				}

				if ($_POST['cod_muni']) {
					$arraycampos['cod_muni']	= $_POST['cod_muni'];
				}

				if ($_POST['cod_cat']) {
					$arraycampos['cod_cat']		= $_POST['cod_cat'];
				}

				if ($_POST['cod_zonaho']) {
					$arraycampos['cod_zonaho']	= $_POST['cod_zonaho'];
				}

				if ($_POST['sup_lev']) {
					$arraycampos['sup_lev']		= $_POST['sup_lev'];
				}


			$new_lotes_id = $this->lotes_model->create_lotes($arraycampos);
			if ($new_lotes_id)
			{
				$this->session->set_flashdata('message', $this->ion_auth->messages());
				redirect('ficha_catastral/lotes');
			}
		}else{
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
				 
		//creando campos
		$this->data['gid'] = array(
			'type'     => 'text',
			'name'     => 'gid',
			'id'       => 'gid',
			'value'    => $this->form_validation->set_value('gid'),
			//'data-src' => $lotes->gid,
			'class'    => 'form-control',
			'disabled' => true
		);
		$this->data['lote'] = array(
			'type'  => 'text',
			'name'  => 'lote',
			'id'    => 'lote',
			'style' => 'width: 268px;height: 30px',
			'value'    => $this->form_validation->set_value('lote'),
			'class' => 'form-control'
		);
		 
		$this->data['cod_manz'] = array(
			'type'     => 'text',
			'name'     => 'cod_manz',
			'id'       => 'cod_manz',
			'value'    => $this->form_validation->set_value('cod_manz'),
			//'data-src' => $lotes-nombre,
			'class'    => 'form-control'
		);
		$this->data['cod_dist'] = array(
			'type'  => 'text',
			'name'  => 'cod_dist',
			'id'    => 'cod_dist',
			//'style' => 'width: 268px;height: 150px',
			'style' => 'width: 50px',
			'value'    => $this->form_validation->set_value('cod_dist'),
			'class' => 'form-control'
		);
		$this->data['cod_ru'] = array(
			'name'  => 'cod_ru',
			'id'    => 'cod_ru',
			'type'  => 'text',
			'value'    => $this->form_validation->set_value('cod_ru'),
			//'data-src' => $lotes-cod_ru,
			'class' => 'form-control',
		);

		$this->data['cod_muni'] = array(
			'name'  => 'cod_muni',
			'id'    => 'cod_muni',
			'type'  => 'text',
			'value'    => $this->form_validation->set_value('cod_muni'),
			'class' => 'form-control',
		);
	
		$this->data['cod_cat'] = array(
			'name'  => 'cod_cat',
			'id'    => 'cod_cat',
			'type'  => 'text',
			'value'    => $this->form_validation->set_value('cod_cat'),
			'class' => 'form-control',
		);

		$this->data['cod_zonaho'] = array(
			'name'  => 'cod_zonaho',
			'id'    => 'cod_zonaho',
			'type'  => 'text',
			'value'    => $this->form_validation->set_value('cod_zonaho'),
			'class' => 'form-control',
		);

		$this->data['sup_lev'] = array(
			'name'  => 'sup_lev',
			'id'    => 'sup_lev',
			'type'  => 'text',
			'value'    => $this->form_validation->set_value('sup_lev'),
			'class' => 'form-control',
		);


			
			/* Load Template */
			$this->template->admin_render('ficha_catastral/lotes/create', $this->data);
		}
	}




    public function delete($gid= null)
    {
        //$documentos = $this->expedientes_model->view('documentos_sge', array('id_expediente' => $expe_id))->result_array();

        //if (!empty($documentos)) {
        //    $this->eliminar_archivos($expe_id, $documentos);
        //}
        
        $delete  = $this->lotes_model->eliminar_lotes($gid);
        $this->session->set_flashdata('message', '¡El Lote se eliminó correctamente!');

        redirect('ficha_catastral/lotes/index');
    }


	public function edit($gid)
	{

		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin() OR ! $gid OR empty($gid))
		{
			redirect('auth', 'refresh');
		}
       /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_lotes_edit'), 'lotes/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();


        /* Variables *///Trae de la base de datos la fila seleccionada
		$lotes = $this->lotes_model->view($gid)->row();
		
		

        /* Validate form input */
        //$this->form_validation->set_rules('gid', 		$this->lang->line('edit_lotes_validation_gid_label'), 'required|is_numeric|max_length[9]');
    $this->form_validation->set_rules('lote', 			$this->lang->line('edit_lotes_validation_lote_label'), 'required');
	$this->form_validation->set_rules('cod_manz', 		$this->lang->line('edit_lotes_validation_cod_manz_label'), 'required');
	$this->form_validation->set_rules('cod_dist', 		$this->lang->line('edit_lotes_validation_cod_dist_label'), 'required');
	$this->form_validation->set_rules('cod_cat', 		$this->lang->line('edit_lotes_validation_cod_cat_label'), 'required');
	//$this->form_validation->set_rules('manzano', 		$this->lang->line('edit_lotes_validation_manzano_label'), 'required');
	//$this->form_validation->set_rules('lote', 		$this->lang->line('edit_lotes_validation_lote_label'), 'required');
	

	//Se produce cuando el usuario da click en el submit
	if (isset($_POST) && ! empty($_POST))
		{
			if ($this->form_validation->run() == TRUE)
			{
				if ($_POST['gid']) {
					$arraycampos['gid']		= $_POST['gid'];
				}

				if ($_POST['lote']) {
					$arraycampos['lote']		= $_POST['lote'];
				}
				
				if ($_POST['cod_manz']) {
					$arraycampos['cod_manz']	= $_POST['cod_manz'];
				}

				if ($_POST['cod_dist']) {
					$arraycampos['cod_dist'] 	= $_POST['cod_dist'];
				}

				if ($_POST['cod_ru']) {
					$arraycampos['cod_ru']		= $_POST['cod_ru'];
				}

				if ($_POST['cod_muni']) {
					$arraycampos['cod_muni']	= $_POST['cod_muni'];
				}

				if ($_POST['cod_cat']) {
					$arraycampos['cod_cat']		= $_POST['cod_cat'];
				}

				if ($_POST['cod_zonaho']) {
					$arraycampos['cod_zonaho']	= $_POST['cod_zonaho'];
				}

				if ($_POST['sup_lev']) {
					$arraycampos['sup_lev']		= $_POST['sup_lev'];
				}
				

				if (!is_numeric($_POST['lote'])) {
				   $this->session->set_flashdata('message', 'El número de lote solo puede ser numérico');
				   redirect('ficha_catastral/lotes/edit/'.$gid); 
				} else {
				
				
					$lotes_update = $this->lotes_model->update_lotes($gid,$arraycampos);
	
					if ($lotes_update)
					{
						$this->session->set_flashdata('message', $this->lang->line('lotes_update_successful'));
						redirect('ficha_catastral/lotes/edit/'.$gid); 
					}
					else
					{
						$this->session->set_flashdata('message', $this->ion_auth->errors());
					}
				}

			}
		}

		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
		$this->data['lotes']   = $lotes;

		//$readonly = $this->config->item('admin_group', 'ion_auth') === $colonia->col_desc ? 'readonly' : '';
		
	//configuracion de campos
		$this->data['gid'] = array(
			'type'     => 'text',
			'name'     => 'gid',
			'id'       => 'gid',
			'value'    => $this->form_validation->set_value('gid', $lotes->gid),
			//'data-src' => $lotes->gid,
			'class'    => 'form-control',
			'disabled' => true
		);
		 $this->data['lote'] = array(
			'type'  => 'text',
			'name'  => 'lote',
			'id'    => 'lote',
			//'style' => 'width: 268px;height: 30px',
			'value'    => $this->form_validation->set_value('lote', $lotes->lote),
			'class' => 'form-control'
		);
		 
		$this->data['cod_manz'] = array(
			'type'     => 'text',
			'name'     => 'cod_manz',
			'id'       => 'cod_manz',
			'value'    => $this->form_validation->set_value('cod_manz', $lotes->cod_manz),
			//'data-src' => $lotes-nombre,
			'class'    => 'form-control'
		);
		$this->data['cod_dist'] = array(
			'type'  => 'text',
			'name'  => 'cod_dist',
			'id'    => 'cod_dist',
			//'style' => 'width: 268px;height: 150px',
			'style' => 'width: 390px',
			'value'    => $this->form_validation->set_value('cod_dist', $lotes->cod_dist),
			'class' => 'form-control'
		);
		$this->data['cod_ru'] = array(
			'name'  => 'cod_ru',
			'id'    => 'cod_ru',
			'type'  => 'text',
			'value'    => $this->form_validation->set_value('cod_ru', $lotes->cod_ru),
			//'data-src' => $lotes-cod_ru,
			'class' => 'form-control',
		);

		$this->data['cod_muni'] = array(
			'name'  => 'cod_muni',
			'id'    => 'cod_muni',
			'type'  => 'text',
			'value'    => $this->form_validation->set_value('cod_muni', $lotes->cod_muni),
			'class' => 'form-control',
		);
	
		$this->data['cod_cat'] = array(
			'name'  => 'cod_cat',
			'id'    => 'cod_cat',
			'type'  => 'text',
			'value'    => $this->form_validation->set_value('cod_cat', $lotes->cod_cat),
			'class' => 'form-control',
		);

		$this->data['cod_zonaho'] = array(
			'name'  => 'cod_zonaho',
			'id'    => 'cod_zonaho',
			'type'  => 'text',
			'value'    => $this->form_validation->set_value('cod_zonaho', $lotes->cod_zonaho),
			'class' => 'form-control',
		);

		$this->data['sup_lev'] = array(
			'name'  => 'sup_lev',
			'id'    => 'sup_lev',
			'type'  => 'text',
			'value'    => $this->form_validation->set_value('sup_lev', $lotes->sup_lev),
			'class' => 'form-control',
		);
	
        /* Load Template */
        $this->template->admin_render('ficha_catastral/lotes/edit', $this->data);
	}

	/////////////////////////////// VER PORTAL DE MAPAS ///////////////////// 

	public function verparcela ($objectid) {
	
		$bbox = $this->lotes_model->bb($objectid);
		if ($bbox)
		{
            
		$data['campo1'] = $bbox[0]['campo1'];
        	$data['campo2'] = $bbox[0]['campo2'];
        	$data['campo3'] = $bbox[0]['campo3'];
        	$data['campo4'] = $bbox[0]['campo4'];

        	$data['concat'] = $bbox[0]['campo1']. ',' . $bbox[0]['campo2'] . ',' .$bbox[0]['campo3']. ',' . $bbox[0]['campo4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ms_criamapa.php?tema=selparcel&layers=selparcel";
        	$i_jameuge = $i_jameuge . "&map_layer_selparcel_filter=objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapext=". $data['concat'];
        	$i_jameuge = $i_jameuge . "&extenquery=". $data['concat'];

			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}


	public function verlotes ($objectid) {
	
		$bbox = $this->lotes_model->lote($objectid);
		if ($bbox)
		{
            
		$data['campo1'] = $bbox[0]['campo1'];
        	$data['campo2'] = $bbox[0]['campo2'];
        	$data['campo3'] = $bbox[0]['campo3'];
        	$data['campo4'] = $bbox[0]['campo4'];

        	$data['concat'] = $bbox[0]['campo1']. ',' . $bbox[0]['campo2'] . ',' .$bbox[0]['campo3']. ',' . $bbox[0]['campo4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ms_criamapa.php?tema=sellote&layers=sellote";
        	$i_jameuge = $i_jameuge . "&map_layer_sellote_filter=objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapext=". $data['concat'];
        	$i_jameuge = $i_jameuge . "&extenquery=". $data['concat'];

			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function verlotes_ol ($gid) {

	/*
        echo '<pre>';
        print_r( $gid );
        echo '</pre>';
        show_error(1); 
	*/

        	$i_jameuge = $_SESSION['url_mapserver2']."/jvisorbolivia/index.html?tipo_consulta=lotes_gid";
        	$i_jameuge = $i_jameuge . "&gid=" . $gid;
        	$i_jameuge = $i_jameuge . "&ip_host=".substr($_SESSION['url_mapserver2'],7,strpos($_SESSION['url_mapserver2'], ":",7)-7);

			redirect($i_jameuge);
	}

	//////////////// GENERAR PLANOS DE ADEAS /////////////////////
	//////////////// GENERAR PLANOS DE ADEAS /////////////////////
	//////////////// GENERAR PLANOS DE ADEAS /////////////////////
	//////////////// GENERAR PLANOS DE ADEAS /////////////////////
	//////////////// GENERAR PLANOS DE ADEAS /////////////////////


	public function generarplanoaldeasU ($objectid) {
	
		$bbox = $this->lotes_model->bbaldea($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_Aldeas_UsoActual.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_Aldeas_UsoActual.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}

	}



	public function generarplanoaldeasA ($objectid) {
	
		$bbox = $this->lotes_model->bbaldea($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_Aldeas_UsoAlter.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_Aldeas_UsoAlter.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}

	}


	public function generarplanoaldeasU86 ($objectid) {
	
		$bbox = $this->lotes_model->bbaldea($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_Aldeas_Uso1986.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_Aldeas_Uso1986.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}

	}


	public function generarplanoaldeasC ($objectid) {
	
		$bbox = $this->lotes_model->bbaldea($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	//$i_jameuge = "http://181.120.22.251:8060/i3geo/ferramentas/imprimir/Mapa_A3_f1_Capacidad.php?";
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_Aldeas_Capacidad.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_Aldeas_Capacidad.map";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=black_gm.phtml";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=googlemaps";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanoaldeasT ($objectid) {
	
		$bbox = $this->lotes_model->bbaldea($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	//$i_jameuge = "http://181.120.22.251:8060/i3geo/ferramentas/imprimir/Mapa_A3_f1_Taxonomia.php?";
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_Aldeas_Taxonomia.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_Aldeas_Taxonomia.map";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=black_gm.phtml";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=googlemaps";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanoaldeasI86 ($objectid) {
	
		$bbox = $this->lotes_model->bbaldea($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	//$i_jameuge = "http://181.120.22.251:8060/i3geo/ferramentas/imprimir/Mapa_A3_uso_actual86.php?";
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_Aldeas_Imagen_1986.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_Aldeas_Imagen_1986.map";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=black_gm.phtml";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=googlemaps";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanoaldeasIAC ($objectid) {
	
		$bbox = $this->lotes_model->bbaldea($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	//$i_jameuge = "http://181.120.22.251:8060/i3geo/ferramentas/imprimir/Mapa_A3_imagen_actual.php?";
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_Aldeas_Imagen_Actual.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_Aldeas_Imagen_Actual.map";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=black_gm.phtml";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=googlemaps";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}


	public function generarplanoaldeasF ($objectid) {
	
		$bbox = $this->lotes_model->bbaldea($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	//$i_jameuge = "http://181.120.22.251:8060/i3geo/ferramentas/imprimir/Mapa_A3_uso_actual86.php?";
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_Aldeas_Fincas.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_Aldeas_Fincas.map";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=black_gm.phtml";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=googlemaps";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}



	//////////////// GENERAR PLANOS DE BLOQUES /////////////////////
	//////////////// GENERAR PLANOS DE BLOQUES /////////////////////
	//////////////// GENERAR PLANOS DE BLOQUES /////////////////////
	//////////////// GENERAR PLANOS DE BLOQUES /////////////////////
	//////////////// GENERAR PLANOS DE BLOQUES /////////////////////


	public function generarplanobloquesU ($objectid) {
	
		$bbox = $this->lotes_model->bbbloque($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/bloques/Mapa_A3_Bloques_UsoActual.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/bloques/Mapa_A3_Bloques_UsoActual.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}

	}



	public function generarplanobloquesA ($objectid) {
	
		$bbox = $this->lotes_model->bbbloque($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/bloques/Mapa_A3_Bloques_UsoAlter.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/bloques/Mapa_A3_Bloques_UsoAlter.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}

	}


	public function generarplanobloquesU86 ($objectid) {
	
		$bbox = $this->lotes_model->bbbloque($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/bloques/Mapa_A3_Bloques_Uso1986.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/bloques/Mapa_A3_Bloques_Uso1986.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat']; 
        	redirect($i_jameuge);       	
        }
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}

	}


	public function generarplanobloquesC ($objectid) {
	
		$bbox = $this->lotes_model->bbbloque($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	//$i_jameuge = "http://181.120.22.251:8060/i3geo/ferramentas/imprimir/Mapa_A3_f1_Capacidad.php?";
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/bloques/Mapa_A3_Bloques_Capacidad.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/bloques/Mapa_A3_Bloques_Capacidad.map";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=black_gm.phtml";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=googlemaps";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanobloquesT ($objectid) {
	
		$bbox = $this->lotes_model->bbbloque($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	//$i_jameuge = "http://181.120.22.251:8060/i3geo/ferramentas/imprimir/Mapa_A3_f1_Taxonomia.php?";
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/bloques/Mapa_A3_Bloques_Taxonomia.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/bloques/Mapa_A3_Bloques_Taxonomia.map";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=black_gm.phtml";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=googlemaps";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanobloquesI86 ($objectid) {
	
		$bbox = $this->lotes_model->bbbloque($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	//$i_jameuge = "http://181.120.22.251:8060/i3geo/ferramentas/imprimir/Mapa_A3_uso_actual86.php?";
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/bloques/Mapa_A3_Bloques_Imagen_1986.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/bloques/Mapa_A3_Bloques_Imagen_1986.map";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=black_gm.phtml";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=googlemaps";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanobloquesIAC ($objectid) {
	
		$bbox = $this->lotes_model->bbbloque($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	//$i_jameuge = "http://181.120.22.251:8060/i3geo/ferramentas/imprimir/Mapa_A3_imagen_actual.php?";
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/bloques/Mapa_A3_Bloques_Imagen_Actual.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/bloques/Mapa_A3_Bloques_Imagen_Actual.map";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=black_gm.phtml";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=googlemaps";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}


	public function generarplanobloquesF ($objectid) {
	
		$bbox = $this->lotes_model->bbbloque($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	//$i_jameuge = "http://181.120.22.251:8060/i3geo/ferramentas/imprimir/Mapa_A3_uso_actual86.php?";
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/bloques/Mapa_A3_Bloques_Fincas.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/bloques/Mapa_A3_Bloques_Fincas.map";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=black_gm.phtml";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=googlemaps";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}




	//////////////// GENERAR PLANOS DE LOTES /////////////////////
	//////////////// GENERAR PLANOS DE LOTES /////////////////////
	//////////////// GENERAR PLANOS DE LOTES /////////////////////
	//////////////// GENERAR PLANOS DE LOTES /////////////////////


	public function generarplanoUT ($objectid, $lote_n) {
	
		$bbox = $this->lotes_model->mapabb_lote($lote_n);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_f2_UsoActual.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_f1_UsoActual.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);

		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}

	}


	public function generarplanoA2 ($objectid,$lote_n) {
	
		$bbox = $this->lotes_model->mapabb_lote($lote_n);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_f2_UsoAlternativo.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_f1_UsoAlternativo.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;        	
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}

	}

	public function generarplanoF2 ($objectid, $lote_n) {
	
		$bbox = $this->lotes_model->mapafincabb_lote($lote_n);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_f2_Fincas.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_f1_Fincas.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanoC ($objectid, $lote_n) {
	
		$bbox = $this->lotes_model->mapabb_lote($lote_n);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_f2_Capacidad.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_f1_Capacidad.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanoT ($objectid, $lote_n) {
	
		$bbox = $this->lotes_model->mapabb_lote($lote_n);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_f2_Taxonomia.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_f1_Taxonomia.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanoMS86 ($objectid, $lote_n) {
	
		$bbox = $this->lotes_model->mapabb_lote($lote_n);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_f2_mapa_satelital86.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_mapa_satelital86.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}


	public function generarplanoU862 ($objectid, $lote_n) {
	
		$bbox = $this->lotes_model->mapabb_lote($lote_n);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_f2_uso_1986.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_uso_1986.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanoIA ($objectid, $lote_n) {
	
		$bbox = $this->lotes_model->mapabb_lote($lote_n);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_f2_imagen_actual.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_imagen_actual.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}


	//////////////// GENERAR PLANOS DE lotes /////////////////////
	//////////////// GENERAR PLANOS DE lotes /////////////////////
	//////////////// GENERAR PLANOS DE lotes /////////////////////
	//////////////// GENERAR PLANOS DE lotes /////////////////////




	public function generarplanoU ($objectid) {
	
		$bbox = $this->lotes_model->mapabb($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];

        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_f1_UsoActual.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_f1_UsoActual.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanoA ($objectid) {
	
		$bbox = $this->lotes_model->mapabb($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_f1_UsoAlternativo.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_f1_UsoAlternativo.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanoF ($objectid) {
	
		$bbox = $this->lotes_model->mapafincabb($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_f1_Fincas.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_f1_Fincas.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}


	public function generarplanoU86 ($objectid) {
	
		$bbox = $this->lotes_model->mapabb($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_uso_1986.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_uso_1986.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

    public function reset_busqueda()
    {
        $_SESSION['arraywhere_lotes']             = null;
        $_SESSION['arraywhere_lotes_busqueda']    = null;

        redirect('ficha_catastral/lotes/lotes/index/');
    }

	
}