<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends Admin_Controller {

    public function __construct()
    {
        parent::__construct();

        /* Load :: Common */
        $this->load->helper('number');
        $this->load->model('admin/dashboard_model');
    }


	public function index()
	{
        if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
        {
            redirect('auth/login', 'refresh');
        }
        else
        {
            /* Title Page */
            $this->page_title->push(lang('menu_dashboard'));
            $this->data['pagetitle'] = $this->page_title->show();

            /* Breadcrumbs */
            $this->data['breadcrumb'] = $this->breadcrumbs->show();

            //variable de sesión que identifica el url de i3geo
                        $_SESSION['url_mapserver'] = NULL;

            //variable de sesión que identificará los módulos
                        $_SESSION['id_modulo'] = NULL;

            //Aqui se debe asignar el URL de i3geo
            $_SESSION['url_mapserver'] = 'http://jaimito.site:8060/sgeMap';        
            /* Data */
            $this->data['count_users']       = $this->dashboard_model->get_count_record('users');
            $this->data['count_groups']      = $this->dashboard_model->get_count_record('groups');
            $this->data['disk_totalspace']   = $this->dashboard_model->disk_totalspace(DIRECTORY_SEPARATOR);
            $this->data['disk_freespace']    = $this->dashboard_model->disk_freespace(DIRECTORY_SEPARATOR);
            $this->data['disk_usespace']     = $this->data['disk_totalspace'] - $this->data['disk_freespace'];
            $this->data['disk_usepercent']   = $this->dashboard_model->disk_usepercent(DIRECTORY_SEPARATOR, FALSE);
            $this->data['memory_usage']      = $this->dashboard_model->memory_usage();
            $this->data['memory_peak_usage'] = $this->dashboard_model->memory_peak_usage(TRUE);
            $this->data['memory_usepercent'] = $this->dashboard_model->memory_usepercent(TRUE, FALSE);

            $user_groups = $this->ion_auth->get_users_groups()->result();
            if ($user_groups) {
                foreach ($user_groups as $key => $value) {
                    $_SESSION['user_groups'][] = $value->id;
                }
            }else{
                $_SESSION['user_groups'] = NULL;
            }


            $grupos = $this->ion_auth->obtener_menus($_SESSION['user_id'])->result();
            if ($grupos) {
                foreach ($grupos as $key => $value) {
                    $_SESSION['grupos'][] = $value->id;
                }
            }else{
                $_SESSION['grupos'] = NULL;
            }
/*
            echo '<pre>';
            print_r($_SESSION['grupos']);
            echo '</pre>';
            show_error(1);
*/          
            $usuario = $this->db->get_where('users', array('id' => $_SESSION['user_id']))->row();
            $this->data['nombre_usuario'] = $usuario->first_name.' '.$usuario->last_name;


            $this->data['habilitado_coor'] = grupo_usuario(31);
            $this->data['habilitado_ubi_sup'] = grupo_usuario(33);
            $this->data['habilitado_dao_sup'] = grupo_usuario(35);
            $this->data['habilitado_daj_sup'] = grupo_usuario(37);
            
            /* TEST */
            $this->data['url_exist']    = is_url_exist('http://www.domprojects.com');

            /* Load Template */
            $this->template->admin_render('admin/dashboard/index', $this->data);
        }
	}
}
