<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Auditoria_model extends Ion_auth_model {
	
	public function __construct()
	{
		parent::__construct();
	}
	
	/**
	 * geocolonias
	 *
	 * @return object
	 * @author Ben Edmunds
	 **/
	public function auditoria_all()
	{
		$this->trigger_events('auditoria');

		// run each where that was passed
		
		if (isset($this->_ion_where) && !empty($this->_ion_where))
		{
			foreach ($this->_ion_where as $where)
			{
				$this->db->where($where);
			}
			$this->_ion_where = array();
		}

		if (isset($this->_ion_limit) && isset($this->_ion_offset))
		{
			$this->db->limit($this->_ion_limit, $this->_ion_offset);

			$this->_ion_limit  = NULL;
			$this->_ion_offset = NULL;
		}
		else if (isset($this->_ion_limit))
		{
			$this->db->limit($this->_ion_limit);

			$this->_ion_limit  = NULL;
		}

		// set the order
		if (isset($this->_ion_order_by) && isset($this->_ion_order))
		{
			$this->db->order_by($this->_ion_order_by, $this->_ion_order);
		}

		$this->response = $this->db->get($this->tables['auditoria']);
		
		return $this;
	}


	/**
	 * geocolonia
	 *
	 * @return object
	 * @author Ben Edmunds
	 **/

	public function mostrar_all($tabla=FALSE,$arraywhere=FALSE)
	{
		//$user_id = $this->input->post('user_id');
		$this->trigger_events('mostrar_all');

		$this->response = $this->db->select('*');
		$this->response = $this->db->from($this->tables[$tabla]);
		foreach ($arraywhere as $k => $v) {

			$this->response = $this->db->where($k, $v);
		}

		$this->response = $this->db->limit(1);


		$this->response = $this->db->get();

		return $this;

						
	}

	/**
	 * create_geocolonia
	 *
	 * @author aditya menon
	*/
		
	public function num_filas () { 
	
		$number = $this->db->query("SELECT count(*) as number FROM sesiones")->row()->number; //rápido
		return intval($number);
	
	}

	public function get_pagination ($number_per_page) {
	
		return $this->db->get("sesiones",$number_per_page, $this->uri->segment(3));
	
	}

	
	public function delete_auditoria($id){

		$this->db->delete($this->tables['auditoria'], array('id' => $id));

		return TRUE;

	}
}