<?php


	/**
	 * Prouectos MOPC
	 *
	 * @return bool
	 * @author Lissy Jameuge Rojas Gonzales
	 **/


defined('BASEPATH') OR exit('No direct script access allowed');

class Memos extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('memos/memos_model');
		$this->lang->load('memos/memos_lang');

		/* Titulo de la pagina :: Common */
		$this->page_title->push(lang('menu_memos'));
		$this->data['pagetitle'] = $this->page_title->show();

		//verificación de módulo para el reset de las variables de sessión utilizadas en la misma
		if ($_SESSION['id_modulo'] != 'MEMOS') {

			$_SESSION['arraywhere_memos'] 		 = NULL;
			$_SESSION['arraywhere_memos_busqueda'] = NULL;
			$_SESSION['id_modulo'] = 'MEMOS';
		}

		if ( !isset($_SESSION['arraywhere_memos'])) {
			$this->vaciar_campos_detalle();
		}

		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_memos'), 'memos/memos');
	}

	public function index()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{

			if ($_POST) {
				if ($_POST['id_memo'])
				{
					if (is_numeric($_POST['id_memo'])) {
						$arraywhere['id_memo'] 					= $_POST['id_memo'];
						$arraywherebusq['id_memo'] 				= $_POST['id_memo'];
					}
				}

				if ($_POST['id_prof_emisor'])
				{
					if (is_numeric($_POST['id_prof_emisor'])) {
						$arraywhere['id_prof_emisor'] 					= $_POST['id_prof_emisor'];
						$arraywherebusq['id_prof_emisor'] 				= $_POST['id_prof_emisor'];
					}
				}

				if ($_POST['id_emisor'])
				{
					if (is_numeric($_POST['id_emisor'])) {
						$arraywhere['id_emisor'] 					= $_POST['id_emisor'];
						$arraywherebusq['id_emisor'] 				= $_POST['id_emisor'];
					}
				}

				if ($_POST['id_emisor'])
				{
					$arraywhere['id_emisor'] 					= $_POST['id_emisor'];
					$arraywherebusq['id_emisor like '] 			= '%'.$_POST['id_emisor'].'%';
				}

				if ($_POST['id_prof_receptor'])
				{
					$arraywhere['id_prof_receptor'] 					= $_POST['id_prof_receptor'];
					$arraywherebusq['lower(id_prof_receptor) like '] 	= '%'.strtolower($_POST['id_prof_receptor']).'%';
				}


				if ($_POST['id_receptor'])
				{
					$arraywhere['id_receptor'] 					= $_POST['id_receptor'];
					$arraywherebusq['id_receptor like '] 		= '%'.$_POST['id_receptor'].'%';
				}


				if ($_POST['descripcion'])
				{
					$arraywhere['descripcion'] 					= $_POST['descripcion'];
					$arraywherebusq['lower(descripcion) like '] = '%'.strtolower($_POST['descripcion']).'%';
				}

				if ($_POST['referencia'])
				{
					$arraywhere['referencia'] 					= $_POST['referencia'];
					$arraywherebusq['lower(referencia) like ']  = '%'.strtolower($_POST['referencia']).'%';
				}


				if ($_POST['fecha'])
				{
					$arraywhere['fecha'] 						= $_POST['fecha'];
					$arraywherebusq['lower(fecha) like '] 		= '%'.strtolower($_POST['fecha']).'%';
				}


				if ($_POST['id_usuario'])
				{
					$arraywhere['id_usuario'] 					= $_POST['id_usuario'];
					$arraywherebusq['lower(id_usuario) like '] 	= '%'.strtolower($_POST['id_usuario']).'%';
				}


				if ($_POST['nro_memo'])
				{
					$arraywhere['nro_memo'] 					= $_POST['nro_memo'];
					$arraywherebusq['nro_memo like '] 			= '%'.$_POST['nro_memo'].'%';
				}

				if ($_POST['nro_memo_dao'])
				{
					$arraywhere['nro_memo_dao'] 				= $_POST['nro_memo_dao'];
					$arraywherebusq['nro_memo_dao like '] 		= '%'.$_POST['nro_memo_dao'].'%';
				}


				if ($_POST['anho_memo'])
				{
					if (is_numeric($_POST['anho_memo'])) {
						$arraywhere['anho_memo'] 				= $_POST['anho_memo'];
						$arraywherebusq['anho_memo'] 			= $_POST['anho_memo'];
					}
				}


				$_SESSION['arraywhere_memos'] = $arraywhere;
				$_SESSION['arraywhere_memos_busqueda'] = $arraywherebusq;

				redirect('memos/memos/index/');
			}

			 // ----- Paginacion Generica
			$mi_paginacion = $this->ion_auth->paginacion_generica(
				12, 						// resultados por por_pagina,
				4, 							// segmento uri a leer,
				5, 							// cantidad_enlaces,
				base_url(). 'memos/memos/index/',  // url completa de la pagina paginada
				'memos',		            // scheme y nombre de la tabla, para la consulta
				$_SESSION['arraywhere_memos_busqueda']
				);

			$this->data['pagination'] 		= $mi_paginacion['pagination'];

			$this->data['memos']	  	= $this->ion_auth_model->segmentador_paginas(
			//$proyectos	  	= $this->ion_auth_model->segmentador_paginas(
 				$mi_paginacion['per_page'], 	// resultados por pagina
 				4,								// segmento uri a leer
 				'memos',					    // el nombre de la tabla a consultar $nombre_tabla
 				$_SESSION['arraywhere_memos_busqueda'],
				'memos',
				'ASC'
 				)->result();
			// ----- Fin paginacion

/*
			foreach ($this->data['memos'] as $key => $value) {
				$i = 0;
				foreach ($value as $k => $val) {
					$i = $i + 1;
					if ($i == 1) {

						//$cant_pol = $this->proyectos_model->f_existe_grafico_id_proyecto($value->id_proyecto);
						//$exp['existe_poligono'] = $cant_pol;
						$val['existe_poligono'] = 1;


						//if (grupo_usuario(17) or grupo_usuario(27)) {
							$val['grupo_usuario'] = 'C';
						//}else{
						//	$exp['grupo_usuario'] = 'N';
						//}
					}
					$memo[$k] = $val;
				}
				$memos[] = (object)$memo;
			}
			

			if (isset($memos)) {
				$this->data['memos'] = $memos;
			}else{
				$this->data['memos'] = NULL;
			}
*/
			//emite un mensaje si es que se eliminó un proyecto
			if (isset($_SESSION['last_memo_delete'])) {
				$this->session->set_flashdata('message', $_SESSION['last_memo_delete']);
				unset($_SESSION['last_memo_delete']);
			}

			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

			/* Breadcrumbs */
			$this->data['breadcrumb'] = $this->breadcrumbs->show();

			$this->data['habilitado_sis'] = grupo_usuario(3);
			$this->data['habilitado_director'] = grupo_usuario(3);

			/* Load Template */
            $this->template->admin_render('memos/index', $this->data);
		}
	}

	public function reset_busqueda()
	{
		$_SESSION['arraywhere_memos'] 			= NULL;
		$_SESSION['arraywhere_memos_busqueda'] 	= NULL;

		redirect('memos/memos/index/');
	}

	public function ver_exp($id_memo)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{
			/* Breadcrumbs */
	        $this->breadcrumbs->unshift(2, 'Información Expediente', 'admin/groups/profile');
	        $this->data['breadcrumb'] = $this->breadcrumbs->show();

			$this->data['expe_info']  = $this->memos_model->view('exp', array('id_memo' => $id_memo))->result();

			/* Load Template */
            $this->template->admin_render('memos/ver_memo', $this->data);
		}
	}



	public function create()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('memos_create'), 'memos/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Validate form input */

		$this->form_validation->set_rules('id_emisor', 		'<b>Emisor</b>' , 	'required');
		//$this->form_validation->set_rules('expediente', 		'<b>Expediente</b>' , 		'required');

		//$this->form_validation->set_rules('id_proyecto_geomatica', 	'<b>ID Geomática</b>' ,  'required');

		if ($this->form_validation->run() == TRUE)
		{

				//show_error(2);
	        	if ($_POST['id_memo']){
					$arraycampos['id_memo'] 		= $_POST['id_memo'];
				}

				if ($_POST['id_prof_emisor']){
					$arraycampos['id_prof_emisor'] 	= strtoupper($_POST['id_prof_emisor']);
				
				}

	        	if ($_POST['id_emisor']){
					$arraycampos['id_emisor'] 		= strtoupper($_POST['id_emisor']);

				}

				if ($_POST['id_prof_receptor']){
					$arraycampos['id_prof_receptor'] = strtoupper($_POST['id_prof_receptor']);
				}

	        	if ($_POST['id_receptor']){
					$arraycampos['id_receptor'] 	= strtoupper($_POST['id_receptor']);

				}

	        	if ($_POST['referencia']){
					$arraycampos['referencia'] 		= $_POST['referencia'];
				}

				if ($_POST['descripcion']){
					$arraycampos['descripcion'] 	= $_POST['descripcion'];
				}

				
				if ($_POST['fecha']){
					$arraycampos['fecha'] 			= $_POST['fecha'];
				}

				if ($_POST['id_usuario']){
					$arraycampos['id_usuario'] 		= $_POST['id_usuario'];
				}


				if ($_POST['nro_memo']){
					$arraycampos['nro_memo'] 		= $_POST['nro_memo'];
				}

				if ($_POST['tipo_memo']){
					$arraycampos['tipo_memo'] 		= $_POST['tipo_memo'];
				}

				if ($_POST['anho_memo']){
					$arraycampos['anho_memo'] 		= $_POST['anho_memo'];
				}

				if ($_POST['anho_memo']){
					$arraycampos['anho_memo'] 		= $_POST['anho_memo'];
				}


				
			$accion = 0;
			if (isset($_POST['accion'])){
				$accion = intval($_POST['accion']);
			}else{
				$accion = 0;
			}

			//preguntar si existe memo?	
			$id_memo = $this->memos_model->obtener_nextval('public.memos_id_memo_seq');
			$nro_memo = $this->memos_model->obtener_nextval('public.memos_nro_memo_seq');
			$arraycampos['id_memo'] = $id_memo;
			$arraycampos['nro_memo'] = $nro_memo;
			/*
			echo('ID memo:' . $_POST['id_memo']);
			echo('</br>');
			echo('Nro memo:' . $_POST['nro_memo']);
			echo('</br>');
			echo('referencia:' . $_POST['referencia']);
			echo('</br>');
			echo('descripcion:' . $_POST['descripcion']);
			echo('</br>');
			echo('emisor profesional:' . $_POST['id_prof_emisor']);
			echo('</br>');
			echo('emisor:' . $_POST['id_emisor']);
			echo('</br>');
			echo('receptor profesional:' . $_POST['id_prof_receptor']);
			echo('</br>');
			echo('receptor:' . $_POST['id_receptor']);
			echo('</br>');
			echo('año:' . $_POST['anho_memo']);
			*/
			/*
			echo "<prev>";
			print_r($arraycampos);
			echo "</prev>";
			show_error(1);
			*/

			$memo_create = $this->memos_model->crear_memo($arraycampos);
			

        	if ($memo_create)
        	{

				if($accion===1){ /// ACCION PARA OBSERVAR

        			$this->session->set_flashdata('message', '¡Expediente <b>'.$_POST['id_memo'].'</b>, Memo <b>'.$_POST['id_memo'].'</b> creado exitósamente!');
					//redirect('memos/memos/edit_memos/'.$id_memo);
					redirect('memos/memos/index');

				} else {

        			$this->session->set_flashdata('message', '¡Expediente <b>'.$_POST['id_memo'].'</b>, Gestión <b>'.$_POST['id_memo'].'</b> creado exitósamente!');
					//redirect('memos/memos/edit_memos/'.$id_memo);
					redirect('memos/memos/index');
				}
			}
			else
			{
				$this->session->set_flashdata('message', $this->ion_auth->errors());
			}
		}
		else
		{
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));


			$this->data['id_memo'] = array(
				'type'     => 'text',
				'name'     => 'id_memo',
				'id'       => 'id_memo',
				'value'    => $this->form_validation->set_value('id_memo'),
				'class'    => 'form-control',
				'maxlength'=> '10',
				'readonly' => 'true'
			);

			$this->data['tipo_memo'] = array(
                    'type'     	=> 'radio',
                    'name'     	=> 'tipo_memo',
                    'id'       	=> 'tipo_memo',
                    'value_ubi' => 'UBI',
                    'value_dao'	=> 'DAO',
                    'value_daj'	=> 'DAJ',
                    'value_otr'	=> 'OTR',
                    'class'    	=> 'form-control'
            );
        
            $this->data['tipo_memo']['checked_ubi'] = true;
            $this->data['tipo_memo']['checked_dao'] = false;
            $this->data['tipo_memo']['checked_daj'] = false;
            $this->data['tipo_memo']['checked_otr'] = false;

			$this->data['nro_memo'] = array(
				'type'     => 'text',
				'name'     => 'nro_memo',
				'id'       => 'nro_memo',
				'value'    => $this->form_validation->set_value('nro_memo'),
				'class'    => 'form-control',
				'maxlength'=> '10',
				'readonly' => 'true' 
			);

			$a_id_prof_emisor[''] = 'Seleccione Profesional';
			$r_id_prof_emisor = $this->memos_model->dropdown_data('profesionales')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
				foreach ($r_id_prof_emisor as $d_id_prof_emisor) {
			$a_id_prof_emisor[$d_id_prof_emisor['id_profesional']] = $d_id_prof_emisor['id_profesional'] . ' - ' . $d_id_prof_emisor['cod_des'];
				}

			$this->data['prof_emisor'] = $a_id_prof_emisor;


			$a_id_emisor[''] = 'Seleccione al Emisor';
			$r_id_emisor = $this->memos_model->dropdown_data('users')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
				foreach ($r_id_emisor as $d_id_emisor) {
			$a_id_emisor[$d_id_emisor['id']] = $d_id_emisor['id'] . ' - ' . $d_id_emisor['first_name']. '   ' . $d_id_emisor['last_name'];
				}
			$this->data['emisor'] = $a_id_emisor;
				//$this->data['id_lineaproducto_sel'] = $this->form_validation->set_value('id_lineaproducto'),

			/*$this->data['id_emisor'] = array(
				'type'     => 'text',
				'name'     => 'id_emisor',
				'id'       => 'id_emisor',
				'value'    => $this->form_validation->set_value('id_emisor'),
				'class'    => 'form-control',
				'maxlength'=> '4'
			);*/

			$a_id_prof_receptor[''] = 'Seleccione Profesional';
			$r_id_prof_receptor = $this->memos_model->dropdown_data('profesionales')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
				foreach ($r_id_prof_receptor as $d_id_prof_receptor) {
			$a_id_prof_receptor[$d_id_prof_receptor['id_profesional']] = $d_id_prof_receptor['id_profesional'] . ' - ' . $d_id_prof_receptor['cod_des'];
				}
			$this->data['prof_receptor'] = $a_id_prof_receptor;


			$a_id_receptor[''] = 'Seleccione al Receptor ';
			$r_id_receptor = $this->memos_model->dropdown_data('users')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
				foreach ($r_id_receptor as $d_id_receptor) {
			$a_id_receptor[$d_id_receptor['id']] = $d_id_receptor['id'] . ' - ' . $d_id_receptor['first_name']. '   ' . $d_id_receptor['last_name'];
				}
			$this->data['receptor'] = $a_id_receptor;

			/*
			$this->data['id_receptor'] = array(
				'type'     => 'text',
				'name'     => 'id_receptor',
				'id'       => 'id_receptor',
				'value'    => $this->form_validation->set_value('id_receptor'),
				'class'    => 'form-control',
				'maxlength'=> '4'
			);
			*/
			$this->data['referencia'] = array(
				'type'     => 'text',
				'name'     => 'referencia',
				'id'       => 'referencia',
				'value'    => $this->form_validation->set_value('referencia'),
				'class'    => 'form-control',
				'maxlength'=> '250'
			);
			$this->data['descripcion'] = array(
				'type'     => 'text',
				'name'     => 'descripcion',
				'id'       => 'descripcion',
				'value'    => $this->form_validation->set_value('descripcion'),
				'class'    => 'form-control',
				'maxlength'=> '1000'
			);
			$this->data['fecha'] = array(
				'type'     => 'text',
				'name'     => 'fecha',
				'id'       => 'fecha',
				'rows'     => '1',
				'value'    => $this->form_validation->set_value('fecha'),
				'class'    => 'form-control',
				'maxlength'=> '255'
			);
			$this->data['id_usuario'] = array(
				'type'     => 'text',
				'name'     => 'id_usuario',
				'id'       => 'id_usuario',
				'value'    => $this->form_validation->set_value('id_usuario'),
				'class'    => 'form-control',
				'maxlength'=> '4',
				'readonly' => 'true'
			);
			
			$this->data['anho_memo'] = array(
				'type'     => 'number',
				'name'     => 'anho_memo',
				'id'       => 'anho_memo',
				'value'    => $this->form_validation->set_value('anho_memo'),
				'class'    => 'form-control',
				'onkeyup'  => 'limit_dig(this.id,4)',
				'maxlength'=> '4'
			);
			
			/* Load Template */
			$this->template->admin_render('memos/create_memos', $this->data);
		}
	}

	public function edit_memo($id_memo)
	{

		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin() OR ! $id_memo OR empty($id_memo))
		{
			redirect('auth', 'refresh');
		}
		else
		{
					/* Breadcrumbs */
			$this->breadcrumbs->unshift(2, lang('menu_memos_edit'), 'memos/edit_memo');
			$this->data['breadcrumb'] = $this->breadcrumbs->show();

			//$exp_datos = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();


			$memo = $this->memos_model->view('memos', array('id_memo' => $id_memo))->row();

			$this->form_validation->set_rules('id_memo', 		'<b>Id MEMO</b>' , 		 'required');
			
			//Se produce cuando el usuario da click en el submit
	        if (isset($_POST) && ! empty($_POST))
	        {
	        	if ($this->form_validation->run() == TRUE)
	        	{
					if ($_POST['id_memo']){
						$arraycampos['id_memo'] 			= $_POST['id_memo'];
					}
					
					if ($_POST['id_prof_emisor']){
					$arraycampos['id_prof_emisor'] 			= strtoupper($_POST['id_prof_emisor']);

					}

					if ($_POST['id_emisor']){
					$arraycampos['id_emisor'] 				= strtoupper($_POST['id_emisor']);

					}

					if ($_POST['id_prof_receptor']){
					$arraycampos['id_prof_receptor'] 		= strtoupper($_POST['id_prof_receptor']);

					}

					if ($_POST['id_receptor']){
					$arraycampos['id_receptor'] 			= strtoupper($_POST['id_receptor']);

					}

					if ($_POST['referencia']){
						$arraycampos['referencia'] 			= $_POST['referencia'];
					}
					if ($_POST['descripcion']){
						$arraycampos['descripcion'] 		= $_POST['descripcion'];
					}
					if ($_POST['fecha']){
						$arraycampos['fecha'] 				= $_POST['fecha'];
					}
					if ($_POST['id_usuario']){
						$arraycampos['id_usuario'] 			= $_POST['id_usuario'];
					}
					if ($_POST['nro_memo']){
						$arraycampos['nro_memo'] 			= $_POST['nro_memo'];
					}
					if ($_POST['anho_memo']){
						$arraycampos['anho_memo'] 			= $_POST['anho_memo'];
					}

					
					$actualizar_memo = $this->memos_model->actualizar_memo($id_memo,$arraycampos);

	        		//if ($resul)
	        		if ($actualizar_memo)
	        		{
						//una prueba de que trae los valores es reemplazando $this->lang->line('edit_geocolonia_saved') por $_POST('id') por ejemplo
	        			$this->session->set_flashdata('message', $this->lang->line('memos_update_successful'));
						redirect('memos/memos/edit_memo/'.$id_memo);
					}
					else
					{
						$this->session->set_flashdata('message', $this->ion_auth->errors());
					}


				}
			//echo("Entro VALIDATION") ;
			//show_error(1);				
			}	
			//$this->data['message'] = "Entro POST";
			//show_error(1);
			//$this->form_validation->set_rules('id_exp', 		'<b>Id Expediente</b>' , 		 'required');

			$arraywhere_memos = $_SESSION['arraywhere_memos'];
			
			$id_detalle	      = $arraywhere_memos['id_detalle'];
			$id_exp		   	  = $arraywhere_memos['id_exp'];
			$notificacion	  = $arraywhere_memos['notificacion'];
			$item 		      = $arraywhere_memos['item'];
			//$codigo_unico     = $arraywhere_memos['codigo_unico'];
			$codigo_unico_ref = $arraywhere_memos['codigo_unico_ref'];
			$validacion 	  = $arraywhere_memos['validacion'];
	

			$memo_info  = $this->memos_model->view('memos', array('id_memo' => $id_memo))->result_array();
			$m_detalle  = $this->memos_model->dropdown_data('memos_detalle', array('id_memo' => $id_memo), 'id_detalle ASC')->result_array();
			$validar = $this->memos_model->validar_afectacion_coord($id_memo,$validacion);
			$cant_puntos = $this->memos_model->contar_puntos($id_memo);

			$this->data['memo_info'] 		= $memo_info;
			$this->data['m_detalle'] 		= $m_detalle;

			$this->data['id_memo'] = array(
				'type'     => 'number',
				'name'     => 'id_memo',
				'id'       => 'id_memo',
				//'value'    => $this->form_validation->set_value('id_memo', $memo->id_memo),
				'value'    => $id_memo,
				'class'    => 'form-control',
				'maxlength'=> '10',
				'readonly' => 'true'
			);

			$a_prof_emisor[''] = 'Seleccione Profesional';
			$r_prof_emisor = $this->memos_model->dropdown_data('profesionales')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($r_prof_emisor as $d_prof_emisor) {
				$a_prof_emisor[$d_prof_emisor['id_profesional']] = $d_prof_emisor['id_profesional'] . ' - ' . $d_prof_emisor['cod_des'];
			}
			$this->data['prof_emisor'] = $a_prof_emisor;
			$this->data['prof_emisor_sel'] = $memo->id_prof_emisor;

			$a_emisor[''] = 'Seleccione al Emisor';
			$r_emisor = $this->memos_model->dropdown_data('users')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($r_emisor as $d_emisor) {
				$a_emisor[$d_emisor['id']] = $d_emisor['id'] . ' - ' . $d_emisor['first_name'] . '   ' . $d_emisor['last_name'];
			}
			$this->data['emisor'] = $a_emisor;
			$this->data['emisor_sel'] = $memo->id_emisor;

			$a_prof_receptor[''] = 'Seleccione Profesional';
			$r_prof_receptor = $this->memos_model->dropdown_data('profesionales')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($r_prof_receptor as $d_prof_receptor) {
				$a_prof_receptor[$d_prof_receptor['id_profesional']] = $d_prof_receptor['id_profesional'] . ' - ' . $d_prof_receptor['cod_des'];
			}
			$this->data['prof_receptor'] = $a_prof_receptor;
			$this->data['prof_receptor_sel'] = $memo->id_prof_receptor;

			$a_receptor[''] = 'Seleccione al Receptor';
			$r_receptor = $this->memos_model->dropdown_data('users')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($r_receptor as $d_receptor) {
				$a_receptor[$d_receptor['id']] = $d_receptor['id'] . ' - ' . $d_receptor['first_name'] . '   ' . $d_receptor['last_name'];
			}
			$this->data['receptor'] = $a_receptor;
			$this->data['receptor_sel'] = $memo->id_receptor;

			

			$this->data['referencia'] = array(
				'type'     => 'text',
				'name'     => 'referencia',
				'id'       => 'referencia',
				'value'    => $this->form_validation->set_value('referencia', $memo->referencia),
				//'value'    => $referencia,
				'class'    => 'form-control',
				'maxlength'=> '250'
			);

			$this->data['descripcion'] = array(
				'type'     => 'text',
				'name'     => 'descripcion',
				'id'       => 'descripcion',
				'value'    => $this->form_validation->set_value('descripcion', $memo->descripcion),
				'class'    => 'form-control',
				'maxlength'=> '1000'
			);

			$this->data['fecha'] = array(
	            'type'     => 'text',
	            'name'     => 'fecha',
	            'id'       => 'fecha',
	            'value'    => $this->form_validation->set_value('fecha', formato_fecha($memo->fecha)),
	            //'value'    => $fecha,
	            'class'    => 'form-control',
	            'required' => 'true'
	        );


			$this->data['id_usuario'] = array(
				'type'     => 'text',
				'name'     => 'id_usuario',
				'id'       => 'id_usuario',
				'value'    => $this->form_validation->set_value('id_usuario', $memo->id_usuario),
				//'value'    => $id_usuario,
				'class'    => 'form-control',
				'maxlength'=> '4'
			);
	
		
			$this->data['nro_memo'] = array(
				'type'     => 'text',
				'name'     => 'nro_memo',
				'id'       => 'nro_memo',
				'value'    => $this->form_validation->set_value('nro_memo', $memo->nro_memo),
				//'value'    => $nro_memo,
				'class'    => 'form-control',
				'maxlength'=> '10',
				'readonly' => 'true'
			);
			$this->data['anho_memo'] = array( 
				'type'     => 'number', 
				'name'     => 'anho_memo', 
				'id'       => 'anho_memo', 
				'value'    => $this->form_validation->set_value('anho_memo', $memo->anho_memo), 
				//'value'    => $anho_memo, 
				'class'    => 'form-control', 
				'onkeyup'  => 'limit_dig(this.id,4)', 
				'maxlength'=> '4' 
			);
		
			$this->data['id_detalle'] = array(
				'type'     => 'number',
				'name'     => 'id_detalle',
				'id'       => 'id_detalle',
				//'value'    => $this->form_validation->set_value('id_detalle'),
				'value'    => $this->form_validation->set_value('id_detalle', $id_detalle),
				'readonly' => 'true'
			);

			$this->data['id_exp'] = array(
				'type'     => 'number',
				'name'     => 'codigo_id_exp',
				'id'       => 'codigo_id_exp',
				//'value'    => $this->form_validation->set_value('id_exp'),
				'value'    => $this->form_validation->set_value('id_exp', $id_exp)
			);

			$this->data['notificacion'] = array(
				'type'     => 'text',
				'name'     => 'notificacion',
				'id'       => 'notificacion',
				'maxlength'=> '20',
				//'class'    => 'form-control', 
				//'value'    => $this->form_validation->set_value('notificacion'),
				'maxlength'=> '20',
				'value'    => $this->form_validation->set_value('notificacion', $notificacion)
			);

			$this->data['item'] = array(
				'type'     => 'number',
				'name'     => 'item',
				'id'       => 'item',
				'maxlength'=> '10',
				//'value'    => $this->form_validation->set_value('item'),
				'value'    => $this->form_validation->set_value('item', $item)
			);
			/*
			$this->data['codigo_unico'] = array(
				'type'     => 'text',
				'name'     => 'codigo_unico',
				'id'       => 'codigo_unico',
				'maxlength'=> '20',
				//'class'    => 'form-control', 
				//'value'    => $this->form_validation->set_value('notificacion'),
				'maxlength'=> '20',
				'value'    => $this->form_validation->set_value('codigo_unico', $codigo_unico)
			);
			*/
			/*
			$expes[''] = 'Seleccione Expediente';
			$expe = $this->expedientes_model->dropdown_data('exp',array('expe_id_expediente' => $expediente->expe_id_expediente_ref),
																 'expe_id'
																)->result_array();
			*/

			$expes[''] = 'Seleccione Expediente';			
			$expe = $this->memos_model->dropdown_data('expedientes',array(' lower(codigo_unico) like ' => '%'.strtolower($codigo_unico_ref).'%'), 'id')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($expe as $ex) {
				$expes[$ex['id']] = $ex['codigo_unico'];
			}
			$this->data['expe'] = $expes;
			$this->data['expe_sel'] = $id_exp;	


			$this->data['codigo_unico_ref'] = array(
				'type'     => 'text',
				'name'     => 'codigo_unico_ref',
				'id'       => 'codigo_unico_ref',
				'placeholder'=>'codigo_unico_ref',
				'value'    => $this->form_validation->set_value('codigo_unico_ref', $codigo_unico_ref),
				'class'    => 'form-control',
				'onkeyup'  => 'limit_dig(this.id,10)'
			);

			
		}
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
		
			// Load Template 

			$this->template->admin_render('memos/edit_memos', $this->data);
	}

	public function trae_expe_ref($codigo_unico_ref = NULL)
	//public function trae_expe_ref()
	{
		
		//$codigo_unico_ref 	   = $_POST['codigo_unico_ref'];
		
		//echo $codigo_unico_ref;
		//show_error(1);

		//$expes[''] = 'Seleccione Expediente';			
		$expe = $this->memos_model->dropdown_data('expedientes',array(' lower(codigo_unico) like ' => '%'.strtolower($codigo_unico_ref).'%'), 'id')->result();
		

		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		/*
		foreach ($expe as $ex) {
			$expes[$ex['id']] = $ex['codigo_unico'];
		}
		*/

		$lista = '<option value="">Seleccione Expediente</option>';
		foreach ($expe as $value) {

			$lista = $lista . '<option value="' . $value->id . '">' . $value->codigo_unico .  '</option>';
		}

		echo $lista;
		//echo json_encode($expes);
	}



	/*actualizar_coordafecta*/
    public function actualizar_detalle()
	{

		$id_memo 	= $_POST['id_memo'];
		$memo_data = $this->memos_model->view('memos', array('id_memo' => $id_memo))->row();
		$coord_id_memo= $memo_data->id_memo;

		$id_detalle 				= $_POST['id_detalle'];
		$id_exp 					= $_POST['id_exp'];
		$notificacion				= $_POST['notificacion'];
		$item 	 					= $_POST['item'];
		$codigo_unico_ref			= $_POST['codigo_unico_ref'];

		$datos_update['id_detalle']			= $id_detalle;
        $datos_update['id_memo'] 			= $coord_id_memo;
        $datos_update['id_exp'] 			= $id_exp;
        $datos_update['notificacion']		= $notificacion;
        $datos_update['item'] 				= $item;
        $datos_update['codigo_unico_ref']	= $codigo_unico_ref;

        


        $datos_insert['id_detalle']			= $id_detalle;
        $datos_insert['id_exp']				= $id_exp;
        $datos_insert['id_memo'] 			= $coord_id_memo;
        $datos_insert['notificacion'] 		= $notificacion;
        $datos_insert['item'] 				= $item;
        $datos_insert['codigo_unico_ref'] 	= $codigo_unico_ref;


		$arraywhere_m_detalles['id_detalle']      	= $id_detalle;
		$arraywhere_m_detalles['id_exp']	      	= $id_exp;
		$arraywhere_m_detalles['coord_id_memo']     = $coord_id_memo;
		$arraywhere_m_detalles['notificacion'] 	    = $notificacion;
		$arraywhere_m_detalles['item']      		= $item;
		$arraywhere_m_detalles['codigo_unico_ref']	= $codigo_unico_ref;
		$arraywhere_m_detalles['validacion']      	= 0;

		$_SESSION['arraywhere_m_detalles'] 		 	= $arraywhere_m_detalles;

		/*
				echo '<pre>';
		        print_r( $_SESSION['arraywhere_coordenadas'] );
		        echo '</pre>';
		        show_error(1);
		*/


		$accion = 0;
		if (isset($_POST['accion'])){
			$accion = intval($_POST['accion']);
		}else{
			$accion = 0;
		}
			// pregunta sin existen datos graficos del expediente.
		if (isset($id_exp) && $id_exp>0 && $id_detalle>0 && !is_null($id_detalle)) {		
			
			$cnt_registro = $this->memos_model->f_existe_detalle($coord_id_memo,$id_detalle,$id_exp,$notificacion,$item,$codigo_unico_ref);


		} else {
			$cnt_registro = 0;
		}
		
		//if ($coord_coord_x > 999999 or $coord_coord_y > 9999999) {

		if ($id_detalle > 999999 || (!isset($id_exp) || $id_exp <= 0 )) {
			$this->session->set_flashdata('message', 'Detalles exeden los limites o id expediente es 0!!');
			redirect('memos/memos/edit_memo/'.$coord_id_memo);
		} else {

			if ($cnt_registro==0 && ($id_detalle==0|| is_null($id_detalle))) {
				/*
				echo '<pre>';
		        print_r( $datos_insert );
		        echo '</pre>';
		        show_error(1); 
		        */

	            try {
	                // insert the new expediente
	                $id_detalle = $this->memos_model->obtener_nextval('public.memos_id_detalle_seq');
	                $datos_insert['id_detalle']			= $id_detalle;
					$actu = $this->memos_model->insertar_detalle($datos_insert);
					$this->session->set_flashdata('message', 'Detalle agregada!!');
					$this->limpiar_campos_detalle($coord_id_memo);
					redirect('memos/memos/edit_memo/'.$coord_id_memo);
	            }
	            catch(Exception $e) {
	                //echo 'Message: ' .$e->getMessage();
	                $this->session->set_flashdata('message', 'Error de datos!');
	                redirect('memos/memos/edit_memo/'.$coord_id_memo);
	            }

			}
			else {


	            try {
	                // insert the new expediente			
	            /*
				echo '<pre>';
		        print_r( $datos_update );
		        print_r( $id_detalle );
		        echo '</pre>';
		        show_error(1); 
		        */

	                $actu = $this->memos_model->actualizar_detalle($id_detalle, $datos_update);
	                //$actu = $this->memos_model->actualizar_detalle($id_detalle,$datos_update);

					if ($actu) {
						$this->session->set_flashdata('message', '¡Actualización Realizada!');
						$this->limpiar_campos_detalle($coord_id_memo);
						redirect('memos/memos/edit_memo/'.$coord_id_memo);
					}
					else {
						$this->session->set_flashdata('message', '¡No actualizo!');
						redirect('memos/memos/edit_memo/'.$coord_id_memo);
					}
	            } catch(Exception $e) {
	                //echo 'Message: ' .$e->getMessage();
	                $this->session->set_flashdata('message', '¡Error de detalle! :'.$e);
	                //$this->ion_auth->set_message('coordafecta_creation_successful');
	                redirect('memos/memos/edit_memo/'.$coord_id_memo);
	            }
			}
		}

	}

	public function limpiar_campos_detalle($id_detalle = NULL)
	{


		$this -> vaciar_campos_detalle($id_detalle);

		$this->session->set_flashdata('message', 'Los datos del detalle estan vacias!');
		$this->session->set_flashdata('message', '¡Actualización Realizada!');
		//redirect('memos/memos/edit_memo/'.$id_memo);

	}

	public function vaciar_campos_detalle($id_memo = NULL)
	{


		$arraywhere_m_detalles['id_detalle']    	= NULL;
		$arraywhere_m_detalles['id_memo']      		= $id_memo;
		$arraywhere_m_detalles['id_exp']      		= 0;
		$arraywhere_m_detalles['notificacion']  	= NULL;
		$arraywhere_m_detalles['item']      		= NULL;
		$arraywhere_m_detalles['codigo_unico_ref'] 	= NULL;
		$arraywhere_m_detalles['validacion']    	= 0;
		$_SESSION['arraywhere_m_detalles'] 			= $arraywhere_m_detalles;
	}

	public function imprimir_pdf ($id_memo=NULL) {

        	//$i_jameuge = "https://www.mopc.gov.py/sgeGis/sgeMap/index.html?id_proyec=" . $id_proyec;
        	//$i_pdf = "http://localhost/sge/fpdf/tutorial/memo_mopc?id_memo=" . $id_memo;
        	$i_pdf = "http://localhost/sge/fpdf/memos/report_memo.php?id_memo=" . $id_memo;
        	//$i_pdf = $i_pdf . "&tipo_imprimir=mopc_memos_id_memo";

			redirect($i_pdf);
	}

	public function tiene_salida()
	{
		$id_proyecto = $_POST['id_proyecto'];

		$expe = $this->proyectos_model->view('exp', array('id_proyecto' => $id_proyecto, 'expe_estado' => 'P'))->row();

		if ($expe) {
			echo 'SI';
		}else{
			echo 'NO';
		}
	}

	public function existe_grafico()
	{
		$id_proyecto 	= $_POST['id_proyecto'];
		$gestion 		= $_POST['gestion'];

		$expe = $this->proyectos_model->existe_grafico($id_proyecto, $gestion)->row()->f_existe_grafico;

		echo $expe;
	}


	public function existe_grafico_id_proyecto()
	{
		$id_proyecto 	= $_POST['id_proyecto'];

		$expe = $this->proyectos_model->existe_grafico_id_proyecto($id_proyecto)->row()->f_existe_grafico_id_proyecto;

		echo $expe;
	}

	public function eliminar_detalle($id_memo = NULL, $id_detalle = NULL)
	{

		$resultado = $this->memos_model->eliminar_detalle($id_detalle);

		//if (condition) {
		//	# code...
		//}
		$this->session->set_flashdata('message', 'EL DETALLE SE ELIMINO!');
		redirect('memos/memos/edit_memo/'.$id_memo);

	}

	public function obtener_detalle ($id_detalle) {

	//$dpto=$_POST['dpto'];
	//$distrito=$_POST['distrito'];
	//$colonia=$_POST['colonia'];
	$detalles['data'] = $this->memos_model->obtener_detalle('memos_detalle', array('id_detalle' => $id_detalle))->result_array();
	
	echo json_encode($detalles);

	}


	public function existe_exp()
	{
		$exp 		= $_POST['exp'];
		$gestion 	= $_POST['gest'];

		$expe = $this->proyectos_model->dropdown_data('exp', array('id_proyecto_proyecto' => $exp, 'expe_gestion' => $gestion))->num_rows();

		if ($expe > 0) {
			echo 'SI';
		}else{
			echo 'NO';
		}
	}

	public function existe_exp_uk()
	{

		$codigo 		= $_POST['codigo'];
		$id_proyecto 	= $_POST['id_proyecto'];

		$expe = $this->proyectos_model->dropdown_data('proyectos', array('codigo' => $codigo,
			                                                          'id_proyecto' => $id_proyecto
			                                                          ))->num_rows();

		if ($expe > 0) {
			echo 'SI';
		}else{
			echo 'NO';
		}
	}


	public function reingreso_exp()
	{
		$exp 	= $_POST['exp'];
		$gest 	= $_POST['gest'];

		$id_proyecto = $this->proyectos_model->dropdown_data('exp', array('id_proyecto_proyecto' => $exp, 'expe_gestion' => $gest))->row()->id_proyecto;

		echo $id_proyecto;

		//$reingreso  = $this->proyectos_model->actualizar_proyecto($id_proyecto, array('id_proyecto_proyecto_ref' => $exp, 'id_proyecto' => ));


		//redirect('proyectos/proyectos/edit_proyecto/'.$id_proyecto);
	}

	public function dar_salida_expe($id_proyecto, $id_proyecto_proyecto, $expe_gestion, $expe_provdg = NULL)
	{

		$i_exp 		= $id_proyecto_proyecto;
		$i_gest 	= $expe_gestion;


					$i_user = $this->session->userdata('username');
					//echo $i_user;
					//show_error(1);

		if (!is_null($i_exp) AND $i_gest > 0) {
			if (grupo_usuario(18)) {


				//if ($expe_provdg == NULL) {
				if (is_null($expe_provdg)) {
					$provdg = 0;
				}else{
					$provdg = $expe_provdg;
				}

				if ($provdg == 0) {
					$i_max = $this->proyectos_model->campo_valor_maximo('exp', 'expe_provdg' , array('expe_director' => $i_user ));

					$i_max = $i_max+1;

					$str 	= date_default_timezone_get();
					$fecha  = date("d/m/Y", strtotime($str));

					$salida = $this->proyectos_model->actualizar_proyecto($id_proyecto, array('expe_provdg'   => $i_max,
																					 		  'expe_director' => $this->session->userdata('username'),
																					 		  'expe_salida'   => $fecha,
																					 		  'expe_estado'   => 'P'));
					if ($salida) {
						$this->session->set_flashdata('message', '¡Se DIÓ SALIDA exitósamente!');
						redirect('proyectos/proyectos/edit_proyecto/'.$id_proyecto);
					}else{
						$this->session->set_flashdata('message', '¡No se pudo DAR SALIDA!');
						redirect('proyectos/proyectos/edit_proyecto/'.$id_proyecto);
					}
				}else{
					$this->session->set_flashdata('message', '¡Campo PROV. DG sin dato!');
					redirect('proyectos/proyectos/edit_proyecto/'.$id_proyecto);
				}
			}else{
				$this->session->set_flashdata('message', 'NO TIENE PRIVILEGIOS PARA ESTA ACCIÓN');
				redirect('proyectos/proyectos/edit_proyecto/'.$id_proyecto);
			}
		}else{
			redirect('proyectos/proyectos/edit_proyecto/'.$id_proyecto);
		}
	}

	public function anular_salida_expe($id_proyecto)
	{

		//echo($id_proyecto);
		$expe = $this->proyectos_model->dropdown_data('exp', array('id_proyecto' => $id_proyecto))->result();


		//echo '<option value="">Seleccione el distrito</option>';

		foreach ($expe as $value) {
			$i_exp 		 = $value->id_proyecto_proyecto;
			$i_gest 	 = $value->expe_gestion;
			$i_provdg = $value->expe_provdg;
		}

		if (!is_null($i_exp) AND $i_gest > 0) {
			if (grupo_usuario(18)) {

				if ($i_provdg == NULL) {
					$provdg = 0;
				}else{
					$provdg = $i_provdg;
				}

				if ($provdg != 0) {

					$salida = $this->proyectos_model->actualizar_proyecto($id_proyecto, array('expe_provdg'   => NULL,
																					 		  'expe_director' => '',
																					 		  'expe_salida'   => NULL,
																					 		  'expe_estado'   => 'A'));
					if ($salida) {
						$this->session->set_flashdata('message', '¡Se ANULÓ LA SALIDA exitósamente!');
						redirect('proyectos/proyectos/edit_proyecto/'.$id_proyecto);
					}else{
						$this->session->set_flashdata('message', '¡No se pudo ANULAR SALIDA!');
						//redirect('proyectos/proyectos/edit_proyecto/'.$id_proyecto);
						redirect('proyectos/proyectos/index/');
					}
				}
			}else{
				$this->session->set_flashdata('message', 'NO TIENE PRIVILEGIOS PARA ESTA ACCIÓN');
				//redirect('proyectos/proyectos/index/'.$id_proyecto);
				redirect('proyectos/proyectos/index/');
			}
		}else{
			//redirect('proyectos/proyectos/index/'.$id_proyecto);
			redirect('proyectos/proyectos/index/');
		}
	}


	public function call_bat()
	{
		$cmd = system('cmd /c C:/espacio_trabajo/importar_shape_ide.bat');
	}


	public function trae_distritos()
	{
		$dpto 	   = $_POST['id_proyecto_departamento'];

		$distritos = $this->proyectos_model->dropdown_data('distritos',array('dist_id_departamento' => $dpto), 'dist_id_ciudad')->result();

		echo '<option value="">Seleccione el distrito</option>';
		foreach ($distritos as $value) {
			echo '<option value="' . $value->dist_id_ciudad . '">' . $value->dist_id_ciudad . ' - ' . $value->dist_descripcion . '</option>';
		}

		//echo json_encode($distritos);
	}

/*
	public function trae_expe_ref()
	{
		$expe 	   = $_POST['id_proyecto_proyecto_ref'];

		$expes = $this->proyectos_model->dropdown_data('exp',array('id_proyecto_proyecto_ref' => $expe), 'id_proyecto')->result();

		echo '<option value="">Seleccione Expediente</option>';
		foreach ($expes as $value) {

			$expes[$ex['id_proyecto']] = $ex['id_proyecto_proyecto'].'-'.$ex['expe_gestion'].'-'.$ex['id_proyecto_dependencia'].'-'.$ex['expe_secuencia'];

			echo '<option value="' . $value->id_proyecto . '">' . $value->id_proyecto_proyecto . '-' . $value->expe_gestion . '-' . $value->id_proyecto_dependencia . '-' . $value->expe_secuencia .  '</option>';
		}

		//echo json_encode($distritos);
	}
*/
	public function eliminar_proyecto()
	{
		$id_proyecto= $_POST['id_proyecto'];

		$resultado  = $this->proyectos_model->eliminar_proyecto($id_proyecto);

		/*
		if ($resultado > 0) {
			$this->session->set_flashdata('message', '¡El proyecto con ID= <b>'.$id_proyecto.'</b> tiene expedientes NO SE PUEDE ELIMINAR!!!');
			redirect('proyectos/proyectos/index');
		} else {
			$this->session->set_flashdata('message', '¡El proyecto con ID= <b>'.$id_proyecto.'</b> se eliminó correctamente!');
			redirect('proyectos/proyectos/index');
		}
		*/
		echo $resultado;
	}

//		public function verproyecto_id_proyecto ($id_proyecto ) {
//
//        	$i_jameuge = "http://10.68.8.52:8065/jmap/index.html?id_proyecto=" . $id_proyecto;
//
//			redirect($i_jameuge);
//	}

	 

}
