$(document).ready(function () {
  //funcion para hacer mas dinamica la parte de agregar actividades
  $("#guardarActividad").on("click", function () {
    const descripcion = $("#nueva_actividad").val().trim();
    if (!descripcion) {
      alert("La descripción no puede estar vacía.");
      return;
    }

    $.ajax({
      url: "<?= site_url('man_espacial/proyectos/proyectos/agregar_actividad'); ?>",
      method: "POST",
      data: { descripcion: descripcion },
      success: function (res) {
        try {
          const data = JSON.parse(res);
          if (data.success) {
            const nueva = new Option(
              data.id + " - " + data.descripcion,
              data.id,
              true,
              true
            );
            $("#actividad").append(nueva).selectpicker("refresh");
            $("#actividad").selectpicker("val", data.id);

            $("#modalActividad").modal("hide");
            $("#nueva_actividad").val("");
            alert("Actividad añadida correctamente.");
            window.location.href =
              "<?= site_url('man_espacial/proyectos/proyectos/edit/' . $_SESSION['identificador'] . '/E'); ?>";
          } else {
            alert(data.error || "No se pudo guardar la actividad.");
          }
        } catch (e) {
          console.error("Error en la respuesta:", e);
          alert("Hubo un error inesperado.");
        }
      },
      error: function (err) {
        console.error("Error en el AJAX:", err);
        alert("Error de comunicación con el servidor.");
      },
    });
  });
  //Funcion de proyectos para poder cambiar los campos de distritos y hacerlos mas dinamicos

  /* $('#dpto').change(function() {
        var dpto = $(this).val();
        console.log("Departamento seleccionado:", dpto);
        $('#distrito').html('<option value="">Cargando...</option>').selectpicker('refresh');

        $.post("<?= site_url('man_espacial/proyectos/get_distritos'); ?>", { dpto: dpto }, function(data) {
            var distritos = JSON.parse(data);
            var options = '<option value="">Seleccione un distrito</option>';
            $.each(distritos, function(index, distrito) {
                options += '<option value="' + distrito.distrito + '">' + distrito.dist_desc + '</option>';
            });
            $('#distrito').html(options).selectpicker('refresh');
            $('#barloc').html(options).selectpicker('refresh');
        });
    });
 */
  //funcion para poder agregar las locaclidades y hacerlos mas dinamicos

  /* $('#distrito').change(function() {
        var dpto = $('#dpto').val();
        var distrito = $(this).val();

        console.log("Departamento seleccionado:", dpto);
        console.log("Distrito seleccionado:", distrito);
        $('#barloc').html('<option value="">Cargando...</option>').selectpicker('refresh');

        $.post("<?= site_url('man_espacial/proyectos/get_barloc'); ?>", { dpto: dpto, distrito: distrito }, function(data) {
            var barlocs = JSON.parse(data);
            var options = '<option value="">Seleccione un barrio/localidad</option>';
            $.each(barlocs, function(index, barloc) {
                options += '<option value="' + barloc.id + '">' + barloc.barlo_desc + '</option>';
            });
            $('#barloc').html(options).selectpicker('refresh');
        });
    }); */
  //utilizamos el evento keyup para coger la información
  //cada vez que se pulsa alguna tecla con el foco en el buscador
  $("#dpto").keyup(function () {
    //en info tenemos lo que vamos escribiendo en el buscador
    var info = $(this).val();
    //hacemos la petición al método poblaciones del controlador buscador
    //pasando la variable info

    if (info != "") {
      $.post("buscar", { info: info }, function (data) {
        //si autocompletado nos devuelve algo
        if (data != "") {
          //en el div con clase contenedor mostramos la info
          $(".muestra_geocolonias").show();
          $(".muestra_geocolonias").html(data);
          //alert(data);
        } else {
          //alert("NO FUNCIONA");
          //$(".muestra_geocolonias").html('');
          $(".muestra_geocolonias").show();
          $(".muestra_geocolonias").html(data);
        }
      });
    } else {
      $.post("buscar2", { info: info }, function (data) {
        //si autocompletado nos devuelve algo
        if (data != "") {
          //en el div con clase contenedor mostramos la info
          $(".muestra_geocolonias").show();
          $(".muestra_geocolonias").html(data);
          //alert(data);
        } else {
          //alert("NO FUNCIONA");
          //$(".muestra_geocolonias").html('');
          $(".muestra_geocolonias").show();
          $(".muestra_geocolonias").html(data);
        }
      });
    }
  });
  //Pantalla coloniax\s
  $("#dpto_cod").change(function (event) {
    //alert('Funcionaaaaaa');

    event.preventDefault();
    var sistema = $("#nomsistema").val();
    url_metodo =
      "/" + sistema + "/man_espacial/colonias/colonias/trae_distritos";
    dpto_cod = this.value;
    //console.log('Dpto: ' + dpto_cod);
    jQuery.ajax({
      type: "POST",
      url: url_metodo,
      data: { dpto_cod: dpto_cod },
      success: function (res) {
        if (res) {
          //console.log(res);
          $("#dist_cod").html(res);

          var pad = "000";
          col_cod =
            pad.substring(0, pad.length - $("#col_cod").val().length) +
            $("#col_cod").val();

          id_codgeo = dpto_cod + $("#dist_cod").val() + col_cod;
          $("select[name=dist_cod]").selectpicker("refresh");
          $("#id_codgeo").val(id_codgeo);
        }
      },
    });
  });
});
function actualizarCamposPorEstado(estado) {
  // --- Normalizar valor del select (acepta "06 - RIMA", "06.1 - ..." etc.)
  var m = (estado || "")
    .toString()
    .trim()
    .match(/^(\d+(?:\.\d+)?)/);
  var code = m ? m[1] : "";

  // --- Definición de grupos por estado
  var GROUPS_BY_STATE = {
    "02": [
      "#mesa_control",
      "#mesa_fecha_ini",
      "#mesa_fecha_pago",
      "#mesa_fecha_fin",
      "#mesa_obs",
    ],
    "02.1": [
      "#mesa_control",
      "#mesa_fecha_ini",
      "#mesa_fecha_pago",
      "#mesa_fecha_fin",
      "#mesa_obs",
    ],
    "02.2": [
      "#mesa_control",
      "#mesa_fecha_ini",
      "#mesa_fecha_pago",
      "#mesa_fecha_fin",
      "#mesa_obs",
    ],
    "03": [
      "#atec_ini",
      "#atec_ini_fecha",
      "#atec_ini_fecha_fin",
      "#atec_ini_obs",
    ],
    "04": ["#geomatica", "#geo_fecha_ini", "#geo_fecha_fin", "#geo_obs"],
    "05": [
      "#atecnico",
      "#atec_fecha_ini",
      "#atec_fecha_fin",
      "#atec_obs",
      "#direc_mades",
    ],
    "06": [
      "#rima_p",
      "#rima_p_fecha",
      "#rima_p_fecha_fin",
      "#rima_p_obs",
      "#rima_w",
      "#rima_w_fecha",
      "#rima_w_fecha_fin",
      "#rima_w_obs",
    ],
    "06.1": ["#rima_p", "#rima_p_fecha", "#rima_p_fecha_fin", "#rima_p_obs"],
    "06.2": ["#rima_w", "#rima_w_fecha", "#rima_w_fecha_fin", "#rima_w_obs"],
    "07": ["#diva", "#diva_fecha_ini", "#diva_fecha_fin", "#diva_obs"],
    "08": [
      "#dir_gen",
      "#dir_gen_fecha_ini",
      "#dir_gen_fecha_fin",
      "#dir_gen_obs",
    ],
    "09": [],
    10: [],
  };

  // --- Orden cronológico
  var STATE_ORDER = [
    "02",
    "02.1",
    "02.2",
    "03",
    "04",
    "05",
    "06",
    "06.1",
    "06.2",
    "07",
    "08",
    "09",
    "10",
  ];

  // 1) Deshabilitar TODO
  var todosLosCampos = [
    "#mesa_control",
    "#mesa_fecha_ini",
    "#mesa_fecha_pago",
    "#mesa_fecha_fin",
    "#mesa_obs",
    "#atec_ini",
    "#atec_ini_fecha",
    "#atec_ini_fecha_fin",
    "#atec_ini_obs",
    "#geomatica",
    "#geo_fecha_ini",
    "#geo_fecha_fin",
    "#geo_obs",
    "#atecnico",
    "#atec_fecha_ini",
    "#atec_fecha_fin",
    "#atec_obs",
    "#direc_mades",
    "#rima_p",
    "#rima_p_fecha",
    "#rima_p_fecha_fin",
    "#rima_p_obs",
    "#rima_w",
    "#rima_w_fecha",
    "#rima_w_fecha_fin",
    "#rima_w_obs",
    "#diva",
    "#diva_fecha_ini",
    "#diva_fecha_fin",
    "#diva_obs",
    "#dir_gen",
    "#dir_gen_fecha_ini",
    "#dir_gen_fecha_fin",
    "#dir_gen_obs",
  ];
  $(todosLosCampos.join(",")).prop("disabled", true);
  $(".btn.btn-primary.btn-flat").prop("disabled", true);

  // 2) Mesa de entrada SIEMPRE habilitada
  var mesa = [
    "#mesa_control",
    "#mesa_fecha_ini",
    "#mesa_fecha_pago",
    "#mesa_fecha_fin",
    "#mesa_obs",
  ];
  $(mesa.join(",")).prop("disabled", false);

  // 3) Habilitar acumulado hasta el estado seleccionado
  var idx = STATE_ORDER.indexOf(code);
  if (idx === -1) {
    // si no se reconoce el estado, al menos deja Mesa y el botón
    $(".btn.btn-primary.btn-flat").prop("disabled", false);
    return;
  }

  var camposAEncender = new Set(mesa); // ya incluye Mesa
  for (var i = 0; i <= idx; i++) {
    var s = STATE_ORDER[i];

    // Si el estado elegido es 06.1 o 06.2, saltar el 06 general
    if ((code === "06.1" || code === "06.2") && s === "06") continue;

    (GROUPS_BY_STATE[s] || []).forEach(function (sel) {
      camposAEncender.add(sel);
    });
  }

  // Encender acumulados
  if (camposAEncender.size > 0) {
    $(Array.from(camposAEncender).join(",")).prop("disabled", false);
    $(".btn.btn-primary.btn-flat").prop("disabled", false);
  }
}

function cargarDistritosPorDepartamento(
  dptoSelector,
  distritoSelector,
  barlocSelector,
  url
) {
  const dpto = $(dptoSelector).val();
  const distritoSeleccionado = $(distritoSelector).data("seleccionado"); // obtener del atributo

  $(distritoSelector)
    .html('<option value="">Cargando...</option>')
    .selectpicker("refresh");

  $.post(url, { dpto: dpto }, function (data) {
    try {
      const distritos = JSON.parse(data);
      let options = '<option value="">Seleccione un distrito</option>';
      $.each(distritos, function (index, distrito) {
        const selected =
          distrito.distrito == distritoSeleccionado ? "selected" : "";
        options += `<option value="${distrito.distrito}" ${selected}>${distrito.distrito} - ${distrito.dist_desc}</option>`;
      });

      $(distritoSelector).html(options).selectpicker("refresh");

      // Cargar barrios luego del distrito
      if (barlocSelector) {
        cargarBarriosPorDistrito(
          dptoSelector,
          distritoSelector,
          barlocSelector,
          "<?= site_url('man_espacial/proyectos/get_barloc'); ?>"
        );
      }
    } catch (err) {
      console.error("❌ Error al cargar distritos:", err);
    }
  });
}

function cargarBarriosPorDistrito(
  dptoSelector,
  distritoSelector,
  barlocSelector,
  url
) {
  const dpto = $(dptoSelector).val();
  const distrito = $(distritoSelector).val();
  const barlocSeleccionado = $(barlocSelector).data("seleccionado");

  console.log("📥 Departamento:", dpto);
  console.log("📥 Distrito:", distrito);
  console.log(
    "📥 Barrio seleccionado (data-seleccionado):",
    barlocSeleccionado
  );

  $(barlocSelector)
    .html('<option value="">Cargando...</option>')
    .selectpicker("refresh");

  $.post(url, { dpto: dpto, distrito: distrito }, function (data) {
    try {
      const barlocs = JSON.parse(data);
      let options = '<option value="">Seleccione un barrio/localidad</option>';

      $.each(barlocs, function (index, barloc) {
        const selected = barloc.id == barlocSeleccionado ? "selected" : "";
        console.log(
          `🔹 Opción: ${barloc.id} - ${barloc.bar_loc} - ${barloc.barlo_desc} ${selected}`
        );
        options += `<option value="${barloc.id}" ${selected}>${barloc.bar_loc} - ${barloc.barlo_desc}</option>`;
      });

      $(barlocSelector).html(options).selectpicker("refresh");

      // ✔️ Establecer manualmente el valor seleccionado por si el selected no se aplica
      if (barlocSeleccionado) {
        $(barlocSelector).val(barlocSeleccionado).selectpicker("refresh");
        console.log("✅ Valor seleccionado forzado:", barlocSeleccionado);
      }
    } catch (err) {
      console.error("❌ Error al procesar barrios:", err);
    }
  }).fail(function (xhr, status, error) {
    console.error("❌ Fallo en la llamada AJAX de barloc:", error);
  });
}

function inicializarAgregarActividad(
  btnSelector,
  inputSelector,
  selectSelector,
  modalSelector,
  url
) {
  $(btnSelector).on("click", function () {
    const descripcion = $(inputSelector).val().trim();
    if (!descripcion) {
      alert("La descripción no puede estar vacía.");
      return;
    }

    $.post(url, { descripcion }, function (res) {
      try {
        const data = JSON.parse(res);
        if (data.success) {
          const nueva = new Option(
            `${data.id} - ${data.descripcion}`,
            data.id,
            true,
            true
          );
          $(selectSelector)
            .append(nueva)
            .selectpicker("refresh")
            .selectpicker("val", data.id);
          $(modalSelector).modal("hide");
          $(inputSelector).val("");
          alert("Actividad añadida correctamente.");
          location.reload();
        } else {
          alert(data.error || "Error al guardar la actividad.");
        }
      } catch (e) {
        console.error("Error en la respuesta:", e);
        alert("Hubo un error inesperado.");
      }
    }).fail(function () {
      alert("Error de comunicación con el servidor.");
    });
  });
}
