<head> 
    <style>
        body {
            background-color: #f8f9fa;
        }

        .form-inline {
            gap: 10px;
        }

        .table th {
            background-color: #007bff;
            color: white;
        }

        .btn-primary, .btn-success {
            margin-top: 10px;
        }

        .table-container {
            max-width: 1200px;
            margin: auto;
            padding: 20px;
            border-radius: 5px;
            background-color: #ffffff;
        }

        .table {
            font-size: 15px;
        }

        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }

        .pagination a, .pagination strong {
            padding: 10px 15px;
            margin: 0 5px;
            text-decoration: none;
            background-color: #007bff;
            color: #ffffff;
            border-radius: 3px;
        }

        .pagination a:hover {
            background-color: #0056b3;
        }

        .pagination strong {
            background-color: #6c757d;
        }

        @media (max-width: 768px) {
            .table th, .table td {
                font-size: 14px;
            }
        }
        .note-card{border:2px solid #d0d0d0;border-radius:14px;background:#fff;padding:18px 16px;box-shadow:0 2px 6px rgba(0,0,0,.06);margin:10px 0;}
        .note-card h3{font-weight:600;margin:0 0 8px 0;}
        .note-body{border:2px dashed #bbb;border-radius:12px;padding:14px;min-height:120px;background:#fafafa;}
        .note-label{color:#666;font-size:12px;text-transform:uppercase;letter-spacing:.6px;}
        .note-field{background:#f5f5f5;border:0;width:100%;padding:8px 10px;border-radius:6px;}
        .note-actions{text-align:center;margin-top:10px;}
    </style>
</head>
<body>
<div class="content-wrapper">
    <section class="content-header">
        <!-- Puedes agregar breadcrumbs o títulos aquí -->
    </section>

    <section class="content">
        <div class="container mt-5">
            
            <?php
            echo anchor('man_espacial/proyectos/proyectos/index', '<button type="button" class="btn btn-primary btn-lg w-100">Volver</button>');
            ?>

            <h1 class="mb-4">Listado de Resoluciones , Proyecto: <?php echo isset($nombre_proyecto) ? $nombre_proyecto : 'No especificado'; ?></h1>
            <form class="row g-3 mb-4" method="get" >
                <div class="col-md-3">
                    <label for="nro_resolucion" class="form-label">Nro Resolución</label>
                    <input type="text" class="form-control" name="nro_resolucion" id="nro_resolucion" value="<?= $this->input->get('nro_resolucion') ?>">
                </div>
                <div class="col-md-3">
                    <label for="gestion_resolucion" class="form-label">Gestión</label>
                    <input type="text" class="form-control" name="gestion_resolucion" id="gestion_resolucion" value="<?= $this->input->get('gestion_resolucion') ?>">
                </div>
                <div class="col-md-3">
                    <label for="estado" class="form-label">Estado</label>
                    <select name="estado" id="estado" class="form-control">
                        <?php foreach ($dropdown_estados as $key => $value): ?>
                            <option value="<?php echo $key; ?>" 
                                <?php echo isset($filters['estado']) && $filters['estado'] == $key ? 'selected' : ''; ?>>
                                <?php echo $value; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="tipo_resoluciones" class="form-label">Tipo Resoluciones</label>
                    <select name="tipo_resoluciones" id="tipo_resoluciones" class="form-control">
                        <?php foreach ($dropdown_tipo_resoluciones as $key => $value): ?>
                            <option value="<?php echo $key; ?>" 
                                <?php echo isset($filters['tipo_resoluciones']) && $filters['tipo_resoluciones'] == $key ? 'selected' : ''; ?>>
                                <?php echo $value; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="col-md-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">Filtrar</button>
                </div>
            </form>
            <div class="note-card">
            <h3>Resolución</h3>
            <div class="note-body">
                <div class="form-horizontal">
                    <div class="form-group">
                        <label class="col-sm-3 note-label">Resol.</label>
                        <div class="col-sm-9">
                            <input type="text" class="note-field" readonly
                                value="<?php echo isset($proj_resol['resol']) ? htmlspecialchars($proj_resol['resol'],ENT_QUOTES,'UTF-8') : ''; ?>">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 note-label">Fecha</label>
                        <div class="col-sm-9">
                            <input type="text" class="note-field" readonly
                                value="<?php echo isset($proj_resol['resol_fecha']) ? htmlspecialchars($proj_resol['resol_fecha'],ENT_QUOTES,'UTF-8') : ''; ?>">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 note-label">Observación</label>
                        <div class="col-sm-9">
                            <textarea class="note-field" rows="2" readonly><?php
                                echo isset($proj_resol['resol_obs']) ? htmlspecialchars($proj_resol['resol_obs'],ENT_QUOTES,'UTF-8') : '';
                            ?></textarea>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 note-label">Usuario Modif.</label>
                        <div class="col-sm-9">
                            <input type="text" class="note-field" readonly
                                value="<?php echo isset($proj_resol['resol_usu_modif']) ? htmlspecialchars($proj_resol['resol_usu_modif'],ENT_QUOTES,'UTF-8') : ''; ?>">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 note-label">Fecha Fin</label>
                        <div class="col-sm-9">
                            <input type="text" class="note-field" readonly
                                value="<?php echo isset($proj_resol['resol_fecha_fin']) ? htmlspecialchars($proj_resol['resol_fecha_fin'],ENT_QUOTES,'UTF-8') : ''; ?>">
                        </div>
                    </div>
                </div>
            </div>

            <?php
                $tipo_usuario_card = isset($_SESSION['tipo_usuario'][0]) ? $_SESSION['tipo_usuario'][0] : '';
                if ($tipo_usuario_card != 'C'):
            ?>
            <div class="note-actions">
                <button type="button" class="btn btn-warning btn-flat" data-toggle="modal" data-target="#modalResolMeta">
                    MODIFICAR
                </button>
            </div>
            <?php endif; ?>
            </div>
            <?php 
                $user_id = $this->session->userdata('user_id');
                $tipo_usuario = $_SESSION['tipo_usuario'][0];
                $id_cliente = $_SESSION['id_cliente'][0];
                if ($tipo_usuario == 'C') { 
            ?> 
            
            <?php
                } else {  
            ?>   
                <a href="<?= site_url('resoluciones/create/'. $id_proyecto) ?>" class="btn btn-success mt-3">Crear Nueva Resolución</a>
                <br>
            <?php
                } 
            ?>      
            <br>
            <div class="table-container">
                <div class="table-responsive">
                    <table class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>Acciones</th>
                                <th>ID</th>
                                <th>Estado</th>
                                <th>Nro Resolución</th>
                                <th>Gestión</th>
                                <th>Fecha Resolución</th>
                                <th>Tipo de Resolución</th>
                                
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($resoluciones as $resolucion): ?>
                            <tr>
                                <td>    
                                    <?php 
                                    $user_id = $this->session->userdata('user_id');
                                    $tipo_usuario = $_SESSION['tipo_usuario'][0];
                                    $id_cliente = $_SESSION['id_cliente'][0];
                                    if ($tipo_usuario == 'C') { 
                                    ?>
                                    <a href="<?= site_url('resoluciones/views/' . $resolucion->id_resoluciones. '/' .$resolucion->id_proyecto) ?>" class="btn btn-info btn-sm" >Ver</a>
                                    <?php
                                    } else {  
                                    ?>
                                    <a href="<?= site_url('resoluciones/edit/' . $resolucion->id_resoluciones. '/' .$resolucion->id_proyecto) ?>" class="btn btn-warning btn-sm">Editar</a>
                                    &nbsp;
                                    <a href="<?= site_url('resoluciones/delete/' . $resolucion->id_resoluciones. '/' .$resolucion->id_proyecto) ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Estás seguro?')">Eliminar</a>
                                    &nbsp;
                                    <a href="<?= site_url('resoluciones/views/' . $resolucion->id_resoluciones. '/' .$resolucion->id_proyecto) ?>" class="btn btn-info btn-sm" >Ver</a>
                                    <?php
                                    } 
                                    ?>
                                </td>
                                <td><?= $resolucion->id_resoluciones ?></td>
                                <td><?= $resolucion->estado == 'A' ? 'Activo' : 'Inactivo' ?></td>
                                <td><?= $resolucion->nro_resolucion ?></td>
                                <td><?= $resolucion->gestion_resolucion ?></td>
                                <td><?= $resolucion->fecha_resolucion ?></td>
                                <td><?= $resolucion->tipo_resoluciones ?></td>      
                               
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="pagination">
                <?= $pagination ?>
            </div>
        </div>
    </section>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Bootstrap JS (elige 4.x o 5.x según tu proyecto) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<div class="modal fade" id="modalResolMeta" tabindex="-1" role="dialog" aria-labelledby="modalResolMetaLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <?php echo form_open(current_url(), array('class'=>'form-horizontal')); ?>
      <div class="modal-header">
        <h5 class="modal-title" id="modalResolMetaLabel">Editar Resolución</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <!-- Resol. como select SI/NO -->
        <div class="form-group">
          <label class="col-sm-3 control-label">Resol.</label>
          <div class="col-sm-9">
            <select name="resol" class="form-control">
              <option value="SI" <?php echo (isset($proj_resol['resol']) && $proj_resol['resol'] == 'SI') ? 'selected' : ''; ?>>SI</option>
              <option value="NO" <?php echo (isset($proj_resol['resol']) && $proj_resol['resol'] == 'NO') ? 'selected' : ''; ?>>NO</option>
            </select>
          </div>
        </div>
        <!-- Fecha -->
        <div class="form-group">
          <label class="col-sm-3 control-label">Fecha</label>
          <div class="col-sm-9">
            <input type="date" name="resol_fecha" class="form-control"
                   value="<?php echo isset($proj_resol['resol_fecha']) ? htmlspecialchars($proj_resol['resol_fecha'],ENT_QUOTES,'UTF-8') : ''; ?>">
            <p class="help-block">Formato: yyyy-mm-dd</p>
          </div>
        </div>
        <!-- Observación -->
        <div class="form-group">
          <label class="col-sm-3 control-label">Observación</label>
          <div class="col-sm-9">
            <textarea name="resol_obs" rows="3" class="form-control"><?php
              echo isset($proj_resol['resol_obs']) ? htmlspecialchars($proj_resol['resol_obs'],ENT_QUOTES,'UTF-8') : '';
            ?></textarea>
          </div>
        </div>
        <!-- Fecha Fin -->
        <div class="form-group">
          <label class="col-sm-3 control-label">Fecha Fin</label>
          <div class="col-sm-9">
            <input type="date" name="resol_fecha_fin" class="form-control"
                   value="<?php echo isset($proj_resol['resol_fecha_fin']) ? htmlspecialchars($proj_resol['resol_fecha_fin'],ENT_QUOTES,'UTF-8') : ''; ?>">
            <p class="help-block">Formato: yyyy-mm-dd</p>
          </div>
        </div>
        <input type="hidden" name="guardar_resol_tarjeta" value="1">
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
        <button type="submit" class="btn btn-primary">Guardar</button>
      </div>
      <?php echo form_close(); ?>
    </div>
  </div>
</div>
</body>