<head>
    <style>
        body {
            background-color: #f8f9fa;
        }

        .form-container {
            max-width: 800px;
            margin: auto;
        }

        .btn-container {
            margin-top: 30px; /* Espacio entre los botones y los campos */
        }
        .btn-container .btn {
            margin-right: 10px; /* Espacio entre los botones */
        }
    </style>
</head>
<body>
<div class="content-wrapper">
    <section class="content-header">
        <h1>Crear Nueva Resolución</h1>
    </section>
    <section class="content">
    <div class="container mt-5 form-container">
    <form method="post" enctype="multipart/form-data" action="<?= site_url('resoluciones/create/'.$id_proyecto) ?>">
        <div class="form-group">
            <label for="id_declaracion">ID Declaración</label>
            <input type="text" class="form-control" id="id_declaracion" name="id_declaracion" value="<?= isset($id_declaracion) && !empty($id_declaracion) ? $id_declaracion : '' ?>" readonly>
        </div>
        <div class="form-group">
            <label for="id_proyecto">ID Proyecto</label>
            <input type="number" class="form-control" id="id_proyecto" name="id_proyecto" value="<?= $id_proyecto ?>" required readonly>
        </div>
        <div class="form-group">
            <label for="nro_resolucion">Nro Resolución</label>
            <input type="number" step="1" class="form-control" id="nro_resolucion" name="nro_resolucion" required>
        </div>
        <div class="form-group">
            <label for="gestion_resolucion">Gestión</label>
            <input type="number" step="1" class="form-control" id="gestion_resolucion" name="gestion_resolucion" required>
        </div>
        <div class="form-group">
            <label for="fecha_resolucion">Fecha Resolución</label>
            <input type="date" class="form-control" id="fecha_resolucion" name="fecha_resolucion">
        </div>
        <div class="form-group">
            <label for="fecha_prox_vto_aa">Fecha Próximo Vencimiento Presentación</label>
            <input type="date" class="form-control" id="fecha_prox_vto_aa" name="fecha_prox_vto_aa">
        </div>
        <div class="form-group">
            <label for="estado">Estado</label>
            <select class="form-control" id="estado" name="estado" required>
                <option value="A">Activo</option>
                <option value="I">Inactivo</option>
            </select>
        </div>
        <!-- Dropdown de Tipo de Resolución -->
        <div class="form-group">
            <label for="tipo_resoluciones">Tipo de Resolución</label>
            <select name="tipo_resoluciones" id="tipo_resoluciones" class="form-control" required>
                <?php foreach ($dropdown_tipo_resoluciones as $key => $value): ?>
                    <option value="<?= $key ?>" <?= (isset($filters['tipo_resoluciones']) && $filters['tipo_resoluciones'] == $key) ? 'selected' : '' ?>>
                        <?= $value ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label for="observacion">Observación</label>
            <textarea class="form-control" id="observacion" name="observacion" rows="4"></textarea>
        </div>
        <div class="form-group">
            <label for="documento">Subir Documentos</label>
            <input type="file" name="documento[]" class="form-control" multiple>
            <small class="text-muted">Puede subir varios archivos.</small>
        </div>
        <div class="form-row">
            <div class="form-group col-md-12">
                <div class="btn-container">
                <button type="submit" class="btn btn-primary">Guardar</button>
                <a href="<?= site_url('resoluciones/index/'. $id_proyecto) ?>" class="btn btn-warning">Cancelar</a>
                </div>
            </div>
        </div>
    </form>
</div>

    </section>
</div>
</body>
