<head>
    <style>
        body {
            background-color: #f8f9fa;
        }

        .table th {
            background-color: #007bff;
            color: white;
        }

        .btn-primary, .btn-success {
            margin-top: 10px;
        }

        .table-container {
            max-width: 1200px;
            margin: auto;
            padding: 20px;
            border-radius: 5px;
            background-color: #ffffff;
        }

        .table {
            font-size: 15px;
        }

        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }

        .pagination a, .pagination strong {
            padding: 10px 15px;
            margin: 0 5px;
            text-decoration: none;
            background-color: #007bff;
            color: #ffffff;
            border-radius: 3px;
        }

        .pagination a:hover {
            background-color: #0056b3;
        }

        .pagination strong {
            background-color: #6c757d;
        }

        @media (max-width: 768px) {
            .table th, .table td {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <div class="content-wrapper">
        <section class="content-header">
            <?php //echo $pagetitle; ?>
            <?php //echo $breadcrumb; ?>
        </section>

        <section class="content">    
            <div class="container mt-5">

            <?php
            echo anchor('man_espacial/proyectos/proyectos/index', '<button type="button" class="btn btn-primary btn-lg w-100">Volver</button>');
            ?>
                <h1 class="mb-4">Gestión de PGA, Proyecto: <?php echo isset($nombre_proyecto) ? $nombre_proyecto : 'No especificado'; ?></h1>


                <!-- Formulario de filtros -->
                <form method="get" class="row g-3 mb-4">
     
                    <div class="col-md-3">
                        <label for="des_tipo_riesgo" class="form-label">Tipo Riesgo</label>
                        <input type="text" name="des_tipo_riesgo" id="des_tipo_riesgo" class="form-control" value="<?= $this->input->get('des_tipo_riesgo') ?>">
                    </div>
                    <div class="col-md-3">
                        <label for="des_tipo_plan" class="form-label">Tipo Plan</label>
                        <input type="text" name="des_tipo_plan" id="des_tipo_plan" class="form-control" value="<?= $this->input->get('des_tipo_plan') ?>">
                    </div>
                    <div class="col-md-3">
                        <label for="des_pga_estado" class="form-label">Estado</label>
                        <select name="des_pga_estado" id="des_pga_estado" class="form-control">
                            <?php foreach ($dropdown_estados as $key => $value): ?>
                                <option value="<?= $key ?>" <?= ($this->input->get('des_pga_estado') == $key) ? 'selected' : '' ?>>
                                    <?= $value ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>          
                    <div class="col-md-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary w-100">Filtrar</button>
                    </div>
                </form>
                
                                <?php
  $p = isset($pga_note) ? $pga_note : ['pga'=>'','pga_obs'=>'','pga_fecha'=>'','pga_fecha_fin'=>'','pga_usu_modif'=>''];
?>
<style>
.note-card{border:2px solid #d0d0d0;border-radius:14px;background:#fff;padding:18px 16px;box-shadow:0 2px 6px rgba(0,0,0,.06);margin:12px 0;}
.note-card h3{font-weight:600;margin:0 0 8px;}
.note-body{border:2px dashed #bbb;border-radius:12px;padding:14px;background:#fafafa;}
.note-label{color:#666;font-size:12px;text-transform:uppercase;letter-spacing:.6px;}
.note-field{background:#f5f5f5;border:0;width:100%;padding:8px 10px;border-radius:6px}
.note-actions{text-align:right;margin-top:10px}
</style>

<div class="note-card">
  <h3>PGA</h3>
  <div class="note-body">
    <div class="row">
      <div class="col-md-4">
        <label class="note-label">PGA</label>
        <input class="note-field" type="text" readonly value="<?= html_escape($p['pga']) ?>">
      </div>
      <div class="col-md-4">
        <label class="note-label">Fecha</label>
        <input class="note-field" type="text" readonly value="<?= html_escape($p['pga_fecha']) ?>">
      </div>
      <div class="col-md-4">
        <label class="note-label">Fecha fin</label>
        <input class="note-field" type="text" readonly value="<?= html_escape($p['pga_fecha_fin']) ?>">
      </div>
      <div class="col-md-8" style="margin-top:10px">
        <label class="note-label">Observación</label>
        <textarea class="note-field" rows="2" readonly><?= html_escape($p['pga_obs']) ?></textarea>
      </div>
      <div class="col-md-4" style="margin-top:10px">
        <label class="note-label">Usuario Modif.</label>
        <input class="note-field" type="text" readonly value="<?= html_escape($p['pga_usu_modif']) ?>">
      </div>
    </div>
  </div>
  <?php 
    $tipo_usuario = isset($_SESSION['tipo_usuario'][0]) ? $_SESSION['tipo_usuario'][0] : '';
    if ($tipo_usuario !== 'C'): // solo internos pueden editar
  ?>
  <div class="note-actions">
    <button class="btn btn-warning btn-sm" data-toggle="modal" data-target="#modalPGA">MODIFICAR</button>
  </div>
  <?php endif; ?>
</div>
                <?php 
                $user_id = $this->session->userdata('user_id');
                $tipo_usuario = $_SESSION['tipo_usuario'][0];
                $id_cliente = $_SESSION['id_cliente'][0];
                if ($tipo_usuario == 'C') { 
                ?> 
                
                <?php
                    } else {  
                ?>   
                    <a href="<?= site_url('pga/create/'.$id_proyecto )?>" class="btn btn-success mb-3">Crear Nuevo</a>
                    <br>
                <?php
                    } 
                ?>
                
                <br>
                <!-- Contenedor con fondo blanco -->
                <div class="table-container">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>Acciones</th>
                                    <th>ID</th>
                                    <th>Estado</th>
                                    <th>Tipo Riesgo</th>
                                    <th>Tipo Plan</th>
                                    <th>Descripción</th>
                                    <th>Fecha Reg</th>
                                   
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($pgas as $pga): ?>
                                    <tr>
                                        <td>
                                        <?php 
                                        $user_id = $this->session->userdata('user_id');
                                        $tipo_usuario = $_SESSION['tipo_usuario'][0];
                                        $id_cliente = $_SESSION['id_cliente'][0];
                                        if ($tipo_usuario == 'C') { 
                                        ?> 
                                            <a href="<?= site_url('pga/views/' . $pga->id . '/' . $id_proyecto) ?>" class="btn btn-info btn-sm">Ver</a>
                                        <?php
                                            } else {  
                                        ?>   
                                            <a href="<?= site_url('pga/edit/' . $pga->id . '/' . $id_proyecto) ?>" class="btn btn-warning btn-sm">Editar</a>
                                            &nbsp
                                            <a href="<?= site_url('pga/delete/' . $pga->id . '/' . $id_proyecto) ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Está seguro?')">Eliminar</a>
                                            &nbsp
                                            <a href="<?= site_url('pga/views/' . $pga->id . '/' . $id_proyecto) ?>" class="btn btn-info btn-sm">Ver</a>
                                        <?php
                                            } 
                                        ?>
                                        
                                        </td>
                                        <td><?= $pga->id ?></td>
                                        <td class="fw-bold text-dark <?php 
                                            switch ($pga->des_pga_estado) {
                                                case 'Cumplido': echo 'bg-success bg-opacity-50'; break;
                                                case 'Pendiente': echo 'bg-danger bg-opacity-50'; break;
                                                case 'Anulado': echo 'bg-secondary bg-opacity-50'; break;
                                                case 'En proceso': echo 'bg-warning bg-opacity-50'; break;
                                            }
                                        ?>">
                                            <?= $pga->des_pga_estado ?>
                                        </td>
                                        <td><?= $pga->des_tipo_riesgo ?></td>
                                        <td><?= $pga->des_tipo_plan ?></td>
                                        <td><?= substr($pga->descript_plan, 0, 50) ?>...</td>
                                        <td><?= $pga->fecha_reg ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Paginación -->
                <div class="pagination">
                    <?= $pagination ?>
                </div>
            </div>
        </section>
    </div>
    <script>
<?php if ($this->session->flashdata('message')): ?>
    console.log("<?= addslashes($this->session->flashdata('message')); ?>");
<?php endif; ?>

<?php if ($this->session->flashdata('error')): ?>
    console.error("<?= addslashes($this->session->flashdata('error')); ?>");
<?php endif; ?>
</script>
<?php 
$tipo_usuario_check = isset($tipo_usuario) 
    ? $tipo_usuario 
    : (isset($_SESSION['tipo_usuario'][0]) ? $_SESSION['tipo_usuario'][0] : '');

if ($tipo_usuario_check !== 'C'): 
?>
<div class="modal fade" id="modalPGA" tabindex="-1" role="dialog" aria-labelledby="modalPGALabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <?= form_open(current_url(), ['id'=>'formPGA']) ?>
      <div class="modal-header">
        <h4 class="modal-title" id="modalPGALabel">Editar datos de PGA</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">

        <div class="form-group">
          <label>PGA</label>
          <input type="text" name="pga" class="form-control" value="<?= html_escape($p['pga']) ?>">
        </div>

        <div class="form-group">
          <label>Fecha</label>
          <div class="input-group date" data-provide="datepicker" data-date-format="dd/mm/yyyy">
            <input type="text" name="pga_fecha" id="pga_fecha" class="form-control" value="<?= html_escape($p['pga_fecha']) ?>">
            <div class="input-group-addon"><i class="fa fa-calendar"></i></div>
          </div>
        </div>

        <div class="form-group">
          <label>Fecha fin</label>
          <div class="input-group date" data-provide="datepicker" data-date-format="dd/mm/yyyy">
            <input type="text" name="pga_fecha_fin" id="pga_fecha_fin" class="form-control" value="<?= html_escape($p['pga_fecha_fin']) ?>">
            <div class="input-group-addon"><i class="fa fa-calendar"></i></div>
          </div>
        </div>

        <div class="form-group">
          <label>Observación</label>
          <textarea name="pga_obs" class="form-control" rows="3"><?= html_escape($p['pga_obs']) ?></textarea>
        </div>

        <input type="hidden" name="guardar_pga" value="1">
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
        <button type="submit" class="btn btn-primary">Guardar</button>
      </div>
      <?= form_close() ?>
    </div>
  </div>
</div>

<!-- datepicker (si ya lo cargas en layout, omite) -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/locales/bootstrap-datepicker.es.min.js"></script>
<script>
$(function(){
  $('.input-group.date').datepicker({
    format: 'dd/mm/yyyy',
    autoclose: true,
    todayHighlight: true,
    language: 'es'
  });
});
</script>
<?php endif; ?>

</body>
