<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Google Charts -->
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>

<div class="content-wrapper">
    <section class="content-header">
        <?= $pagetitle ?>
        <?= $breadcrumb ?>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header with-border">
                        <h3 class="box-title"><?= lang('proyectos_create'); ?></h3>
                    </div>

                    <div class="nav-tabs-custom">
                        <ul class="nav nav-tabs">
                            <li><a href="<?= site_url('man_espacial/proyectos/proyectos/edit/'.$_SESSION['identificador'].'/E'); ?>">Proyecto Edit</a></li>
                            <li><a href="<?= site_url('man_espacial/proyectos/proyectos/edit2/'.$_SESSION['identificador'].'/E'); ?>">Evaluación</a></li>
                            <li class="active"><a href="#" style="background-color: #F0F0F0">BPM Estadístico</a></li>
                        </ul>  
                        <div class="box-body">
                            <div id="timeline_chart" style="height: <?= count($evaluaciones) * 60 ?>px;"></div>
                        </div>      
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Script para Google Timeline -->
<script type="text/javascript">
    google.charts.load("current", {packages:["timeline"]});
    google.charts.setOnLoadCallback(drawChart);

    function drawChart() {
        var container = document.getElementById('timeline_chart');
        var chart = new google.visualization.Timeline(container);
        var dataTable = new google.visualization.DataTable();

        dataTable.addColumn({ type: 'string', id: 'Categoría' });
        dataTable.addColumn({ type: 'string', id: 'Detalle' });
        dataTable.addColumn({ type: 'date', id: 'Inicio' });
        dataTable.addColumn({ type: 'date', id: 'Fin' });

        dataTable.addRows([
            <?php foreach ($evaluaciones as $ev):
                $categoria = addslashes($ev->categoria);
                $fecha_ini_ts = strtotime($ev->fecha);
                $fecha_fin_ts = $ev->fecha_final ? strtotime($ev->fecha_final) : ($fecha_ini_ts + 86400);

            
                if ($fecha_ini_ts == $fecha_fin_ts) {
                    $fecha_fin_ts += 86400;
                }

                $ini_parts = explode(',', date('Y,n,j', $fecha_ini_ts));
                $fin_parts = explode(',', date('Y,n,j', $fecha_fin_ts));
            ?>
            ['<?= $categoria ?>', '<?= date("d/m", $fecha_ini_ts) ?> - <?= date("d/m", $fecha_fin_ts) ?>',
             new Date(<?= $ini_parts[0] ?>, <?= $ini_parts[1] - 1 ?>, <?= $ini_parts[2] ?>),
             new Date(<?= $fin_parts[0] ?>, <?= $fin_parts[1] - 1 ?>, <?= $fin_parts[2] ?>)],
            <?php endforeach; ?>
        ]);

        chart.draw(dataTable);
    }
</script>
