<?php
defined('BASEPATH') OR exit('No direct script access allowed');

?>

            <div class="content-wrapper">
                <section class="content-header">
                    <?php echo $pagetitle.'CONSULTORES DE SUELO'; ?>
                    <?php echo $breadcrumb; ?>
                </section>

                <section class="content">
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header with-border">
                    <h3 class="box-title"><?php echo lang('consultores_view_consultores'); ?></h3>
                    <?php echo $message;?>
                </div>
                <div class="box-body">
                    <?php echo form_open(current_url(), array('class' => 'form-horizontal')); ?>                                    
                        <div class="form-group">
                            <?php echo lang('consultores_id_consultor', 'id_consultor', array('class' => 'col-sm-3 control-label')); ?>
                            <div class="col-sm-4">
                                <?php echo form_input(array('name' => 'id_consultor', 'value' => $consultor->id_consultor, 'readonly' => 'readonly', 'class' => 'form-control')); ?>
                            </div>
                        </div>
                        <div class="form-group">
                            <?php echo lang('consultores_cedularuc', 'cedularuc', array('class' => 'col-sm-3 control-label')); ?>
                            <div class="col-sm-4">
                                <?php echo form_input(array('name' => 'cedularuc', 'value' => $consultor->cedularuc, 'readonly' => 'readonly', 'class' => 'form-control')); ?>
                            </div>
                        </div>
                        <div class="form-group">
                            <?php echo lang('consultores_nombre', 'nombre', array('class' => 'col-sm-3 control-label')); ?>
                            <div class="col-sm-4">
                                <?php echo form_input(array('name' => 'nombre', 'value' => $consultor->nombre, 'readonly' => 'readonly', 'class' => 'form-control')); ?>
                            </div>
                        </div>
                        <div class="form-group">
                            <?php echo lang('consultores_apellido', 'apellido', array('class' => 'col-sm-3 control-label')); ?>
                            <div class="col-sm-4">
                                <?php echo form_input(array('name' => 'apellido', 'value' => $consultor->apellido, 'readonly' => 'readonly', 'class' => 'form-control')); ?>
                            </div>
                        </div>
                        <div class="form-group">
                            <?php echo lang('consultores_email', 'email', array('class' => 'col-sm-3 control-label')); ?>
                            <div class="col-sm-4">
                                <?php echo form_input(array('name' => 'email', 'value' => $consultor->email, 'readonly' => 'readonly', 'class' => 'form-control')); ?>
                            </div>
                        </div>
                        <div class="form-group">
                            <?php echo lang('consultores_fecha_nac', 'fecha_nac', array('class' => 'col-sm-3 control-label')); ?>
                            <div class="col-sm-4">
                                <?php echo form_input(array('name' => 'fecha_nac', 'value' => $consultor->fecha_nac, 'readonly' => 'readonly', 'class' => 'form-control')); ?>
                            </div>
                        </div>
                        <div class="form-group">
                            <?php echo lang('consultores_sexo', 'dp_sexo', array('class' => 'col-sm-3 control-label')); ?>
                            <div class="col-sm-4">
                                <?php echo form_input(array('name' => 'sexo', 'value' => $consultor->sexo, 'readonly' => 'readonly', 'class' => 'form-control')); ?>
                            </div>
                        </div>
                        <div class="form-group">
                            <?php echo lang('consultores_id_cliente', 'id_cliente', array('class' => 'col-sm-3 control-label')); ?>
                            <div class="col-sm-4">
                                <?php echo form_input(array('name' => 'id_cliente', 'value' => $consultor->id_cliente, 'readonly' => 'readonly', 'class' => 'form-control')); ?>
                            </div>
                        </div>
                        <div class="form-group">
                            <?php echo lang('consultores_tipo_persona', 'dp_tipo_persona', array('class' => 'col-sm-3 control-label')); ?>
                            <div class="col-sm-4">
                                <?php echo form_input(array('name' => 'tipo_persona', 'value' => $consultor->tipo_persona, 'readonly' => 'readonly', 'class' => 'form-control')); ?>
                            </div>
                        </div>
                        <div class="form-group">
                            <?php echo lang('consultores_telefono', 'telefono', array('class' => 'col-sm-3 control-label')); ?>
                            <div class="col-sm-4">
                                <?php echo form_input(array('name' => 'telefono', 'value' => $consultor->telefono, 'readonly' => 'readonly', 'class' => 'form-control')); ?>
                            </div>
                        </div>
                        <div class="form-group">
                            <?php echo lang('consultores_direccion', 'direccion', array('class' => 'col-sm-3 control-label')); ?>
                            <div class="col-sm-4">
                                <?php echo form_input(array('name' => 'direccion', 'value' => $consultor->direccion, 'readonly' => 'readonly', 'class' => 'form-control')); ?>
                            </div>
                        </div>
                        <div class="form-group">
                            <?php echo lang('consultores_tipo_empresa', 'dp_tipo_empresa', array('class' => 'col-sm-3 control-label')); ?>
                            <div class="col-sm-4">
                                <?php echo form_input(array('name' => 'tipo_empresa', 'value' => $consultor->tipo_empresa, 'readonly' => 'readonly', 'class' => 'form-control')); ?>
                            </div>
                        </div>
                        <div class="form-group">
                            <?php echo lang('consultores_nacionalidad', 'nacionalidad', array('class' => 'col-sm-3 control-label')); ?>
                            <div class="col-sm-4">
                                <?php echo form_input(array('name' => 'nacionalidad', 'value' => $consultor->nacionalidad, 'readonly' => 'readonly', 'class' => 'form-control')); ?>
                            </div>
                        </div>
                        <div class="form-group">
                            <?php echo lang('consultores_rlegal_cedula', 'rlegal_cedula', array('class' => 'col-sm-3 control-label')); ?>
                            <div class="col-sm-4">
                                <?php echo form_input(array('name' => 'rlegal_cedula', 'value' => $consultor->rlegal_cedula, 'readonly' => 'readonly', 'class' => 'form-control')); ?>
                            </div>
                        </div>
                        <div class="form-group">
                            <?php echo lang('consultores_rlegal_nombre', 'rlegal_nombre', array('class' => 'col-sm-3 control-label')); ?>
                            <div class="col-sm-4">
                                <?php echo form_input(array('name' => 'rlegal_nombre', 'value' => $consultor->rlegal_nombre, 'readonly' => 'readonly', 'class' => 'form-control')); ?>
                            </div>
                        </div>
                        <div class="form-group">
                            <?php echo lang('consultores_rlegal_apellido', 'rlegal_apellido', array('class' => 'col-sm-3 control-label')); ?>
                            <div class="col-sm-4">
                                <?php echo form_input(array('name' => 'rlegal_apellido', 'value' => $consultor->rlegal_apellido, 'readonly' => 'readonly', 'class' => 'form-control')); ?>
                            </div>
                        </div>
                        <div class="form-group">
                            <?php echo lang('consultores_rlegal_sexo', 'dp_rlegal_sexo', array('class' => 'col-sm-3 control-label')); ?>
                            <div class="col-sm-4">
                                <?php echo form_input(array('name' => 'rlegal_sexo', 'value' => $consultor->rlegal_sexo, 'readonly' => 'readonly', 'class' => 'form-control')); ?>
                            </div>
                        </div>                                          
                        <div class="form-group">
                            <div class="col-sm-offset-2 col-sm-10">
                                <div class="btn-group">
                                    <?php echo anchor('man_espacial/consultores/index', lang('actions_cancel'), array('class' => 'btn btn-default btn-flat')); ?>
                                </div>
                            </div>
                        </div>
                    <?php echo form_close();?>
                </div>
            </div>
        </div>
    </div>
</section>

            </div>
            <script>
                $(document).ready(function () {
                    $('.selectpicker').selectpicker();
                    const dpTipoPersona = $('#dp_tipo_persona');
                    const campos = ['#nombre', '#apellido', '#email', '#dp_sexo'];
                    const camposRlegal = ['#rlegal_cedula', '#rlegal_nombre', '#rlegal_apellido', '#dp_rlegal_sexo'];

                    const actualizarCampos = () => {
                        const selectedValue = dpTipoPersona.val();

                        
                        campos.forEach(campoSelector => {
                            const $campo = $(campoSelector);
                            if ($campo.length) {
                                if (selectedValue === 'J') { 
                                    $campo.val('');
                                    $campo.prop('disabled', true);
                                    if ($campo.hasClass('selectpicker')) {
                                        $campo.selectpicker('refresh');
                                    }
                                } else if (selectedValue === 'F') { 
                                    $campo.prop('disabled', false);
                                    if ($campo.hasClass('selectpicker')) {
                                        $campo.selectpicker('refresh');
                                    }
                                }
                                console.log($campo.attr('id') + " disabled: " + $campo.prop('disabled'));
                            }
                        });

                        
                        camposRlegal.forEach(campoSelector => {
                            const $campo = $(campoSelector);
                            if ($campo.length) {
                                if (selectedValue === 'F') { 
                                    $campo.val('');
                                    $campo.prop('disabled', true);
                                    if ($campo.hasClass('selectpicker')) {
                                        $campo.selectpicker('refresh');
                                    }
                                } else if (selectedValue === 'J') { 
                                    $campo.prop('disabled', false);
                                    if ($campo.hasClass('selectpicker')) {
                                        $campo.selectpicker('refresh');
                                    }
                                }
                                console.log($campo.attr('id') + " disabled: " + $campo.prop('disabled'));
                            }
                        });
                    };

                    
                    actualizarCampos();

                    
                    dpTipoPersona.on('change', actualizarCampos);
                });

            </script>