<head>
    <style>
        body {
            background-color: #f8f9fa;
        }
        .form-section {
            margin-bottom: 15px;
        }
        .btn-container {
            margin-top: 30px; /* Espacio entre los botones y los campos */
        }
        .btn-container .btn {
            margin-right: 10px; /* Espacio entre los botones */
        }
    </style>
</head>
<body>
    <div class="content-wrapper">
        <section class="content-header">
            <!-- Puedes agregar breadcrumbs o títulos aquí -->
        </section>

        <section class="content">
            <div class="container mt-5">
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h4>Editar Declaración</h4>
                    </div>
                    <div class="card-body">
                        <form action="<?= site_url('declaraciones/edit/' . $declaracion['id_declaracion']) ?>" method="post" enctype="multipart/form-data">

                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="id_proyecto">ID Proyecto</label>
                                    <input type="number" class="form-control" name="id_proyecto" id="id_proyecto" value="<?= set_value('id_proyecto', $declaracion['id_proyecto']) ?>" required readonly>
                                    <?= form_error('id_proyecto', '<small class="text-danger">', '</small>') ?>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="nro_declaracion">Número de Declaración</label>
                                    <input type="number" class="form-control" name="nro_declaracion" id="nro_declaracion" value="<?= set_value('nro_declaracion', $declaracion['nro_declaracion']) ?>" required>
                                    <?= form_error('nro_declaracion', '<small class="text-danger">', '</small>') ?>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="gestion_declaracion">Gestión de Declaración</label>
                                    <input type="number" class="form-control" name="gestion_declaracion" id="gestion_declaracion" value="<?= set_value('gestion_declaracion', $declaracion['gestion_declaracion']) ?>" required>
                                    <?= form_error('gestion_declaracion', '<small class="text-danger">', '</small>') ?>
                                </div>
                            <div class="form-group col-md-6">
                                <label for="estado">Estado</label>
                                <select name="estado" id="estado" class="form-control">
                                    <?php foreach ($dropdown_estados as $key => $value): ?>
                                        <option value="<?php echo $key; ?>"
                                            <?php 
                                                $estado_actual = isset($_POST['estado']) ? $_POST['estado'] : $declaracion['estado']; 
                                                echo ($estado_actual == $key) ? 'selected' : ''; 
                                            ?>>
                                            <?php echo $value; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="fecha_declaracion">Fecha de Declaración</label>
                                    <input type="date" class="form-control" name="fecha_declaracion" id="fecha_declaracion" value="<?= set_value('fecha_declaracion', $declaracion['fecha_declaracion']) ?>">
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="fecha_declaracion_vto">Fecha de Vencimiento</label>
                                    <input type="date" class="form-control" name="fecha_declaracion_vto" id="fecha_declaracion_vto" value="<?= set_value('fecha_declaracion_vto', $declaracion['fecha_declaracion_vto']) ?>">
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="fecha_prox_vto_aa">Fecha Próximo Vencimiento AA</label>
                                    <input type="date" class="form-control" name="fecha_prox_vto_aa" id="fecha_prox_vto_aa" value="<?= set_value('fecha_prox_vto_aa', $declaracion['fecha_prox_vto_aa']) ?>">
                                </div>
                            </div>
                

                            <div class="form-group">
                                <div class="form-group col-md-12">
                                    <label for="observacion">Observación</label>
                                    <textarea class="form-control" name="observacion" id="observacion" rows="3"><?= set_value('observacion', $declaracion['observacion']) ?></textarea>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <div class="btn-container">
                                        <button type="submit" class="btn btn-primary">Guardar</button>
                                        <a href="<?= site_url('declaraciones/index/'. $declaracion['id_proyecto']) ?>" class="btn btn-warning">Cancelar</a>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label for="documento" class="col-sm-2 control-label">Importar Documentos</label>
                                <div class="col-sm-4">
                                <input type="file" name="documento[]" id="documento" class="form-control" multiple>
                                    <p class="help-block">Selecciona un archivo CSV o Excel para importar documentos.</p>
                                </div>
                                <div class="col-sm-2">
                                    <button type="submit" name="importar" class="btn btn-success btn-flat">Importar</button>
                                </div>
                            </div>
                            
                            <div style="border: 1px solid #ccc; border-radius: 5px; background-color: #f1f1f1;">
                                <h4>Documentos Existentes</h4>
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Nombre del Archivo</th>
                                            <th>Fecha de Subida</th>
                                            <th>Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if (!empty($documentos)): ?>
                                            <?php foreach ($documentos as $documento): ?>
                                                <tr>
                                                    <td><?php echo htmlspecialchars(basename($documento->url)); ?></td>
                                                    <td><?php echo date('d/m/Y', strtotime($documento->fecha_reg)); ?></td>
                                                    <td>
                                                    <a href="<?php echo site_url('documentos/descargarArchivo/' . $documento->id_archivo); ?>" class="btn btn-info btn-sm">
                                                                        Descargar
                                                                    </a>
                                                        &nbsp;
                                                        <a href="#" class="btn btn-danger btn-sm delete-document"
                                                        data-id="<?php echo $documento->id_archivo; ?>"
                                                        data-id-proyecto="<?php echo $declaracion['id_proyecto']; ?>">
                                                            Eliminar
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <tr>
                                                <td colspan="3" class="text-center">No hay documentos asociados.</td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <!-- Modal para mensajes -->
        <div class="modal fade" id="mensajeModal" tabindex="-1" role="dialog" aria-labelledby="mensajeModalLabel">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                <div class="modal-header alert-success">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="mensajeModalLabel">Mensaje</h4>
                </div>
                <div class="modal-body">
                    <?= $this->session->flashdata('message') ?: $this->session->flashdata('error') ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                </div>
                </div>
            </div>
        </div>

    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>

    <script>
        $(document).ready(function() {
            $('.delete-document').on('click', function(e) {
                e.preventDefault();
                var id = $(this).data('id');
                var idProyecto = $(this).data('id-proyecto');

                var deleteUrl = '<?= site_url("declaraciones/delete_document") ?>/' + id + '/' + idProyecto;
                console.log("Eliminando documento en:", deleteUrl);

                if (confirm('¿Estás seguro de que deseas eliminar este documento?')) {
                    window.location.href = deleteUrl;
                }
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            <?php if ($this->session->flashdata('message') || $this->session->flashdata('error')): ?>
                $('#mensajeModal').modal('show');
            <?php endif; ?>
        });
    </script>
</body>
