<head>
    <style>
        body {
            background-color: #f8f9fa;
        }

        .form-inline {
            gap: 10px;
        }

        .table th {
            background-color: #007bff;
            color: white;
        }

        .btn-primary, .btn-success {
            margin-top: 10px;
        }

        .table-container {
            max-width: 1200px; /* Aumentar el ancho máximo */
            margin: auto; /* Centrar la tabla */
        }

        .table {
            font-size: 15px; /* Ajustar tamaño de fuente si es necesario */
        }
    </style>
</head>
<body>
<div class="content-wrapper">
    <section class="content-header">
        <?php //echo $pagetitle; ?>
        <?php //echo $breadcrumb; ?>
    </section>

    <section class="content">
        <div class="container-fluid py-5">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <h1 class="text-center mb-4">Listado de Clientes</h1>
                    <form method="get" class="form-row">
                        <div class="form-group col-md-3">
                            <input type="text" name="cedularuc" placeholder="Cédula/RUC" value="<?= $this->input->get('cedularuc') ?>" class="form-control">
                        </div>
                        <div class="form-group col-md-3">
                            <input type="text" name="nombre" placeholder="Nombre" value="<?= $this->input->get('nombre') ?>" class="form-control">
                        </div>
                        <div class="form-group col-md-3">
                            <input type="text" name="apellido" placeholder="Apellido" value="<?= $this->input->get('apellido') ?>" class="form-control">
                        </div>
                        <div class="form-group col-md-3">
                            <input type="text" name="email" placeholder="Email" value="<?= $this->input->get('email') ?>" class="form-control">
                        </div>
                        <div class="form-group col-12 d-flex justify-content-between">
                            <button type="submit" class="btn btn-primary">Filtrar</button>&nbsp
                            <a href="<?= site_url('clientes/clientes/create') ?>" class="btn btn-success">Nuevo Cliente</a>
                        </div>
                    </form>

                    <div class="table-container mt-4">
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>Acciones</th>
                                        <th>ID</th>
                                        <th>Cédula/RUC</th>
                                        <th>Nombre</th>
                                        <th>Apellido</th>
                                        <th>Email</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php if (!empty($clientes)): ?>
                                    <?php foreach ($clientes as $cliente): ?>
                                        <tr>
                                            <td>
                                                <a href="<?= site_url('clientes/clientes/edit/' . $cliente['id_cliente']) ?>" class="btn btn-warning btn-sm">Editar</a>&nbsp
                                                <a href="<?= site_url('clientes/clientes/detele/' . $cliente['id_cliente']) ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Está seguro?')">Eliminar</a>
                                            </td>
                                            <td><?= $cliente['id_cliente'] ?></td>
                                            <td><?= $cliente['cedularuc'] ?></td>
                                            <td><?= $cliente['nombre'] ?></td>
                                            <td><?= $cliente['apellido'] ?></td>
                                            <td><?= $cliente['email'] ?></td>
                                            
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="6" class="text-center">No se encontraron clientes.</td>
                                    </tr>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
