<head>
  <style>
    body { background-color: #f8f9fa; }
    .mensaje-padre, .respuesta {
      border: 1px solid #ddd; padding: 10px; margin-bottom: 10px;
      border-radius: 5px; background-color: #ffffff;
    }
    .respuesta { margin-left: 20px; border-left: 3px solid #007bff; }
    .btn-container { margin-top: 15px; }
  </style>
</head>
<body>
<div class="content-wrapper">
  <section class="content">
    <div class="container mt-5">
      <h1 class="mb-4"><?= $pagetitle; ?></h1>

      <div class="mensaje-padre">
        <h5>Mensaje Inicial (ID: <?= htmlspecialchars($mensaje_padre['id_alerta']) ?>)</h5>
        <p><?= htmlspecialchars($mensaje_padre['mensaje']) ?></p>
        <p><small>Fecha: <?= htmlspecialchars($mensaje_padre['fecha_reg']) ?></small></p>
      </div>

      <?php if ($respuestas): ?>
        <h5>Respuestas</h5>
        <?php foreach ($respuestas as $respuesta): ?>
          <div class="respuesta">
            <p><?= htmlspecialchars($respuesta->mensaje) ?></p>
            <p><small>Fecha: <?= htmlspecialchars($respuesta->fecha_reg) ?></small></p>
          </div>
        <?php endforeach; ?>
      <?php else: ?>
        <p>No hay respuestas todavía.</p>
      <?php endif; ?>

      <!-- Formulario de respuesta -->
      <?php if (!$ya_respondido): ?>
      <div class="card mt-4">
        <div class="card-header bg-primary text-white">
          <h4>Responder</h4>
        </div>
        <div class="card-body">
          <form action="<?= site_url('alertnotific/responder/'.$mensaje_padre['id_alerta']) ?>" method="post">
            <div class="form-group">
              <textarea name="mensaje" id="mensaje" class="form-control" rows="3" placeholder="Escribe tu respuesta..." required></textarea>
            </div>
            <div class="btn-container">
              <button type="submit" class="btn btn-success">Enviar Respuesta</button>
              <a href="<?= base_url('alertnotific/index') ?>" class="btn btn-warning">Volver</a>
            </div>
          </form>
        </div>
      </div>
      <?php else: ?>
        <div class="alert alert-info mt-4">Ya se ha respondido a este mensaje. No se puede responder de nuevo.</div>
      <?php endif; ?>
    </div>
  </section>
</div>
</body>
