DROP FUNCTION bya.actualizar_usos(character varying, integer);

CREATE OR REPLACE FUNCTION bya.actualizar_usos(
	i_tabla character varying,
	i_colonia integer)
    RETURNS boolean
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE STRICT PARALLEL UNSAFE
AS $BODY$
DECLARE

   resultado  boolean;
   a_linea geometry(MultiLineString);
   d bya.uso_alternativo%ROWTYPE;

   b bya.bloques%ROWTYPE;
   a bya.aldeas%ROWTYPE;
   p bya.parcelas%ROWTYPE;

   -- Bloques
   ba bya.bloques_uso_alternativo%ROWTYPE;
   bai i3geo.bloques_uso_alternativo%ROWTYPE;
   bu bya.bloques_uso_actual%ROWTYPE;
   bui i3geo.bloques_uso_actual%ROWTYPE; 
   b6 bya.bloques_uso86%ROWTYPE;
   b6i i3geo.bloques_uso86%ROWTYPE;     

   -- Aldeas
   aa bya.aldeas_uso_alternativo%ROWTYPE;
   aai i3geo.aldeas_uso_alternativo%ROWTYPE;
   au bya.aldeas_uso_actual%ROWTYPE;
   aui i3geo.aldeas_uso_actual%ROWTYPE;   
   a6 bya.aldeas_uso86%ROWTYPE;
   a6i i3geo.aldeas_uso86%ROWTYPE;   

   -- Parcelas
   pa bya.parcelas_uso_alternativo%ROWTYPE;
   pai i3geo.parcelas_uso_alternativo%ROWTYPE;
   pu bya.parcelas_uso_actual%ROWTYPE;
   pui i3geo.parcelas_uso_actual%ROWTYPE;   
   p6 bya.parcelas_uso86%ROWTYPE;
   p6i i3geo.parcelas_uso86%ROWTYPE;   

   
   i_nombre_uso varchar(50);
   i_sql varchar(4000);
   i_desc varchar;
   c_tabla0 refcursor;
   c_tabla1 refcursor;
   c_tabla2 refcursor;
   c_tabla3 refcursor;
   c_tabla4 refcursor;
   
BEGIN
   resultado:=true;

   if i_tabla='BLOQUES_USO_ALTERNATIVO' then   
      delete from bya.errores;
      delete from bya.bloques_uso_alternativo where id_colonia = i_colonia;
      delete from i3geo.bloques_uso_alternativo where id_colonia = i_colonia;
	  i_sql='select * from bya.bloques where id_colonia='||i_colonia; 
      open c_tabla0 for execute i_sql;
      loop                                                                
         fetch c_tabla0 into b;
         exit when not found;  	 
		 SELECT st_boundary(b.geom) into a_linea;
	     i_sql='select u.gid,u.categoria,u.uso,u.gid objectid,a.gid objectid_par,0 part1,0 part2,0 part3,u.geom ';
		 i_sql=i_sql||'from bya.bloques a, bya.uso_alternativo u where a.gid='||b.gid||' and st_intersects(a.geom,u.geom);'; 
         open c_tabla1 for execute i_sql;
         loop  --ba nivel 1                                                              
           fetch c_tabla1 into ba.gid,ba.categoria,ba.uso,ba.objectid,ba.objectid_par,ba.part1,ba.part2,ba.part3,ba.geom; 
           exit when not found;  	 		   
           ba.id_colonia = i_colonia;	 
		   bai.id_colonia = i_colonia;
		   bai.categoria = ba.categoria;
	  	   bai.part1 = ba.part1;
		   bai.part2 = ba.part2;
		   bai.part3 = ba.part3;		   
		   bai.objectid = ba.objectid;
		   bai.uso = ba.uso;
		   bai.objectid_par = ba.objectid_par;		   
		   if (ST_Contains(b.geom,ba.geom)) then
		     select nextval('i3geo.bloques_uso_alternativo_gid_seq') into ba.gid;
			 bai.gid = ba.gid;
		     select ST_Transform(ST_SetSRID(ba.geom,32721),4326) into bai.the_geom;
             insert into bya.bloques_uso_alternativo select ba.*;
		     insert into i3geo.bloques_uso_alternativo select bai.*;		   
		   else		 			 
			 -- Este SQL funciona es el mas lento
             --i_sql='select part3,sup_cat,geom from bya.v_bloques_uso_alternativo_p3 ';
             --i_sql=i_sql||'where objectid='||ba.objectid||' and objectid_par='||b.gid;
			 --open c_tabla2 for execute i_sql;			 
			 -----------------------------------------------------------------
			 open c_tabla2 for SELECT (r.g_geom).path[1] AS part3, 
             st_area((r.g_geom).geom) AS sup_cat, 
             (r.g_geom).geom AS geom 
             FROM ( SELECT st_dump(st_split(ba.geom, a_linea)) AS g_geom ) r 
			 WHERE st_area((r.g_geom).geom) > 0;			 
			 --insert into bya.errores (descripcion) values (i_sql);
             loop  --ba nivel 2                                                   
               fetch c_tabla2 into ba.part3,ba.sup_cat,ba.geom;
               exit when not found;  	 
			   if ((ST_Area(ST_intersection(b.geom,ba.geom)))>0) then
			     --insert into bya.errores (descripcion) 
				 --values ('NO gid: '||ba.gid||' objectid: '||ba.objectid||' aldea: '||b.gid);			   
		         select nextval('i3geo.bloques_uso_alternativo_gid_seq') into ba.gid;
			     bai.gid = ba.gid;			   				 
                 -- Este SQL funciona... Es el mas eficiente
				 open c_tabla3 for SELECT (r.g_geom).path[1] AS part2, 
				 st_area((r.g_geom).geom) AS sup_cat, 
				 (r.g_geom).geom AS geom 
				 FROM ( SELECT st_dump(ST_intersection(b.geom,ba.geom)) AS g_geom ) r 
				 WHERE st_area((r.g_geom).geom) > 0; 
                 loop --ba nivel 3                                                          
                   fetch c_tabla3 into ba.part2,ba.sup_cat,ba.geom; 
                   exit when not found;  	 
			       if ((ST_Area(ST_intersection(b.geom,ba.geom)))>0) then		   
		             select nextval('i3geo.bloques_uso_alternativo_gid_seq') into ba.gid;
			         bai.gid = ba.gid;		
					 BEGIN
		               select ST_SetSRID(ST_intersection(b.geom,ba.geom),32721) into ba.geom;
				       select ST_Transform(ST_SetSRID(ba.geom,32721),4326) into bai.the_geom;
                       insert into bya.bloques_uso_alternativo select ba.*;
		               insert into i3geo.bloques_uso_alternativo select bai.*;	
					 EXCEPTION WHEN OTHERS THEN
       				   open c_tabla4 for SELECT (r.g_geom).path[1] AS part2, 
				       st_area((r.g_geom).geom) AS sup_cat, 
				       (r.g_geom).geom AS geom 
				       FROM ( SELECT st_dump(ST_intersection(b.geom,ba.geom)) AS g_geom ) r 
				       WHERE st_area((r.g_geom).geom) > 0;
                       loop --ba nivel 4                                                                    
                         fetch c_tabla4 into ba.part2,ba.sup_cat,ba.geom;
                         exit when not found;  	 
			             if ((ST_Area(ST_intersection(b.geom,ba.geom)))>0) then		   
		                   select nextval('i3geo.bloques_uso_alternativo_gid_seq') into ba.gid;
			               bai.gid = ba.gid;		
					       BEGIN
		                     select ST_SetSRID(ST_intersection(b.geom,ba.geom),32721) into ba.geom;
				             select ST_Transform(ST_SetSRID(ba.geom,32721),4326) into bai.the_geom;
                             insert into bya.bloques_uso_alternativo select ba.*;
		                     insert into i3geo.bloques_uso_alternativo select bai.*;	
					       EXCEPTION WHEN OTHERS THEN
					         select ST_ASTEXT(ST_intersection(b.geom,ba.geom),32721) into i_desc;
	                         insert into bya.errores (descripcion) 
				             values ('NO gid: '||ba.gid||' objectid: '||ba.objectid||' aldea: '||b.gid||' ------   '||i_desc);		
					       END;
			             end if;
			           end loop;     
                       close c_tabla4; 
					 END;
			       end if;
			     end loop;     
                 close c_tabla3; 
			   end if;
			 end loop;     
             close c_tabla2; 
		   end if;
         end loop;     
         close c_tabla1;	          
      end loop;     
      close c_tabla0;	  
   end if; 

   
   if i_tabla='ALDEAS_USO_ALTERNATIVO' then   
      delete from bya.errores;
      delete from bya.aldeas_uso_alternativo where id_colonia = i_colonia;
      delete from i3geo.aldeas_uso_alternativo where id_colonia = i_colonia;
	  i_sql='select * from bya.aldeas where id_colonia='||i_colonia; 
      open c_tabla0 for execute i_sql;
      loop                                                                
         fetch c_tabla0 into a;
         exit when not found;  	 
		 SELECT st_boundary(a.geom) into a_linea;
	     i_sql='select u.gid,u.categoria,u.uso,u.gid objectid,a.gid objectid_par,0 part1,0 part2,0 part3,u.geom ';
		 i_sql=i_sql||'from bya.aldeas a, bya.uso_alternativo u where a.gid='||a.gid||' and st_intersects(a.geom,u.geom);'; 
         open c_tabla1 for execute i_sql;
         loop                                                                
           fetch c_tabla1 into aa.gid,aa.categoria,aa.uso,ba.objectid,aa.objectid_par,aa.part1,aa.part2,aa.part3,aa.geom;
           exit when not found;  	 		   
           aa.id_colonia = i_colonia;	 
		   aai.id_colonia = i_colonia;
		   aai.categoria = aa.categoria;
	  	   aai.part1 = aa.part1;
		   aai.part2 = aa.part2;
		   aai.part3 = aa.part3;		   
		   aai.objectid = aa.objectid;
		   aai.uso = aa.uso;
		   aai.objectid_par = aa.objectid_par;		   
		   if (ST_Contains(a.geom,aa.geom)) then
		     select nextval('i3geo.aldeas_uso_alternativo_gid_seq') into aa.gid;
			 aai.gid = aa.gid;
		     select ST_Transform(ST_SetSRID(aa.geom,32721),4326) into aai.the_geom;
             insert into bya.aldeas_uso_alternativo select aa.*;
		     insert into i3geo.aldeas_uso_alternativo select aai.*;		   
		   else		 			 
			 -- Este SQL funciona es el mas lento
             --i_sql='select part3,sup_cat,geom from bya.v_aldeas_uso_alternativo_p3 ';
             --i_sql=i_sql||'where objectid='||ba.objectid||' and objectid_par='||b.gid;
			 --open c_tabla2 for execute i_sql;			 
			 -----------------------------------------------------------------
			 open c_tabla2 for SELECT (r.g_geom).path[1] AS part3, 
             st_area((r.g_geom).geom) AS sup_cat, 
             (r.g_geom).geom AS geom 
             FROM ( SELECT st_dump(st_split(aa.geom, a_linea)) AS g_geom ) r 
			 WHERE st_area((r.g_geom).geom) > 0;			 
			 --insert into bya.errores (descripcion) values (i_sql);
             loop                                                                
               fetch c_tabla2 into aa.part3,aa.sup_cat,aa.geom;
               exit when not found;  	 
			   if ((ST_Area(ST_intersection(a.geom,aa.geom)))>0) then
			     --insert into bya.errores (descripcion) 
				 --values ('NO gid: '||aa.gid||' objectid: '||aa.objectid||' aldea: '||a.gid);			   
		         select nextval('i3geo.aldeas_uso_alternativo_gid_seq') into aa.gid;
			     aai.gid = aa.gid;			   				 
                 -- Este SQL funciona... Es el mas eficiente
				 open c_tabla3 for SELECT (r.g_geom).path[1] AS part2, 
				 st_area((r.g_geom).geom) AS sup_cat, 
				 (r.g_geom).geom AS geom 
				 FROM ( SELECT st_dump(ST_intersection(a.geom,aa.geom)) AS g_geom ) r 
				 WHERE st_area((r.g_geom).geom) > 0;
                 loop                                                                
                   fetch c_tabla3 into aa.part2,aa.sup_cat,aa.geom;
                   exit when not found;  	 
			       if ((ST_Area(ST_intersection(a.geom,aa.geom)))>0) then		   
		             select nextval('i3geo.aldeas_uso_alternativo_gid_seq') into aa.gid;
			         aai.gid = aa.gid;		
					 BEGIN
		               select ST_SetSRID(ST_intersection(a.geom,aa.geom),32721) into aa.geom;
				       select ST_Transform(ST_SetSRID(aa.geom,32721),4326) into aai.the_geom;
                       insert into bya.aldeas_uso_alternativo select aa.*;
		               insert into i3geo.aldeas_uso_alternativo select aai.*;	
					 EXCEPTION WHEN OTHERS THEN
       				   open c_tabla4 for SELECT (r.g_geom).path[1] AS part2, 
				       st_area((r.g_geom).geom) AS sup_cat, 
				       (r.g_geom).geom AS geom 
				       FROM ( SELECT st_dump(ST_intersection(a.geom,aa.geom)) AS g_geom ) r 
				       WHERE st_area((r.g_geom).geom) > 0;
                       loop                                                                
                         fetch c_tabla4 into aa.part2,aa.sup_cat,aa.geom;
                         exit when not found;  	 
			             if ((ST_Area(ST_intersection(a.geom,aa.geom)))>0) then		   
		                   select nextval('i3geo.aldeas_uso_alternativo_gid_seq') into aa.gid;
			               aai.gid = aa.gid;		
					       BEGIN
		                     select ST_SetSRID(ST_intersection(a.geom,aa.geom),32721) into aa.geom;
				             select ST_Transform(ST_SetSRID(aa.geom,32721),4326) into aai.the_geom;
                             insert into bya.aldeas_uso_alternativo select aa.*;
		                     insert into i3geo.aldeas_uso_alternativo select aai.*;	
					       EXCEPTION WHEN OTHERS THEN
					         select ST_ASTEXT(ST_intersection(a.geom,aa.geom),32721) into i_desc;
	                         insert into bya.errores (descripcion) 
				             values ('NO gid: '||aa.gid||' objectid: '||aa.objectid||' aldea: '||a.gid||' ------   '||i_desc);		
					       END;
			             end if;
			           end loop;     
                       close c_tabla4; 
					 END;
			       end if;
			     end loop;     
                 close c_tabla3; 
			   end if;
			 end loop;     
             close c_tabla2; 
		   end if;
         end loop;     
         close c_tabla1;	          
      end loop;     
      close c_tabla0;	  
   end if; 

   if i_tabla='PARCELAS_USO_ALTERNATIVO' then    
      delete from bya.errores;
      delete from bya.parcelas_uso_alternativo where id_colonia = i_colonia;
      delete from i3geo.parcelas_uso_alternativo where id_colonia = i_colonia;
      i_sql='select * from bya.parcelas where id_colonia='||i_colonia; 
      open c_tabla0 for execute i_sql;
      loop                                                                
         fetch c_tabla0 into p;
         exit when not found;  	 
		 SELECT st_boundary(p.geom) into a_linea;
	     i_sql='select u.gid,u.categoria,u.uso,u.gid objectid,a.gid objectid_par,0 part1,0 part2,0 part3,u.geom ';
		 i_sql=i_sql||'from bya.parcelas a, bya.uso_alternativo u where a.gid='||p.gid||' and st_intersects(a.geom,u.geom);'; 
         open c_tabla1 for execute i_sql;
         loop                                                                
           fetch c_tabla1 into pa.gid,pa.categoria,pa.uso,pa.objectid,pa.objectid_par,pa.part1,pa.part2,pa.part3,pa.geom;
           exit when not found;  	 		   
           pa.id_colonia = i_colonia;	 
		   pai.id_colonia = i_colonia;
		   pai.categoria = ba.categoria;
	  	   pai.part1 = pa.part1;
		   pai.part2 = pa.part2;
		   pai.part3 = pa.part3;		   
		   pai.objectid = pa.objectid;
		   pai.uso = pa.uso;
		   pai.objectid_par = pa.objectid_par;		   
		   if (ST_Contains(p.geom,pa.geom)) then
		     select nextval('i3geo.parcelas_uso_alternativo_gid_seq') into pa.gid;
			 pai.gid = pa.gid;
		     select ST_Transform(ST_SetSRID(pa.geom,32721),4326) into pai.the_geom;
             insert into bya.parcelas_uso_alternativo select pa.*;
		     insert into i3geo.parcelas_uso_alternativo select pai.*;		   
		   else		 			 
			 -- Este SQL funciona es el mas lento
             --i_sql='select part3,sup_cat,geom from bya.v_parcelas_uso_alternativo_p3 ';
             --i_sql=i_sql||'where objectid='||pa.objectid||' and objectid_par='||p.gid;
			 --open c_tabla2 for execute i_sql;			 
			 -----------------------------------------------------------------
			 -- Este SQL funciona... Es el mas eficiente
			 open c_tabla2 for SELECT (r.g_geom).path[1] AS part3, 
             st_area((r.g_geom).geom) AS sup_cat, 
             (r.g_geom).geom AS geom 
             FROM ( SELECT st_dump(st_split(pa.geom, a_linea)) AS g_geom ) r 
			 WHERE st_area((r.g_geom).geom) > 0;
			 -----------------------------------------------------------------			 
			 --insert into bya.errores (descripcion) values (i_sql);
             loop                                                                
               fetch c_tabla2 into pa.part3,pa.sup_cat,pa.geom;
               exit when not found;  	 
			   if ((ST_Area(ST_intersection(p.geom,pa.geom)))>0) then
			     --insert into bya.errores (descripcion) 
				 --values ('NO gid: '||ba.gid||' objectid: '||ba.objectid||' aldea: '||p.gid);			   
		         select nextval('i3geo.parcelas_uso_alternativo_gid_seq') into pa.gid;
			     pai.gid = pa.gid;			   				 
                 -- Este SQL funciona... Es el mas eficiente
				 open c_tabla3 for SELECT (r.g_geom).path[1] AS part2, 
				 st_area((r.g_geom).geom) AS sup_cat, 
				 (r.g_geom).geom AS geom 
				 FROM ( SELECT st_dump(ST_intersection(p.geom,pa.geom)) AS g_geom ) r 
				 WHERE st_area((r.g_geom).geom) > 0;
                 loop                                                                
                   fetch c_tabla3 into pa.part2,pa.sup_cat,pa.geom;
                   exit when not found;  	 
			       if ((ST_Area(ST_intersection(p.geom,pa.geom)))>0) then		   
		             select nextval('i3geo.parcelas_uso_alternativo_gid_seq') into pa.gid;
			         pai.gid = pa.gid;		
					 BEGIN
		               select ST_SetSRID(ST_intersection(p.geom,pa.geom),32721) into pa.geom;
				       select ST_Transform(ST_SetSRID(pa.geom,32721),4326) into pai.the_geom;
                       insert into bya.parcelas_uso_alternativo select pa.*;
		               insert into i3geo.parcelas_uso_alternativo select pai.*;	
					 EXCEPTION WHEN OTHERS THEN
       				   open c_tabla4 for SELECT (r.g_geom).path[1] AS part2, 
				       st_area((r.g_geom).geom) AS sup_cat, 
				       (r.g_geom).geom AS geom 
				       FROM ( SELECT st_dump(ST_intersection(p.geom,pa.geom)) AS g_geom ) r 
				       WHERE st_area((r.g_geom).geom) > 0;
                       loop                                                                
                         fetch c_tabla4 into pa.part2,pa.sup_cat,pa.geom;
                         exit when not found;  	 
			             if ((ST_Area(ST_intersection(p.geom,pa.geom)))>0) then		   
		                   select nextval('i3geo.parcelas_uso_alternativo_gid_seq') into pa.gid;
			               pai.gid = pa.gid;		
					       BEGIN
		                     select ST_SetSRID(ST_intersection(p.geom,pa.geom),32721) into pa.geom;
				             select ST_Transform(ST_SetSRID(pa.geom,32721),4326) into pai.the_geom;
                             insert into bya.parcelas_uso_alternativo select pa.*;
		                     insert into i3geo.parcelas_uso_alternativo select pai.*;	
					       EXCEPTION WHEN OTHERS THEN
					         select ST_ASTEXT(ST_intersection(p.geom,pa.geom),32721) into i_desc;
	                         insert into bya.errores (descripcion) 
				             values ('NO gid: '||pa.gid||' objectid: '||pa.objectid||' aldea: '||p.gid||' ------   '||i_desc);		
					       END;
			             end if;
			           end loop;     
                       close c_tabla4; 
					 END;
			       end if;
			     end loop;     
                 close c_tabla3; 
			   end if;
			 end loop;     
             close c_tabla2; 
		   end if;
         end loop;     
         close c_tabla1;	          
      end loop;     
      close c_tabla0;	  
   end if; 

   if i_tabla='BLOQUES_USO_ACTUAL' then   
      delete from bya.errores;
      delete from bya.bloques_uso_actual where id_colonia = i_colonia;
      delete from i3geo.bloques_uso_actual where id_colonia = i_colonia;
	  i_sql='select * from bya.bloques where id_colonia='||i_colonia; 
      open c_tabla0 for execute i_sql;
      loop                                                                
         fetch c_tabla0 into b;
         exit when not found;  	 
		 SELECT st_boundary(b.geom) into a_linea;
	     i_sql='select u.gid,u.categoria,u.uso,u.gid objectid,a.gid objectid_par,0 part1,0 part2,0 part3,u.geom ';
		 i_sql=i_sql||'from bya.bloques a, bya.uso_actual u where a.gid='||b.gid||' and st_intersects(a.geom,u.geom);'; 
         open c_tabla1 for execute i_sql;
         loop  --ba nivel 1                                                              
           fetch c_tabla1 into bu.gid,bu.categoria,bu.uso,bu.objectid,bu.objectid_par,bu.part1,bu.part2,bu.part3,bu.geom; 
           exit when not found;  	 		   
           bu.id_colonia = i_colonia;	 
		   bui.id_colonia = i_colonia;
		   bui.categoria = bu.categoria;
	  	   bui.part1 = bu.part1;
		   bui.part2 = bu.part2;
		   bui.part3 = bu.part3;		   
		   bui.objectid = bu.objectid;
		   bui.uso = bu.uso;
		   bui.objectid_par = bu.objectid_par;		   
		   if (ST_Contains(b.geom,bu.geom)) then
		     select nextval('i3geo.bloques_uso_actual_gid_seq') into bu.gid;
			 bui.gid = bu.gid;
		     select ST_Transform(ST_SetSRID(bu.geom,32721),4326) into bui.the_geom;
             insert into bya.bloques_uso_actual select bu.*;
		     insert into i3geo.bloques_uso_actual select bui.*;		   
		   else		 			 
			 -- Este SQL funciona es el mas lento
             --i_sql='select part3,sup_cat,geom from bya.v_bloques_uso_actual_p3 ';
             --i_sql=i_sql||'where objectid='||bu.objectid||' and objectid_par='||b.gid;
			 --open c_tabla2 for execute i_sql;			 
			 -----------------------------------------------------------------
			 open c_tabla2 for SELECT (r.g_geom).path[1] AS part3, 
             st_area((r.g_geom).geom) AS sup_cat, 
             (r.g_geom).geom AS geom 
             FROM ( SELECT st_dump(st_split(bu.geom, a_linea)) AS g_geom ) r 
			 WHERE st_area((r.g_geom).geom) > 0;			 
			 --insert into bya.errores (descripcion) values (i_sql);
             loop  --ba nivel 2                                                   
               fetch c_tabla2 into bu.part3,bu.sup_cat,bu.geom;
               exit when not found;  	 
			   if ((ST_Area(ST_intersection(b.geom,bu.geom)))>0) then
			     --insert into bya.errores (descripcion) 
				 --values ('NO gid: '||bu.gid||' objectid: '||bu.objectid||' aldea: '||b.gid);			   
		         select nextval('i3geo.bloques_uso_actual_gid_seq') into bu.gid;
			     bui.gid = bu.gid;			   				 
                 -- Este SQL funciona... Es el mas eficiente
				 open c_tabla3 for SELECT (r.g_geom).path[1] AS part2, 
				 st_area((r.g_geom).geom) AS sup_cat, 
				 (r.g_geom).geom AS geom 
				 FROM ( SELECT st_dump(ST_intersection(b.geom,bu.geom)) AS g_geom ) r 
				 WHERE st_area((r.g_geom).geom) > 0; 
                 loop --ba nivel 3                                                          
                   fetch c_tabla3 into bu.part2,bu.sup_cat,bu.geom; 
                   exit when not found;  	 
			       if ((ST_Area(ST_intersection(b.geom,bu.geom)))>0) then		   
		             select nextval('i3geo.bloques_uso_actual_gid_seq') into bu.gid;
			         bui.gid = bu.gid;		
					 BEGIN
		               select ST_SetSRID(ST_intersection(b.geom,bu.geom),32721) into bu.geom;
				       select ST_Transform(ST_SetSRID(bu.geom,32721),4326) into bui.the_geom;
                       insert into bya.bloques_uso_actual select bu.*;
		               insert into i3geo.bloques_uso_actual select bui.*;	
					 EXCEPTION WHEN OTHERS THEN
       				   open c_tabla4 for SELECT (r.g_geom).path[1] AS part2, 
				       st_area((r.g_geom).geom) AS sup_cat, 
				       (r.g_geom).geom AS geom 
				       FROM ( SELECT st_dump(ST_intersection(b.geom,bu.geom)) AS g_geom ) r 
				       WHERE st_area((r.g_geom).geom) > 0;
                       loop --ba nivel 4                                                                    
                         fetch c_tabla4 into bu.part2,bu.sup_cat,bu.geom;
                         exit when not found;  	 
			             if ((ST_Area(ST_intersection(b.geom,bu.geom)))>0) then		   
		                   select nextval('i3geo.bloques_uso_actual_gid_seq') into bu.gid;
			               bui.gid = bu.gid;		
					       BEGIN
		                     select ST_SetSRID(ST_intersection(b.geom,bu.geom),32721) into bu.geom;
				             select ST_Transform(ST_SetSRID(bu.geom,32721),4326) into bui.the_geom;
                             insert into bya.bloques_uso_actual select bu.*;
		                     insert into i3geo.bloques_uso_actual select bui.*;	
					       EXCEPTION WHEN OTHERS THEN
					         select ST_ASTEXT(ST_intersection(b.geom,bu.geom),32721) into i_desc;
	                         insert into bya.errores (descripcion) 
				             values ('NO gid: '||bu.gid||' objectid: '||bu.objectid||' aldea: '||b.gid||' ------   '||i_desc);		
					       END;
			             end if;
			           end loop;     
                       close c_tabla4; 
					 END;
			       end if;
			     end loop;     
                 close c_tabla3; 
			   end if;
			 end loop;     
             close c_tabla2; 
		   end if;
         end loop;     
         close c_tabla1;	          
      end loop;     
      close c_tabla0;	  
   end if; 

   if i_tabla='ALDEAS_USO_ACTUAL' then   
      delete from bya.errores;
      delete from bya.aldeas_uso_actual where id_colonia = i_colonia;
      delete from i3geo.aldeas_uso_actual where id_colonia = i_colonia;
	  i_sql='select * from bya.aldeas where id_colonia='||i_colonia; 
      open c_tabla0 for execute i_sql;
      loop                                                                
         fetch c_tabla0 into a;
         exit when not found;  	 
		 SELECT st_boundary(a.geom) into a_linea;
	     i_sql='select u.gid,u.categoria,u.uso,u.gid objectid,a.gid objectid_par,0 part1,0 part2,0 part3,u.geom ';
		 i_sql=i_sql||'from bya.aldeas a, bya.uso_actual u where a.gid='||a.gid||' and st_intersects(a.geom,u.geom);'; 
         open c_tabla1 for execute i_sql;
         loop                                                                
           fetch c_tabla1 into au.gid,au.categoria,au.uso,bu.objectid,au.objectid_par,au.part1,au.part2,au.part3,au.geom;
           exit when not found;  	 		   
           au.id_colonia = i_colonia;	 
		   aui.id_colonia = i_colonia;
		   aui.categoria = au.categoria;
	  	   aui.part1 = au.part1;
		   aui.part2 = au.part2;
		   aui.part3 = au.part3;		   
		   aui.objectid = au.objectid;
		   aui.uso = au.uso;
		   aui.objectid_par = au.objectid_par;		   
		   if (ST_Contains(a.geom,au.geom)) then
		     select nextval('i3geo.aldeas_uso_actual_gid_seq') into au.gid;
			 aui.gid = au.gid;
		     select ST_Transform(ST_SetSRID(au.geom,32721),4326) into aui.the_geom;
             insert into bya.aldeas_uso_actual select au.*;
		     insert into i3geo.aldeas_uso_actual select aui.*;		   
		   else		 			 
			 -- Este SQL funciona es el mas lento
             --i_sql='select part3,sup_cat,geom from bya.v_aldeas_uso_actual_p3 ';
             --i_sql=i_sql||'where objectid='||bu.objectid||' and objectid_par='||b.gid;
			 --open c_tabla2 for execute i_sql;			 
			 -----------------------------------------------------------------
			 open c_tabla2 for SELECT (r.g_geom).path[1] AS part3, 
             st_area((r.g_geom).geom) AS sup_cat, 
             (r.g_geom).geom AS geom 
             FROM ( SELECT st_dump(st_split(au.geom, a_linea)) AS g_geom ) r 
			 WHERE st_area((r.g_geom).geom) > 0;			 
			 --insert into bya.errores (descripcion) values (i_sql);
             loop                                                                
               fetch c_tabla2 into au.part3,au.sup_cat,au.geom;
               exit when not found;  	 
			   if ((ST_Area(ST_intersection(a.geom,au.geom)))>0) then
			     --insert into bya.errores (descripcion) 
				 --values ('NO gid: '||au.gid||' objectid: '||au.objectid||' aldea: '||a.gid);			   
		         select nextval('i3geo.aldeas_uso_actual_gid_seq') into au.gid;
			     aui.gid = au.gid;			   				 
                 -- Este SQL funciona... Es el mas eficiente
				 open c_tabla3 for SELECT (r.g_geom).path[1] AS part2, 
				 st_area((r.g_geom).geom) AS sup_cat, 
				 (r.g_geom).geom AS geom 
				 FROM ( SELECT st_dump(ST_intersection(a.geom,au.geom)) AS g_geom ) r 
				 WHERE st_area((r.g_geom).geom) > 0;
                 loop                                                                
                   fetch c_tabla3 into au.part2,au.sup_cat,au.geom;
                   exit when not found;  	 
			       if ((ST_Area(ST_intersection(a.geom,au.geom)))>0) then		   
		             select nextval('i3geo.aldeas_uso_actual_gid_seq') into au.gid;
			         aui.gid = au.gid;		
					 BEGIN
		               select ST_SetSRID(ST_intersection(a.geom,au.geom),32721) into au.geom;
				       select ST_Transform(ST_SetSRID(au.geom,32721),4326) into aui.the_geom;
                       insert into bya.aldeas_uso_actual select au.*;
		               insert into i3geo.aldeas_uso_actual select aui.*;	
					 EXCEPTION WHEN OTHERS THEN
       				   open c_tabla4 for SELECT (r.g_geom).path[1] AS part2, 
				       st_area((r.g_geom).geom) AS sup_cat, 
				       (r.g_geom).geom AS geom 
				       FROM ( SELECT st_dump(ST_intersection(a.geom,au.geom)) AS g_geom ) r 
				       WHERE st_area((r.g_geom).geom) > 0;
                       loop                                                                
                         fetch c_tabla4 into au.part2,au.sup_cat,au.geom;
                         exit when not found;  	 
			             if ((ST_Area(ST_intersection(a.geom,au.geom)))>0) then		   
		                   select nextval('i3geo.aldeas_uso_actual_gid_seq') into au.gid;
			               aui.gid = au.gid;		
					       BEGIN
		                     select ST_SetSRID(ST_intersection(a.geom,au.geom),32721) into au.geom;
				             select ST_Transform(ST_SetSRID(au.geom,32721),4326) into aui.the_geom;
                             insert into bya.aldeas_uso_actual select au.*;
		                     insert into i3geo.aldeas_uso_actual select aui.*;	
					       EXCEPTION WHEN OTHERS THEN
					         select ST_ASTEXT(ST_intersection(a.geom,au.geom),32721) into i_desc;
	                         insert into bya.errores (descripcion) 
				             values ('NO gid: '||au.gid||' objectid: '||au.objectid||' aldea: '||a.gid||' ------   '||i_desc);		
					       END;
			             end if;
			           end loop;     
                       close c_tabla4; 
					 END;
			       end if;
			     end loop;     
                 close c_tabla3; 
			   end if;
			 end loop;     
             close c_tabla2; 
		   end if;
         end loop;     
         close c_tabla1;	          
      end loop;     
      close c_tabla0;	  
   end if; 

   if i_tabla='PARCELAS_USO_ACTUAL' then 
      delete from bya.errores;
      delete from bya.parcelas_uso_actual where id_colonia = i_colonia;
      delete from i3geo.parcelas_uso_actual where id_colonia = i_colonia;   
      i_sql='select * from bya.parcelas where id_colonia='||i_colonia; 
      open c_tabla0 for execute i_sql;
      loop                                                                
         fetch c_tabla0 into p;
         exit when not found;  	 
		 SELECT st_boundary(p.geom) into a_linea;
	     i_sql='select u.gid,u.categoria,u.uso,u.gid objectid,a.gid objectid_par,0 part1,0 part2,0 part3,u.geom ';
		 i_sql=i_sql||'from bya.parcelas a, bya.uso_actual u where a.gid='||p.gid||' and st_intersects(a.geom,u.geom);'; 
         open c_tabla1 for execute i_sql;
         loop                                                                
           fetch c_tabla1 into pu.gid,pu.categoria,pu.uso,pu.objectid,pu.objectid_par,pu.part1,pu.part2,pu.part3,pu.geom;
           exit when not found;  	 		   
           pu.id_colonia = i_colonia;	 
		   pui.id_colonia = i_colonia;
		   pui.categoria = bu.categoria;
	  	   pui.part1 = pu.part1;
		   pui.part2 = pu.part2;
		   pui.part3 = pu.part3;		   
		   pui.objectid = pu.objectid;
		   pui.uso = pu.uso;
		   pui.objectid_par = pu.objectid_par;		   
		   if (ST_Contains(p.geom,pu.geom)) then
		     select nextval('i3geo.parcelas_uso_actual_gid_seq') into pu.gid;
			 pui.gid = pu.gid;
		     select ST_Transform(ST_SetSRID(pu.geom,32721),4326) into pui.the_geom;
             insert into bya.parcelas_uso_actual select pu.*;
		     insert into i3geo.parcelas_uso_actual select pui.*;		   
		   else		 			 
			 -- Este SQL funciona es el mas lento
             --i_sql='select part3,sup_cat,geom from bya.v_parcelas_uso_actual_p3 ';
             --i_sql=i_sql||'where objectid='||pu.objectid||' and objectid_par='||p.gid;
			 --open c_tabla2 for execute i_sql;			 
			 -----------------------------------------------------------------
			 -- Este SQL funciona... Es el mas eficiente
			 open c_tabla2 for SELECT (r.g_geom).path[1] AS part3, 
             st_area((r.g_geom).geom) AS sup_cat, 
             (r.g_geom).geom AS geom 
             FROM ( SELECT st_dump(st_split(pu.geom, a_linea)) AS g_geom ) r 
			 WHERE st_area((r.g_geom).geom) > 0;
			 -----------------------------------------------------------------			 
			 --insert into bya.errores (descripcion) values (i_sql);
             loop                                                                
               fetch c_tabla2 into pu.part3,pu.sup_cat,pu.geom;
               exit when not found;  	 
			   if ((ST_Area(ST_intersection(p.geom,pu.geom)))>0) then
			     --insert into bya.errores (descripcion) 
				 --values ('NO gid: '||bu.gid||' objectid: '||bu.objectid||' aldea: '||p.gid);			   
		         select nextval('i3geo.parcelas_uso_actual_gid_seq') into pu.gid;
			     pui.gid = pu.gid;			   				 
                 -- Este SQL funciona... Es el mas eficiente
				 open c_tabla3 for SELECT (r.g_geom).path[1] AS part2, 
				 st_area((r.g_geom).geom) AS sup_cat, 
				 (r.g_geom).geom AS geom 
				 FROM ( SELECT st_dump(ST_intersection(p.geom,pu.geom)) AS g_geom ) r 
				 WHERE st_area((r.g_geom).geom) > 0;
                 loop                                                                
                   fetch c_tabla3 into pu.part2,pu.sup_cat,pu.geom;
                   exit when not found;  	 
			       if ((ST_Area(ST_intersection(p.geom,pu.geom)))>0) then		   
		             select nextval('i3geo.parcelas_uso_actual_gid_seq') into pu.gid;
			         pui.gid = pu.gid;		
					 BEGIN
		               select ST_SetSRID(ST_intersection(p.geom,pu.geom),32721) into pu.geom;
				       select ST_Transform(ST_SetSRID(pu.geom,32721),4326) into pui.the_geom;
                       insert into bya.parcelas_uso_actual select pu.*;
		               insert into i3geo.parcelas_uso_actual select pui.*;	
					 EXCEPTION WHEN OTHERS THEN
       				   open c_tabla4 for SELECT (r.g_geom).path[1] AS part2, 
				       st_area((r.g_geom).geom) AS sup_cat, 
				       (r.g_geom).geom AS geom 
				       FROM ( SELECT st_dump(ST_intersection(p.geom,pu.geom)) AS g_geom ) r 
				       WHERE st_area((r.g_geom).geom) > 0;
                       loop                                                                
                         fetch c_tabla4 into pu.part2,pu.sup_cat,pu.geom;
                         exit when not found;  	 
			             if ((ST_Area(ST_intersection(p.geom,pu.geom)))>0) then		   
		                   select nextval('i3geo.parcelas_uso_actual_gid_seq') into pu.gid;
			               pui.gid = pu.gid;		
					       BEGIN
		                     select ST_SetSRID(ST_intersection(p.geom,pu.geom),32721) into pu.geom;
				             select ST_Transform(ST_SetSRID(pu.geom,32721),4326) into pui.the_geom;
                             insert into bya.parcelas_uso_actual select pu.*;
		                     insert into i3geo.parcelas_uso_actual select pui.*;	
					       EXCEPTION WHEN OTHERS THEN
					         select ST_ASTEXT(ST_intersection(p.geom,pu.geom),32721) into i_desc;
	                         insert into bya.errores (descripcion) 
				             values ('NO gid: '||pu.gid||' objectid: '||pu.objectid||' aldea: '||p.gid||' ------   '||i_desc);		
					       END;
			             end if;
			           end loop;     
                       close c_tabla4; 
					 END;
			       end if;
			     end loop;     
                 close c_tabla3; 
			   end if;
			 end loop;     
             close c_tabla2; 
		   end if;
         end loop;     
         close c_tabla1;	          
      end loop;     
      close c_tabla0;	  
   end if; 



   if i_tabla='BLOQUES_USO86' then   
      delete from bya.errores;
      delete from bya.bloques_uso86 where id_colonia = i_colonia;
      delete from i3geo.bloques_uso86 where id_colonia = i_colonia;
	  i_sql='select * from bya.bloques where id_colonia='||i_colonia; 
      open c_tabla0 for execute i_sql;
      loop                                                                
         fetch c_tabla0 into b;
         exit when not found;  	 
		 SELECT st_boundary(b.geom) into a_linea;
	     i_sql='select u.gid,u.categorias,u.uso,u.gid objectid,a.gid objectid_par,0 part1,0 part2,0 part3,u.geom ';
		 i_sql=i_sql||'from bya.bloques a, bya.uso86 u where a.gid='||b.gid||' and st_intersects(a.geom,u.geom);'; 
         open c_tabla1 for execute i_sql;
         loop  --ba nivel 1                                                              
           fetch c_tabla1 into b6.gid,b6.categorias,b6.uso,b6.objectid,b6.objectid_par,b6.part1,b6.part2,b6.part3,b6.geom; 
           exit when not found;  	 		   
           b6.id_colonia = i_colonia;	 
		   b6i.id_colonia = i_colonia;
		   b6i.categorias = b6.categorias;
	  	   b6i.part1 = b6.part1;
		   b6i.part2 = b6.part2;
		   b6i.part3 = b6.part3;		   
		   b6i.objectid = b6.objectid;
		   b6i.uso = b6.uso;
		   b6i.objectid_par = b6.objectid_par;		   
		   if (ST_Contains(b.geom,b6.geom)) then
		     select nextval('i3geo.bloques_uso86_gid_seq') into b6.gid;
			 b6i.gid = b6.gid;
		     select ST_Transform(ST_SetSRID(b6.geom,32721),4326) into b6i.the_geom;
             insert into bya.bloques_uso86 select b6.*;
		     insert into i3geo.bloques_uso86 select b6i.*;		   
		   else		 			 
			 -- Este SQL funciona es el mas lento
             --i_sql='select part3,sup_cat,geom from bya.v_bloques_uso86_p3 ';
             --i_sql=i_sql||'where objectid='||b6.objectid||' and objectid_par='||b.gid;
			 --open c_tabla2 for execute i_sql;			 
			 -----------------------------------------------------------------
			 open c_tabla2 for SELECT (r.g_geom).path[1] AS part3, 
             st_area((r.g_geom).geom) AS sup_cat, 
             (r.g_geom).geom AS geom 
             FROM ( SELECT st_dump(st_split(b6.geom, a_linea)) AS g_geom ) r 
			 WHERE st_area((r.g_geom).geom) > 0;			 
			 --insert into bya.errores (descripcion) values (i_sql);
             loop  --ba nivel 2                                                   
               fetch c_tabla2 into b6.part3,b6.sup_cat,b6.geom;
               exit when not found;  	 
			   if ((ST_Area(ST_intersection(b.geom,b6.geom)))>0) then
			     --insert into bya.errores (descripcion) 
				 --values ('NO gid: '||b6.gid||' objectid: '||b6.objectid||' aldea: '||b.gid);			   
		         select nextval('i3geo.bloques_uso86_gid_seq') into b6.gid;
			     b6i.gid = b6.gid;			   				 
                 -- Este SQL funciona... Es el mas eficiente
				 open c_tabla3 for SELECT (r.g_geom).path[1] AS part2, 
				 st_area((r.g_geom).geom) AS sup_cat, 
				 (r.g_geom).geom AS geom 
				 FROM ( SELECT st_dump(ST_intersection(b.geom,b6.geom)) AS g_geom ) r 
				 WHERE st_area((r.g_geom).geom) > 0; 
                 loop --ba nivel 3                                                          
                   fetch c_tabla3 into b6.part2,b6.sup_cat,b6.geom; 
                   exit when not found;  	 
			       if ((ST_Area(ST_intersection(b.geom,b6.geom)))>0) then		   
		             select nextval('i3geo.bloques_uso86_gid_seq') into b6.gid;
			         b6i.gid = b6.gid;		
					 BEGIN
		               select ST_SetSRID(ST_intersection(b.geom,b6.geom),32721) into b6.geom;
				       select ST_Transform(ST_SetSRID(b6.geom,32721),4326) into b6i.the_geom;
                       insert into bya.bloques_uso86 select b6.*;
		               insert into i3geo.bloques_uso86 select b6i.*;	
					 EXCEPTION WHEN OTHERS THEN
       				   open c_tabla4 for SELECT (r.g_geom).path[1] AS part2, 
				       st_area((r.g_geom).geom) AS sup_cat, 
				       (r.g_geom).geom AS geom 
				       FROM ( SELECT st_dump(ST_intersection(b.geom,b6.geom)) AS g_geom ) r 
				       WHERE st_area((r.g_geom).geom) > 0;
                       loop --ba nivel 4                                                                    
                         fetch c_tabla4 into b6.part2,b6.sup_cat,b6.geom;
                         exit when not found;  	 
			             if ((ST_Area(ST_intersection(b.geom,b6.geom)))>0) then		   
		                   select nextval('i3geo.bloques_uso86_gid_seq') into b6.gid;
			               b6i.gid = b6.gid;		
					       BEGIN
		                     select ST_SetSRID(ST_intersection(b.geom,b6.geom),32721) into b6.geom;
				             select ST_Transform(ST_SetSRID(b6.geom,32721),4326) into b6i.the_geom;
                             insert into bya.bloques_uso86 select b6.*;
		                     insert into i3geo.bloques_uso86 select b6i.*;	
					       EXCEPTION WHEN OTHERS THEN
					         select ST_ASTEXT(ST_intersection(b.geom,b6.geom),32721) into i_desc;
	                         insert into bya.errores (descripcion) 
				             values ('NO gid: '||b6.gid||' objectid: '||b6.objectid||' aldea: '||b.gid||' ------   '||i_desc);		
					       END;
			             end if;
			           end loop;     
                       close c_tabla4; 
					 END;
			       end if;
			     end loop;     
                 close c_tabla3; 
			   end if;
			 end loop;     
             close c_tabla2; 
		   end if;
         end loop;     
         close c_tabla1;	          
      end loop;     
      close c_tabla0;	  
   end if; 

   if i_tabla='ALDEAS_USO86' then   
      delete from bya.errores;
      delete from bya.aldeas_uso86 where id_colonia = i_colonia;
      delete from i3geo.aldeas_uso86 where id_colonia = i_colonia;
	  i_sql='select * from bya.aldeas where id_colonia='||i_colonia; 
      open c_tabla0 for execute i_sql;
      loop                                                                
         fetch c_tabla0 into a;
         exit when not found;  	 
		 SELECT st_boundary(a.geom) into a_linea;
	     i_sql='select u.gid,u.categorias,u.uso,u.gid objectid,a.gid objectid_par,0 part1,0 part2,0 part3,u.geom ';
		 i_sql=i_sql||'from bya.aldeas a, bya.uso86 u where a.gid='||a.gid||' and st_intersects(a.geom,u.geom);'; 
         open c_tabla1 for execute i_sql;
         loop                                                                
           fetch c_tabla1 into a6.gid,a6.categorias,a6.uso,b6.objectid,a6.objectid_par,a6.part1,a6.part2,a6.part3,a6.geom;
           exit when not found;  	 		   
           a6.id_colonia = i_colonia;	 
		   a6i.id_colonia = i_colonia;
		   a6i.categorias = a6.categorias;
	  	   a6i.part1 = a6.part1;
		   a6i.part2 = a6.part2;
		   a6i.part3 = a6.part3;		   
		   a6i.objectid = a6.objectid;
		   a6i.uso = a6.uso;
		   a6i.objectid_par = a6.objectid_par;		   
		   if (ST_Contains(a.geom,a6.geom)) then
		     select nextval('i3geo.aldeas_uso86_gid_seq') into a6.gid;
			 a6i.gid = a6.gid;
		     select ST_Transform(ST_SetSRID(a6.geom,32721),4326) into a6i.the_geom;
             insert into bya.aldeas_uso86 select a6.*;
		     insert into i3geo.aldeas_uso86 select a6i.*;		   
		   else		 			 
			 -- Este SQL funciona es el mas lento
             --i_sql='select part3,sup_cat,geom from bya.v_aldeas_uso86_p3 ';
             --i_sql=i_sql||'where objectid='||b6.objectid||' and objectid_par='||b.gid;
			 --open c_tabla2 for execute i_sql;			 
			 -----------------------------------------------------------------
			 open c_tabla2 for SELECT (r.g_geom).path[1] AS part3, 
             st_area((r.g_geom).geom) AS sup_cat, 
             (r.g_geom).geom AS geom 
             FROM ( SELECT st_dump(st_split(a6.geom, a_linea)) AS g_geom ) r 
			 WHERE st_area((r.g_geom).geom) > 0;			 
			 --insert into bya.errores (descripcion) values (i_sql);
             loop                                                                
               fetch c_tabla2 into a6.part3,a6.sup_cat,a6.geom;
               exit when not found;  	 
			   if ((ST_Area(ST_intersection(a.geom,a6.geom)))>0) then
			     --insert into bya.errores (descripcion) 
				 --values ('NO gid: '||a6.gid||' objectid: '||a6.objectid||' aldea: '||a.gid);			   
		         select nextval('i3geo.aldeas_uso86_gid_seq') into a6.gid;
			     a6i.gid = a6.gid;			   				 
                 -- Este SQL funciona... Es el mas eficiente
				 open c_tabla3 for SELECT (r.g_geom).path[1] AS part2, 
				 st_area((r.g_geom).geom) AS sup_cat, 
				 (r.g_geom).geom AS geom 
				 FROM ( SELECT st_dump(ST_intersection(a.geom,a6.geom)) AS g_geom ) r 
				 WHERE st_area((r.g_geom).geom) > 0;
                 loop                                                                
                   fetch c_tabla3 into a6.part2,a6.sup_cat,a6.geom;
                   exit when not found;  	 
			       if ((ST_Area(ST_intersection(a.geom,a6.geom)))>0) then		   
		             select nextval('i3geo.aldeas_uso86_gid_seq') into a6.gid;
			         a6i.gid = a6.gid;		
					 BEGIN
		               select ST_SetSRID(ST_intersection(a.geom,a6.geom),32721) into a6.geom;
				       select ST_Transform(ST_SetSRID(a6.geom,32721),4326) into a6i.the_geom;
                       insert into bya.aldeas_uso86 select a6.*;
		               insert into i3geo.aldeas_uso86 select a6i.*;	
					 EXCEPTION WHEN OTHERS THEN
       				   open c_tabla4 for SELECT (r.g_geom).path[1] AS part2, 
				       st_area((r.g_geom).geom) AS sup_cat, 
				       (r.g_geom).geom AS geom 
				       FROM ( SELECT st_dump(ST_intersection(a.geom,a6.geom)) AS g_geom ) r 
				       WHERE st_area((r.g_geom).geom) > 0;
                       loop                                                                
                         fetch c_tabla4 into a6.part2,a6.sup_cat,a6.geom;
                         exit when not found;  	 
			             if ((ST_Area(ST_intersection(a.geom,a6.geom)))>0) then		   
		                   select nextval('i3geo.aldeas_uso86_gid_seq') into a6.gid;
			               a6i.gid = a6.gid;		
					       BEGIN
		                     select ST_SetSRID(ST_intersection(a.geom,a6.geom),32721) into a6.geom;
				             select ST_Transform(ST_SetSRID(a6.geom,32721),4326) into a6i.the_geom;
                             insert into bya.aldeas_uso86 select a6.*;
		                     insert into i3geo.aldeas_uso86 select a6i.*;	
					       EXCEPTION WHEN OTHERS THEN
					         select ST_ASTEXT(ST_intersection(a.geom,a6.geom),32721) into i_desc;
	                         insert into bya.errores (descripcion) 
				             values ('NO gid: '||a6.gid||' objectid: '||a6.objectid||' aldea: '||a.gid||' ------   '||i_desc);		
					       END;
			             end if;
			           end loop;     
                       close c_tabla4; 
					 END;
			       end if;
			     end loop;     
                 close c_tabla3; 
			   end if;
			 end loop;     
             close c_tabla2; 
		   end if;
         end loop;     
         close c_tabla1;	          
      end loop;     
      close c_tabla0;	  
   end if; 

   if i_tabla='PARCELAS_USO86' then 
      delete from bya.errores;
      delete from bya.parcelas_uso86 where id_colonia = i_colonia;
      delete from i3geo.parcelas_uso86 where id_colonia = i_colonia;   
      i_sql='select * from bya.parcelas where id_colonia='||i_colonia; 
      open c_tabla0 for execute i_sql;
      loop                                                                
         fetch c_tabla0 into p;
         exit when not found;  	 
		 SELECT st_boundary(p.geom) into a_linea;
	     i_sql='select u.gid,u.categorias,u.uso,u.gid objectid,a.gid objectid_par,0 part1,0 part2,0 part3,u.geom ';
		 i_sql=i_sql||'from bya.parcelas a, bya.uso86 u where a.gid='||p.gid||' and st_intersects(a.geom,u.geom);'; 
         open c_tabla1 for execute i_sql;
         loop                                                                
           fetch c_tabla1 into p6.gid,p6.categorias,p6.uso,p6.objectid,p6.objectid_par,p6.part1,p6.part2,p6.part3,p6.geom;
           exit when not found;  	 		   
           p6.id_colonia = i_colonia;	 
		   p6i.id_colonia = i_colonia;
		   p6i.categorias = b6.categorias;
	  	   p6i.part1 = p6.part1;
		   p6i.part2 = p6.part2;
		   p6i.part3 = p6.part3;		   
		   p6i.objectid = p6.objectid;
		   p6i.uso = p6.uso;
		   p6i.objectid_par = p6.objectid_par;		   
		   if (ST_Contains(p.geom,p6.geom)) then
		     select nextval('i3geo.parcelas_uso86_gid_seq') into p6.gid;
			 p6i.gid = p6.gid;
		     select ST_Transform(ST_SetSRID(p6.geom,32721),4326) into p6i.the_geom;
             insert into bya.parcelas_uso86 select p6.*;
		     insert into i3geo.parcelas_uso86 select p6i.*;		   
		   else		 			 
			 -- Este SQL funciona es el mas lento
             --i_sql='select part3,sup_cat,geom from bya.v_parcelas_uso86_p3 ';
             --i_sql=i_sql||'where objectid='||p6.objectid||' and objectid_par='||p.gid;
			 --open c_tabla2 for execute i_sql;			 
			 -----------------------------------------------------------------
			 -- Este SQL funciona... Es el mas eficiente
			 open c_tabla2 for SELECT (r.g_geom).path[1] AS part3, 
             st_area((r.g_geom).geom) AS sup_cat, 
             (r.g_geom).geom AS geom 
             FROM ( SELECT st_dump(st_split(p6.geom, a_linea)) AS g_geom ) r 
			 WHERE st_area((r.g_geom).geom) > 0;
			 -----------------------------------------------------------------			 
			 --insert into bya.errores (descripcion) values (i_sql);
             loop                                                                
               fetch c_tabla2 into p6.part3,p6.sup_cat,p6.geom;
               exit when not found;  	 
			   if ((ST_Area(ST_intersection(p.geom,p6.geom)))>0) then
			     --insert into bya.errores (descripcion) 
				 --values ('NO gid: '||b6.gid||' objectid: '||b6.objectid||' aldea: '||p.gid);			   
		         select nextval('i3geo.parcelas_uso86_gid_seq') into p6.gid;
			     p6i.gid = p6.gid;			   				 
                 -- Este SQL funciona... Es el mas eficiente
				 open c_tabla3 for SELECT (r.g_geom).path[1] AS part2, 
				 st_area((r.g_geom).geom) AS sup_cat, 
				 (r.g_geom).geom AS geom 
				 FROM ( SELECT st_dump(ST_intersection(p.geom,p6.geom)) AS g_geom ) r 
				 WHERE st_area((r.g_geom).geom) > 0;
                 loop                                                                
                   fetch c_tabla3 into p6.part2,p6.sup_cat,p6.geom;
                   exit when not found;  	 
			       if ((ST_Area(ST_intersection(p.geom,p6.geom)))>0) then		   
		             select nextval('i3geo.parcelas_uso86_gid_seq') into p6.gid;
			         p6i.gid = p6.gid;		
					 BEGIN
		               select ST_SetSRID(ST_intersection(p.geom,p6.geom),32721) into p6.geom;
				       select ST_Transform(ST_SetSRID(p6.geom,32721),4326) into p6i.the_geom;
                       insert into bya.parcelas_uso86 select p6.*;
		               insert into i3geo.parcelas_uso86 select p6i.*;	
					 EXCEPTION WHEN OTHERS THEN
       				   open c_tabla4 for SELECT (r.g_geom).path[1] AS part2, 
				       st_area((r.g_geom).geom) AS sup_cat, 
				       (r.g_geom).geom AS geom 
				       FROM ( SELECT st_dump(ST_intersection(p.geom,p6.geom)) AS g_geom ) r 
				       WHERE st_area((r.g_geom).geom) > 0;
                       loop                                                                
                         fetch c_tabla4 into p6.part2,p6.sup_cat,p6.geom;
                         exit when not found;  	 
			             if ((ST_Area(ST_intersection(p.geom,p6.geom)))>0) then		   
		                   select nextval('i3geo.parcelas_uso86_gid_seq') into p6.gid;
			               p6i.gid = p6.gid;		
					       BEGIN
		                     select ST_SetSRID(ST_intersection(p.geom,p6.geom),32721) into p6.geom;
				             select ST_Transform(ST_SetSRID(p6.geom,32721),4326) into p6i.the_geom;
                             insert into bya.parcelas_uso86 select p6.*;
		                     insert into i3geo.parcelas_uso86 select p6i.*;	
					       EXCEPTION WHEN OTHERS THEN
					         select ST_ASTEXT(ST_intersection(p.geom,p6.geom),32721) into i_desc;
	                         insert into bya.errores (descripcion) 
				             values ('NO gid: '||p6.gid||' objectid: '||p6.objectid||' aldea: '||p.gid||' ------   '||i_desc);		
					       END;
			             end if;
			           end loop;     
                       close c_tabla4; 
					 END;
			       end if;
			     end loop;     
                 close c_tabla3; 
			   end if;
			 end loop;     
             close c_tabla2; 
		   end if;
         end loop;     
         close c_tabla1;	          
      end loop;     
      close c_tabla0;	  
   end if; 





   RETURN resultado;
END;
$BODY$;

ALTER FUNCTION bya.actualizar_usos(character varying, integer)
    OWNER TO postgres;
