<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Consultores_model extends Ion_auth_model {
//class Consultores_model extends ci_model {
	
    public function __construct()
    {
        parent::__construct();
	}
	
	/**
	 * consultores
	 *
	 * @return object
	 * @author Jaime Rojas
	 **/
	public function buscar_clientes($term)
	{
		$this->db->select('id_cliente, nombre, apellido, cedularuc, email, telefono');
		$this->db->from('ema.cliente');

		// Si el término es numérico, busca exactamente en cedularuc
		if (is_numeric($term)) {
			$this->db->where('cedularuc', $term);
		} else {
			// Si no es numérico, busca por nombre o apellido
			$this->db->or_like('nombre', $term);
			$this->db->or_like('apellido', $term);
		}

		$query = $this->db->get();

		return $query->result();
	}

	

	public function get_consultores($filters = [], $limit = 10, $offset = 0)
	{
		if (!empty($filters['cedularuc'])) {
			$this->db->like('CAST(cedularuc AS TEXT)', $filters['cedularuc']); // Convertimos a texto para LIKE en numéricos
		}
		if (!empty($filters['nombre'])) {
			$this->db->like('LOWER(nombre)', strtolower($filters['nombre']));
		}
		if (!empty($filters['apellido'])) {
			$this->db->like('LOWER(apellido)', strtolower($filters['apellido']));
		}
		if (!empty($filters['email'])) {
			$this->db->like('LOWER(email)', strtolower($filters['email']));
		}
		if (!empty($filters['id_cliente'])) {
			$this->db->like('CAST(id_cliente AS TEXT)', $filters['id_cliente']);
		}
	
		return $this->db->get('ema.consultores', $limit, $offset)->result_array();
	}
	
	public function count_consultores($filters = [])
	{
		if (!empty($filters['cedularuc'])) {
			$this->db->like('CAST(cedularuc AS TEXT)', $filters['cedularuc']);
		}
		if (!empty($filters['nombre'])) {
			$this->db->like('LOWER(nombre)', strtolower($filters['nombre']));
		}
		if (!empty($filters['apellido'])) {
			$this->db->like('LOWER(apellido)', strtolower($filters['apellido']));
		}
		if (!empty($filters['email'])) {
			$this->db->like('LOWER(email)', strtolower($filters['email']));
		}        
		if (!empty($filters['id_cliente'])) {
			$this->db->like('CAST(id_cliente AS TEXT)', $filters['id_cliente']);
		}
	
		return $this->db->count_all_results('ema.consultores');
	}
	

	public function view_all($tabla, $where = NULL)
	{
		$this->trigger_events('consultores');

		// run each where that was passed
		
		$this->response = $this->db->get_where($this->tables[$tabla], $where)->num_rows();
		
		return $this;
	}



	public function dropdown_data($tabla = NULL, $where = NULL, $order_by = NULL)
	{
		if ($where) {
			foreach ($where as $k => $v) {

				$this->response = $this->db->where($k, $v);
			}
		}
		
		if ($order_by) {
			$this->response = $this->db->order_by($order_by, 'ASC');
		}

		$this->response = $this->db->get($this->tables[$tabla]);

		return $this;
	}


	/**
	 * Consultores
	 *
	 * @return object
	 * @author Jaime Rojas
	 **/

	public function view($tabla, $where = NULL)
	{
		$this->trigger_events('proyectos');

		$this->response = $this->db->get_where($this->tables[$tabla], $where);
		
		return $this;
	}


	public function concepto ($i_tipoconcepto, $blanco = FALSE, $orderby = FALSE, $i_concepto = FALSE)
	{
		$query = "SELECT CONCEPTO, NOMBRE, DESCRIPCION, TIPOCONCEPTO FROM public.CONCEPTOS WHERE TIPOCONCEPTO = '".$i_tipoconcepto."'";

		if ($i_concepto == TRUE) {
			$query = $query . " AND CONCEPTO = '" . $i_concepto . "'";
		}

		if ($blanco == TRUE) {
			$query = $query . " UNION SELECT '  ', 'DEJAR EN BLANCO', '', ''";
		}
		if ($orderby) {
			$query = $query . " ORDER BY ".$orderby;
		}
		$this->response = $this->db->query($query);

		$_SESSION['last_query'] = $this->db->last_query();

		return $this;
	}
	

	/**
	 * create consultores
	 *
	 * @author Jaime Rojas
	*/
	public function create_consultores($arraycampos = NULL)
	{
		// bail if the group name already exists
		$existing_consultor = $this->db->get_where($this->tables['consultores'], $arraycampos)->num_rows();

		
		if($existing_consultor !== 0)
		{
			$this->ion_auth->set_error('consultores_already_exists');
			return FALSE;
		}
		
		// insert the new group
		$this->db->insert($this->tables['consultores'], $arraycampos);
		$consultores_gid = $this->db->insert_id();

		// report success
		$this->set_message('consultores_creation_successful');
		// return the brand new group id
		return $consultores_gid;
	}

	
	
	/**
	 * update_consultores
	 *
	 * @return bool
	 * @author Jaime Rojas
	 **/

    public function update_consultores($consultor, $arraycampos)
	{
		$this->db->update($this->tables['consultores'], $arraycampos, array('id_consultor' => $consultor));

        $this->ion_auth->set_message('consultores_update_successful');

        return TRUE;
	}

//		$resultado = $this->db->query("SELECT SEAM_IDE.F_EXISTE_GRAFICO('".$exp."',".$gest.");")->row()->f_existe_grafico;


	/**
	 * eliminar_consultores
	 * cuenta registros espaciales dependientes de consultores.
	 * @return integer 
	 * @author Jaime Rojas Landivar
	 **/
    public function cnt_consultores_reg_layers($consultor = null)
	{
		$total =  0; 
        $sq = "select sum(x.cnt) total from (
        select 'proyectos' tabla, count(*) cnt from ema.proyectos where id_consultor = '".$consultor."' 

		) x;     
         ";

        //union select 'ConsultorActual' tabla, count(*) cnt from ema.consultor_actual where consultor = '".$consultor."' 
        //union select 'consultor_alternativo' tabla, count(*) cnt from ema.consultor_alternativo where consultor = '".$consultor."'

		$total = $this->db->query($sq)->row()->total;
		return $total; 
	}

	/**
	 * eliminar_consultores
	 * elimina dependientes de la tabla consultores
	 * @return bool
	 * @author Jaime Rojas Landivar
	 **/
    public function eliminar_consultores($consultor)
	{
		$resultado =  true; 
        $sq = "select sum(x.cnt) as total from (
        select 'Consultores' tabla, count(*) cnt from ema.proyectos where id_consultor = '".$consultor."' 

		) x;     
         ";

        //union select 'ConsultorActual' tabla, count(*) cnt from ema.consultor_actual where consultor = '".$consultor."' 
        //union select 'consultor_alternativo' tabla, count(*) cnt from ema.consultor_alternativo where consultor = '".$consultor."' 

		$total = $this->db->query($sq)->row()->total;

		if ($total == 0) {
			$sq = "delete from ema.consultores where id_consultor = '".$consultor."';";			
			$del = $this->db->query($sq);
			$sq = "select count(*) as total from ema.consultores where id_consultor = '".$consultor."'";
			$total = $this->db->query($sq)->row()->total;	
			if ($total == 0) {
				$resultado = true;
			}else{
				$resultado = false;
			}			

		}else{
			$resultado = false;
		}
		return $resultado; 
	}

	/*
	 * delete consultores
	 * elimina consultores 
	 * @return bool
	 * @author Jaime Rojas Lndivar
    */

    public function delete($tabla, $where)
	{
		$this->db->delete($this->tables[$tabla], $where);

        return TRUE;
	}


	public function f_existe_grafico($exp = NULL, $gest = NULL)
	{
		$resultado = $this->db->query("SELECT SEAM_IDE.F_EXISTE_GRAFICO('".$exp."',".$gest.");")->row()->f_existe_grafico;

		return $resultado;
	}



	/**
	 * contador_registros
	 *	Obtiene la cantidad de registro de una tabla y condición dada
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function contador_registros_all ($tabla = NULL)
	{

		$this->db->from($this->tables[$tabla]);
		return $this->db->count_all_results();
	}

	/**
	 * contador_registros
	 *	Obtiene la cantidad de registro de una tabla y condición dada
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function contador_registros ($tabla = NULL, $arraywhere = NULL)
	{
		foreach ($arraywhere as $k => $v) {

			$this->db->where($k, $v);
		}
		$this->db->from($this->tables[$tabla]);
		return $this->db->count_all_results();
	}

	/**
	 * eliminar_datos_tabla
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function eliminar_datos_tabla($tabla = NULL)
	{
		
		$resultado = $this->db->query("SELECT ema.f_eliminar_datos_tabla('".$tabla."');");

		return $resultado;
	}
	

	/**
	 * actualizar_categorias
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function actualizar_categorias($i_colonia = NULL)
	{
		//$resultado = 0;
		/* Provoca un error -- sintaxis SQL falsa */
		$i_sql = "SELECT ema.actualizar_categorias('CONSULTOR_ALTERNATIVO',".$i_colonia.");";
		$resultado = $this->db->query($i_sql); //run query
		//$i_sql = "SELECT ema.actualizar_categorias(".$i_colonia.",'CONSULTOR_ACTUAL');";
		//$resultado = $this->db->query($i_sql); //run query		

		return $resultado;
	}	



	/**
	 * actualizar_consultores
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function actualizar_consultores($i_tabla = NULL, $i_colonia = NULL)
	{
		$i_sql = "SELECT ema.actualizar_consultores('".$i_tabla."',".$i_colonia.");";
		$resultado = $this->db->query($i_sql); //run query	
		return $resultado;
	}




	/**
	 * obtener_nextval
	 *
	 * @return int
	 * @author Jaime Rojas Landivar
	 **/
	public function obtener_nextval($sequence)
	{
		$seq = $this->db->query("SELECT NEXTVAL('" . $sequence . "');")->row()->nextval;

		return $seq;
	}

	public function get_consultor_by_id($id) {
		return $this->db->get_where('ema.consultores', ['id_consultor' => $id])->row();
	}

	//Nuevo

    public function view_consultor($condiciones = []) {
        $query = $this->db->get_where($this->table, $condiciones);
        return $query->row(); // Retorna solo un resultado
    }

    /**
     * Obtiene todos los consultores
     * @return array Retorna un array con todos los consultores
     */
    public function get_all_consultores() {
        $query = $this->db->get($this->table);
        return $query->result(); // Retorna múltiples filas
    }
}
