<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Grupos_model extends CI_Model {
    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    // Obtener grupos con filtro y paginación
    public function get_filtered_groups($id_cliente = null, $limit = 10, $offset = 0) {
        $this->db->select('*');
        $this->db->from('ema.grupos');
        if ($id_cliente !== null) {
            $this->db->where('id_cliente', $id_cliente);
        }
        $this->db->limit($limit, $offset);
        return $this->db->get()->result_array();
    }

    // Contar los grupos con filtro
    public function count_filtered_groups($id_cliente = null) {
        $this->db->from('ema.grupos');
        if ($id_cliente !== null) {
            $this->db->where('id_cliente', $id_cliente);
        }
        return $this->db->count_all_results();
    }
}