<?php
class Dpto_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }
    
    public function dropdown_data($tabla = NULL, $where = NULL, $order_by = NULL)
	{
		if ($where) {
			foreach ($where as $k => $v) {

				$this->response = $this->db->where($k, $v);
			}
		}
		
		if ($order_by) {
			$this->response = $this->db->order_by($order_by, 'ASC');
		}

		$this->response = $this->db->get($this->tables[$tabla]);

		return $this;
	}

    public function get_departamentos($filters = [], $limit = 10, $offset = 0) {
        if (!empty($filters)) {
            if (!empty($filters['id'])) {
                $this->db->where('id', $filters['id']);
            }
            if (!empty($filters['dpto'])) {
                $this->db->where('dpto', $filters['dpto']);
            }
            if (!empty($filters['dpto_desc'])) {
                $this->db->like('dpto_desc', $filters['dpto_desc']);
            }
            if (!empty($filters['region'])) {
                $this->db->where('region', $filters['region']);
            }
        }

        $this->db->limit($limit, $offset);
        return $this->db->get('ide.dpto')->result();
    }

    public function count_departamentos($filters = []) {
        if (!empty($filters['id'])) {
            $this->db->where('id', $filters['id']);
        }
        if (!empty($filters['dpto'])) {
            $this->db->where('dpto', $filters['dpto']);
        }
        if (!empty($filters['dpto_desc'])) {
            $this->db->like('dpto_desc', $filters['dpto_desc']);
        }
        if (!empty($filters['region'])) {
            $this->db->where('region', $filters['region']);
        }

        return $this->db->count_all_results('ide.dpto');
    }

    public function get_dpto_by_id($id) {
        $this->db->where('id', $id);
        return $this->db->get('ide.dpto')->row_array();
    }

    public function create_dpto($data) {
        return $this->db->insert('ide.dpto', $data);
    }

    public function update_dpto($id, $data) {
        return $this->db->where('id', $id)->update('ide.dpto', $data);
    }

    public function delete_dpto($id) {
        return $this->db->where('id', $id)->delete('ide.dpto');
    }

    public function get_dptos() {
        $this->db->select('id, dpto_desc');
        $this->db->order_by('dpto_desc', 'ASC');
        return $this->db->get('ide.dpto')->result_array();
    }
    
}
?>
